/* rygel-thumbnailer.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-thumbnailer.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010-2011 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
typedef struct _RygelThumbnailerPrivate RygelThumbnailerPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_DBUS_THUMBNAILER (rygel_dbus_thumbnailer_get_type ())
#define RYGEL_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailer))
#define RYGEL_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))
#define RYGEL_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))

typedef struct _RygelDbusThumbnailer RygelDbusThumbnailer;
typedef struct _RygelDbusThumbnailerClass RygelDbusThumbnailerClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

typedef enum  {
	THUMBNAILER_ERROR_NO_DIR,
	THUMBNAILER_ERROR_NO_THUMBNAIL
} ThumbnailerError;
#define THUMBNAILER_ERROR thumbnailer_error_quark ()
struct _RygelThumbnailer {
	GObject parent_instance;
	RygelThumbnailerPrivate * priv;
};

struct _RygelThumbnailerClass {
	GObjectClass parent_class;
};

struct _RygelThumbnailerPrivate {
	RygelThumbnail* template;
	gchar* extension;
	RygelDbusThumbnailer* thumbler;
};

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	GUPnPDIDLLiteResource* (*add_resource) (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
};


static gpointer rygel_thumbnailer_parent_class = NULL;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer = NULL;
static gboolean rygel_thumbnailer_first_time;
static gboolean rygel_thumbnailer_first_time = TRUE;

GQuark thumbnailer_error_quark (void);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_dbus_thumbnailer_get_type (void) G_GNUC_CONST;
#define RYGEL_THUMBNAILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerPrivate))
enum  {
	RYGEL_THUMBNAILER_DUMMY_PROPERTY
};
static RygelThumbnailer* rygel_thumbnailer_new (GError** error);
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_new (const gchar* flavor, GError** error);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_construct (GType object_type, const gchar* flavor, GError** error);
static void rygel_thumbnailer_on_dbus_thumbnailer_ready (RygelThumbnailer* self, gboolean available);
static void _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready (RygelDbusThumbnailer* _sender, gboolean available, gpointer self);
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error);
void rygel_dbus_thumbnailer_queue_thumbnail_task (RygelDbusThumbnailer* self, const gchar* uri, const gchar* mime);
static void rygel_thumbnailer_finalize (GObject* obj);


GQuark thumbnailer_error_quark (void) {
	return g_quark_from_static_string ("thumbnailer_error-quark");
}


static void _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready (RygelDbusThumbnailer* _sender, gboolean available, gpointer self) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	rygel_thumbnailer_on_dbus_thumbnailer_ready (self, available);
#line 144 "rygel-thumbnailer.c"
}


static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error) {
	RygelThumbnailer * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
	RygelThumbnail* _tmp2_ = NULL;
	RygelThumbnail* _tmp3_ = NULL;
	RygelThumbnail* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self = (RygelThumbnailer*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = rygel_thumbnail_new ("image/png", "PNG_TN", "png");
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_rygel_icon_info_unref0 (self->priv->template);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv->template = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp1_ = self->priv->template;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp1_)->width = 128;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp2_ = self->priv->template;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp2_)->height = 128;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp3_ = self->priv->template;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp3_)->depth = 32;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp4_ = self->priv->template;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp5_ = ((RygelIconInfo*) _tmp4_)->file_extension;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp6_ = g_strconcat (".", _tmp5_, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (self->priv->extension);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv->extension = _tmp6_;
#line 188 "rygel-thumbnailer.c"
	{
		RygelDbusThumbnailer* _tmp7_ = NULL;
		RygelDbusThumbnailer* _tmp8_ = NULL;
		RygelDbusThumbnailer* _tmp9_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp8_ = rygel_dbus_thumbnailer_new ("normal", &_inner_error_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp7_ = _tmp8_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		if (_inner_error_ != NULL) {
#line 199 "rygel-thumbnailer.c"
			goto __catch71_g_error;
		}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (self->priv->thumbler);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		self->priv->thumbler = _tmp7_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp9_ = self->priv->thumbler;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_signal_connect_object (_tmp9_, "ready", (GCallback) _rygel_thumbnailer_on_dbus_thumbnailer_ready_rygel_dbus_thumbnailer_ready, self, 0);
#line 210 "rygel-thumbnailer.c"
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* _error_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_error_ = _inner_error_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_error_free0 (_error_);
#line 222 "rygel-thumbnailer.c"
	}
	__finally71:
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		if (_inner_error_->domain == THUMBNAILER_ERROR) {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_propagate_error (error, _inner_error_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_g_object_unref0 (self);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			return NULL;
#line 235 "rygel-thumbnailer.c"
		} else {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_clear_error (&_inner_error_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			return NULL;
#line 243 "rygel-thumbnailer.c"
		}
	}
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return self;
#line 248 "rygel-thumbnailer.c"
}


static RygelThumbnailer* rygel_thumbnailer_new (GError** error) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return rygel_thumbnailer_construct (RYGEL_TYPE_THUMBNAILER, error);
#line 255 "rygel-thumbnailer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return self ? g_object_ref (self) : NULL;
#line 262 "rygel-thumbnailer.c"
}


RygelThumbnailer* rygel_thumbnailer_get_default (void) {
	RygelThumbnailer* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelThumbnailer* _tmp6_ = NULL;
	RygelThumbnailer* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = rygel_thumbnailer_first_time;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp0_) {
#line 276 "rygel-thumbnailer.c"
		{
			RygelThumbnailer* _tmp1_ = NULL;
			RygelThumbnailer* _tmp2_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp2_ = rygel_thumbnailer_new (&_inner_error_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp1_ = _tmp2_;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				if (_inner_error_->domain == THUMBNAILER_ERROR) {
#line 288 "rygel-thumbnailer.c"
					goto __catch72_thumbnailer_error;
				}
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
				return NULL;
#line 297 "rygel-thumbnailer.c"
			}
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_g_object_unref0 (rygel_thumbnailer_thumbnailer);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			rygel_thumbnailer_thumbnailer = _tmp1_;
#line 303 "rygel-thumbnailer.c"
		}
		goto __finally72;
		__catch72_thumbnailer_error:
		{
			GError* err = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			err = _inner_error_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp3_ = _ ("No thumbnailer available: %s");
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp4_ = err;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_tmp5_ = _tmp4_->message;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_warning (_tmp3_, _tmp5_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			_g_error_free0 (err);
#line 326 "rygel-thumbnailer.c"
		}
		__finally72:
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		if (_inner_error_ != NULL) {
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			g_clear_error (&_inner_error_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
			return NULL;
#line 337 "rygel-thumbnailer.c"
		}
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		rygel_thumbnailer_first_time = FALSE;
#line 341 "rygel-thumbnailer.c"
	}
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp6_ = rygel_thumbnailer_thumbnailer;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	result = _tmp7_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return result;
#line 351 "rygel-thumbnailer.c"
}


RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error) {
	RygelThumbnail* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFileInfo* info = NULL;
	GFile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	gchar* path = NULL;
	GFileInfo* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean failed = FALSE;
	GFileInfo* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp15_ = FALSE;
	RygelDbusThumbnailer* _tmp16_ = NULL;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	GFileInfo* _tmp29_ = NULL;
	GFile* _tmp30_ = NULL;
	GFileInfo* _tmp31_ = NULL;
	GFileInfo* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	RygelThumbnail* thumbnail = NULL;
	RygelThumbnail* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	RygelThumbnail* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	RygelThumbnail* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	RygelThumbnail* _tmp42_ = NULL;
	RygelThumbnail* _tmp43_ = NULL;
	RygelThumbnail* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	RygelThumbnail* _tmp46_ = NULL;
	RygelThumbnail* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	RygelThumbnail* _tmp49_ = NULL;
	RygelThumbnail* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	gchar* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	RygelThumbnail* _tmp55_ = NULL;
	RygelThumbnail* _tmp56_ = NULL;
	GFileInfo* _tmp57_ = NULL;
	guint64 _tmp58_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = uri;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp1_ = g_file_new_for_uri (_tmp0_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	file = _tmp1_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp2_ = file;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp3_ = g_file_is_native (_tmp2_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (!_tmp3_) {
#line 426 "rygel-thumbnailer.c"
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp4_ = _ ("Thumbnailing not supported");
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp5_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp4_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp5_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 441 "rygel-thumbnailer.c"
	}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp6_ = file;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp7_ = g_file_query_info (_tmp6_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH "," G_FILE_ATTRIBUTE_THUMBNAILING_FAILED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	info = _tmp7_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 457 "rygel-thumbnailer.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp8_ = info;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp9_ = g_file_info_get_attribute_as_string (_tmp8_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	path = _tmp9_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp10_ = info;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp11_ = g_file_info_get_attribute_boolean (_tmp10_, G_FILE_ATTRIBUTE_THUMBNAILING_FAILED);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	failed = _tmp11_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp12_ = failed;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp12_) {
#line 475 "rygel-thumbnailer.c"
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp13_ = _ ("No thumbnail available");
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp14_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp13_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp14_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 494 "rygel-thumbnailer.c"
	}
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp16_ = self->priv->thumbler;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp16_ != NULL) {
#line 500 "rygel-thumbnailer.c"
		const gchar* _tmp17_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp17_ = path;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp15_ = _tmp17_ == NULL;
#line 506 "rygel-thumbnailer.c"
	} else {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp15_ = FALSE;
#line 510 "rygel-thumbnailer.c"
	}
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp18_ = _tmp15_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp18_) {
#line 516 "rygel-thumbnailer.c"
		RygelDbusThumbnailer* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp19_ = self->priv->thumbler;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp20_ = uri;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp21_ = mime_type;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		rygel_dbus_thumbnailer_queue_thumbnail_task (_tmp19_, _tmp20_, _tmp21_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp22_ = _ ("No thumbnail available");
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp23_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp22_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp23_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 546 "rygel-thumbnailer.c"
	}
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp24_ = path;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_tmp24_ == NULL) {
#line 552 "rygel-thumbnailer.c"
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp25_ = _ ("No thumbnail available");
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp26_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp25_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp26_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 571 "rygel-thumbnailer.c"
	}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp27_ = path;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp28_ = g_file_new_for_path (_tmp27_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (file);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	file = _tmp28_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp30_ = file;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp31_ = g_file_query_info (_tmp30_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp29_ = _tmp31_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 599 "rygel-thumbnailer.c"
	}
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (info);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	info = _tmp29_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp32_ = info;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp33_ = g_file_info_get_attribute_boolean (_tmp32_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (!_tmp33_) {
#line 611 "rygel-thumbnailer.c"
		const gchar* _tmp34_ = NULL;
		GError* _tmp35_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp34_ = _ ("No thumbnail available");
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp35_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp34_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_inner_error_ = _tmp35_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 630 "rygel-thumbnailer.c"
	}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp36_ = self->priv->template;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp37_ = ((RygelIconInfo*) _tmp36_)->mime_type;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp38_ = self->priv->template;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp39_ = _tmp38_->dlna_profile;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp40_ = self->priv->template;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp41_ = ((RygelIconInfo*) _tmp40_)->file_extension;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp42_ = rygel_thumbnail_new (_tmp37_, _tmp39_, _tmp41_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	thumbnail = _tmp42_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp43_ = thumbnail;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp44_ = self->priv->template;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp45_ = ((RygelIconInfo*) _tmp44_)->width;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp43_)->width = _tmp45_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp46_ = thumbnail;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp47_ = self->priv->template;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp48_ = ((RygelIconInfo*) _tmp47_)->height;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp46_)->height = _tmp48_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp49_ = thumbnail;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp50_ = self->priv->template;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp51_ = ((RygelIconInfo*) _tmp50_)->depth;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp49_)->depth = _tmp51_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp53_ = path;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp54_ = g_filename_to_uri (_tmp53_, NULL, &_inner_error_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp52_ = _tmp54_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_rygel_icon_info_unref0 (thumbnail);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		return NULL;
#line 692 "rygel-thumbnailer.c"
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp55_ = thumbnail;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (((RygelIconInfo*) _tmp55_)->uri);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp55_)->uri = _tmp52_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp56_ = thumbnail;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp57_ = info;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp58_ = g_file_info_get_attribute_uint64 (_tmp57_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp56_)->size = (gint64) _tmp58_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	result = thumbnail;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (path);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (info);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (file);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	return result;
#line 718 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_on_dbus_thumbnailer_ready (RygelThumbnailer* self, gboolean available) {
	gboolean _tmp0_ = FALSE;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_tmp0_ = available;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	if (!_tmp0_) {
#line 730 "rygel-thumbnailer.c"
		const gchar* _tmp1_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_g_object_unref0 (self->priv->thumbler);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		self->priv->thumbler = NULL;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		_tmp1_ = _ ("No D-Bus thumbnailer available");
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
		g_message ("rygel-thumbnailer.vala:132: %s", _tmp1_);
#line 740 "rygel-thumbnailer.c"
	}
}


static void rygel_thumbnailer_class_init (RygelThumbnailerClass * klass) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	rygel_thumbnailer_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	g_type_class_add_private (klass, sizeof (RygelThumbnailerPrivate));
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnailer_finalize;
#line 752 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_instance_init (RygelThumbnailer * self) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv = RYGEL_THUMBNAILER_GET_PRIVATE (self);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self->priv->thumbler = NULL;
#line 761 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_finalize (GObject* obj) {
	RygelThumbnailer * self;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAILER, RygelThumbnailer);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_rygel_icon_info_unref0 (self->priv->template);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_free0 (self->priv->extension);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	_g_object_unref0 (self->priv->thumbler);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-thumbnailer.vala"
	G_OBJECT_CLASS (rygel_thumbnailer_parent_class)->finalize (obj);
#line 777 "rygel-thumbnailer.c"
}


/**
 * Provides thumbnails for images and videos.
 */
GType rygel_thumbnailer_get_type (void) {
	static volatile gsize rygel_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnailer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnailer), 0, (GInstanceInitFunc) rygel_thumbnailer_instance_init, NULL };
		GType rygel_thumbnailer_type_id;
		rygel_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnailer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnailer_type_id__volatile, rygel_thumbnailer_type_id);
	}
	return rygel_thumbnailer_type_id__volatile;
}



