/* rygel-item-updater.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-item-updater.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Krzesimir Nowak <krnowak@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelItemUpdaterPrivate RygelItemUpdaterPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemUpdaterRunData RygelItemUpdaterRunData;
typedef struct _RygelItemUpdaterUpdateObjectData RygelItemUpdaterUpdateObjectData;
typedef struct _RygelItemUpdaterFetchObjectData RygelItemUpdaterFetchObjectData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelItemUpdater {
	GObject parent_instance;
	RygelItemUpdaterPrivate * priv;
};

struct _RygelItemUpdaterClass {
	GObjectClass parent_class;
};

struct _RygelItemUpdaterPrivate {
	gchar* object_id;
	gchar* current_tag_value;
	gchar* new_tag_value;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemUpdaterRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _error_;
	GError* _tmp7_;
	GUPnPServiceAction* _tmp8_;
	GError* _tmp9_;
	gint _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _RygelItemUpdaterUpdateObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	GeeLinkedList* current_list;
	const gchar* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* new_list;
	const gchar* _tmp3_;
	GeeLinkedList* _tmp4_;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelMediaObject* _tmp5_;
	GeeLinkedList* _tmp6_;
	GeeLinkedList* _tmp7_;
	RygelContentDirectory* _tmp8_;
	RygelHTTPServer* _tmp9_;
	GUPnPDIDLLiteFragmentResult _tmp10_;
	GUPnPDIDLLiteFragmentResult _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _RygelItemUpdaterFetchObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	RygelMediaObject* _tmp9_;
	GUPnPOCMFlags _tmp10_;
	GUPnPOCMFlags _tmp11_;
	gchar* msg;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	RygelMediaObject* _tmp19_;
	RygelMediaContainer* _tmp20_;
	RygelMediaContainer* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gchar* _vala1_msg;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObject* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaContainer* _tmp31_;
	RygelMediaContainer* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GError* _tmp35_;
	GError * _inner_error_;
};


static gpointer rygel_item_updater_parent_class = NULL;
static GRegex* rygel_item_updater_escape_regex;
static GRegex* rygel_item_updater_escape_regex = NULL;
static RygelStateMachineIface* rygel_item_updater_rygel_state_machine_parent_iface = NULL;

GType rygel_item_updater_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_UPDATER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterPrivate))
enum  {
	RYGEL_ITEM_UPDATER_DUMMY_PROPERTY,
	RYGEL_ITEM_UPDATER_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_item_updater_real_run_data_free (gpointer _data);
static void rygel_item_updater_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_updater_update_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_updater_update_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_item_updater_unescape (const gchar* value);
static GeeLinkedList* rygel_item_updater_csv_split (const gchar* tag_values);
static void rygel_item_updater_update_object_data_free (gpointer _data);
static gboolean rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_);
static void rygel_item_updater_fetch_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_item_updater_fetch_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_update_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_);
static void rygel_item_updater_fetch_object_data_free (gpointer _data);
static gboolean rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_item_updater_finalize (GObject* obj);
static void _vala_rygel_item_updater_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_updater_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 330 "rygel-item-updater.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return self ? g_object_ref (self) : NULL;
#line 337 "rygel-item-updater.c"
}


RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemUpdater * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelContentDirectory* _tmp1_ = NULL;
	RygelContentDirectory* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self = (RygelItemUpdater*) g_object_new (object_type, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp0_ = content_dir;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self->priv->content_dir = _tmp1_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp2_ = content_dir;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp4_ = action;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	action = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self->priv->action = _tmp4_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	__vala_GUPnPServiceAction_free0 (action);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return self;
#line 380 "rygel-item-updater.c"
}


RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return rygel_item_updater_construct (RYGEL_TYPE_ITEM_UPDATER, content_dir, action);
#line 387 "rygel-item-updater.c"
}


static void rygel_item_updater_real_run_data_free (gpointer _data) {
	RygelItemUpdaterRunData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_slice_free (RygelItemUpdaterRunData, _data_);
#line 398 "rygel-item-updater.c"
}


static void rygel_item_updater_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdater * self;
	RygelItemUpdaterRunData* _data_;
	RygelItemUpdater* _tmp0_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self = (RygelItemUpdater*) base;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = g_slice_new0 (RygelItemUpdaterRunData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_real_run);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_real_run_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_real_run_co (_data_);
#line 420 "rygel-item-updater.c"
}


static void rygel_item_updater_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemUpdaterRunData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 428 "rygel-item-updater.c"
}


static void rygel_item_updater_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterRunData* _data_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = _user_data_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_source_object_ = source_object;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_res_ = _res_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_real_run_co (_data_);
#line 442 "rygel-item-updater.c"
}


static gboolean rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	switch (_data_->_state_) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case 0:
#line 451 "rygel-item-updater.c"
		goto _state_0;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case 1:
#line 455 "rygel-item-updater.c"
		goto _state_1;
		default:
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_assert_not_reached ();
#line 460 "rygel-item-updater.c"
	}
	_state_0:
	{
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp0_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp0_ = _data_->self->priv->action;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		gupnp_service_action_get (_data_->_tmp0_, "ObjectID", G_TYPE_STRING, &_data_->self->priv->object_id, "CurrentTagValue", G_TYPE_STRING, &_data_->self->priv->current_tag_value, "NewTagValue", G_TYPE_STRING, &_data_->self->priv->new_tag_value, NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp1_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp1_ = _data_->self->priv->object_id;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_data_->_tmp1_ == NULL) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp2_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp2_ = _ ("Object id missing");
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp3_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp2_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp3_;
#line 486 "rygel-item-updater.c"
			goto __catch61_g_error;
		}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_state_ = 1;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		rygel_item_updater_update_object (_data_->self, rygel_item_updater_run_ready, _data_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return FALSE;
#line 495 "rygel-item-updater.c"
		_state_1:
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		rygel_item_updater_update_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_data_->_inner_error_ != NULL) {
#line 501 "rygel-item-updater.c"
			goto __catch61_g_error;
		}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp4_ = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp4_ = _data_->self->priv->action;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		gupnp_service_action_return (_data_->_tmp4_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp5_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp5_ = _ ("Successfully updated object '%s'");
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp6_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp6_ = _data_->self->priv->object_id;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_debug (_data_->_tmp5_, _data_->_tmp6_);
#line 520 "rygel-item-updater.c"
	}
	goto __finally61;
	__catch61_g_error:
	{
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_inner_error_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp7_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp7_ = _data_->_error_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_data_->_tmp7_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp8_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp8_ = _data_->self->priv->action;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp9_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp9_ = _data_->_error_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp10_ = 0;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp10_ = _data_->_tmp9_->code;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp11_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp11_ = _data_->_error_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp12_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp12_ = _data_->_tmp11_->message;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			gupnp_service_action_return_error (_data_->_tmp8_, (guint) _data_->_tmp10_, _data_->_tmp12_);
#line 557 "rygel-item-updater.c"
		} else {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp13_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp13_ = _data_->self->priv->action;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp14_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp14_ = _data_->_error_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp15_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp15_ = _data_->_tmp14_->message;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			gupnp_service_action_return_error (_data_->_tmp13_, (guint) 701, _data_->_tmp15_);
#line 573 "rygel-item-updater.c"
		}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp16_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp16_ = _ ("Failed to update object '%s': %s");
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp17_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp17_ = _data_->self->priv->object_id;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp18_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp18_ = _data_->_error_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp19_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp19_ = _data_->_tmp18_->message;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_warning (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp19_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_g_error_free0 (_data_->_error_);
#line 595 "rygel-item-updater.c"
	}
	__finally61:
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_clear_error (&_data_->_inner_error_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return FALSE;
#line 606 "rygel-item-updater.c"
	}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_state_ == 0) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 614 "rygel-item-updater.c"
	} else {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 618 "rygel-item-updater.c"
	}
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_object_unref (_data_->_async_result);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return FALSE;
#line 624 "rygel-item-updater.c"
}


static gchar* rygel_item_updater_unescape (const gchar* value) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 633 "rygel-item-updater.c"
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp1_ = rygel_item_updater_escape_regex;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp2_ = value;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp3_ = g_regex_replace (_tmp1_, _tmp2_, (gssize) (-1), 0, "\\1", 0, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp0_ = _tmp3_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 651 "rygel-item-updater.c"
				goto __catch62_g_regex_error;
			}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return NULL;
#line 660 "rygel-item-updater.c"
		}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		result = _tmp0_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return result;
#line 666 "rygel-item-updater.c"
	}
	goto __finally62;
	__catch62_g_regex_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_error_ = _inner_error_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_inner_error_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp4_ = value;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		result = _tmp5_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_g_error_free0 (_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return result;
#line 688 "rygel-item-updater.c"
	}
	__finally62:
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return NULL;
#line 697 "rygel-item-updater.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 965 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 715 "rygel-item-updater.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 738 "rygel-item-updater.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 746 "rygel-item-updater.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 758 "rygel-item-updater.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 783 "rygel-item-updater.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 789 "rygel-item-updater.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 793 "rygel-item-updater.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 799 "rygel-item-updater.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 811 "rygel-item-updater.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 821 "rygel-item-updater.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 827 "rygel-item-updater.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 841 "rygel-item-updater.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 851 "rygel-item-updater.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 857 "rygel-item-updater.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 866 "rygel-item-updater.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 886 "rygel-item-updater.c"
}


static GeeLinkedList* rygel_item_updater_csv_split (const gchar* tag_values) {
	GeeLinkedList* result = NULL;
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean escape = FALSE;
	gint token_start = 0;
	gint token_length = 0;
	gint len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GeeLinkedList* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	list = _tmp0_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp1_ = tag_values;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_tmp1_ == NULL) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		result = list;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return result;
#line 921 "rygel-item-updater.c"
	}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	escape = FALSE;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	token_start = 0;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	token_length = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp2_ = tag_values;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp3_ = strlen (_tmp2_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp4_ = _tmp3_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	len = _tmp4_;
#line 937 "rygel-item-updater.c"
	{
		gint iter = 0;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		iter = 0;
#line 942 "rygel-item-updater.c"
		{
			gboolean _tmp5_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_tmp5_ = TRUE;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			while (TRUE) {
#line 949 "rygel-item-updater.c"
				gboolean _tmp6_ = FALSE;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gchar c = '\0';
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gchar _tmp12_ = '\0';
				gboolean increase = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp25_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp6_ = _tmp5_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				if (!_tmp6_) {
#line 964 "rygel-item-updater.c"
					gint _tmp7_ = 0;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					_tmp7_ = iter;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					iter = _tmp7_ + 1;
#line 970 "rygel-item-updater.c"
				}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp5_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp8_ = iter;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp9_ = len;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					break;
#line 982 "rygel-item-updater.c"
				}
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp10_ = tag_values;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp11_ = iter;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp12_ = string_get (_tmp10_, (glong) _tmp11_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				c = _tmp12_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				increase = TRUE;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp13_ = escape;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				if (_tmp13_) {
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					escape = FALSE;
#line 1000 "rygel-item-updater.c"
				} else {
					gchar _tmp14_ = '\0';
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					_tmp14_ = c;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					switch (_tmp14_) {
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
						case '\\':
#line 1009 "rygel-item-updater.c"
						{
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							escape = TRUE;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							break;
#line 1015 "rygel-item-updater.c"
						}
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
						case ',':
#line 1019 "rygel-item-updater.c"
						{
							gchar* value = NULL;
							const gchar* _tmp15_ = NULL;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gchar* _tmp18_ = NULL;
							GeeLinkedList* _tmp19_ = NULL;
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp15_ = tag_values;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp16_ = token_start;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp17_ = token_length;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp18_ = string_substring (_tmp15_, (glong) _tmp16_, (glong) _tmp17_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							value = _tmp18_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp19_ = list;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp20_ = value;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp21_ = rygel_item_updater_unescape (_tmp20_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp22_ = _tmp21_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp22_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_g_free0 (_tmp22_);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp23_ = token_start;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_tmp24_ = token_length;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							token_start = _tmp23_ + (_tmp24_ + 1);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							token_length = 0;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							increase = FALSE;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							_g_free0 (value);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
							break;
#line 1068 "rygel-item-updater.c"
						}
						default:
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
						break;
#line 1073 "rygel-item-updater.c"
					}
				}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_tmp25_ = increase;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				if (_tmp25_) {
#line 1080 "rygel-item-updater.c"
					gint _tmp26_ = 0;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					_tmp26_ = token_length;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					token_length = _tmp26_ + 1;
#line 1086 "rygel-item-updater.c"
				}
			}
		}
	}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp27_ = list;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp28_ = tag_values;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp29_ = token_start;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp30_ = string_substring (_tmp28_, (glong) _tmp29_, (glong) (-1));
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp31_ = _tmp30_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp32_ = rygel_item_updater_unescape (_tmp31_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp33_ = _tmp32_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp33_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_free0 (_tmp33_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_free0 (_tmp31_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	result = list;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return result;
#line 1115 "rygel-item-updater.c"
}


static void rygel_item_updater_update_object_data_free (gpointer _data) {
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_slice_free (RygelItemUpdaterUpdateObjectData, _data_);
#line 1126 "rygel-item-updater.c"
}


static void rygel_item_updater_update_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdaterUpdateObjectData* _data_;
	RygelItemUpdater* _tmp0_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = g_slice_new0 (RygelItemUpdaterUpdateObjectData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_update_object);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_update_object_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_update_object_co (_data_);
#line 1145 "rygel-item-updater.c"
}


static void rygel_item_updater_update_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error) {
	RygelItemUpdaterUpdateObjectData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return;
#line 1155 "rygel-item-updater.c"
	}
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1159 "rygel-item-updater.c"
}


static void rygel_item_updater_update_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterUpdateObjectData* _data_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = _user_data_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_source_object_ = source_object;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_res_ = _res_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_update_object_co (_data_);
#line 1173 "rygel-item-updater.c"
}


static gboolean rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	switch (_data_->_state_) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case 0:
#line 1182 "rygel-item-updater.c"
		goto _state_0;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case 1:
#line 1186 "rygel-item-updater.c"
		goto _state_1;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case 2:
#line 1190 "rygel-item-updater.c"
		goto _state_2;
		default:
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_assert_not_reached ();
#line 1195 "rygel-item-updater.c"
	}
	_state_0:
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_state_ = 1;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_fetch_object (_data_->self, rygel_item_updater_update_object_ready, _data_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return FALSE;
#line 1204 "rygel-item-updater.c"
	_state_1:
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp0_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp0_ = rygel_item_updater_fetch_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->media_object = _data_->_tmp0_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_inner_error_ != NULL) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_error_free (_data_->_inner_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_data_->_state_ == 0) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1222 "rygel-item-updater.c"
		} else {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1226 "rygel-item-updater.c"
		}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_object_unref (_data_->_async_result);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return FALSE;
#line 1232 "rygel-item-updater.c"
	}
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp1_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp1_ = _data_->self->priv->current_tag_value;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp2_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp2_ = rygel_item_updater_csv_split (_data_->_tmp1_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->current_list = _data_->_tmp2_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp3_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp3_ = _data_->self->priv->new_tag_value;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp4_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp4_ = rygel_item_updater_csv_split (_data_->_tmp3_);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->new_list = _data_->_tmp4_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp5_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp5_ = _data_->media_object;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp6_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp6_ = _data_->current_list;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp7_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp7_ = _data_->new_list;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp8_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp8_ = _data_->self->priv->content_dir;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp9_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp9_ = _data_->_tmp8_->http_server;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_state_ = 2;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_media_object_apply_fragments (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_item_updater_update_object_ready, _data_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return FALSE;
#line 1280 "rygel-item-updater.c"
	_state_2:
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp10_ = 0;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp10_ = rygel_media_object_apply_fragments_finish (_data_->_tmp5_, _data_->_res_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_result_ = _data_->_tmp10_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp11_ = 0;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp11_ = _data_->_result_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	switch (_data_->_tmp11_) {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK:
#line 1296 "rygel-item-updater.c"
		{
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			break;
#line 1300 "rygel-item-updater.c"
		}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_BAD_XML:
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_INVALID:
#line 1306 "rygel-item-updater.c"
		{
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp12_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp12_ = _ ("Bad current tag value.");
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp13_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE, _data_->_tmp12_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp13_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_error_free (_data_->_inner_error_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->new_list);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->current_list);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->media_object);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_state_ == 0) {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1332 "rygel-item-updater.c"
			} else {
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1336 "rygel-item-updater.c"
			}
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_object_unref (_data_->_async_result);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return FALSE;
#line 1342 "rygel-item-updater.c"
		}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_BAD_XML:
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_INVALID:
#line 1348 "rygel-item-updater.c"
		{
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp14_ = NULL;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp14_ = _ ("Bad new tag value.");
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp15_ = NULL;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, _data_->_tmp14_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp15_;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_error_free (_data_->_inner_error_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->new_list);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->current_list);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->media_object);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_state_ == 0) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1374 "rygel-item-updater.c"
			} else {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1378 "rygel-item-updater.c"
			}
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_object_unref (_data_->_async_result);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return FALSE;
#line 1384 "rygel-item-updater.c"
		}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_REQUIRED_TAG:
#line 1388 "rygel-item-updater.c"
		{
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp16_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp16_ = _ ("Tried to delete required tag.");
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp17_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp17_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG, _data_->_tmp16_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp17_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_error_free (_data_->_inner_error_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->new_list);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->current_list);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->media_object);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_state_ == 0) {
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1414 "rygel-item-updater.c"
			} else {
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1418 "rygel-item-updater.c"
			}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_object_unref (_data_->_async_result);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return FALSE;
#line 1424 "rygel-item-updater.c"
		}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_READONLY_TAG:
#line 1428 "rygel-item-updater.c"
		{
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp18_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp18_ = _ ("Tried to change read-only property.");
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp19_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp19_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG, _data_->_tmp18_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp19_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_error_free (_data_->_inner_error_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->new_list);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->current_list);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->media_object);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_state_ == 0) {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1454 "rygel-item-updater.c"
			} else {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1458 "rygel-item-updater.c"
			}
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_object_unref (_data_->_async_result);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return FALSE;
#line 1464 "rygel-item-updater.c"
		}
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_MISMATCH:
#line 1468 "rygel-item-updater.c"
		{
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp20_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp20_ = _ ("Parameter count mismatch.");
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp21_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp21_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH, _data_->_tmp20_);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp21_;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_error_free (_data_->_inner_error_);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->new_list);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->current_list);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->media_object);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_state_ == 0) {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1494 "rygel-item-updater.c"
			} else {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1498 "rygel-item-updater.c"
			}
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_object_unref (_data_->_async_result);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return FALSE;
#line 1504 "rygel-item-updater.c"
		}
		default:
		{
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp22_ = NULL;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp22_ = _ ("Unknown error.");
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp23_ = NULL;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp23_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp22_);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp23_;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_error_free (_data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->new_list);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->current_list);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->media_object);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_state_ == 0) {
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1532 "rygel-item-updater.c"
			} else {
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1536 "rygel-item-updater.c"
			}
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_object_unref (_data_->_async_result);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return FALSE;
#line 1542 "rygel-item-updater.c"
		}
	}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->new_list);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->current_list);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->media_object);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_state_ == 0) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1555 "rygel-item-updater.c"
	} else {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1559 "rygel-item-updater.c"
	}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_object_unref (_data_->_async_result);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return FALSE;
#line 1565 "rygel-item-updater.c"
}


static void rygel_item_updater_fetch_object_data_free (gpointer _data) {
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_slice_free (RygelItemUpdaterFetchObjectData, _data_);
#line 1578 "rygel-item-updater.c"
}


static void rygel_item_updater_fetch_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdaterFetchObjectData* _data_;
	RygelItemUpdater* _tmp0_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = g_slice_new0 (RygelItemUpdaterFetchObjectData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_fetch_object);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_fetch_object_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_fetch_object_co (_data_);
#line 1597 "rygel-item-updater.c"
}


static RygelMediaObject* rygel_item_updater_fetch_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelItemUpdaterFetchObjectData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return NULL;
#line 1608 "rygel-item-updater.c"
	}
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return result;
#line 1618 "rygel-item-updater.c"
}


static void rygel_item_updater_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterFetchObjectData* _data_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_ = _user_data_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_source_object_ = source_object;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_res_ = _res_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_fetch_object_co (_data_);
#line 1632 "rygel-item-updater.c"
}


static gboolean rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	switch (_data_->_state_) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case 0:
#line 1641 "rygel-item-updater.c"
		goto _state_0;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case 1:
#line 1645 "rygel-item-updater.c"
		goto _state_1;
		default:
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_assert_not_reached ();
#line 1650 "rygel-item-updater.c"
	}
	_state_0:
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp0_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp0_ = _data_->self->priv->content_dir;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp1_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp2_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp2_ = _data_->self->priv->object_id;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp3_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp4_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_state_ = 1;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_media_container_find_object (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp4_, rygel_item_updater_fetch_object_ready, _data_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return FALSE;
#line 1679 "rygel-item-updater.c"
	_state_1:
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp5_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp5_ = rygel_media_container_find_object_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->media_object = _data_->_tmp5_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_inner_error_ != NULL) {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_error_free (_data_->_inner_error_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_data_->_state_ == 0) {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1697 "rygel-item-updater.c"
		} else {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1701 "rygel-item-updater.c"
		}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_object_unref (_data_->_async_result);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return FALSE;
#line 1707 "rygel-item-updater.c"
	}
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp6_ = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->_tmp6_ = _data_->media_object;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_tmp6_ == NULL) {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp7_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp7_ = _ ("No such object");
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp8_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp7_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_error_free (_data_->_inner_error_);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_g_object_unref0 (_data_->media_object);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_data_->_state_ == 0) {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1735 "rygel-item-updater.c"
		} else {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1739 "rygel-item-updater.c"
		}
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_object_unref (_data_->_async_result);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		return FALSE;
#line 1745 "rygel-item-updater.c"
	} else {
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp9_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp9_ = _data_->media_object;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp10_ = 0;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp10_ = rygel_media_object_get_ocm_flags (_data_->_tmp9_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp11_ = 0;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (!((_data_->_tmp11_ & GUPNP_OCM_FLAGS_CHANGE_METADATA) == GUPNP_OCM_FLAGS_CHANGE_METADATA)) {
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp12_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp12_ = _ ("Metadata modification of object %s not allowed");
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp13_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->msg = _data_->_tmp13_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp14_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp14_ = _data_->msg;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp15_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp15_ = _data_->media_object;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp16_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp16_ = rygel_media_object_get_id (_data_->_tmp15_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp17_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp18_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp18_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT, _data_->_tmp14_, _data_->_tmp17_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_inner_error_ = _data_->_tmp18_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_error_free (_data_->_inner_error_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_free0 (_data_->msg);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_g_object_unref0 (_data_->media_object);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_state_ == 0) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1805 "rygel-item-updater.c"
			} else {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1809 "rygel-item-updater.c"
			}
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_object_unref (_data_->_async_result);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			return FALSE;
#line 1815 "rygel-item-updater.c"
		} else {
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp19_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp19_ = _data_->media_object;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp20_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp20_ = rygel_media_object_get_parent (_data_->_tmp19_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp21_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp21_ = _data_->_tmp20_;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp22_ = FALSE;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp22_ = rygel_media_object_get_restricted ((RygelMediaObject*) _data_->_tmp21_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp23_ = FALSE;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			_data_->_tmp23_ = _data_->_tmp22_;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_data_->_tmp23_) {
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp24_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp24_ = _ ("Metadata modification of object %s being a child of restricted object " \
"%s not allowed");
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp25_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_vala1_msg = _data_->_tmp25_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp26_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp26_ = _data_->_vala1_msg;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp27_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp27_ = _data_->media_object;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp28_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp28_ = rygel_media_object_get_id (_data_->_tmp27_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp29_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp29_ = _data_->_tmp28_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp30_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp30_ = _data_->media_object;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp31_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp31_ = rygel_media_object_get_parent (_data_->_tmp30_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp32_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp32_ = _data_->_tmp31_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp33_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp33_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp32_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp34_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp34_ = _data_->_tmp33_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp35_ = NULL;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_tmp35_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp26_, _data_->_tmp29_, _data_->_tmp34_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_data_->_inner_error_ = _data_->_tmp35_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_error_free (_data_->_inner_error_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_g_free0 (_data_->_vala1_msg);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				_g_object_unref0 (_data_->media_object);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				if (_data_->_state_ == 0) {
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1903 "rygel-item-updater.c"
				} else {
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1907 "rygel-item-updater.c"
				}
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				g_object_unref (_data_->_async_result);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
				return FALSE;
#line 1913 "rygel-item-updater.c"
			}
		}
	}
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_data_->result = _data_->media_object;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_state_ == 0) {
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1923 "rygel-item-updater.c"
	} else {
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1927 "rygel-item-updater.c"
	}
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_object_unref (_data_->_async_result);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return FALSE;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (_data_->media_object);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_data_->_state_ == 0) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1939 "rygel-item-updater.c"
	} else {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1943 "rygel-item-updater.c"
	}
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_object_unref (_data_->_async_result);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return FALSE;
#line 1949 "rygel-item-updater.c"
}


static GCancellable* rygel_item_updater_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemUpdater* self;
	GCancellable* _tmp0_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self = (RygelItemUpdater*) base;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp0_ = self->priv->_cancellable;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	result = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	return result;
#line 1965 "rygel-item-updater.c"
}


static void rygel_item_updater_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemUpdater* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self = (RygelItemUpdater*) base;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp0_ = value;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self->priv->_cancellable = _tmp1_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1985 "rygel-item-updater.c"
}


static void rygel_item_updater_class_init (RygelItemUpdaterClass * klass) {
	GError * _inner_error_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_type_class_add_private (klass, sizeof (RygelItemUpdaterPrivate));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_updater_get_property;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_updater_set_property;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_item_updater_finalize;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_UPDATER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2003 "rygel-item-updater.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp1_ = g_regex_new ("\\\\(.)", 0, 0, &_inner_error_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_tmp0_ = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		if (_inner_error_ != NULL) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2015 "rygel-item-updater.c"
				goto __catch63_g_regex_error;
			}
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
			g_clear_error (&_inner_error_);
#line 2022 "rygel-item-updater.c"
		}
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_g_regex_unref0 (rygel_item_updater_escape_regex);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		rygel_item_updater_escape_regex = _tmp0_;
#line 2028 "rygel-item-updater.c"
	}
	goto __finally63;
	__catch63_g_regex_error:
	{
		GError* _error_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_error_ = _inner_error_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_inner_error_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_assert_not_reached ();
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		_g_error_free0 (_error_);
#line 2042 "rygel-item-updater.c"
	}
	__finally63:
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	if (_inner_error_ != NULL) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_clear_error (&_inner_error_);
#line 2051 "rygel-item-updater.c"
	}
}


static void rygel_item_updater_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	rygel_item_updater_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_updater_real_run;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	iface->run_finish = rygel_item_updater_real_run_finish;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	iface->get_cancellable = rygel_item_updater_real_get_cancellable;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	iface->set_cancellable = rygel_item_updater_real_set_cancellable;
#line 2067 "rygel-item-updater.c"
}


static void rygel_item_updater_instance_init (RygelItemUpdater * self) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self->priv = RYGEL_ITEM_UPDATER_GET_PRIVATE (self);
#line 2074 "rygel-item-updater.c"
}


static void rygel_item_updater_finalize (GObject* obj) {
	RygelItemUpdater * self;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_free0 (self->priv->object_id);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_free0 (self->priv->current_tag_value);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_free0 (self->priv->new_tag_value);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	G_OBJECT_CLASS (rygel_item_updater_parent_class)->finalize (obj);
#line 2096 "rygel-item-updater.c"
}


/**
 * UpdateObject action implementation.
 */
GType rygel_item_updater_get_type (void) {
	static volatile gsize rygel_item_updater_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_updater_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemUpdaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_updater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemUpdater), 0, (GInstanceInitFunc) rygel_item_updater_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_updater_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_updater_type_id;
		rygel_item_updater_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemUpdater", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_updater_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_updater_type_id__volatile, rygel_item_updater_type_id);
	}
	return rygel_item_updater_type_id__volatile;
}


static void _vala_rygel_item_updater_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case RYGEL_ITEM_UPDATER_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		break;
#line 2128 "rygel-item-updater.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		break;
#line 2134 "rygel-item-updater.c"
	}
}


static void _vala_rygel_item_updater_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
	switch (property_id) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		case RYGEL_ITEM_UPDATER_CANCELLABLE:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		break;
#line 2150 "rygel-item-updater.c"
		default:
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-item-updater.vala"
		break;
#line 2156 "rygel-item-updater.c"
	}
}



