/* rygel-http-post.c generated by valac 0.13.4, the Vala compiler
 * generated from rygel-http-post.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPPostPrivate RygelHTTPPostPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpPostHandleData RygelHttpPostHandleData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHttpPostHandleRealData RygelHttpPostHandleRealData;
typedef struct _Block2Data Block2Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _RygelHttpPostRemoveItemData RygelHttpPostRemoveItemData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPPost {
	RygelHTTPRequest parent_instance;
	RygelHTTPPostPrivate * priv;
};

struct _RygelHTTPPostClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPPostPrivate {
	GSourceFunc handle_continue;
	gpointer handle_continue_target;
	GDestroyNotify handle_continue_target_destroy_notify;
	GFile* file;
	GOutputStream* stream;
};

struct _RygelHttpPostHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
	RygelItemRemovalQueue* _tmp1_;
	RygelMediaItem* _tmp2_;
	GError* _error_;
	RygelItemRemovalQueue* _tmp3_;
	RygelMediaItem* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpPostHandleRealData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	RygelMediaItem* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* msg;
	const gchar* _tmp7_;
	RygelMediaItem* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	RygelMediaItem* _tmp11_;
	GCancellable* _tmp12_;
	GCancellable* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	const gchar* _tmp17_;
	RygelMediaItem* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GFile* _tmp21_;
	GCancellable* _tmp22_;
	GCancellable* _tmp23_;
	GFileOutputStream* _tmp24_;
	GFileOutputStream* _tmp25_;
	SoupServer* _tmp26_;
	SoupMessage* _tmp27_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	RygelHTTPPost * self;
	GMainLoop* main_loop;
};

struct _RygelHttpPostRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPost* self;
	RygelItemRemovalQueue* _tmp0_;
	RygelItemRemovalQueue* queue;
	RygelMediaItem* _tmp1_;
};


static gpointer rygel_http_post_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_post_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST, RygelHTTPPostPrivate))
enum  {
	RYGEL_HTTP_POST_DUMMY_PROPERTY
};
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self);
static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self);
static void rygel_http_post_real_handle_data_free (gpointer _data);
static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static void rygel_http_post_handle_real_data_free (gpointer _data);
static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_);
static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk);
static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg);
static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GQuark rygel_content_directory_error_quark (void);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark rygel_http_request_error_quark (void);
static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void ___lambda6_ (Block2Data* _data2_, RygelMediaContainer* container);
static void ____lambda6__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean ___lambda7_ (Block2Data* _data2_);
static gboolean ____lambda7__gsource_func (gpointer self);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_);
static void rygel_http_post_remove_item_data_free (gpointer _data);
static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_);
static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_post_finalize (GObject* obj);


static void _rygel_http_post_on_request_cancelled_gfunc (gconstpointer data, gpointer self) {
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_on_request_cancelled (self);
#line 368 "rygel-http-post.c"
}


RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPPost * self = NULL;
	RygelHTTPServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageBody* _tmp6_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp0_ = http_server;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp1_ = server;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp2_ = msg;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self = (RygelHTTPPost*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp4_ = _tmp3_;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_cancellable_connect (_tmp4_, (GCallback*) _rygel_http_post_on_request_cancelled_gfunc, g_object_ref (self), g_object_unref);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp5_ = msg;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp6_ = _tmp5_->request_body;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	soup_message_body_set_accumulate (_tmp6_, FALSE);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return self;
#line 409 "rygel-http-post.c"
}


RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return rygel_http_post_construct (RYGEL_TYPE_HTTP_POST, http_server, server, msg);
#line 416 "rygel-http-post.c"
}


static void rygel_http_post_real_handle_data_free (gpointer _data) {
	RygelHttpPostHandleData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_slice_free (RygelHttpPostHandleData, _data_);
#line 427 "rygel-http-post.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return self ? g_object_ref (self) : NULL;
#line 434 "rygel-http-post.c"
}


static void rygel_http_post_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPPost * self;
	RygelHttpPostHandleData* _data_;
	RygelHTTPPost* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self = (RygelHTTPPost*) base;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostHandleData);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_real_handle);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_real_handle_data_free);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_real_handle_co (_data_);
#line 456 "rygel-http-post.c"
}


static void rygel_http_post_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleData* _data_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return;
#line 466 "rygel-http-post.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 470 "rygel-http-post.c"
}


static void rygel_http_post_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleData* _data_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = _user_data_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_real_handle_co (_data_);
#line 484 "rygel-http-post.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return self ? g_error_copy (self) : NULL;
#line 491 "rygel-http-post.c"
}


static gboolean rygel_http_post_real_handle_co (RygelHttpPostHandleData* _data_) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 0:
#line 500 "rygel-http-post.c"
		goto _state_0;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 1:
#line 504 "rygel-http-post.c"
		goto _state_1;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 2:
#line 508 "rygel-http-post.c"
		goto _state_2;
		default:
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_assert_not_reached ();
#line 513 "rygel-http-post.c"
	}
	_state_0:
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp0_ = rygel_item_removal_queue_get_default ();
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->queue = _data_->_tmp0_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp1_ = _data_->queue;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_item_removal_queue_dequeue (_data_->_tmp1_, _data_->_tmp2_);
#line 528 "rygel-http-post.c"
	{
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_state_ = 1;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		rygel_http_post_handle_real (_data_->self, rygel_http_post_handle_ready, _data_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return FALSE;
#line 536 "rygel-http-post.c"
		_state_1:
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		rygel_http_post_handle_real_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_data_->_inner_error_ != NULL) {
#line 542 "rygel-http-post.c"
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_inner_error_ = NULL;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp3_ = _data_->queue;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_state_ = 2;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		rygel_item_removal_queue_remove_now (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp6_, rygel_http_post_handle_ready, _data_);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return FALSE;
#line 567 "rygel-http-post.c"
		_state_2:
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		rygel_item_removal_queue_remove_now_finish (_data_->_tmp3_, _data_->_res_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp7_ = _data_->_error_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_g_error_free0 (_data_->_error_);
#line 579 "rygel-http-post.c"
		goto __finally37;
	}
	__finally37:
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_g_object_unref0 (_data_->queue);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 595 "rygel-http-post.c"
		} else {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 599 "rygel-http-post.c"
		}
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return FALSE;
#line 605 "rygel-http-post.c"
	}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (_data_->queue);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 613 "rygel-http-post.c"
	} else {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 617 "rygel-http-post.c"
	}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return FALSE;
#line 623 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_data_free (gpointer _data) {
	RygelHttpPostHandleRealData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_slice_free (RygelHttpPostHandleRealData, _data_);
#line 634 "rygel-http-post.c"
}


static void rygel_http_post_handle_real (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
	RygelHTTPPost* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostHandleRealData);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_handle_real);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_handle_real_data_free);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_handle_real_co (_data_);
#line 653 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_finish (RygelHTTPPost* self, GAsyncResult* _res_, GError** error) {
	RygelHttpPostHandleRealData* _data_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return;
#line 663 "rygel-http-post.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 667 "rygel-http-post.c"
}


static void _rygel_http_post_on_got_chunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_on_got_chunk (self, _sender, chunk);
#line 674 "rygel-http-post.c"
}


static void _rygel_http_post_on_got_body_soup_message_got_body (SoupMessage* _sender, gpointer self) {
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_on_got_body (self, _sender);
#line 681 "rygel-http-post.c"
}


static void rygel_http_post_handle_real_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostHandleRealData* _data_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = _user_data_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_handle_real_co (_data_);
#line 695 "rygel-http-post.c"
}


static gboolean _rygel_http_post_handle_real_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_post_handle_real_co (self);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return result;
#line 704 "rygel-http-post.c"
}


static gboolean rygel_http_post_handle_real_co (RygelHttpPostHandleRealData* _data_) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 0:
#line 713 "rygel-http-post.c"
		goto _state_0;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 1:
#line 717 "rygel-http-post.c"
		goto _state_1;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 2:
#line 721 "rygel-http-post.c"
		goto _state_2;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 3:
#line 725 "rygel-http-post.c"
		goto _state_3;
		default:
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_assert_not_reached ();
#line 730 "rygel-http-post.c"
	}
	_state_0:
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_signal_connect_object (_data_->_tmp0_, "got-chunk", (GCallback) _rygel_http_post_on_got_chunk_soup_message_got_chunk, _data_->self, 0);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_signal_connect_object (_data_->_tmp1_, "got-body", (GCallback) _rygel_http_post_on_got_body_soup_message_got_body, _data_->self, 0);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp2_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp3_ = rygel_media_item_get_place_holder (_data_->_tmp2_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (!_data_->_tmp4_) {
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp5_ = NULL;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp5_ = _ ("Pushing data to non-empty item '%s' not allowed");
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->msg = _data_->_tmp6_;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp7_ = _data_->msg;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp8_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp9_ = ((RygelMediaObject*) _data_->_tmp8_)->id;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp10_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp7_, _data_->_tmp9_);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp10_;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_g_free0 (_data_->msg);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 777 "rygel-http-post.c"
		} else {
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 781 "rygel-http-post.c"
		}
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return FALSE;
#line 787 "rygel-http-post.c"
	}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp12_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp13_ = _data_->_tmp12_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->_tmp11_, _data_->_tmp13_, rygel_http_post_handle_real_ready, _data_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return FALSE;
#line 801 "rygel-http-post.c"
	_state_1:
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp14_ = NULL;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp14_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 819 "rygel-http-post.c"
		} else {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 823 "rygel-http-post.c"
		}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return FALSE;
#line 829 "rygel-http-post.c"
	}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->file);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->file = _data_->_tmp15_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp16_ = _data_->self->priv->file;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_data_->_tmp16_ == NULL) {
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp17_ = NULL;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp17_ = _ ("No writable URI for %s available");
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp18_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp19_ = ((RygelMediaObject*) _data_->_tmp18_)->id;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_tmp20_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp17_, _data_->_tmp19_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data_->_inner_error_ = _data_->_tmp20_;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 859 "rygel-http-post.c"
		} else {
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 863 "rygel-http-post.c"
		}
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return FALSE;
#line 869 "rygel-http-post.c"
	}
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp21_ = _data_->self->priv->file;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp22_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_state_ = 2;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_file_replace_async (_data_->_tmp21_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_LOW, _data_->_tmp23_, rygel_http_post_handle_real_ready, _data_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return FALSE;
#line 883 "rygel-http-post.c"
	_state_2:
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp24_ = NULL;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp24_ = g_file_replace_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp25_ = _data_->_tmp24_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_data_->_inner_error_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_error_free (_data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_data_->_state_ == 0) {
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 901 "rygel-http-post.c"
		} else {
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 905 "rygel-http-post.c"
		}
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_object_unref (_data_->_async_result);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return FALSE;
#line 911 "rygel-http-post.c"
	}
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (_data_->self->priv->stream);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->stream = (GOutputStream*) _data_->_tmp25_;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp27_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	soup_server_unpause_message (_data_->_tmp26_, _data_->_tmp27_);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	(_data_->self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->handle_continue_target_destroy_notify (_data_->self->priv->handle_continue_target), NULL);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->handle_continue = NULL;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target = NULL;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->handle_continue = _rygel_http_post_handle_real_co_gsource_func;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target = _data_;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self->priv->handle_continue_target_destroy_notify = NULL;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_state_ = 3;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return FALSE;
#line 941 "rygel-http-post.c"
	_state_3:
	;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 948 "rygel-http-post.c"
	} else {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 952 "rygel-http-post.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return FALSE;
#line 958 "rygel-http-post.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return _data2_;
#line 967 "rygel-http-post.c"
}


static void block2_data_unref (Block2Data* _data2_) {
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_g_object_unref0 (_data2_->self);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_g_main_loop_unref0 (_data2_->main_loop);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_slice_free (Block2Data, _data2_);
#line 980 "rygel-http-post.c"
	}
}


static void ___lambda6_ (Block2Data* _data2_, RygelMediaContainer* container) {
	RygelHTTPPost * self;
	GMainLoop* _tmp0_;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self = _data2_->self;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_if_fail (container != NULL);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp0_ = _data2_->main_loop;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_main_loop_quit (_tmp0_);
#line 996 "rygel-http-post.c"
}


static void ____lambda6__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	___lambda6_ (self, container);
#line 1003 "rygel-http-post.c"
}


static gboolean ___lambda7_ (Block2Data* _data2_) {
	RygelHTTPPost * self;
	gboolean result = FALSE;
	RygelMediaItem* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GMainLoop* _tmp3_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self = _data2_->self;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->item;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->parent;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp2_ = ((RygelMediaObject*) _tmp1_)->id;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_debug ("rygel-http-post.vala:104: Timeout while waiting for 'updated' signal o" \
"n '%s'.", _tmp2_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp3_ = _data2_->main_loop;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_main_loop_quit (_tmp3_);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	result = FALSE;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return result;
#line 1032 "rygel-http-post.c"
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ (self);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return result;
#line 1041 "rygel-http-post.c"
}


static void rygel_http_post_on_got_body (RygelHTTPPost* self, SoupMessage* msg) {
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	GError * _inner_error_ = NULL;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_if_fail (msg != NULL);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp1_ = msg;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_tmp0_ != _tmp1_) {
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return;
#line 1061 "rygel-http-post.c"
	}
	{
		Block2Data* _data2_;
		GOutputStream* _tmp2_;
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		GMainLoop* _tmp5_;
		RygelMediaItem* _tmp6_;
		RygelMediaContainer* _tmp7_;
		guint _tmp8_ = 0U;
		guint timeout_id;
		RygelMediaItem* _tmp9_;
		RygelMediaContainer* _tmp10_;
		const gchar* _tmp11_;
		RygelMediaItem* _tmp12_;
		const gchar* _tmp13_;
		GMainLoop* _tmp14_;
		guint _tmp15_;
		RygelMediaItem* _tmp16_;
		RygelMediaContainer* _tmp17_;
		const gchar* _tmp18_;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data2_ = g_slice_new0 (Block2Data);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data2_->_ref_count_ = 1;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data2_->self = g_object_ref (self);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp2_ = self->priv->stream;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp4_ = _tmp3_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_output_stream_close (_tmp2_, _tmp4_, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			block2_data_unref (_data2_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
			_data2_ = NULL;
#line 1103 "rygel-http-post.c"
			goto __catch38_g_error;
		}
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp5_ = g_main_loop_new (NULL, FALSE);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data2_->main_loop = _tmp5_;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp6_ = ((RygelHTTPRequest*) self)->item;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp7_ = ((RygelMediaObject*) _tmp6_)->parent;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_signal_connect_data (_tmp7_, "container-updated", (GCallback) ____lambda6__rygel_media_container_container_updated, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp8_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ____lambda7__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		timeout_id = _tmp8_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp9_ = ((RygelHTTPRequest*) self)->item;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp10_ = ((RygelMediaObject*) _tmp9_)->parent;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp11_ = ((RygelMediaObject*) _tmp10_)->id;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp12_ = ((RygelHTTPRequest*) self)->item;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp13_ = ((RygelMediaObject*) _tmp12_)->id;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_debug ("Waiting for update signal from container '%s' after pushing" " content to its child item '%s'..", _tmp11_, _tmp13_);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp14_ = _data2_->main_loop;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_main_loop_run (_tmp14_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp15_ = timeout_id;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_source_remove (_tmp15_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp16_ = ((RygelHTTPRequest*) self)->item;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp17_ = ((RygelMediaObject*) _tmp16_)->parent;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp18_ = ((RygelMediaObject*) _tmp17_)->id;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_debug ("rygel-http-post.vala:117: Finished waiting for update signal from cont" \
"ainer '%s'", _tmp18_);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		rygel_http_request_end ((RygelHTTPRequest*) self, (guint) SOUP_STATUS_OK);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		block2_data_unref (_data2_);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_data2_ = NULL;
#line 1154 "rygel-http-post.c"
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* _error_ = NULL;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_error_ = _inner_error_;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_inner_error_ = NULL;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		rygel_http_request_end ((RygelHTTPRequest*) self, (guint) SOUP_STATUS_INTERNAL_SERVER_ERROR);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_g_error_free0 (_error_);
#line 1168 "rygel-http-post.c"
	}
	__finally38:
	{
		GSourceFunc _tmp19_;
		void* _tmp19__target;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp19_ = self->priv->handle_continue;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp19__target = self->priv->handle_continue_target;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp19_ (_tmp19__target);
#line 1180 "rygel-http-post.c"
	}
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return;
#line 1190 "rygel-http-post.c"
	}
}


static void rygel_http_post_on_got_chunk (RygelHTTPPost* self, SoupMessage* msg, SoupBuffer* chunk) {
	GError * _inner_error_ = NULL;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_if_fail (msg != NULL);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_if_fail (chunk != NULL);
#line 1203 "rygel-http-post.c"
	{
		GOutputStream* _tmp0_;
		SoupBuffer* _tmp1_;
		guint8* _tmp2_;
		gint _tmp2__length1;
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp0_ = self->priv->stream;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp1_ = chunk;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp2_ = _tmp1_->data;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp2__length1 = (gint) _tmp1_->length;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp4_ = _tmp3_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_output_stream_write_all (_tmp0_, _tmp2_, (gsize) _tmp2__length1, NULL, _tmp4_, &_inner_error_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		if (_inner_error_ != NULL) {
#line 1227 "rygel-http-post.c"
			goto __catch39_g_error;
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		GSourceFunc _tmp6_;
		void* _tmp6__target;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_error_ = _inner_error_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_inner_error_ = NULL;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp5_ = _error_;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		rygel_http_request_handle_error ((RygelHTTPRequest*) self, _tmp5_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp6_ = self->priv->handle_continue;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp6__target = self->priv->handle_continue_target;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_tmp6_ (_tmp6__target);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		_g_error_free0 (_error_);
#line 1254 "rygel-http-post.c"
	}
	__finally39:
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_inner_error_ != NULL) {
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_clear_error (&_inner_error_);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		return;
#line 1265 "rygel-http-post.c"
	}
}


static void rygel_http_post_on_request_cancelled (RygelHTTPPost* self) {
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_remove_item (self, NULL, NULL);
#line 1275 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_data_free (gpointer _data) {
	RygelHttpPostRemoveItemData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_slice_free (RygelHttpPostRemoveItemData, _data_);
#line 1286 "rygel-http-post.c"
}


static void rygel_http_post_remove_item (RygelHTTPPost* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
	RygelHTTPPost* _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = g_slice_new0 (RygelHttpPostRemoveItemData);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_remove_item);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_remove_item_data_free);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_remove_item_co (_data_);
#line 1305 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_finish (RygelHTTPPost* self, GAsyncResult* _res_) {
	RygelHttpPostRemoveItemData* _data_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1313 "rygel-http-post.c"
}


static void rygel_http_post_remove_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostRemoveItemData* _data_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_ = _user_data_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_source_object_ = source_object;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_res_ = _res_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_remove_item_co (_data_);
#line 1327 "rygel-http-post.c"
}


static gboolean rygel_http_post_remove_item_co (RygelHttpPostRemoveItemData* _data_) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	switch (_data_->_state_) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 0:
#line 1336 "rygel-http-post.c"
		goto _state_0;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		case 1:
#line 1340 "rygel-http-post.c"
		goto _state_1;
		default:
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_assert_not_reached ();
#line 1345 "rygel-http-post.c"
	}
	_state_0:
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp0_ = NULL;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp0_ = rygel_item_removal_queue_get_default ();
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->queue = _data_->_tmp0_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->item;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_data_->_state_ = 1;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_item_removal_queue_remove_now (_data_->queue, _data_->_tmp1_, NULL, rygel_http_post_remove_item_ready, _data_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return FALSE;
#line 1362 "rygel-http-post.c"
	_state_1:
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_item_removal_queue_remove_now_finish (_data_->queue, _data_->_res_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (_data_->queue);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	if (_data_->_state_ == 0) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1372 "rygel-http-post.c"
	} else {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1376 "rygel-http-post.c"
	}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_object_unref (_data_->_async_result);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	return FALSE;
#line 1382 "rygel-http-post.c"
}


static void rygel_http_post_class_init (RygelHTTPPostClass * klass) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	rygel_http_post_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPPostPrivate));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_post_real_handle;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_post_real_handle_finish;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_finalize;
#line 1397 "rygel-http-post.c"
}


static void rygel_http_post_instance_init (RygelHTTPPost * self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self->priv = RYGEL_HTTP_POST_GET_PRIVATE (self);
#line 1404 "rygel-http-post.c"
}


static void rygel_http_post_finalize (GObject* obj) {
	RygelHTTPPost * self;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self = RYGEL_HTTP_POST (obj);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	(self->priv->handle_continue_target_destroy_notify == NULL) ? NULL : (self->priv->handle_continue_target_destroy_notify (self->priv->handle_continue_target), NULL);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self->priv->handle_continue = NULL;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self->priv->handle_continue_target = NULL;
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	self->priv->handle_continue_target_destroy_notify = NULL;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (self->priv->file);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	_g_object_unref0 (self->priv->stream);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-http-post.vala"
	G_OBJECT_CLASS (rygel_http_post_parent_class)->finalize (obj);
#line 1426 "rygel-http-post.c"
}


/**
 * Responsible for handling HTTP POST client requests.
 */
GType rygel_http_post_get_type (void) {
	static volatile gsize rygel_http_post_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPost), 0, (GInstanceInitFunc) rygel_http_post_instance_init, NULL };
		GType rygel_http_post_type_id;
		rygel_http_post_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPPost", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_type_id__volatile, rygel_http_post_type_id);
	}
	return rygel_http_post_type_id__volatile;
}



