/* rygel-root-device-factory.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libgssdp/gssdp.h>
#include <stdio.h>
#include <gio/gio.h>
#include <libxml/parser.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _RygelParamSpecRootDeviceFactory RygelParamSpecRootDeviceFactory;

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	RygelConfiguration* config;
	gchar* desc_dir;
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelParamSpecRootDeviceFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_root_device_factory_parent_class = NULL;

void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid, guchar* output);
GQuark root_device_factory_error_quark (void);
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelXBoxHacks* rygel_xbox_hacks_new (void);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error);
static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin);
static void rygel_root_device_factory_save_modified_desc (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title);
static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self);
static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info);
static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin);
static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj);


GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return self ? g_object_ref (self) : NULL;
#line 308 "rygel-root-device-factory.c"
}


RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
	RygelRootDeviceFactory* self = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	GUPnPContext* _tmp1_;
	GUPnPContext* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* config_dir;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	self = (RygelRootDeviceFactory*) g_type_create_instance (object_type);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = rygel_meta_config_get_default ();
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->config);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	self->priv->config = (RygelConfiguration*) _tmp0_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = context;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (self->context);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	self->context = _tmp2_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = g_get_user_config_dir ();
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	config_dir = _tmp4_;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp5_ = config_dir;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, _tmp5_, &_inner_error_);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (config_dir);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_rygel_root_device_factory_unref0 (self);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 363 "rygel-root-device-factory.c"
	}
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp6_ = config_dir;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp7_ = g_build_filename (_tmp6_, "Rygel", NULL);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (self->priv->desc_dir);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	self->priv->desc_dir = _tmp7_;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp8_ = self->priv->desc_dir;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_ensure_dir_exists (self, _tmp8_, &_inner_error_);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (config_dir);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_rygel_root_device_factory_unref0 (self);
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 387 "rygel-root-device-factory.c"
	}
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (config_dir);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return self;
#line 393 "rygel-root-device-factory.c"
}


RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
#line 400 "rygel-root-device-factory.c"
}


RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
	RygelRootDevice* result = NULL;
	const gchar* _tmp0_;
	RygelPlugin* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* desc_path;
	RygelPlugin* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* template_path;
	RygelPlugin* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GUPnPXMLDoc* _tmp13_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPContext* _tmp14_;
	RygelPlugin* _tmp15_;
	GUPnPXMLDoc* _tmp16_;
	const gchar* _tmp17_;
	RygelRootDevice* _tmp18_;
	RygelRootDevice* device;
	RygelXBoxHacks* _tmp19_;
	RygelXBoxHacks* xbox_hacks;
	RygelXBoxHacks* _tmp20_;
	RygelRootDevice* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_ = NULL;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = self->priv->desc_dir;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = plugin;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = _tmp1_->name;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = g_strconcat (_tmp2_, ".xml", NULL);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp4_ = _tmp3_;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp5_ = g_build_filename (_tmp0_, _tmp4_, NULL);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp6_ = _tmp5_;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (_tmp4_);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	desc_path = _tmp6_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp7_ = plugin;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp8_ = _tmp7_->desc_path;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	template_path = _tmp9_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp10_ = plugin;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp11_ = desc_path;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp12_ = template_path;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp13_ = rygel_root_device_factory_create_desc (self, _tmp10_, _tmp11_, _tmp12_, &_inner_error_);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	doc = _tmp13_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (template_path);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (desc_path);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 485 "rygel-root-device-factory.c"
	}
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp14_ = self->context;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp15_ = plugin;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp16_ = doc;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp17_ = desc_path;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp18_ = rygel_root_device_new (_tmp14_, _tmp15_, _tmp16_, _tmp17_, DATA_DIR);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	device = _tmp18_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp19_ = rygel_xbox_hacks_new ();
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xbox_hacks = _tmp19_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp20_ = xbox_hacks;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp21_ = device;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp22_ = desc_path;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_xbox_hacks_apply_on_device (_tmp20_, _tmp21_, _tmp22_, &_inner_error_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (xbox_hacks);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (device);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (doc);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (template_path);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (desc_path);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 527 "rygel-root-device-factory.c"
	}
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	result = device;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (xbox_hacks);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (doc);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (template_path);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (desc_path);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return result;
#line 541 "rygel-root-device-factory.c"
}


static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GUPnPXMLDoc* doc;
	GUPnPXMLDoc* _tmp3_;
	RygelPlugin* _tmp4_;
	GUPnPXMLDoc* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (desc_path != NULL, NULL);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (template_path != NULL, NULL);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = desc_path;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = template_path;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = rygel_root_device_factory_get_latest_doc (self, _tmp0_, _tmp1_, &_inner_error_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	doc = _tmp2_;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 578 "rygel-root-device-factory.c"
	}
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = doc;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp4_ = plugin;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_prepare_desc_for_plugin (self, _tmp3_, _tmp4_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp5_ = doc;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp6_ = desc_path;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_save_modified_desc (self, _tmp5_, _tmp6_, &_inner_error_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (doc);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 600 "rygel-root-device-factory.c"
	}
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	result = doc;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return result;
#line 606 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin) {
	xmlNode* device_element = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_;
	xmlNode* _tmp5_;
	RygelPlugin* _tmp6_;
	const gchar* _tmp7_;
	RygelPlugin* _tmp8_;
	const gchar* _tmp9_;
	RygelPlugin* _tmp10_;
	const gchar* _tmp11_;
	xmlNode* _tmp15_;
	RygelPlugin* _tmp16_;
	xmlNode* _tmp17_;
	RygelPlugin* _tmp18_;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (doc != NULL);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = doc;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = _tmp0_->doc;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", NULL, NULL);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	device_element = _tmp2_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = device_element;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp3_ == NULL) {
#line 645 "rygel-root-device-factory.c"
		const gchar* _tmp4_ = NULL;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp4_ = _ ("XML node '%s' not found.");
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_warning (_tmp4_, "/root/device");
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return;
#line 653 "rygel-root-device-factory.c"
	}
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp5_ = device_element;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp6_ = plugin;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp7_ = _tmp6_->name;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp8_ = plugin;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp9_ = _tmp8_->title;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_set_friendly_name_and_udn (self, _tmp5_, _tmp7_, _tmp9_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp10_ = plugin;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp11_ = _tmp10_->description;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp11_ != NULL) {
#line 673 "rygel-root-device-factory.c"
		xmlNode* _tmp12_;
		RygelPlugin* _tmp13_;
		const gchar* _tmp14_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp12_ = device_element;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp13_ = plugin;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp14_ = _tmp13_->description;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		rygel_root_device_factory_set_description (self, _tmp12_, _tmp14_);
#line 685 "rygel-root-device-factory.c"
	}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp15_ = device_element;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp16_ = plugin;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_add_icons_to_desc (self, _tmp15_, _tmp16_);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp17_ = device_element;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp18_ = plugin;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_add_services_to_desc (self, _tmp17_, _tmp18_);
#line 699 "rygel-root-device-factory.c"
}


/**
     * Fills the description doc @doc with a friendly name, and UDN from gconf.
     * If these keys are not present in gconf, they are set with default values.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 716 "rygel-root-device-factory.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 746 "rygel-root-device-factory.c"
				goto __catch82_g_regex_error;
			}
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 755 "rygel-root-device-factory.c"
		}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 771 "rygel-root-device-factory.c"
				goto __catch82_g_regex_error;
			}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 782 "rygel-root-device-factory.c"
		}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 790 "rygel-root-device-factory.c"
	}
	goto __finally82;
	__catch82_g_regex_error:
	{
		GError* e = NULL;
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 804 "rygel-root-device-factory.c"
	}
	__finally82:
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return NULL;
#line 815 "rygel-root-device-factory.c"
	}
}


static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	xmlNode* _tmp19_;
	const gchar* _tmp20_;
	xmlNode* _tmp21_;
	xmlNode* _tmp22_ = NULL;
	xmlNode* _tmp23_;
	xmlNode* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* udn;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gboolean _tmp30_;
	GError * _inner_error_ = NULL;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (plugin_name != NULL);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (plugin_title != NULL);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = device_element;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "friendlyName", NULL, NULL);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	element = _tmp1_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = element;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp2_ == NULL) {
#line 863 "rygel-root-device-factory.c"
		const gchar* _tmp3_ = NULL;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp3_ = _ ("XML node '%s' not found.");
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_warning (_tmp3_, "/root/device/friendlyName");
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return;
#line 871 "rygel-root-device-factory.c"
	}
	{
		RygelConfiguration* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp4_ = self->priv->config;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp5_ = plugin_name;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp6_ = rygel_configuration_get_title (_tmp4_, _tmp5_, &_inner_error_);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp7_ = _tmp6_;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 888 "rygel-root-device-factory.c"
			goto __catch81_g_error;
		}
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		title = _tmp7_;
#line 895 "rygel-root-device-factory.c"
	}
	goto __finally81;
	__catch81_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		err = _inner_error_;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_inner_error_ = NULL;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp8_ = plugin_title;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		title = _tmp9_;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_error_free0 (err);
#line 917 "rygel-root-device-factory.c"
	}
	__finally81:
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return;
#line 930 "rygel-root-device-factory.c"
	}
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp10_ = title;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp11_ = g_get_real_name ();
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp12_ = string_replace (_tmp10_, "@REALNAME@", _tmp11_);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	title = _tmp12_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp13_ = title;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp14_ = g_get_user_name ();
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp15_ = string_replace (_tmp13_, "@USERNAME@", _tmp14_);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	title = _tmp15_;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp16_ = title;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp17_ = g_get_host_name ();
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp18_ = string_replace (_tmp16_, "@HOSTNAME@", _tmp17_);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	title = _tmp18_;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp19_ = element;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp20_ = title;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNodeSetContent (_tmp19_, _tmp20_);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp21_ = device_element;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp22_ = rygel_xml_utils_get_element (_tmp21_, "UDN", NULL);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	element = _tmp22_;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp23_ = element;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp23_ == NULL) {
#line 978 "rygel-root-device-factory.c"
		const gchar* _tmp24_ = NULL;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp24_ = _ ("XML node '%s' not found.");
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_warning (_tmp24_, "/root/device/UDN");
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (title);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return;
#line 988 "rygel-root-device-factory.c"
	}
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp25_ = element;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp26_ = xmlNodeGetContent (_tmp25_);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	udn = _tmp26_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp28_ = udn;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp28_ == NULL) {
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp27_ = TRUE;
#line 1002 "rygel-root-device-factory.c"
	} else {
		const gchar* _tmp29_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp29_ = udn;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp27_ = g_strcmp0 (_tmp29_, "") == 0;
#line 1009 "rygel-root-device-factory.c"
	}
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp30_ = _tmp27_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp30_) {
#line 1015 "rygel-root-device-factory.c"
		gchar* _tmp31_ = NULL;
		xmlNode* _tmp32_;
		const gchar* _tmp33_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp31_ = rygel_root_device_factory_generate_random_udn (self);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (udn);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		udn = _tmp31_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp32_ = element;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp33_ = udn;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		xmlNodeSetContent (_tmp32_, _tmp33_);
#line 1031 "rygel-root-device-factory.c"
	}
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (udn);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (title);
#line 1037 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	xmlNode* _tmp5_;
	const gchar* _tmp6_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (description != NULL);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = device_element;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "modelDescription", NULL, NULL);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	element = _tmp1_;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = element;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp2_ == NULL) {
#line 1062 "rygel-root-device-factory.c"
		xmlNode* _tmp3_;
		const gchar* _tmp4_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp3_ = device_element;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp4_ = description;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		xmlNewChild (_tmp3_, NULL, "modelDescription", _tmp4_);
#line 1071 "rygel-root-device-factory.c"
	}
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp5_ = element;
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp6_ = description;
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNodeSetContent (_tmp5_, _tmp6_);
#line 1079 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* service_list_node;
	xmlNode* _tmp2_;
	xmlNode* _tmp4_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = device_element;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "serviceList", NULL, NULL);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	service_list_node = _tmp1_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = service_list_node;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp2_ == NULL) {
#line 1103 "rygel-root-device-factory.c"
		const gchar* _tmp3_ = NULL;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp3_ = _ ("XML node '%s' not found.");
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_warning (_tmp3_, "/root/device/serviceList");
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return;
#line 1111 "rygel-root-device-factory.c"
	}
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp4_ = service_list_node;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNodeSetContent (_tmp4_, "");
#line 1117 "rygel-root-device-factory.c"
	{
		RygelPlugin* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _resource_info_list;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _resource_info_size;
		gint _resource_info_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp5_ = plugin;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp6_ = _tmp5_->resource_infos;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_resource_info_list = _tmp7_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp8_ = _resource_info_list;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp10_ = _tmp9_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_resource_info_size = _tmp10_;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_resource_info_index = -1;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		while (TRUE) {
#line 1148 "rygel-root-device-factory.c"
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			RygelResourceInfo* resource_info;
			RygelResourceInfo* _tmp17_;
			GType _tmp18_;
			gboolean _tmp19_ = FALSE;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp11_ = _resource_info_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_resource_info_index = _tmp11_ + 1;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp12_ = _resource_info_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp13_ = _resource_info_size;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
				break;
#line 1171 "rygel-root-device-factory.c"
			}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp14_ = _resource_info_list;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp15_ = _resource_info_index;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			resource_info = (RygelResourceInfo*) _tmp16_;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp17_ = resource_info;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp18_ = _tmp17_->type;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp19_ = g_type_is_a (_tmp18_, GUPNP_TYPE_SERVICE);
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			if (_tmp19_) {
#line 1189 "rygel-root-device-factory.c"
				xmlNode* _tmp20_;
				RygelPlugin* _tmp21_;
				const gchar* _tmp22_;
				RygelResourceInfo* _tmp23_;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
				_tmp20_ = service_list_node;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
				_tmp21_ = plugin;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
				_tmp22_ = _tmp21_->name;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
				_tmp23_ = resource_info;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
				rygel_root_device_factory_add_service_to_desc (self, _tmp20_, _tmp22_, _tmp23_);
#line 1204 "rygel-root-device-factory.c"
			}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_rygel_resource_info_unref0 (resource_info);
#line 1208 "rygel-root-device-factory.c"
		}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (_resource_info_list);
#line 1212 "rygel-root-device-factory.c"
	}
}


static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* service_node;
	RygelResourceInfo* _tmp2_;
	const gchar* _tmp3_;
	RygelResourceInfo* _tmp4_;
	const gchar* _tmp5_;
	RygelResourceInfo* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* url;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RygelResourceInfo* _tmp15_;
	GType _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	RygelResourceInfo* _tmp25_;
	GType _tmp26_;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	const gchar* _tmp29_;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (plugin_name != NULL);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (resource_info != NULL);
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = service_list_node;
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = xmlNewChild (_tmp0_, NULL, "service", NULL);
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	service_node = _tmp1_;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = resource_info;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = _tmp2_->upnp_type;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "serviceType", _tmp3_);
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp4_ = resource_info;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp5_ = _tmp4_->upnp_id;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "serviceId", _tmp5_);
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp6_ = resource_info;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp7_ = _tmp6_->description_path;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp8_ = g_strconcat ("/", _tmp7_, NULL);
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	url = _tmp8_;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp9_ = url;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "SCPDURL", _tmp9_);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp10_ = plugin_name;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp11_ = g_strconcat ("/Event/", _tmp10_, NULL);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp12_ = _tmp11_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp13_ = g_strconcat (_tmp12_, "/", NULL);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp14_ = _tmp13_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp15_ = resource_info;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp16_ = _tmp15_->type;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp17_ = g_type_name (_tmp16_);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (url);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	url = _tmp18_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (_tmp14_);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (_tmp12_);
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp19_ = url;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "eventSubURL", _tmp19_);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp20_ = plugin_name;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp21_ = g_strconcat ("/Control/", _tmp20_, NULL);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp22_ = _tmp21_;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp24_ = _tmp23_;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp25_ = resource_info;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp26_ = _tmp25_->type;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp27_ = g_type_name (_tmp26_);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (url);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	url = _tmp28_;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (_tmp24_);
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (_tmp22_);
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp29_ = url;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (service_node, NULL, "controlURL", _tmp29_);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (url);
#line 1348 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	RygelPlugin* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* icons;
	gboolean _tmp3_ = FALSE;
	GeeArrayList* _tmp4_;
	gboolean _tmp8_;
	xmlNode* _tmp14_;
	xmlNode* _tmp15_ = NULL;
	xmlNode* icon_list_node;
	xmlNode* _tmp16_;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = plugin;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = _tmp0_->icon_infos;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	icons = _tmp2_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp4_ = icons;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp4_ == NULL) {
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp3_ = TRUE;
#line 1382 "rygel-root-device-factory.c"
	} else {
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp5_ = icons;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp7_ = _tmp6_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp3_ = _tmp7_ == 0;
#line 1395 "rygel-root-device-factory.c"
	}
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp8_ = _tmp3_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp8_) {
#line 1401 "rygel-root-device-factory.c"
		RygelPlugin* _tmp9_;
		const gchar* _tmp10_;
		RygelPlugin* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp9_ = plugin;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp10_ = _tmp9_->name;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_debug ("rygel-root-device-factory.vala:235: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", _tmp10_);
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp11_ = plugin;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp12_ = _tmp11_->default_icons;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (icons);
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		icons = _tmp13_;
#line 1423 "rygel-root-device-factory.c"
	}
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp14_ = device_element;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp15_ = rygel_xml_utils_get_element (_tmp14_, "iconList", NULL, NULL);
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	icon_list_node = _tmp15_;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp16_ = icon_list_node;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp16_ == NULL) {
#line 1435 "rygel-root-device-factory.c"
		xmlNode* _tmp17_;
		xmlNode* _tmp18_ = NULL;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp17_ = device_element;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp18_ = xmlNewChild (_tmp17_, NULL, "iconList", NULL);
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		icon_list_node = _tmp18_;
#line 1444 "rygel-root-device-factory.c"
	} else {
		xmlNode* _tmp19_;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp19_ = icon_list_node;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		xmlNodeSetContent (_tmp19_, "");
#line 1451 "rygel-root-device-factory.c"
	}
	{
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _icon_list;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _icon_size;
		gint _icon_index;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp20_ = icons;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_icon_list = _tmp21_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp22_ = _icon_list;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp24_ = _tmp23_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_icon_size = _tmp24_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_icon_index = -1;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		while (TRUE) {
#line 1480 "rygel-root-device-factory.c"
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_ = NULL;
			RygelIconInfo* icon;
			xmlNode* _tmp31_;
			RygelIconInfo* _tmp32_;
			RygelPlugin* _tmp33_;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp25_ = _icon_index;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_icon_index = _tmp25_ + 1;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp26_ = _icon_index;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp27_ = _icon_size;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			if (!(_tmp26_ < _tmp27_)) {
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
				break;
#line 1503 "rygel-root-device-factory.c"
			}
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp28_ = _icon_list;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp29_ = _icon_index;
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			icon = (RygelIconInfo*) _tmp30_;
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp31_ = icon_list_node;
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp32_ = icon;
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_tmp33_ = plugin;
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			rygel_root_device_factory_add_icon_to_desc (self, _tmp31_, _tmp32_, _tmp33_);
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_rygel_icon_info_unref0 (icon);
#line 1523 "rygel-root-device-factory.c"
		}
#line 251 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (_icon_list);
#line 1527 "rygel-root-device-factory.c"
	}
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (icons);
#line 1531 "rygel-root-device-factory.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1297 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1297 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1297 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1297 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1298 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1298 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1554 "rygel-root-device-factory.c"
		glong _tmp4_;
#line 1299 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1299 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1299 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1562 "rygel-root-device-factory.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1301 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1301 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1301 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1301 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 1574 "rygel-root-device-factory.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1308 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1310 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1310 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1599 "rygel-root-device-factory.c"
		glong _tmp2_;
#line 1310 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1310 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1605 "rygel-root-device-factory.c"
	} else {
#line 1310 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1609 "rygel-root-device-factory.c"
	}
#line 1310 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1310 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1615 "rygel-root-device-factory.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1312 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1312 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1312 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1312 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1627 "rygel-root-device-factory.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1314 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1314 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1314 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1637 "rygel-root-device-factory.c"
	}
#line 1317 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1317 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1643 "rygel-root-device-factory.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1318 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1318 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1318 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1319 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1657 "rygel-root-device-factory.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1321 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1321 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1321 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1667 "rygel-root-device-factory.c"
	}
#line 1323 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1323 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1673 "rygel-root-device-factory.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1324 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1324 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1324 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1682 "rygel-root-device-factory.c"
	}
#line 1326 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1326 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1326 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1326 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1327 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1327 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1327 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1327 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1327 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 1702 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* icon_node;
	RygelIconInfo* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* width;
	RygelIconInfo* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* height;
	RygelIconInfo* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* depth;
	xmlNode* _tmp11_;
	RygelIconInfo* _tmp12_;
	const gchar* _tmp13_;
	xmlNode* _tmp14_;
	const gchar* _tmp15_;
	xmlNode* _tmp16_;
	const gchar* _tmp17_;
	xmlNode* _tmp18_;
	const gchar* _tmp19_;
	RygelIconInfo* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* uri;
	const gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (icon_info != NULL);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (plugin != NULL);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = icon_list_node;
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = xmlNewChild (_tmp0_, NULL, "icon", NULL);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	icon_node = _tmp1_;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = icon_info;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = _tmp2_->width;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	width = _tmp4_;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp5_ = icon_info;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp6_ = _tmp5_->height;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	height = _tmp7_;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp8_ = icon_info;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp9_ = _tmp8_->depth;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp10_ = g_strdup_printf ("%i", _tmp9_);
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	depth = _tmp10_;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp11_ = icon_node;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp12_ = icon_info;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp13_ = _tmp12_->mime_type;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (_tmp11_, NULL, "mimetype", _tmp13_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp14_ = icon_node;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp15_ = width;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (_tmp14_, NULL, "width", _tmp15_);
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp16_ = icon_node;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp17_ = height;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (_tmp16_, NULL, "height", _tmp17_);
#line 269 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp18_ = icon_node;
#line 269 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp19_ = depth;
#line 269 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlNewChild (_tmp18_, NULL, "depth", _tmp19_);
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp20_ = icon_info;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp21_ = _tmp20_->uri;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp22_ = g_strdup (_tmp21_);
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	uri = _tmp22_;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp23_ = uri;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp24_ = g_str_has_prefix (_tmp23_, "file://");
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp24_) {
#line 1813 "rygel-root-device-factory.c"
		RygelPlugin* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		RygelIconInfo* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* remote_path;
		const gchar* _tmp50_;
		gchar* _tmp51_ = NULL;
		gchar* local_path;
		GUPnPContext* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		xmlNode* _tmp55_;
		const gchar* _tmp56_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp25_ = plugin;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp26_ = _tmp25_->name;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp27_ = g_strconcat ("/", _tmp26_, NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp28_ = _tmp27_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp29_ = g_strconcat (_tmp28_, "-", NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp30_ = _tmp29_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp31_ = width;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp33_ = _tmp32_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp34_ = g_strconcat (_tmp33_, "x", NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp35_ = _tmp34_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp36_ = height;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp37_ = g_strconcat (_tmp35_, _tmp36_, NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp38_ = _tmp37_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp39_ = g_strconcat (_tmp38_, "x", NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp40_ = _tmp39_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp41_ = depth;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp42_ = g_strconcat (_tmp40_, _tmp41_, NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp43_ = _tmp42_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp44_ = g_strconcat (_tmp43_, ".", NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp45_ = _tmp44_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp46_ = icon_info;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp47_ = _tmp46_->file_extension;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp48_ = g_strconcat (_tmp45_, _tmp47_, NULL);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp49_ = _tmp48_;
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp45_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp43_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp40_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp38_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp35_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp33_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp30_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (_tmp28_);
#line 275 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		remote_path = _tmp49_;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp50_ = uri;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp51_ = string_substring (_tmp50_, (glong) 7, (glong) (-1));
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		local_path = _tmp51_;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp52_ = self->context;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp53_ = local_path;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp54_ = remote_path;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		gupnp_context_host_path (_tmp52_, _tmp53_, _tmp54_);
#line 282 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp55_ = icon_node;
#line 282 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp56_ = remote_path;
#line 282 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		xmlNewChild (_tmp55_, NULL, "url", _tmp56_);
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (local_path);
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (remote_path);
#line 1940 "rygel-root-device-factory.c"
	} else {
		const gchar* _tmp57_;
		GUPnPContext* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_ = NULL;
		xmlNode* _tmp62_;
		const gchar* _tmp63_;
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp57_ = uri;
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp58_ = self->context;
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp59_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp58_);
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp60_ = _tmp59_;
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp61_ = string_replace (_tmp57_, "@ADDRESS@", _tmp60_);
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (uri);
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		uri = _tmp61_;
#line 285 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp62_ = icon_node;
#line 285 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp63_ = uri;
#line 285 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		xmlNewChild (_tmp62_, NULL, "url", _tmp63_);
#line 1969 "rygel-root-device-factory.c"
	}
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (uri);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (depth);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (height);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (width);
#line 1979 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_save_modified_desc (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* file;
	FILE* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar* mem;
	gint len;
	GUPnPXMLDoc* _tmp9_;
	xmlDoc* _tmp10_;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	FILE* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	GError * _inner_error_ = NULL;
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (doc != NULL);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (desc_path != NULL);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = desc_path;
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = fopen (_tmp0_, "w+");
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	file = _tmp1_;
#line 293 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = file;
#line 293 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = G_UNLIKELY (_tmp2_ == NULL);
#line 293 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp3_) {
#line 2020 "rygel-root-device-factory.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* message;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp4_ = _ ("Failed to write modified description to %s");
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		message = _tmp5_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp6_ = message;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp7_ = desc_path;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp6_, _tmp7_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_inner_error_ = _tmp8_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (message);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_fclose0 (file);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return;
#line 2049 "rygel-root-device-factory.c"
	}
#line 299 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	mem = NULL;
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	len = -1;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp9_ = doc;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp10_ = _tmp9_->doc;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	xmlDocDumpMemoryEnc (_tmp10_, &_tmp11_, &_tmp12_, "UTF-8");
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (mem);
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	mem = _tmp11_;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	len = _tmp12_;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp13_ = len;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp14_ = G_UNLIKELY (_tmp13_ <= 0);
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp14_) {
#line 2073 "rygel-root-device-factory.c"
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* message;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		GError* _tmp19_;
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp15_ = _ ("Failed to write modified description to %s");
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		message = _tmp16_;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp17_ = message;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp18_ = desc_path;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp19_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp17_, _tmp18_);
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_inner_error_ = _tmp19_;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (message);
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_free0 (mem);
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_fclose0 (file);
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return;
#line 2104 "rygel-root-device-factory.c"
	}
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp20_ = file;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp21_ = mem;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp22_ = string_replace (_tmp21_, "\n", "");
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp23_ = _tmp22_;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	fputs (_tmp23_, _tmp20_);
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (_tmp23_);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (mem);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_fclose0 (file);
#line 2122 "rygel-root-device-factory.c"
}


static GUPnPXMLDoc* rygel_root_device_factory_get_latest_doc (RygelRootDeviceFactory* self, const gchar* path1, const gchar* path2, GError** error) {
	GUPnPXMLDoc* result = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp7_;
	GFileInfo* _tmp8_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp9_;
	guint64 _tmp10_ = 0ULL;
	guint64 mod1;
	const gchar* _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	GFileInfo* _tmp14_ = NULL;
	GFileInfo* _tmp15_;
	GFileInfo* _tmp16_;
	guint64 _tmp17_ = 0ULL;
	guint64 mod2;
	guint64 _tmp18_;
	guint64 _tmp19_;
	GError * _inner_error_ = NULL;
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (path1 != NULL, NULL);
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (path2 != NULL, NULL);
#line 315 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = path1;
#line 315 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 315 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	file = _tmp1_;
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = file;
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (!_tmp3_) {
#line 2168 "rygel-root-device-factory.c"
		const gchar* _tmp4_;
		GUPnPXMLDoc* _tmp5_;
		GUPnPXMLDoc* _tmp6_;
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp4_ = path2;
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp5_ = gupnp_xml_doc_new_from_path (_tmp4_, &_inner_error_);
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp6_ = _tmp5_;
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			return NULL;
#line 2186 "rygel-root-device-factory.c"
		}
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		result = _tmp6_;
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return result;
#line 2194 "rygel-root-device-factory.c"
	}
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp7_ = file;
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp8_ = g_file_query_info (_tmp7_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	info = _tmp8_;
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 2210 "rygel-root-device-factory.c"
	}
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp9_ = info;
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp10_ = g_file_info_get_attribute_uint64 (_tmp9_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	mod1 = _tmp10_;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp11_ = path2;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp12_ = g_file_new_for_path (_tmp11_);
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	file = _tmp12_;
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp13_ = file;
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp14_ = g_file_query_info (_tmp13_, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp15_ = _tmp14_;
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_inner_error_ != NULL) {
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_propagate_error (error, _inner_error_);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return NULL;
#line 2242 "rygel-root-device-factory.c"
	}
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (info);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	info = _tmp15_;
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp16_ = info;
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp17_ = g_file_info_get_attribute_uint64 (_tmp16_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 327 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	mod2 = _tmp17_;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp18_ = mod1;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp19_ = mod2;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (_tmp18_ > _tmp19_) {
#line 2260 "rygel-root-device-factory.c"
		const gchar* _tmp20_;
		GUPnPXMLDoc* _tmp21_;
		GUPnPXMLDoc* _tmp22_;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp20_ = path1;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp21_ = gupnp_xml_doc_new_from_path (_tmp20_, &_inner_error_);
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp22_ = _tmp21_;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			return NULL;
#line 2280 "rygel-root-device-factory.c"
		}
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		result = _tmp22_;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return result;
#line 2290 "rygel-root-device-factory.c"
	} else {
		const gchar* _tmp23_;
		GUPnPXMLDoc* _tmp24_;
		GUPnPXMLDoc* _tmp25_;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp23_ = path2;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp24_ = gupnp_xml_doc_new_from_path (_tmp23_, &_inner_error_);
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp25_ = _tmp24_;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_g_object_unref0 (info);
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			return NULL;
#line 2311 "rygel-root-device-factory.c"
		}
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		result = _tmp25_;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (info);
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_g_object_unref0 (file);
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return result;
#line 2321 "rygel-root-device-factory.c"
	}
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (info);
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 2327 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
#line 336 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (dir_path != NULL);
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = dir_path;
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	file = _tmp1_;
#line 338 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = file;
#line 338 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 338 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (!_tmp3_) {
#line 2354 "rygel-root-device-factory.c"
		GFile* _tmp4_;
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		_tmp4_ = file;
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_file_make_directory (_tmp4_, NULL, &_inner_error_);
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		if (_inner_error_ != NULL) {
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			g_propagate_error (error, _inner_error_);
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			_g_object_unref0 (file);
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			return;
#line 2368 "rygel-root-device-factory.c"
		}
	}
#line 336 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (file);
#line 2373 "rygel-root-device-factory.c"
}


static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* udn;
	gint udn_length1;
	gint _udn_size_;
	guchar* _tmp1_ = NULL;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	gchar* _tmp2_;
#line 343 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp0_ = g_new0 (guchar, 50);
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	udn = _tmp0_;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	udn_length1 = 50;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_udn_size_ = udn_length1;
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp1_ = g_new0 (guchar, 16);
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	id = _tmp1_;
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	id_length1 = 16;
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_id_size_ = id_length1;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	uuid_generate (id);
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	uuid_unparse (id, udn);
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_tmp2_ = g_strconcat ("uuid:", (const gchar*) udn, NULL);
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	result = _tmp2_;
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	id = (g_free (id), NULL);
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	udn = (g_free (udn), NULL);
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return result;
#line 2420 "rygel-root-device-factory.c"
}


static void rygel_value_root_device_factory_init (GValue* value) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	value->data[0].v_pointer = NULL;
#line 2427 "rygel-root-device-factory.c"
}


static void rygel_value_root_device_factory_free_value (GValue* value) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (value->data[0].v_pointer) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		rygel_root_device_factory_unref (value->data[0].v_pointer);
#line 2436 "rygel-root-device-factory.c"
	}
}


static void rygel_value_root_device_factory_copy_value (const GValue* src_value, GValue* dest_value) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (src_value->data[0].v_pointer) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		dest_value->data[0].v_pointer = rygel_root_device_factory_ref (src_value->data[0].v_pointer);
#line 2446 "rygel-root-device-factory.c"
	} else {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2450 "rygel-root-device-factory.c"
	}
}


static gpointer rygel_value_root_device_factory_peek_pointer (const GValue* value) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return value->data[0].v_pointer;
#line 2458 "rygel-root-device-factory.c"
}


static gchar* rygel_value_root_device_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (collect_values[0].v_pointer) {
#line 2465 "rygel-root-device-factory.c"
		RygelRootDeviceFactory* object;
		object = collect_values[0].v_pointer;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		if (object->parent_instance.g_class == NULL) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2472 "rygel-root-device-factory.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2476 "rygel-root-device-factory.c"
		}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		value->data[0].v_pointer = rygel_root_device_factory_ref (object);
#line 2480 "rygel-root-device-factory.c"
	} else {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		value->data[0].v_pointer = NULL;
#line 2484 "rygel-root-device-factory.c"
	}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return NULL;
#line 2488 "rygel-root-device-factory.c"
}


static gchar* rygel_value_root_device_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelRootDeviceFactory** object_p;
	object_p = collect_values[0].v_pointer;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (!object_p) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2499 "rygel-root-device-factory.c"
	}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (!value->data[0].v_pointer) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		*object_p = NULL;
#line 2505 "rygel-root-device-factory.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		*object_p = value->data[0].v_pointer;
#line 2509 "rygel-root-device-factory.c"
	} else {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		*object_p = rygel_root_device_factory_ref (value->data[0].v_pointer);
#line 2513 "rygel-root-device-factory.c"
	}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return NULL;
#line 2517 "rygel-root-device-factory.c"
}


GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecRootDeviceFactory* spec;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return G_PARAM_SPEC (spec);
#line 2531 "rygel-root-device-factory.c"
}


gpointer rygel_value_get_root_device_factory (const GValue* value) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return value->data[0].v_pointer;
#line 2540 "rygel-root-device-factory.c"
}


void rygel_value_set_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	old = value->data[0].v_pointer;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (v_object) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		value->data[0].v_pointer = v_object;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		rygel_root_device_factory_ref (value->data[0].v_pointer);
#line 2560 "rygel-root-device-factory.c"
	} else {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		value->data[0].v_pointer = NULL;
#line 2564 "rygel-root-device-factory.c"
	}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (old) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		rygel_root_device_factory_unref (old);
#line 2570 "rygel-root-device-factory.c"
	}
}


void rygel_value_take_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	old = value->data[0].v_pointer;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (v_object) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		value->data[0].v_pointer = v_object;
#line 2589 "rygel-root-device-factory.c"
	} else {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		value->data[0].v_pointer = NULL;
#line 2593 "rygel-root-device-factory.c"
	}
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (old) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		rygel_root_device_factory_unref (old);
#line 2599 "rygel-root-device-factory.c"
	}
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	RYGEL_ROOT_DEVICE_FACTORY_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
#line 2611 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	self->ref_count = 1;
#line 2620 "rygel-root-device-factory.c"
}


static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj) {
	RygelRootDeviceFactory * self;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	self = RYGEL_ROOT_DEVICE_FACTORY (obj);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (self->context);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_object_unref0 (self->priv->config);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	_g_free0 (self->priv->desc_dir);
#line 2634 "rygel-root-device-factory.c"
}


/**
 * Factory for RootDevice objects. Give it a plugin and it will create a
 * Root device for that.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_root_device_factory_init, rygel_value_root_device_factory_free_value, rygel_value_root_device_factory_copy_value, rygel_value_root_device_factory_peek_pointer, "p", rygel_value_root_device_factory_collect_value, "p", rygel_value_root_device_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelRootDeviceFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


gpointer rygel_root_device_factory_ref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	g_atomic_int_inc (&self->ref_count);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	return instance;
#line 2663 "rygel-root-device-factory.c"
}


void rygel_root_device_factory_unref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS (self)->finalize (self);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-root-device-factory.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2676 "rygel-root-device-factory.c"
	}
}



