/* rygel-item-creator.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;
typedef struct _RygelItemCreatorParseArgsData RygelItemCreatorParseArgsData;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _RygelItemCreatorCreateUriData RygelItemCreatorCreateUriData;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _RygelItemCreatorWaitForItemData RygelItemCreatorWaitForItemData;

typedef enum  {
	RYGEL_ITEM_CREATOR_ERROR_PARSE
} RygelItemCreatorError;
#define RYGEL_ITEM_CREATOR_ERROR rygel_item_creator_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelItemCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	GUPnPDIDLLiteParser* _tmp0_;
	GUPnPDIDLLiteParser* _tmp1_;
	const gchar* _tmp2_;
	GError* parse_err;
	GError* _tmp3_;
	GUPnPDIDLLiteItem* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* message;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	gboolean _tmp10_;
	GUPnPDIDLLiteItem* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GUPnPDIDLLiteItem* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	GError* _tmp18_;
	GUPnPDIDLLiteItem* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	GUPnPDIDLLiteItem* _tmp23_;
	GUPnPOCMFlags _tmp24_;
	GUPnPOCMFlags _tmp25_;
	GError* _tmp26_;
	GUPnPDIDLLiteItem* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GError* _tmp30_;
	RygelWritableContainer* _tmp31_;
	RygelWritableContainer* container;
	gboolean _tmp32_;
	RygelWritableContainer* _tmp33_;
	GeeArrayList* _tmp34_;
	GeeArrayList* _tmp35_;
	GUPnPDIDLLiteItem* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gboolean _tmp39_;
	const gchar* _tmp40_;
	gboolean _tmp41_;
	GUPnPDIDLLiteItem* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	RygelWritableContainer* _tmp45_;
	const gchar* _tmp46_;
	GError* _tmp47_;
	GUPnPDIDLLiteItem* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	RygelWritableContainer* _tmp51_;
	GUPnPDIDLLiteItem* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	GUPnPDIDLLiteItem* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	RygelMediaItem* _tmp58_;
	RygelMediaItem* _tmp59_;
	GUPnPDIDLLiteItem* _tmp60_;
	GList* _tmp61_;
	GList* resources;
	gboolean _tmp62_;
	GList* _tmp63_;
	GList* _tmp64_;
	guint _tmp65_;
	gboolean _tmp66_;
	GList* _tmp67_;
	GList* _tmp68_;
	gconstpointer _tmp69_;
	GUPnPDIDLLiteResource* _tmp70_;
	GUPnPDIDLLiteResource* resource;
	GUPnPDIDLLiteResource* _tmp71_;
	GUPnPProtocolInfo* _tmp72_;
	GUPnPProtocolInfo* _tmp73_;
	GUPnPProtocolInfo* _tmp74_;
	GUPnPProtocolInfo* info;
	GUPnPProtocolInfo* _tmp75_;
	GUPnPProtocolInfo* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	GUPnPProtocolInfo* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	gboolean _tmp82_;
	GUPnPProtocolInfo* _tmp83_;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	GError* _tmp86_;
	RygelMediaItem* _tmp87_;
	GUPnPProtocolInfo* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	GUPnPProtocolInfo* _tmp92_;
	const gchar* _tmp93_;
	const gchar* _tmp94_;
	RygelMediaItem* _tmp95_;
	GUPnPProtocolInfo* _tmp96_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	GUPnPDIDLLiteResource* _tmp100_;
	const gchar* _tmp101_;
	const gchar* _tmp102_;
	gboolean _tmp103_;
	RygelMediaItem* _tmp104_;
	GUPnPDIDLLiteResource* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	GUPnPDIDLLiteResource* _tmp108_;
	glong _tmp109_;
	glong _tmp110_;
	RygelMediaItem* _tmp111_;
	GUPnPDIDLLiteResource* _tmp112_;
	glong _tmp113_;
	glong _tmp114_;
	RygelMediaItem* _tmp115_;
	const gchar* _tmp116_;
	RygelMediaItem* _tmp117_;
	gchar* _tmp118_;
	RygelMediaItem* _tmp119_;
	gint64 _tmp120_;
	gint64 _tmp121_;
	RygelMediaItem* _tmp122_;
	RygelMediaItem* _tmp123_;
	GeeArrayList* _tmp124_;
	gint _tmp125_;
	gint _tmp126_;
	RygelWritableContainer* _tmp127_;
	RygelMediaItem* _tmp128_;
	const gchar* _tmp129_;
	const gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* uri;
	RygelMediaItem* _tmp132_;
	GeeArrayList* _tmp133_;
	const gchar* _tmp134_;
	RygelMediaItem* _tmp135_;
	RygelMediaItem* _tmp136_;
	GeeArrayList* _tmp137_;
	gpointer _tmp138_;
	gchar* _tmp139_;
	GFile* _tmp140_;
	GFile* _tmp141_;
	GFile* file;
	RygelMediaItem* _tmp142_;
	GFile* _tmp143_;
	gboolean _tmp144_;
	RygelMediaItem* _tmp145_;
	RygelMediaItem* _tmp146_;
	GeeArrayList* _tmp147_;
	gpointer _tmp148_;
	RygelWritableContainer* _tmp149_;
	RygelMediaItem* _tmp150_;
	GCancellable* _tmp151_;
	GCancellable* _tmp152_;
	RygelWritableContainer* _tmp153_;
	RygelMediaItem* _tmp154_;
	GUPnPDIDLLiteWriter* _tmp155_;
	RygelContentDirectory* _tmp156_;
	RygelHTTPServer* _tmp157_;
	GUPnPDIDLLiteObject* _tmp158_;
	GUPnPDIDLLiteObject* _tmp159_;
	gboolean _tmp160_;
	const gchar* _tmp161_;
	RygelMediaItem* _tmp162_;
	gboolean _tmp163_;
	gboolean _tmp164_;
	gboolean _tmp165_;
	RygelItemRemovalQueue* _tmp166_;
	RygelItemRemovalQueue* queue;
	RygelItemRemovalQueue* _tmp167_;
	RygelMediaItem* _tmp168_;
	GCancellable* _tmp169_;
	GCancellable* _tmp170_;
	GError* err;
	GError* _tmp171_;
	GError * _inner_error_;
};

struct _RygelItemCreatorParseArgsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GPatternSpec* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* upnp_class;
	const gchar* _tmp5_;
	RygelRelationalExpression* _tmp6_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp7_;
	RygelRelationalExpression* _tmp8_;
	gchar* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	guint total_matches;
	RygelContentDirectory* _tmp13_;
	RygelMediaContainer* _tmp14_;
	RygelSearchableContainer* _tmp15_;
	RygelSearchableContainer* container;
	RygelSearchableContainer* _tmp16_;
	RygelSearchableContainer* _tmp17_;
	RygelRelationalExpression* _tmp18_;
	GCancellable* _tmp19_;
	GCancellable* _tmp20_;
	guint _tmp21_;
	RygelMediaObjects* _tmp22_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	RygelMediaObjects* _tmp26_;
	gpointer _tmp27_;
	GUPnPDIDLLiteItem* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GUPnPDIDLLiteItem* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GError* _tmp34_;
	RygelContentDirectory* _tmp35_;
	RygelMediaContainer* _tmp36_;
	const gchar* _tmp37_;
	GCancellable* _tmp38_;
	GCancellable* _tmp39_;
	RygelMediaObject* _tmp40_;
	RygelMediaObject* _tmp41_;
	RygelMediaObject* _tmp42_;
	const gchar* _tmp43_;
	GError* _tmp44_;
	gboolean _tmp45_;
	RygelMediaObject* _tmp46_;
	RygelMediaObject* _tmp47_;
	GUPnPOCMFlags _tmp48_;
	GUPnPOCMFlags _tmp49_;
	gboolean _tmp50_;
	const gchar* _tmp51_;
	RygelMediaObject* _tmp52_;
	const gchar* _tmp53_;
	GError* _tmp54_;
	RygelMediaObject* _tmp55_;
	RygelWritableContainer* _tmp56_;
	GError * _inner_error_;
};

struct _RygelItemCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* dir;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* now;
	GFile* _tmp10_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* file;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GDateTime* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	RygelItemCreator * self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	guint timeout;
};

struct _RygelItemCreatorWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	Block5Data* _data5_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaItem* item;
	RygelMediaItem* _tmp4_;
	RygelMediaItem* _tmp5_;
	Block6Data* _data6_;
	RygelWritableContainer* _tmp6_;
	gulong _tmp7_;
	gulong id;
	guint _tmp8_;
	RygelWritableContainer* _tmp9_;
	gulong _tmp10_;
	RygelWritableContainer* _tmp11_;
	RygelMediaItem* _tmp12_;
	const gchar* _tmp13_;
	GCancellable* _tmp14_;
	GCancellable* _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelMediaObject* _tmp17_;
	GError* _error_;
	RygelWritableContainer* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaItem* _tmp20_;
	const gchar* _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	RygelWritableContainer* _tmp24_;
	const gchar* _tmp25_;
	GError * _inner_error_;
};


static gpointer rygel_item_creator_parent_class = NULL;
static GPatternSpec* rygel_item_creator_comment_pattern;
static GPatternSpec* rygel_item_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GQuark rygel_item_creator_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void ___lambda9_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item);
static void ____lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_item_creator_conclude (RygelItemCreator* self);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
static void rygel_item_creator_parse_args_data_free (gpointer _data);
static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* _data_);
static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static void rygel_item_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_data_free (gpointer _data);
static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void ____lambda10_ (Block6Data* _data6_, RygelMediaContainer* container);
static void _____lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean ____lambda11_ (Block6Data* _data6_);
static gboolean _____lambda11__gsource_func (gpointer self);
static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_finalize (GObject* obj);
static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_item_creator_error_quark (void) {
	return g_quark_from_static_string ("rygel_item_creator_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return self ? g_object_ref (self) : NULL;
#line 881 "rygel-item-creator.c"
}


RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	RygelContentDirectory* _tmp2_;
	GCancellable* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	GUPnPDIDLLiteWriter* _tmp5_;
	GUPnPDIDLLiteParser* _tmp6_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = content_dir;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->content_dir = _tmp1_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = content_dir;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp4_ = action;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	action = NULL;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->action = _tmp4_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp5_ = gupnp_didl_lite_writer_new (NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_writer);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->didl_writer = _tmp5_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp6_ = gupnp_didl_lite_parser_new ();
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->didl_parser = _tmp6_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return self;
#line 934 "rygel-item-creator.c"
}


RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
#line 941 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorRunData, _data_);
#line 952 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	RygelItemCreator* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_real_run_co (_data_);
#line 974 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 982 "rygel-item-creator.c"
}


static void ___lambda9_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item) {
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (didl_item != NULL);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = didl_item;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->didl_item);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->didl_item = _tmp1_;
#line 999 "rygel-item-creator.c"
}


static void ____lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	___lambda9_ (self, item);
#line 1006 "rygel-item-creator.c"
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* _data_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_real_run_co (_data_);
#line 1020 "rygel-item-creator.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1027 "rygel-item-creator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_list_free (self);
#line 1036 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 1045 "rygel-item-creator.c"
		goto _state_0;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 1049 "rygel-item-creator.c"
		goto _state_1;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 2:
#line 1053 "rygel-item-creator.c"
		goto _state_2;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 3:
#line 1057 "rygel-item-creator.c"
		goto _state_3;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 4:
#line 1061 "rygel-item-creator.c"
		goto _state_4;
		default:
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 1066 "rygel-item-creator.c"
	}
	_state_0:
	{
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_parse_args (_data_->self, NULL, NULL);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp0_ = _data_->self->priv->didl_parser;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_signal_connect_object (_data_->_tmp0_, "item-available", (GCallback) ____lambda9__gupnp_didl_lite_parser_item_available, _data_->self, 0);
#line 1076 "rygel-item-creator.c"
		{
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp1_ = _data_->self->priv->didl_parser;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp2_ = _data_->self->elements;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			gupnp_didl_lite_parser_parse_didl (_data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1086 "rygel-item-creator.c"
				goto __catch71_g_error;
			}
		}
		goto __finally71;
		__catch71_g_error:
		{
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->parse_err = _data_->_inner_error_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = NULL;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp3_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_error_free0 (_data_->parse_err);
#line 1103 "rygel-item-creator.c"
			goto __finally71;
		}
		__finally71:
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1109 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = _data_->self->didl_item;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp4_ == NULL) {
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp5_ = NULL;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp5_ = _ ("No items in DIDL-Lite from client: '%s'");
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->message = _data_->_tmp6_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = _data_->message;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = _data_->self->elements;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp9_ = g_error_new (RYGEL_ITEM_CREATOR_ERROR, RYGEL_ITEM_CREATOR_ERROR_PARSE, _data_->_tmp7_, _data_->_tmp8_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp9_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->message);
#line 1134 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp11_ = _data_->self->didl_item;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp12_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp11_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp13_ == NULL) {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = TRUE;
#line 1147 "rygel-item-creator.c"
		} else {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp14_ = _data_->self->didl_item;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp15_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp14_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = g_strcmp0 (_data_->_tmp16_, "") != 0;
#line 1157 "rygel-item-creator.c"
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp17_ = _data_->_tmp10_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp17_) {
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp18_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "@id must be set to \"\" in " "CreateItem");
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp18_;
#line 1167 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp19_ = _data_->self->didl_item;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp20_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _data_->_tmp19_);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp21_ = _data_->_tmp20_;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp21_ == NULL) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp22_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "dc:title must be set in " "CreateItem");
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp22_;
#line 1182 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp23_ = _data_->self->didl_item;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp24_ = gupnp_didl_lite_object_get_dlna_managed ((GUPnPDIDLLiteObject*) _data_->_tmp23_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if ((_data_->_tmp25_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp26_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Flags that must not be set " "were found in 'dlnaManaged'");
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp26_;
#line 1197 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp27_ = _data_->self->didl_item;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp28_ = gupnp_didl_lite_object_get_restricted ((GUPnPDIDLLiteObject*) _data_->_tmp27_);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp29_) {
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp30_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Cannot create restricted item");
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp30_;
#line 1212 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 1;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_fetch_container (_data_->self, rygel_item_creator_run_ready, _data_);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1221 "rygel-item-creator.c"
		_state_1:
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp31_ = NULL;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp31_ = rygel_item_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->container = _data_->_tmp31_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1231 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp33_ = _data_->container;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp34_ = rygel_writable_container_get_create_classes (_data_->_tmp33_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp35_ = _data_->_tmp34_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp36_ = _data_->self->didl_item;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp37_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp36_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp38_ = _data_->_tmp37_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp39_ = FALSE;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp39_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp35_, _data_->_tmp38_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (!_data_->_tmp39_) {
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp40_ = _data_->self->container_id;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp32_ = g_strcmp0 (_data_->_tmp40_, "DLNA_ORG.AnyContainer") != 0;
#line 1256 "rygel-item-creator.c"
		} else {
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp32_ = FALSE;
#line 1260 "rygel-item-creator.c"
		}
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp41_ = _data_->_tmp32_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp41_) {
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp42_ = _data_->self->didl_item;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp43_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp42_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp44_ = _data_->_tmp43_;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp45_ = _data_->container;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp46_ = ((RygelMediaObject*) _data_->_tmp45_)->id;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp47_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp44_, _data_->_tmp46_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp47_;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1282 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp48_ = _data_->self->didl_item;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp49_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp48_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp50_ = _data_->_tmp49_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp51_ = _data_->container;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp52_ = _data_->self->didl_item;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp53_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _data_->_tmp52_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp54_ = _data_->_tmp53_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp55_ = _data_->self->didl_item;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp56_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp55_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp57_ = _data_->_tmp56_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp58_ = NULL;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp58_ = rygel_item_creator_create_item (_data_->self, _data_->_tmp50_, _data_->_tmp51_, _data_->_tmp54_, _data_->_tmp57_, &_data_->_inner_error_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp59_ = _data_->_tmp58_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1315 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->self->item);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->self->item = _data_->_tmp59_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp60_ = _data_->self->didl_item;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp61_ = NULL;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp61_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _data_->_tmp60_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->resources = _data_->_tmp61_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp63_ = _data_->resources;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp63_ != NULL) {
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp64_ = _data_->resources;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp65_ = 0U;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp65_ = g_list_length (_data_->_tmp64_);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp62_ = _data_->_tmp65_ > ((guint) 0);
#line 1342 "rygel-item-creator.c"
		} else {
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp62_ = FALSE;
#line 1346 "rygel-item-creator.c"
		}
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp66_ = _data_->_tmp62_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp66_) {
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp67_ = _data_->resources;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp68_ = NULL;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp68_ = g_list_nth (_data_->_tmp67_, (guint) 0);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp69_ = _data_->_tmp68_->data;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp70_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) _data_->_tmp69_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->resource = _data_->_tmp70_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp71_ = _data_->resource;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp72_ = gupnp_didl_lite_resource_get_protocol_info (_data_->_tmp71_);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp73_ = _data_->_tmp72_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp74_ = _g_object_ref0 (_data_->_tmp73_);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->info = _data_->_tmp74_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp75_ = _data_->info;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp75_ != NULL) {
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp76_ = _data_->info;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp77_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp76_);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp78_ = _data_->_tmp77_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_tmp78_ != NULL) {
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp79_ = _data_->info;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp80_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp79_);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp81_ = _data_->_tmp80_;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp82_ = FALSE;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp82_ = rygel_item_creator_is_profile_valid (_data_->self, _data_->_tmp81_);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					if (!_data_->_tmp82_) {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp83_ = _data_->info;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp84_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp83_);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp85_ = _data_->_tmp84_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp86_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' DLNA profile unsupported", _data_->_tmp85_);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_inner_error_ = _data_->_tmp86_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_g_object_unref0 (_data_->info);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_g_object_unref0 (_data_->resource);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						__g_list_free__g_object_unref0_0 (_data_->resources);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_g_object_unref0 (_data_->container);
#line 1416 "rygel-item-creator.c"
						goto __catch70_g_error;
					}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp87_ = _data_->self->item;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp88_ = _data_->info;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp89_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp88_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp90_ = _data_->_tmp89_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp91_ = g_strdup (_data_->_tmp90_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (_data_->_tmp87_->dlna_profile);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp87_->dlna_profile = _data_->_tmp91_;
#line 1433 "rygel-item-creator.c"
				}
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp92_ = _data_->info;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp93_ = gupnp_protocol_info_get_mime_type (_data_->_tmp92_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp94_ = _data_->_tmp93_;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_tmp94_ != NULL) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp95_ = _data_->self->item;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp96_ = _data_->info;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp97_ = gupnp_protocol_info_get_mime_type (_data_->_tmp96_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp98_ = _data_->_tmp97_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp99_ = g_strdup (_data_->_tmp98_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (_data_->_tmp95_->mime_type);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp95_->mime_type = _data_->_tmp99_;
#line 1457 "rygel-item-creator.c"
				}
			}
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp100_ = _data_->resource;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp101_ = gupnp_didl_lite_resource_get_uri (_data_->_tmp100_);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp102_ = _data_->_tmp101_;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp103_ = FALSE;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp103_ = rygel_item_creator_is_valid_uri (_data_->self, _data_->_tmp102_);
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp103_) {
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp104_ = _data_->self->item;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp105_ = _data_->resource;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp106_ = gupnp_didl_lite_resource_get_uri (_data_->_tmp105_);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp107_ = _data_->_tmp106_;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_media_item_add_uri (_data_->_tmp104_, _data_->_tmp107_);
#line 1482 "rygel-item-creator.c"
			}
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp108_ = _data_->resource;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp109_ = gupnp_didl_lite_resource_get_size (_data_->_tmp108_);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp110_ = _data_->_tmp109_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp110_ >= ((glong) 0)) {
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp111_ = _data_->self->item;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp112_ = _data_->resource;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp113_ = gupnp_didl_lite_resource_get_size (_data_->_tmp112_);
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp114_ = _data_->_tmp113_;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_media_item_set_size (_data_->_tmp111_, (gint64) _data_->_tmp114_);
#line 1502 "rygel-item-creator.c"
			}
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->info);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->resource);
#line 1508 "rygel-item-creator.c"
		}
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp115_ = _data_->self->item;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp116_ = _data_->_tmp115_->mime_type;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp116_ == NULL) {
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp117_ = _data_->self->item;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp118_ = NULL;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp118_ = rygel_item_creator_get_generic_mime_type (_data_->self);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->_tmp117_->mime_type);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp117_->mime_type = _data_->_tmp118_;
#line 1526 "rygel-item-creator.c"
		}
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp119_ = _data_->self->item;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp120_ = rygel_media_item_get_size (_data_->_tmp119_);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp121_ = _data_->_tmp120_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp121_ < ((gint64) 0)) {
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp122_ = _data_->self->item;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_media_item_set_size (_data_->_tmp122_, (gint64) 0);
#line 1540 "rygel-item-creator.c"
		}
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp123_ = _data_->self->item;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp124_ = ((RygelMediaObject*) _data_->_tmp123_)->uris;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp125_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp124_);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp126_ = _data_->_tmp125_;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp126_ == 0) {
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp127_ = _data_->container;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp128_ = _data_->self->item;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp129_ = rygel_media_object_get_title ((RygelMediaObject*) _data_->_tmp128_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp130_ = _data_->_tmp129_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_state_ = 2;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_item_creator_create_uri (_data_->self, _data_->_tmp127_, _data_->_tmp130_, rygel_item_creator_run_ready, _data_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 1566 "rygel-item-creator.c"
			_state_2:
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp131_ = NULL;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp131_ = rygel_item_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->uri = _data_->_tmp131_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_inner_error_ != NULL) {
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				__g_list_free__g_object_unref0_0 (_data_->resources);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->container);
#line 1580 "rygel-item-creator.c"
				goto __catch70_g_error;
			}
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp132_ = _data_->self->item;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp133_ = ((RygelMediaObject*) _data_->_tmp132_)->uris;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp134_ = _data_->uri;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp133_, _data_->_tmp134_);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp135_ = _data_->self->item;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_media_item_set_place_holder (_data_->_tmp135_, TRUE);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->uri);
#line 1597 "rygel-item-creator.c"
		} else {
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp136_ = _data_->self->item;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp137_ = ((RygelMediaObject*) _data_->_tmp136_)->uris;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp138_ = NULL;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp138_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp137_, 0);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp139_ = (gchar*) _data_->_tmp138_;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp140_ = NULL;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp140_ = g_file_new_for_uri (_data_->_tmp139_);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp141_ = _data_->_tmp140_;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->_tmp139_);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->file = _data_->_tmp141_;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp142_ = _data_->self->item;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp143_ = _data_->file;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp144_ = FALSE;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp144_ = g_file_is_native (_data_->_tmp143_);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_media_item_set_place_holder (_data_->_tmp142_, !_data_->_tmp144_);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->file);
#line 1631 "rygel-item-creator.c"
		}
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp145_ = _data_->self->item;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp146_ = _data_->self->item;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp147_ = ((RygelMediaObject*) _data_->_tmp146_)->uris;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp148_ = NULL;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp148_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp147_, 0);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_free0 (((RygelMediaObject*) _data_->_tmp145_)->id);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		((RygelMediaObject*) _data_->_tmp145_)->id = (gchar*) _data_->_tmp148_;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp149_ = _data_->container;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp150_ = _data_->self->item;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp151_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp152_ = _data_->_tmp151_;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 3;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_writable_container_add_item (_data_->_tmp149_, _data_->_tmp150_, _data_->_tmp152_, rygel_item_creator_run_ready, _data_);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1661 "rygel-item-creator.c"
		_state_3:
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_writable_container_add_item_finish (_data_->_tmp149_, _data_->_res_, &_data_->_inner_error_);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			__g_list_free__g_object_unref0_0 (_data_->resources);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1671 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp153_ = _data_->container;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 4;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_wait_for_item (_data_->self, _data_->_tmp153_, rygel_item_creator_run_ready, _data_);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1682 "rygel-item-creator.c"
		_state_4:
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_wait_for_item_finish (_data_->self, _data_->_res_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp154_ = _data_->self->item;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp155_ = _data_->self->priv->didl_writer;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp156_ = _data_->self->priv->content_dir;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp157_ = _data_->_tmp156_->http_server;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp158_ = NULL;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp158_ = rygel_media_object_serialize ((RygelMediaObject*) _data_->_tmp154_, _data_->_tmp155_, _data_->_tmp157_, &_data_->_inner_error_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp159_ = _data_->_tmp158_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->_tmp159_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			__g_list_free__g_object_unref0_0 (_data_->resources);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1708 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_conclude (_data_->self);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp161_ = _data_->self->container_id;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (g_strcmp0 (_data_->_tmp161_, "DLNA.ORG_AnyContainer") == 0) {
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp162_ = _data_->self->item;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp163_ = rygel_media_item_get_place_holder (_data_->_tmp162_);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp164_ = _data_->_tmp163_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp160_ = _data_->_tmp164_;
#line 1725 "rygel-item-creator.c"
		} else {
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp160_ = FALSE;
#line 1729 "rygel-item-creator.c"
		}
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp165_ = _data_->_tmp160_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp165_) {
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp166_ = NULL;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp166_ = rygel_item_removal_queue_get_default ();
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->queue = _data_->_tmp166_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp167_ = _data_->queue;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp168_ = _data_->self->item;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp169_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp170_ = _data_->_tmp169_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_item_removal_queue_queue (_data_->_tmp167_, _data_->_tmp168_, _data_->_tmp170_);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->queue);
#line 1753 "rygel-item-creator.c"
		}
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		__g_list_free__g_object_unref0_0 (_data_->resources);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->container);
#line 1759 "rygel-item-creator.c"
	}
	goto __finally70;
	__catch70_g_error:
	{
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->err = _data_->_inner_error_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = NULL;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp171_ = _data_->err;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_handle_error (_data_->self, _data_->_tmp171_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_error_free0 (_data_->err);
#line 1774 "rygel-item-creator.c"
	}
	__finally70:
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_clear_error (&_data_->_inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1785 "rygel-item-creator.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1791 "rygel-item-creator.c"
	} else {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1795 "rygel-item-creator.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 1801 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_args_data_free (gpointer _data) {
	RygelItemCreatorParseArgsData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorParseArgsData, _data_);
#line 1812 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* _data_;
	RygelItemCreator* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorParseArgsData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_parse_args);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_parse_args_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_parse_args_co (_data_);
#line 1831 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorParseArgsData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return;
#line 1841 "rygel-item-creator.c"
	}
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1845 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* _data_) {
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 1854 "rygel-item-creator.c"
		goto _state_0;
		default:
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 1859 "rygel-item-creator.c"
	}
	_state_0:
#line 199 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->action;
#line 199 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	gupnp_service_action_get (_data_->_tmp0_, "ContainerID", G_TYPE_STRING, &_data_->self->container_id, "Elements", G_TYPE_STRING, &_data_->self->elements, NULL);
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp1_ = _data_->self->elements;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp1_ == NULL) {
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp2_ = NULL;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp2_ = _ ("'Elements' argument missing.");
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp2_);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1886 "rygel-item-creator.c"
		} else {
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1890 "rygel-item-creator.c"
		}
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1896 "rygel-item-creator.c"
	} else {
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = rygel_item_creator_comment_pattern;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = _data_->self->elements;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp6_ = FALSE;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp6_ = g_pattern_match_string (_data_->_tmp4_, _data_->_tmp5_);
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp6_) {
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = NULL;
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = _ ("Comments not allowed in XML");
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp7_);
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp8_;
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1924 "rygel-item-creator.c"
			} else {
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1928 "rygel-item-creator.c"
			}
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 1934 "rygel-item-creator.c"
		}
	}
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp9_ = _data_->self->container_id;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp9_ == NULL) {
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp10_ = NULL;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp10_ = _ ("No such object");
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp11_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp10_);
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp11_;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1957 "rygel-item-creator.c"
		} else {
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1961 "rygel-item-creator.c"
		}
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1967 "rygel-item-creator.c"
	}
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1973 "rygel-item-creator.c"
	} else {
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1977 "rygel-item-creator.c"
	}
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 1983 "rygel-item-creator.c"
}


static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* needle;
	gchar* _tmp2_;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (upnp_class != NULL);
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = *upnp_class;
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) (-1), ".");
#line 218 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	needle = _tmp1_;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = needle;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp2_ != NULL) {
#line 2006 "rygel-item-creator.c"
		gchar* _tmp3_;
		gchar _tmp4_;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp3_ = needle;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		*_tmp3_ = '\0';
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp4_ = *_tmp3_;
#line 2015 "rygel-item-creator.c"
	}
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->result);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorFetchContainerData, _data_);
#line 2029 "rygel-item-creator.c"
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	RygelItemCreator* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_fetch_container_co (_data_);
#line 2048 "rygel-item-creator.c"
}


static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return NULL;
#line 2059 "rygel-item-creator.c"
	}
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = _data_->result;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = NULL;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 2069 "rygel-item-creator.c"
}


static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_fetch_container_co (_data_);
#line 2083 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_) {
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 2092 "rygel-item-creator.c"
		goto _state_0;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 2096 "rygel-item-creator.c"
		goto _state_1;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 2:
#line 2100 "rygel-item-creator.c"
		goto _state_2;
		default:
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 2105 "rygel-item-creator.c"
	}
	_state_0:
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->media_object = NULL;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->self->container_id;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_strcmp0 (_data_->_tmp0_, "DLNA.ORG_AnyContainer") == 0) {
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp1_ = _data_->self->didl_item;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp2_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp1_);
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->upnp_class = _data_->_tmp4_;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		while (TRUE) {
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp5_ = _data_->upnp_class;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (!(g_strcmp0 (_data_->_tmp5_, "object.item") != 0)) {
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				break;
#line 2132 "rygel-item-creator.c"
			}
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp6_ = rygel_relational_expression_new ();
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->expression = _data_->_tmp6_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = _data_->expression;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			((RygelSearchExpression*) _data_->_tmp7_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
#line 233 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = _data_->expression;
#line 233 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp9_ = g_strdup ("upnp:createClass");
#line 233 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (((RygelSearchExpression*) _data_->_tmp8_)->operand1);
#line 233 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			((RygelSearchExpression*) _data_->_tmp8_)->operand1 = _data_->_tmp9_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = _data_->expression;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp11_ = _data_->upnp_class;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand2);
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			((RygelSearchExpression*) _data_->_tmp10_)->operand2 = _data_->_tmp12_;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp13_ = _data_->self->priv->content_dir;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp14_ = _data_->_tmp13_->root_container;
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp15_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp14_) ? ((RygelSearchableContainer*) _data_->_tmp14_) : NULL);
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->container = _data_->_tmp15_;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp16_ = _data_->container;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp16_ != NULL) {
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp17_ = _data_->container;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp18_ = _data_->expression;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp19_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp20_ = _data_->_tmp19_;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp21_ = 0U;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_state_ = 1;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_searchable_container_search (_data_->_tmp17_, (RygelSearchExpression*) _data_->_tmp18_, (guint) 0, (guint) 1, _data_->_tmp20_, rygel_item_creator_fetch_container_ready, _data_);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return FALSE;
#line 2188 "rygel-item-creator.c"
				_state_1:
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp22_ = NULL;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp22_ = rygel_searchable_container_search_finish (_data_->_tmp17_, _data_->_res_, &_data_->_tmp21_, &_data_->_inner_error_);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->total_matches = _data_->_tmp21_;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_result_ = _data_->_tmp22_;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_inner_error_ != NULL) {
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					g_error_free (_data_->_inner_error_);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->container);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_rygel_search_expression_unref0 (_data_->expression);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (_data_->upnp_class);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->media_object);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					if (_data_->_state_ == 0) {
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2216 "rygel-item-creator.c"
					} else {
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 2220 "rygel-item-creator.c"
					}
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					g_object_unref (_data_->_async_result);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					return FALSE;
#line 2226 "rygel-item-creator.c"
				}
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp23_ = _data_->_result_;
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp24_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp23_);
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp25_ = _data_->_tmp24_;
#line 247 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_tmp25_ > 0) {
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp26_ = _data_->_result_;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp27_ = NULL;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp26_, 0);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->media_object);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->media_object = (RygelMediaObject*) _data_->_tmp27_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp28_ = _data_->self->didl_item;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp29_ = _data_->upnp_class;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp28_, _data_->_tmp29_);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->_result_);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->container);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_rygel_search_expression_unref0 (_data_->expression);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					break;
#line 2260 "rygel-item-creator.c"
				} else {
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					rygel_item_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
#line 2264 "rygel-item-creator.c"
				}
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->_result_);
#line 2268 "rygel-item-creator.c"
			} else {
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->container);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_rygel_search_expression_unref0 (_data_->expression);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				break;
#line 2276 "rygel-item-creator.c"
			}
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 2282 "rygel-item-creator.c"
		}
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp30_ = _data_->upnp_class;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (g_strcmp0 (_data_->_tmp30_, "object.item") == 0) {
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp31_ = _data_->self->didl_item;
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp32_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp31_);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp33_ = _data_->_tmp32_;
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp34_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' UPnP class unsupported", _data_->_tmp33_);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp34_;
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->upnp_class);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2310 "rygel-item-creator.c"
			} else {
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2314 "rygel-item-creator.c"
			}
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 2320 "rygel-item-creator.c"
		}
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_free0 (_data_->upnp_class);
#line 2324 "rygel-item-creator.c"
	} else {
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp35_ = _data_->self->priv->content_dir;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp36_ = _data_->_tmp35_->root_container;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp37_ = _data_->self->container_id;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp38_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp39_ = _data_->_tmp38_;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 2;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_media_container_find_object (_data_->_tmp36_, _data_->_tmp37_, _data_->_tmp39_, rygel_item_creator_fetch_container_ready, _data_);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 2342 "rygel-item-creator.c"
		_state_2:
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp40_ = NULL;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp40_ = rygel_media_container_find_object_finish (_data_->_tmp36_, _data_->_res_, &_data_->_inner_error_);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2362 "rygel-item-creator.c"
			} else {
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2366 "rygel-item-creator.c"
			}
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 2372 "rygel-item-creator.c"
		}
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->media_object = _data_->_tmp41_;
#line 2378 "rygel-item-creator.c"
	}
#line 269 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp42_ = _data_->media_object;
#line 269 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp42_ == NULL) {
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp43_ = NULL;
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp43_ = _ ("No such object");
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp44_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp43_);
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp44_;
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2402 "rygel-item-creator.c"
		} else {
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2406 "rygel-item-creator.c"
		}
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 270 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 2412 "rygel-item-creator.c"
	} else {
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp46_ = _data_->media_object;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (!RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp46_)) {
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp45_ = TRUE;
#line 2420 "rygel-item-creator.c"
		} else {
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp47_ = _data_->media_object;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp48_ = rygel_media_object_get_ocm_flags (_data_->_tmp47_);
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp49_ = _data_->_tmp48_;
#line 273 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp45_ = !((_data_->_tmp49_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD);
#line 2430 "rygel-item-creator.c"
		}
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp50_ = _data_->_tmp45_;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp50_) {
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp51_ = NULL;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp51_ = _ ("Object creation in %s not allowed");
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp52_ = _data_->media_object;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp53_ = _data_->_tmp52_->id;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp54_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp51_, _data_->_tmp53_);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp54_;
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2458 "rygel-item-creator.c"
			} else {
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2462 "rygel-item-creator.c"
			}
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 274 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 2468 "rygel-item-creator.c"
		}
	}
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp55_ = _data_->media_object;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp56_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp55_) ? ((RygelWritableContainer*) _data_->_tmp55_) : NULL);
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = _data_->_tmp56_;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2483 "rygel-item-creator.c"
	} else {
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2487 "rygel-item-creator.c"
	}
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2499 "rygel-item-creator.c"
	} else {
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2503 "rygel-item-creator.c"
	}
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 2509 "rygel-item-creator.c"
}


static void rygel_item_creator_conclude (RygelItemCreator* self) {
	GUPnPDIDLLiteWriter* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* didl;
	GUPnPServiceAction* _tmp2_;
	RygelMediaItem* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 282 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = self->priv->didl_writer;
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = gupnp_didl_lite_writer_get_string (_tmp0_);
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	didl = _tmp1_;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = self->priv->action;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = self->item;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp4_ = ((RygelMediaObject*) _tmp3_)->id;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	gupnp_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp4_, "Result", G_TYPE_STRING, didl, NULL);
#line 290 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp5_ = self->priv->action;
#line 290 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	gupnp_service_action_return (_tmp5_);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 282 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (didl);
#line 2545 "rygel-item-creator.c"
}


static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _error_;
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 2561 "rygel-item-creator.c"
		GUPnPServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp1_ = self->priv->action;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp2_ = _error_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp3_ = _tmp2_->code;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp4_ = _error_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp5_ = _tmp4_->message;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
#line 2579 "rygel-item-creator.c"
	} else {
		GUPnPServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 298 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp6_ = self->priv->action;
#line 298 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp7_ = _error_;
#line 298 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp8_ = _tmp7_->message;
#line 298 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
#line 2592 "rygel-item-creator.c"
	}
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp9_ = _ ("Failed to create item under '%s': %s");
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp10_ = self->container_id;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp11_ = _error_;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp12_ = _tmp11_->message;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_warning (_tmp9_, _tmp10_, _tmp12_);
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 2606 "rygel-item-creator.c"
}


static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
	gchar* result = NULL;
	RygelMediaItem* _tmp0_;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = self->item;
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (RYGEL_IS_IMAGE_ITEM (_tmp0_)) {
#line 2619 "rygel-item-creator.c"
		gchar* _tmp1_;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp1_ = g_strdup ("image");
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		result = _tmp1_;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return result;
#line 2627 "rygel-item-creator.c"
	} else {
		RygelMediaItem* _tmp2_;
#line 311 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp2_ = self->item;
#line 311 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (RYGEL_IS_VIDEO_ITEM (_tmp2_)) {
#line 2634 "rygel-item-creator.c"
			gchar* _tmp3_;
#line 312 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_tmp3_ = g_strdup ("video");
#line 312 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			result = _tmp3_;
#line 312 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return result;
#line 2642 "rygel-item-creator.c"
		} else {
			gchar* _tmp4_;
#line 314 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_tmp4_ = g_strdup ("audio");
#line 314 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			result = _tmp4_;
#line 314 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return result;
#line 2651 "rygel-item-creator.c"
		}
	}
}


static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = upnp_class;
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _tmp0_;
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2683 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp4_;
				RygelWritableContainer* _tmp5_;
				const gchar* _tmp6_;
				RygelImageItem* _tmp7_;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp4_ = id;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp5_ = parent;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp6_ = title;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_, RYGEL_IMAGE_ITEM_UPNP_CLASS);
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp7_;
#line 324 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2702 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2708 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp8_;
				RygelWritableContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelPhotoItem* _tmp11_;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp8_ = id;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp9_ = parent;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp10_ = title;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp11_;
#line 326 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2727 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2733 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp12_;
				RygelWritableContainer* _tmp13_;
				const gchar* _tmp14_;
				RygelVideoItem* _tmp15_;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp12_ = id;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp13_ = parent;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp14_ = title;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp15_;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2752 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2758 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp16_;
				RygelWritableContainer* _tmp17_;
				const gchar* _tmp18_;
				RygelAudioItem* _tmp19_;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp16_ = id;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp17_ = parent;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp18_ = title;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_, RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp19_;
#line 330 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2777 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2783 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp20_;
				RygelWritableContainer* _tmp21_;
				const gchar* _tmp22_;
				RygelMusicItem* _tmp23_;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp20_ = id;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp21_ = parent;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp22_ = title;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp23_;
#line 332 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2802 "rygel-item-creator.c"
			}
		}
	} else {
#line 322 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2808 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp24_;
				GError* _tmp25_;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp24_ = upnp_class;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp25_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", _tmp24_);
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_inner_error_ = _tmp25_;
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_propagate_error (error, _inner_error_);
#line 334 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return NULL;
#line 2823 "rygel-item-creator.c"
			}
		}
	}
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
#line 1148 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 2844 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
#line 343 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = uri;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp1_ == NULL) {
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp0_ = TRUE;
#line 2861 "rygel-item-creator.c"
	} else {
		const gchar* _tmp2_;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp2_ = uri;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 2868 "rygel-item-creator.c"
	}
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = _tmp0_;
#line 344 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp3_) {
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		result = FALSE;
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return result;
#line 2878 "rygel-item-creator.c"
	}
	{
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* next;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp4_ = uri;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp5_ = g_utf8_next_char (_tmp4_);
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		next = _tmp6_;
#line 2893 "rygel-item-creator.c"
		{
			gboolean _tmp7_;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_tmp7_ = TRUE;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			while (TRUE) {
#line 2900 "rygel-item-creator.c"
				gboolean _tmp8_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gunichar _tmp14_ = 0U;
				gboolean _tmp15_ = FALSE;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp8_ = _tmp7_;
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (!_tmp8_) {
#line 2910 "rygel-item-creator.c"
					const gchar* _tmp9_;
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_tmp9_ = next;
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_tmp10_ = g_utf8_next_char (_tmp9_);
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_tmp11_ = g_strdup (_tmp10_);
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (next);
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					next = _tmp11_;
#line 2924 "rygel-item-creator.c"
				}
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp7_ = FALSE;
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp12_ = next;
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (!(g_strcmp0 (_tmp12_, "") != 0)) {
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					break;
#line 2934 "rygel-item-creator.c"
				}
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp13_ = next;
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp14_ = string_get_char (_tmp13_, (glong) 0);
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp15_ = g_unichar_isspace (_tmp14_);
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_tmp15_) {
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					result = FALSE;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (next);
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					return result;
#line 2950 "rygel-item-creator.c"
				}
			}
		}
#line 348 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_free0 (next);
#line 2956 "rygel-item-creator.c"
	}
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = TRUE;
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 2962 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri_data_free (gpointer _data) {
	RygelItemCreatorCreateUriData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->container);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->title);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->result);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorCreateUriData, _data_);
#line 2979 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorCreateUriData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_uri);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_uri_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = container;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->container = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = title;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->title = _tmp4_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_create_uri_co (_data_);
#line 3014 "rygel-item-creator.c"
}


static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelItemCreatorCreateUriData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return NULL;
#line 3025 "rygel-item-creator.c"
	}
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = _data_->result;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = NULL;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3035 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_create_uri_co (_data_);
#line 3049 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_) {
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 3058 "rygel-item-creator.c"
		goto _state_0;
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 3062 "rygel-item-creator.c"
		goto _state_1;
		default:
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 3067 "rygel-item-creator.c"
	}
	_state_0:
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_state_ = 1;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->_tmp0_, _data_->_tmp2_, rygel_item_creator_create_uri_ready, _data_);
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 3082 "rygel-item-creator.c"
	_state_1:
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp3_ = NULL;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp3_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->dir = _data_->_tmp3_;
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3100 "rygel-item-creator.c"
		} else {
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3104 "rygel-item-creator.c"
		}
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 361 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 3110 "rygel-item-creator.c"
	}
#line 362 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp4_ = _data_->dir;
#line 362 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp4_ == NULL) {
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = NULL;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = _ ("Object creation in %s not allowed");
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp6_ = _data_->container;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->id;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp8_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp5_, _data_->_tmp7_);
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3138 "rygel-item-creator.c"
		} else {
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3142 "rygel-item-creator.c"
		}
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 3148 "rygel-item-creator.c"
	}
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp9_ = g_date_time_new_now_utc ();
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->now = _data_->_tmp9_;
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp10_ = _data_->dir;
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp11_ = _data_->title;
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp12_ = NULL;
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp12_ = g_file_get_child_for_display_name (_data_->_tmp10_, _data_->_tmp11_, &_data_->_inner_error_);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->file = _data_->_tmp12_;
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_date_time_unref0 (_data_->now);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3178 "rygel-item-creator.c"
		} else {
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3182 "rygel-item-creator.c"
		}
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 3188 "rygel-item-creator.c"
	}
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp13_ = _data_->file;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp14_ = NULL;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp14_ = g_file_get_uri (_data_->_tmp13_);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp16_ = _data_->now;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp17_ = NULL;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp17_ = g_date_time_format (_data_->_tmp16_, "%s");
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp18_ = _data_->_tmp17_;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp19_ = g_strconcat (_data_->_tmp15_, _data_->_tmp18_, NULL);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp20_ = _data_->_tmp19_;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->_tmp18_);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->_tmp15_);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = _data_->_tmp20_;
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->file);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_date_time_unref0 (_data_->now);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3226 "rygel-item-creator.c"
	} else {
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3230 "rygel-item-creator.c"
	}
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 371 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->file);
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_date_time_unref0 (_data_->now);
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3246 "rygel-item-creator.c"
	} else {
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3250 "rygel-item-creator.c"
	}
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 3256 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_data_free (gpointer _data) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->container);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorWaitForItemData, _data_);
#line 3269 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorWaitForItemData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_wait_for_item);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_wait_for_item_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = container;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->container = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data_);
#line 3296 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_) {
	RygelItemCreatorWaitForItemData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3304 "rygel-item-creator.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return _data5_;
#line 3313 "rygel-item-creator.c"
}


static void block5_data_unref (Block5Data* _data5_) {
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data5_->self);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data5_->container);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_slice_free (Block5Data, _data5_);
#line 3326 "rygel-item-creator.c"
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return _data6_;
#line 3336 "rygel-item-creator.c"
}


static void block6_data_unref (Block6Data* _data6_) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		block5_data_unref (_data6_->_data5_);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data6_->_data5_ = NULL;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_slice_free (Block6Data, _data6_);
#line 3349 "rygel-item-creator.c"
	}
}


static void ____lambda10_ (Block6Data* _data6_, RygelMediaContainer* container) {
	Block5Data* _data5_;
	RygelItemCreator * self;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data5_ = _data6_->_data5_;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = _data5_->self;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (container != NULL);
#line 383 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data5_->_async_data_);
#line 3365 "rygel-item-creator.c"
}


static void _____lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	____lambda10_ (self, container);
#line 3372 "rygel-item-creator.c"
}


static gboolean ____lambda11_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelItemCreator * self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_;
	const gchar* _tmp1_;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data5_ = _data6_->_data5_;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = _data5_->self;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _data5_->container;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:388: Timeout on waiting for 'updated' signal o" \
"n '%s'.", _tmp1_);
#line 390 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data5_->_async_data_);
#line 391 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data6_->timeout = (guint) 0;
#line 393 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = FALSE;
#line 393 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3400 "rygel-item-creator.c"
}


static gboolean _____lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda11_ (self);
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3409 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data_);
#line 3423 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_) {
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 3432 "rygel-item-creator.c"
		goto _state_0;
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 3436 "rygel-item-creator.c"
		goto _state_1;
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 2:
#line 3440 "rygel-item-creator.c"
		goto _state_2;
		default:
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 3445 "rygel-item-creator.c"
	}
	_state_0:
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_ = g_slice_new0 (Block5Data);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->_ref_count_ = 1;
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->self = g_object_ref (_data_->self);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->container = _data_->_tmp1_;
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->_async_data_ = _data_;
#line 375 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp2_ = _data_->_data5_->container;
#line 375 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp3_ = ((RygelMediaObject*) _data_->_tmp2_)->id;
#line 375 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:375: Waiting for new item to appear under cont" \
"ainer '%s'..", _data_->_tmp3_);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->item = NULL;
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	while (TRUE) {
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = _data_->item;
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (!(_data_->_tmp4_ == NULL)) {
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			break;
#line 3478 "rygel-item-creator.c"
		}
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = _data_->item;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp5_ == NULL) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_ = g_slice_new0 (Block6Data);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->_ref_count_ = 1;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->_data5_ = block5_data_ref (_data_->_data5_);
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp6_ = _data_->_data5_->container;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = 0UL;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp6_, "container-updated", (GCallback) _____lambda10__rygel_media_container_container_updated, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->id = _data_->_tmp7_;
#line 386 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->timeout = (guint) 0;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = 0U;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda11__gsource_func, block6_data_ref (_data_->_data6_), block6_data_unref);
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->timeout = _data_->_tmp8_;
#line 396 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_state_ = 1;
#line 396 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 3510 "rygel-item-creator.c"
			_state_1:
			;
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp9_ = _data_->_data5_->container;
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = _data_->id;
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_signal_handler_disconnect ((GObject*) _data_->_tmp9_, _data_->_tmp10_);
#line 3519 "rygel-item-creator.c"
			{
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp11_ = _data_->_data5_->container;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp12_ = _data_->self->item;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp13_ = ((RygelMediaObject*) _data_->_tmp12_)->id;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp14_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_state_ = 2;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp11_, _data_->_tmp13_, _data_->_tmp15_, rygel_item_creator_wait_for_item_ready, _data_);
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return FALSE;
#line 3537 "rygel-item-creator.c"
				_state_2:
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp16_ = NULL;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp16_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp17_ = _data_->_tmp16_;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_inner_error_ != NULL) {
#line 3547 "rygel-item-creator.c"
					goto __catch72_g_error;
				}
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->item);
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->item = RYGEL_IS_MEDIA_ITEM (_data_->_tmp17_) ? ((RygelMediaItem*) _data_->_tmp17_) : NULL;
#line 3554 "rygel-item-creator.c"
			}
			goto __finally72;
			__catch72_g_error:
			{
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_error_ = _data_->_inner_error_;
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_inner_error_ = NULL;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp18_ = _data_->_data5_->container;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp19_ = ((RygelMediaObject*) _data_->_tmp18_)->id;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp20_ = _data_->self->item;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp21_ = ((RygelMediaObject*) _data_->_tmp20_)->id;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_warning ("Error from container '%s' on trying to find newly " "added child item '%s' in it", _data_->_tmp19_, _data_->_tmp21_);
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_error_free0 (_data_->_error_);
#line 3575 "rygel-item-creator.c"
			}
			__finally72:
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_inner_error_ != NULL) {
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				block6_data_unref (_data_->_data6_);
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_data6_ = NULL;
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->item);
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				block5_data_unref (_data_->_data5_);
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_data5_ = NULL;
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_clear_error (&_data_->_inner_error_);
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return FALSE;
#line 3596 "rygel-item-creator.c"
			}
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp22_ = _data_->_data6_->timeout;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp22_ != ((guint) 0)) {
#line 413 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp23_ = _data_->_data6_->timeout;
#line 413 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_source_remove (_data_->_tmp23_);
#line 3606 "rygel-item-creator.c"
			} else {
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				block6_data_unref (_data_->_data6_);
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_data6_ = NULL;
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				break;
#line 3614 "rygel-item-creator.c"
			}
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			block6_data_unref (_data_->_data6_);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_ = NULL;
#line 3620 "rygel-item-creator.c"
		}
	}
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp24_ = _data_->_data5_->container;
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp25_ = ((RygelMediaObject*) _data_->_tmp24_)->id;
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:419: Finished waiting for new item to appear u" \
"nder container '%s'", _data_->_tmp25_);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->item);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	block5_data_unref (_data_->_data5_);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_ = NULL;
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3639 "rygel-item-creator.c"
	} else {
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3643 "rygel-item-creator.c"
	}
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 3649 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GUPnPDLNADiscoverer* _tmp0_;
	GUPnPDLNADiscoverer* discoverer;
	gboolean valid;
	GUPnPDLNADiscoverer* _tmp1_;
	GList* _tmp2_ = NULL;
#line 423 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 423 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (profile != NULL, FALSE);
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, FALSE);
#line 424 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	discoverer = _tmp0_;
#line 428 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	valid = FALSE;
#line 429 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = discoverer;
#line 429 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = gupnp_dlna_discoverer_list_profiles (_tmp1_);
#line 3674 "rygel-item-creator.c"
	{
		GList* known_profile_collection = NULL;
		GList* known_profile_it = NULL;
#line 429 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		known_profile_collection = _tmp2_;
#line 429 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		for (known_profile_it = known_profile_collection; known_profile_it != NULL; known_profile_it = known_profile_it->next) {
#line 3682 "rygel-item-creator.c"
			GUPnPDLNAProfile* known_profile = NULL;
#line 429 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			known_profile = (GUPnPDLNAProfile*) known_profile_it->data;
#line 3686 "rygel-item-creator.c"
			{
				GUPnPDLNAProfile* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
#line 430 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp3_ = known_profile;
#line 430 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp4_ = gupnp_dlna_profile_get_name (_tmp3_);
#line 430 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp5_ = _tmp4_;
#line 430 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp6_ = profile;
#line 430 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
#line 431 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					valid = TRUE;
#line 433 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					break;
#line 3706 "rygel-item-creator.c"
				}
			}
		}
	}
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = valid;
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (discoverer);
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3717 "rygel-item-creator.c"
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	GCancellable* _tmp0_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = self->priv->_cancellable;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3733 "rygel-item-creator.c"
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = value;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->_cancellable = _tmp1_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 3753 "rygel-item-creator.c"
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	GPatternSpec* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_creator_get_property;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_creator_set_property;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, "cancellable");
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_comment_pattern = _tmp0_;
#line 3775 "rygel-item-creator.c"
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_creator_real_run;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->run_finish = rygel_item_creator_real_run_finish;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
#line 3790 "rygel-item-creator.c"
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
#line 3797 "rygel-item-creator.c"
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = RYGEL_ITEM_CREATOR (obj);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (self->container_id);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (self->elements);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->didl_item);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->item);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_writer);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
#line 3823 "rygel-item-creator.c"
}


/**
 * CreateObject action implementation.
 */
GType rygel_item_creator_get_type (void) {
	static volatile gsize rygel_item_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_creator_type_id;
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_creator_type_id__volatile, rygel_item_creator_type_id);
	}
	return rygel_item_creator_type_id__volatile;
}


static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3855 "rygel-item-creator.c"
		default:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3861 "rygel-item-creator.c"
	}
}


static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3877 "rygel-item-creator.c"
		default:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3883 "rygel-item-creator.c"
	}
}



