/* chess-view-3d.c generated by valac 0.12.0, the Vala compiler
 * generated from chess-view-3d.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <gdk/gdk.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <float.h>
#include <math.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <cairo.h>
#include <GL/glu.h>
#include <stdlib.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW3_D (chess_view3_d_get_type ())
#define CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW3_D, ChessView3D))
#define CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW3_D, ChessView3DClass))
#define IS_CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW3_D))
#define IS_CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW3_D))
#define CHESS_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW3_D, ChessView3DClass))

typedef struct _ChessView3D ChessView3D;
typedef struct _ChessView3DClass ChessView3DClass;
typedef struct _ChessView3DPrivate ChessView3DPrivate;

#define TYPE_TDS_MODEL (tds_model_get_type ())
#define TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TDS_MODEL, TDSModel))
#define TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TDS_MODEL, TDSModelClass))
#define IS_TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TDS_MODEL))
#define IS_TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TDS_MODEL))
#define TDS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TDS_MODEL, TDSModelClass))

typedef struct _TDSModel TDSModel;
typedef struct _TDSModelClass TDSModelClass;
#define _tds_model_unref0(var) ((var == NULL) ? NULL : (var = (tds_model_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _XFree0(var) ((var == NULL) ? NULL : (var = (XFree (var), NULL)))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView3D {
	ChessView parent_instance;
	ChessView3DPrivate * priv;
};

struct _ChessView3DClass {
	ChessViewClass parent_class;
};

struct _ChessView3DPrivate {
	GLXContext context;
	void* display;
	GLXDrawable drawable;
	gint border;
	gint square_size;
	TDSModel* pawn_model;
	TDSModel* knight_model;
	TDSModel* bishop_model;
	TDSModel* rook_model;
	TDSModel* queen_model;
	TDSModel* king_model;
	GLfloat* board_vertices;
	gint board_vertices_length1;
	gint _board_vertices_size_;
	GLfloat* board_normals;
	gint board_normals_length1;
	gint _board_normals_size_;
	GLushort* board_quads;
	gint board_quads_length1;
	gint _board_quads_size_;
	GLfloat SQUARE_WIDTH;
	GLfloat BOARD_DEPTH;
	GLfloat BOARD_BORDER;
	GLfloat BOARD_CHAMFER;
	GLfloat BOARD_INNER_WIDTH;
	GLfloat BOARD_OUTER_WIDTH;
	GLfloat OFFSET;
	GLfloat white_piece_color[4];
	GLfloat white_piece_specular[4];
	GLfloat black_piece_color[4];
	GLfloat black_piece_specular[4];
	GLuint _board_texture;
	GLuint _numbering_texture;
	GLuint _piece_texture;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_view3_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view3_d_get_type (void) G_GNUC_CONST;
gpointer tds_model_ref (gpointer instance);
void tds_model_unref (gpointer instance);
GParamSpec* param_spec_tds_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tds_model (GValue* value, gpointer v_object);
void value_take_tds_model (GValue* value, gpointer v_object);
gpointer value_get_tds_model (const GValue* value);
GType tds_model_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW3_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW3_D, ChessView3DPrivate))
enum  {
	CHESS_VIEW3_D_DUMMY_PROPERTY
};
ChessView3D* chess_view3_d_new (void);
ChessView3D* chess_view3_d_construct (GType object_type);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static void chess_view3_d_realize_cb (ChessView3D* self);
static void _chess_view3_d_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void chess_view3_d_unrealize_cb (ChessView3D* self);
static void _chess_view3_d_unrealize_cb_gtk_widget_unrealize (GtkWidget* _sender, gpointer self);
TDSModel* tds_model_new (GFile* file, GError** error);
TDSModel* tds_model_construct (GType object_type, GFile* file, GError** error);
static void chess_view3_d_create_board (ChessView3D* self);
static gboolean chess_view3_d_start_gl (ChessView3D* self);
static gboolean _context_equal (const GLXContext* s1, const GLXContext* s2);
static gboolean chess_view3_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view3_d_accFrustum (ChessView3D* self, GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus);
static void chess_view3_d_accPerspective (ChessView3D* self, GLfloat fovy, GLfloat aspect, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus);
static gboolean chess_view3_d_real_draw (GtkWidget* base, cairo_t* c);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
gboolean chess_scene_get_show_3d_smooth (ChessScene* self);
static void chess_view3_d_transform_camera (ChessView3D* self);
gdouble chess_scene_get_board_angle (ChessScene* self);
static void chess_view3_d_draw_board (ChessView3D* self);
static void chess_view3_d_draw_numbering (ChessView3D* self);
static void chess_view3_d_draw_pieces (ChessView3D* self);
static GLuint chess_view3_d_get_board_texture (ChessView3D* self);
static GLuint chess_view3_d_get_numbering_texture (ChessView3D* self);
static void chess_view3_d_draw_label (ChessView3D* self, GLfloat x, GLfloat z, GLfloat width, gint cell);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
static GLuint chess_view3_d_get_piece_texture (ChessView3D* self);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
static void chess_view3_d_render_piece (ChessView3D* self, ChessPiece* piece, GLfloat alpha);
gboolean chess_scene_get_show_move_hints (ChessScene* self);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
void tds_model_render (TDSModel* self);
static gboolean chess_view3_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static GLuint chess_view3_d_load_texture (ChessView3D* self, const gchar* filename);
static GLuint chess_view3_d_make_numbering_texture (ChessView3D* self);
static void chess_view3_d_draw_centered_text (ChessView3D* self, cairo_t* c, gdouble x, gdouble y, gdouble scale, const gchar* text);
static void chess_view3_d_finalize (GObject* obj);
static void _vala_chess_view3_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _chess_view3_d_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	chess_view3_d_realize_cb (self);
}


static void _chess_view3_d_unrealize_cb_gtk_widget_unrealize (GtkWidget* _sender, gpointer self) {
	chess_view3_d_unrealize_cb (self);
}


ChessView3D* chess_view3_d_construct (GType object_type) {
	ChessView3D * self = NULL;
	GLfloat _tmp0_[4] = {0};
	GLfloat _tmp1_[4] = {0};
	GLfloat _tmp2_[4] = {0};
	GLfloat _tmp3_[4] = {0};
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_;
	TDSModel* _tmp8_ = NULL;
	TDSModel* _tmp9_;
	TDSModel* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_;
	TDSModel* _tmp15_ = NULL;
	TDSModel* _tmp16_;
	TDSModel* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	GFile* _tmp20_ = NULL;
	GFile* _tmp21_;
	TDSModel* _tmp22_ = NULL;
	TDSModel* _tmp23_;
	TDSModel* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	GFile* _tmp27_ = NULL;
	GFile* _tmp28_;
	TDSModel* _tmp29_ = NULL;
	TDSModel* _tmp30_;
	TDSModel* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	GFile* _tmp34_ = NULL;
	GFile* _tmp35_;
	TDSModel* _tmp36_ = NULL;
	TDSModel* _tmp37_;
	TDSModel* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	GFile* _tmp41_ = NULL;
	GFile* _tmp42_;
	TDSModel* _tmp43_ = NULL;
	TDSModel* _tmp44_;
	TDSModel* _tmp45_;
	GError * _inner_error_ = NULL;
	self = (ChessView3D*) chess_view_construct (object_type);
	self->priv->SQUARE_WIDTH = (GLfloat) 10.0f;
	self->priv->BOARD_DEPTH = (GLfloat) 3.0f;
	self->priv->BOARD_BORDER = (GLfloat) 5.0f;
	self->priv->BOARD_CHAMFER = (GLfloat) 2.0f;
	self->priv->BOARD_INNER_WIDTH = self->priv->SQUARE_WIDTH * 8.0f;
	self->priv->BOARD_OUTER_WIDTH = self->priv->BOARD_INNER_WIDTH + (self->priv->BOARD_BORDER * 2.0f);
	self->priv->OFFSET = self->priv->BOARD_OUTER_WIDTH * 0.5f;
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) _chess_view3_d_realize_cb_gtk_widget_realize, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unrealize", (GCallback) _chess_view3_d_unrealize_cb_gtk_widget_unrealize, self, 0);
	_tmp0_[0] = (GLfloat) (0.95f * 0.7f);
	_tmp0_[1] = (GLfloat) (0.81f * 0.7f);
	_tmp0_[2] = (GLfloat) (0.64f * 0.7f);
	_tmp0_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->white_piece_color, _tmp0_, 4 * sizeof (GLfloat));
	_tmp1_[0] = (GLfloat) 0.95f;
	_tmp1_[1] = (GLfloat) 0.81f;
	_tmp1_[2] = (GLfloat) 0.64f;
	_tmp1_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->white_piece_specular, _tmp1_, 4 * sizeof (GLfloat));
	_tmp2_[0] = (GLfloat) (0.62f * 0.7f);
	_tmp2_[1] = (GLfloat) (0.45f * 0.7f);
	_tmp2_[2] = (GLfloat) (0.28f * 0.7f);
	_tmp2_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->black_piece_color, _tmp2_, 4 * sizeof (GLfloat));
	_tmp3_[0] = (GLfloat) 0.62f;
	_tmp3_[1] = (GLfloat) 0.45f;
	_tmp3_[2] = (GLfloat) 0.28f;
	_tmp3_[3] = (GLfloat) 1.0f;
	memcpy (self->priv->black_piece_specular, _tmp3_, 4 * sizeof (GLfloat));
	gtk_widget_set_double_buffered ((GtkWidget*) self, FALSE);
	_tmp4_ = g_build_filename (PKGDATADIR, "pieces", "3d", "pawn.3ds", NULL, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = tds_model_new (_tmp7_, &_inner_error_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tds_model_unref0 (self->priv->pawn_model);
	self->priv->pawn_model = _tmp10_;
	_tmp11_ = g_build_filename (PKGDATADIR, "pieces", "3d", "knight.3ds", NULL, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_file_new_for_path (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = tds_model_new (_tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp17_ = _tmp16_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tds_model_unref0 (self->priv->knight_model);
	self->priv->knight_model = _tmp17_;
	_tmp18_ = g_build_filename (PKGDATADIR, "pieces", "3d", "bishop.3ds", NULL, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_file_new_for_path (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = tds_model_new (_tmp21_, &_inner_error_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp24_ = _tmp23_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tds_model_unref0 (self->priv->bishop_model);
	self->priv->bishop_model = _tmp24_;
	_tmp25_ = g_build_filename (PKGDATADIR, "pieces", "3d", "rook.3ds", NULL, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_file_new_for_path (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = tds_model_new (_tmp28_, &_inner_error_);
	_tmp30_ = _tmp29_;
	_g_object_unref0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp31_ = _tmp30_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tds_model_unref0 (self->priv->rook_model);
	self->priv->rook_model = _tmp31_;
	_tmp32_ = g_build_filename (PKGDATADIR, "pieces", "3d", "queen.3ds", NULL, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_file_new_for_path (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = tds_model_new (_tmp35_, &_inner_error_);
	_tmp37_ = _tmp36_;
	_g_object_unref0 (_tmp35_);
	_g_free0 (_tmp33_);
	_tmp38_ = _tmp37_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tds_model_unref0 (self->priv->queen_model);
	self->priv->queen_model = _tmp38_;
	_tmp39_ = g_build_filename (PKGDATADIR, "pieces", "3d", "king.3ds", NULL, NULL);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_file_new_for_path (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = tds_model_new (_tmp42_, &_inner_error_);
	_tmp44_ = _tmp43_;
	_g_object_unref0 (_tmp42_);
	_g_free0 (_tmp40_);
	_tmp45_ = _tmp44_;
	if (_inner_error_ != NULL) {
		goto __catch13_g_error;
	}
	_tds_model_unref0 (self->priv->king_model);
	self->priv->king_model = _tmp45_;
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	chess_view3_d_create_board (self);
	return self;
}


ChessView3D* chess_view3_d_new (void) {
	return chess_view3_d_construct (TYPE_CHESS_VIEW3_D);
}


static gboolean _context_equal (const GLXContext* s1, const GLXContext* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean chess_view3_d_start_gl (ChessView3D* self) {
	gboolean result = FALSE;
	GLXContext null_context;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	null_context = (GLXContext) NULL;
	if (_context_equal (&self->priv->context, &null_context) == TRUE) {
		result = FALSE;
		return result;
	}
	_tmp0_ = glXMakeCurrent (self->priv->display, self->priv->drawable, self->priv->context);
	result = _tmp0_;
	return result;
}


static void chess_view3_d_create_board (ChessView3D* self) {
	gfloat a;
	GLfloat b;
	GLfloat c;
	GLfloat d;
	GLfloat e;
	GLfloat f;
	gfloat l;
	GLfloat k;
	GLfloat j;
	GLfloat i;
	GLfloat h;
	GLfloat g;
	GLfloat* _tmp0_ = NULL;
	GLfloat* _tmp1_ = NULL;
	GLushort* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	a = 0.0f;
	b = self->priv->BOARD_CHAMFER;
	c = self->priv->BOARD_BORDER;
	d = c + (self->priv->SQUARE_WIDTH * 8.0f);
	e = (d + self->priv->BOARD_BORDER) - self->priv->BOARD_CHAMFER;
	f = d + self->priv->BOARD_BORDER;
	l = 0.0f;
	k = -self->priv->BOARD_CHAMFER;
	j = -self->priv->BOARD_BORDER;
	i = j - (self->priv->SQUARE_WIDTH * 8.0f);
	h = (i - self->priv->BOARD_BORDER) + self->priv->BOARD_CHAMFER;
	g = i - self->priv->BOARD_BORDER;
	_tmp0_ = g_new0 (GLfloat, 48);
	_tmp0_[0] = c;
	_tmp0_[1] = (GLfloat) 0.0f;
	_tmp0_[2] = i;
	_tmp0_[3] = d;
	_tmp0_[4] = (GLfloat) 0.0f;
	_tmp0_[5] = i;
	_tmp0_[6] = d;
	_tmp0_[7] = (GLfloat) 0.0f;
	_tmp0_[8] = j;
	_tmp0_[9] = c;
	_tmp0_[10] = (GLfloat) 0.0f;
	_tmp0_[11] = j;
	_tmp0_[12] = b;
	_tmp0_[13] = (GLfloat) 0.0f;
	_tmp0_[14] = h;
	_tmp0_[15] = e;
	_tmp0_[16] = (GLfloat) 0.0f;
	_tmp0_[17] = h;
	_tmp0_[18] = e;
	_tmp0_[19] = (GLfloat) 0.0f;
	_tmp0_[20] = k;
	_tmp0_[21] = b;
	_tmp0_[22] = (GLfloat) 0.0f;
	_tmp0_[23] = k;
	_tmp0_[24] = (GLfloat) a;
	_tmp0_[25] = -self->priv->BOARD_CHAMFER;
	_tmp0_[26] = g;
	_tmp0_[27] = f;
	_tmp0_[28] = -self->priv->BOARD_CHAMFER;
	_tmp0_[29] = g;
	_tmp0_[30] = f;
	_tmp0_[31] = -self->priv->BOARD_CHAMFER;
	_tmp0_[32] = (GLfloat) l;
	_tmp0_[33] = (GLfloat) a;
	_tmp0_[34] = -self->priv->BOARD_CHAMFER;
	_tmp0_[35] = (GLfloat) l;
	_tmp0_[36] = (GLfloat) a;
	_tmp0_[37] = -self->priv->BOARD_DEPTH;
	_tmp0_[38] = g;
	_tmp0_[39] = f;
	_tmp0_[40] = -self->priv->BOARD_DEPTH;
	_tmp0_[41] = g;
	_tmp0_[42] = f;
	_tmp0_[43] = -self->priv->BOARD_DEPTH;
	_tmp0_[44] = (GLfloat) l;
	_tmp0_[45] = (GLfloat) a;
	_tmp0_[46] = -self->priv->BOARD_DEPTH;
	_tmp0_[47] = (GLfloat) l;
	self->priv->board_vertices = (g_free (self->priv->board_vertices), NULL);
	self->priv->board_vertices = _tmp0_;
	self->priv->board_vertices_length1 = 48;
	self->priv->_board_vertices_size_ = 48;
	_tmp1_ = g_new0 (GLfloat, 27);
	_tmp1_[0] = (GLfloat) 0.0f;
	_tmp1_[1] = (GLfloat) 1.0f;
	_tmp1_[2] = (GLfloat) 0.0f;
	_tmp1_[3] = (GLfloat) 0.0f;
	_tmp1_[4] = (GLfloat) 0.0f;
	_tmp1_[5] = (GLfloat) (-1.0f);
	_tmp1_[6] = (GLfloat) 1.0f;
	_tmp1_[7] = (GLfloat) 0.0f;
	_tmp1_[8] = (GLfloat) 0.0f;
	_tmp1_[9] = (GLfloat) 0.0f;
	_tmp1_[10] = (GLfloat) 0.0f;
	_tmp1_[11] = (GLfloat) 1.0f;
	_tmp1_[12] = (GLfloat) (-1.0f);
	_tmp1_[13] = (GLfloat) 0.0f;
	_tmp1_[14] = (GLfloat) 0.0f;
	_tmp1_[15] = (GLfloat) 0.0f;
	_tmp1_[16] = (GLfloat) 0.707f;
	_tmp1_[17] = (GLfloat) (-0.707f);
	_tmp1_[18] = (GLfloat) 0.707f;
	_tmp1_[19] = (GLfloat) 0.707f;
	_tmp1_[20] = (GLfloat) 0.0f;
	_tmp1_[21] = (GLfloat) 0.0f;
	_tmp1_[22] = (GLfloat) 0.707f;
	_tmp1_[23] = (GLfloat) 0.707f;
	_tmp1_[24] = (GLfloat) (-0.707f);
	_tmp1_[25] = (GLfloat) 0.707f;
	_tmp1_[26] = (GLfloat) 0.0f;
	self->priv->board_normals = (g_free (self->priv->board_normals), NULL);
	self->priv->board_normals = _tmp1_;
	self->priv->board_normals_length1 = 27;
	self->priv->_board_normals_size_ = 27;
	_tmp2_ = g_new0 (GLushort, 60);
	_tmp2_[0] = (GLushort) 0;
	_tmp2_[1] = (GLushort) 1;
	_tmp2_[2] = (GLushort) 5;
	_tmp2_[3] = (GLushort) 4;
	_tmp2_[4] = (GLushort) 0;
	_tmp2_[5] = (GLushort) 1;
	_tmp2_[6] = (GLushort) 2;
	_tmp2_[7] = (GLushort) 6;
	_tmp2_[8] = (GLushort) 5;
	_tmp2_[9] = (GLushort) 0;
	_tmp2_[10] = (GLushort) 2;
	_tmp2_[11] = (GLushort) 3;
	_tmp2_[12] = (GLushort) 7;
	_tmp2_[13] = (GLushort) 6;
	_tmp2_[14] = (GLushort) 0;
	_tmp2_[15] = (GLushort) 3;
	_tmp2_[16] = (GLushort) 0;
	_tmp2_[17] = (GLushort) 4;
	_tmp2_[18] = (GLushort) 7;
	_tmp2_[19] = (GLushort) 0;
	_tmp2_[20] = (GLushort) 4;
	_tmp2_[21] = (GLushort) 5;
	_tmp2_[22] = (GLushort) 9;
	_tmp2_[23] = (GLushort) 8;
	_tmp2_[24] = (GLushort) 5;
	_tmp2_[25] = (GLushort) 5;
	_tmp2_[26] = (GLushort) 6;
	_tmp2_[27] = (GLushort) 10;
	_tmp2_[28] = (GLushort) 9;
	_tmp2_[29] = (GLushort) 6;
	_tmp2_[30] = (GLushort) 6;
	_tmp2_[31] = (GLushort) 7;
	_tmp2_[32] = (GLushort) 11;
	_tmp2_[33] = (GLushort) 10;
	_tmp2_[34] = (GLushort) 7;
	_tmp2_[35] = (GLushort) 7;
	_tmp2_[36] = (GLushort) 4;
	_tmp2_[37] = (GLushort) 8;
	_tmp2_[38] = (GLushort) 11;
	_tmp2_[39] = (GLushort) 8;
	_tmp2_[40] = (GLushort) 8;
	_tmp2_[41] = (GLushort) 9;
	_tmp2_[42] = (GLushort) 13;
	_tmp2_[43] = (GLushort) 12;
	_tmp2_[44] = (GLushort) 1;
	_tmp2_[45] = (GLushort) 9;
	_tmp2_[46] = (GLushort) 10;
	_tmp2_[47] = (GLushort) 14;
	_tmp2_[48] = (GLushort) 13;
	_tmp2_[49] = (GLushort) 2;
	_tmp2_[50] = (GLushort) 10;
	_tmp2_[51] = (GLushort) 11;
	_tmp2_[52] = (GLushort) 15;
	_tmp2_[53] = (GLushort) 14;
	_tmp2_[54] = (GLushort) 3;
	_tmp2_[55] = (GLushort) 11;
	_tmp2_[56] = (GLushort) 8;
	_tmp2_[57] = (GLushort) 12;
	_tmp2_[58] = (GLushort) 15;
	_tmp2_[59] = (GLushort) 4;
	self->priv->board_quads = (g_free (self->priv->board_quads), NULL);
	self->priv->board_quads = _tmp2_;
	self->priv->board_quads_length1 = 60;
	self->priv->_board_quads_size_ = 60;
}


static void chess_view3_d_realize_cb (ChessView3D* self) {
	gint* _tmp0_ = NULL;
	gint* attributes;
	gint attributes_length1;
	gint _attributes_size_;
	GdkWindow* _tmp1_ = NULL;
	Window _tmp2_;
	GdkWindow* _tmp3_ = NULL;
	GdkDisplay* _tmp4_ = NULL;
	Display* _tmp5_ = NULL;
	GdkScreen* _tmp6_ = NULL;
	gint _tmp7_;
	gint screen;
	XVisualInfo* _tmp8_ = NULL;
	XVisualInfo* visual;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gint, 17);
	_tmp0_[0] = GLX_RGBA;
	_tmp0_[1] = GLX_RED_SIZE;
	_tmp0_[2] = 1;
	_tmp0_[3] = GLX_GREEN_SIZE;
	_tmp0_[4] = 1;
	_tmp0_[5] = GLX_BLUE_SIZE;
	_tmp0_[6] = 1;
	_tmp0_[7] = GLX_DOUBLEBUFFER;
	_tmp0_[8] = GLX_DEPTH_SIZE;
	_tmp0_[9] = 1;
	_tmp0_[10] = GLX_ACCUM_RED_SIZE;
	_tmp0_[11] = 1;
	_tmp0_[12] = GLX_ACCUM_GREEN_SIZE;
	_tmp0_[13] = 1;
	_tmp0_[14] = GLX_ACCUM_BLUE_SIZE;
	_tmp0_[15] = 1;
	_tmp0_[16] = 0;
	attributes = _tmp0_;
	attributes_length1 = 17;
	_attributes_size_ = 17;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_x11_window_get_xid (_tmp1_);
	self->priv->drawable = (GLXDrawable) _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp4_ = gdk_window_get_display (_tmp3_);
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
	self->priv->display = _tmp5_;
	_tmp6_ = gtk_widget_get_screen ((GtkWidget*) self);
	_tmp7_ = gdk_x11_screen_get_screen_number (_tmp6_);
	screen = _tmp7_;
	_tmp8_ = glXChooseVisual (self->priv->display, screen, attributes);
	visual = _tmp8_;
	if (visual == NULL) {
		g_warning ("chess-view-3d.vala:167: Failed to get GLX visual on display %p, screen" \
" %d", self->priv->display, screen);
	} else {
		GLXContext _tmp9_;
		GLXContext null_context;
		_tmp9_ = glXCreateContext (self->priv->display, visual, NULL, TRUE);
		self->priv->context = _tmp9_;
		null_context = (GLXContext) NULL;
		if (_context_equal (&self->priv->context, &null_context) == TRUE) {
			g_warning ("chess-view-3d.vala:173: Failed to create GLX context");
		}
	}
	_XFree0 (visual);
	attributes = (g_free (attributes), NULL);
}


static void chess_view3_d_unrealize_cb (ChessView3D* self) {
	GLXContext null_context;
	GLXDrawable _tmp0_;
	g_return_if_fail (self != NULL);
	null_context = (GLXContext) NULL;
	if (_context_equal (&self->priv->context, &null_context) == TRUE) {
		return;
	}
	_tmp0_ = glXGetCurrentDrawable ();
	if (self->priv->drawable == _tmp0_) {
		glXWaitGL ();
		glXMakeCurrent (self->priv->display, (GLXDrawable) None, (GLXContext) NULL);
	}
	glXDestroyContext (self->priv->display, self->priv->context);
}


static gboolean chess_view3_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView3D * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint short_edge;
	gdouble _tmp3_;
	gboolean _tmp4_;
	self = (ChessView3D*) base;
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	short_edge = _tmp2_;
	_tmp3_ = floor ((short_edge - (2 * self->priv->border)) / 9.0);
	self->priv->square_size = (gint) _tmp3_;
	_tmp4_ = chess_view3_d_start_gl (self);
	if (_tmp4_) {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp6_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		glViewport ((GLint) 0, (GLint) 0, (GLsizei) _tmp5_, (GLsizei) _tmp6_);
	}
	result = TRUE;
	return result;
}


static void chess_view3_d_accFrustum (ChessView3D* self, GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus) {
	GLfloat xwsize;
	GLfloat ywsize;
	gint _tmp0_;
	GLfloat dx;
	gint _tmp1_;
	GLfloat dy;
	g_return_if_fail (self != NULL);
	xwsize = right - left;
	ywsize = top - bottom;
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	dx = -(((pixdx * xwsize) / _tmp0_) + ((eyedx * near) / focus));
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	dy = -(((pixdy * ywsize) / _tmp1_) + ((eyedy * near) / focus));
	glFrustum ((GLdouble) (left + dx), (GLdouble) (right + dx), (GLdouble) (bottom + dy), (GLdouble) (top + dy), (GLdouble) near, (GLdouble) far);
	glTranslatef (-eyedx, -eyedy, (GLfloat) 0.0f);
}


static void chess_view3_d_accPerspective (ChessView3D* self, GLfloat fovy, GLfloat aspect, GLfloat near, GLfloat far, GLfloat pixdx, GLfloat pixdy, GLfloat eyedx, GLfloat eyedy, GLfloat focus) {
	GLfloat fov2;
	gdouble _tmp0_;
	gdouble _tmp1_;
	GLfloat top;
	GLfloat bottom;
	GLfloat right;
	GLfloat left;
	g_return_if_fail (self != NULL);
	fov2 = ((fovy * ((GLfloat) G_PI)) / 180.0f) / 2.0f;
	_tmp0_ = cos ((gdouble) fov2);
	_tmp1_ = sin ((gdouble) fov2);
	top = near / (((GLfloat) _tmp0_) / ((GLfloat) _tmp1_));
	bottom = -top;
	right = top * aspect;
	left = -right;
	chess_view3_d_accFrustum (self, left, right, bottom, top, near, far, pixdx, pixdy, eyedx, eyedy, focus);
}


static gboolean chess_view3_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView3D * self;
	gboolean result = FALSE;
	GLfloat* _tmp0_ = NULL;
	GLfloat* jitters;
	gint jitters_length1;
	gint _jitters_size_;
	gboolean _tmp1_;
	gint n_passes;
	ChessScene* _tmp2_ = NULL;
	gboolean _tmp3_;
	ChessScene* _tmp18_ = NULL;
	gboolean _tmp19_;
	self = (ChessView3D*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = g_new0 (GLfloat, 6);
	_tmp0_[0] = (GLfloat) 0.0033922635f;
	_tmp0_[1] = (GLfloat) 0.3317967229f;
	_tmp0_[2] = (GLfloat) 0.2806016275f;
	_tmp0_[3] = (GLfloat) (-0.2495619123f);
	_tmp0_[4] = (GLfloat) (-0.273817106f);
	_tmp0_[5] = (GLfloat) (-0.086844639f);
	jitters = _tmp0_;
	jitters_length1 = 6;
	_jitters_size_ = 6;
	_tmp1_ = chess_view3_d_start_gl (self);
	if (!_tmp1_) {
		result = TRUE;
		jitters = (g_free (jitters), NULL);
		return result;
	}
	n_passes = 1;
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
	_tmp3_ = chess_scene_get_show_3d_smooth (_tmp2_);
	if (_tmp3_) {
		glClear ((GLbitfield) GL_ACCUM_BUFFER_BIT);
		n_passes = 3;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				GtkStyle* _tmp5_ = NULL;
				GtkStateType _tmp6_;
				GdkColor bg;
				ChessScene* _tmp7_ = NULL;
				gboolean _tmp8_;
				GLfloat* _tmp13_ = NULL;
				GLfloat* pos;
				gint pos_length1;
				gint _pos_size_;
				ChessScene* _tmp14_ = NULL;
				gdouble _tmp15_;
				ChessScene* _tmp16_ = NULL;
				gboolean _tmp17_;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < n_passes)) {
					break;
				}
				_tmp5_ = gtk_widget_get_style ((GtkWidget*) self);
				_tmp6_ = gtk_widget_get_state ((GtkWidget*) self);
				bg = _tmp5_->bg[_tmp6_];
				glClearColor ((GLclampf) (bg.red / 65535.0f), (GLclampf) (bg.green / 65535.0f), (GLclampf) (bg.blue / 65535.0f), (GLclampf) 1.0f);
				glClear ((GLbitfield) (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT));
				glEnable (GL_DEPTH_TEST);
				glMatrixMode (GL_PROJECTION);
				glLoadIdentity ();
				_tmp7_ = chess_view_get_scene ((ChessView*) self);
				_tmp8_ = chess_scene_get_show_3d_smooth (_tmp7_);
				if (_tmp8_) {
					gint _tmp9_;
					gint _tmp10_;
					_tmp9_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
					_tmp10_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
					chess_view3_d_accPerspective (self, (GLfloat) 60.0f, (GLfloat) (((gfloat) _tmp9_) / _tmp10_), (GLfloat) 0.1f, (GLfloat) 1000, jitters[i * 2], jitters[(i * 2) + 1], (GLfloat) 0, (GLfloat) 0, (GLfloat) 1);
				} else {
					gint _tmp11_;
					gint _tmp12_;
					_tmp11_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
					_tmp12_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
					gluPerspective ((GLdouble) 60.0f, (GLdouble) (((gfloat) _tmp11_) / _tmp12_), (GLdouble) 0.1f, (GLdouble) 1000);
				}
				glMatrixMode (GL_MODELVIEW);
				chess_view3_d_transform_camera (self);
				_tmp13_ = g_new0 (GLfloat, 4);
				_tmp13_[0] = (GLfloat) 100.0f;
				_tmp13_[1] = (GLfloat) 100.0f;
				_tmp13_[2] = (GLfloat) 100.0f;
				_tmp13_[3] = (GLfloat) 1.0f;
				pos = _tmp13_;
				pos_length1 = 4;
				_pos_size_ = 4;
				glLightfv (GL_LIGHT0, GL_POSITION, pos);
				glEnable (GL_LIGHTING);
				glEnable (GL_LIGHT0);
				glPushMatrix ();
				_tmp14_ = chess_view_get_scene ((ChessView*) self);
				_tmp15_ = chess_scene_get_board_angle (_tmp14_);
				glRotatef ((GLfloat) _tmp15_, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
				glTranslatef (-self->priv->OFFSET, (GLfloat) 0.0f, self->priv->OFFSET);
				chess_view3_d_draw_board (self);
				chess_view3_d_draw_numbering (self);
				chess_view3_d_draw_pieces (self);
				glPopMatrix ();
				_tmp16_ = chess_view_get_scene ((ChessView*) self);
				_tmp17_ = chess_scene_get_show_3d_smooth (_tmp16_);
				if (_tmp17_) {
					glAccum (GL_ACCUM, (GLfloat) (1.0f / n_passes));
				}
				pos = (g_free (pos), NULL);
			}
		}
	}
	_tmp18_ = chess_view_get_scene ((ChessView*) self);
	_tmp19_ = chess_scene_get_show_3d_smooth (_tmp18_);
	if (_tmp19_) {
		glAccum (GL_RETURN, (GLfloat) 1);
	}
	glXSwapBuffers (self->priv->display, self->priv->drawable);
	result = TRUE;
	jitters = (g_free (jitters), NULL);
	return result;
}


static void chess_view3_d_draw_board (ChessView3D* self) {
	GLuint _tmp1_;
	g_return_if_fail (self != NULL);
	glEnable (GL_COLOR_MATERIAL);
	glColor3f ((GLfloat) (0x2e / 255.f), (GLfloat) (0x34 / 255.f), (GLfloat) (0x36 / 255.f));
	glBegin (GL_QUADS);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint j;
				if (!_tmp0_) {
					i = i + 5;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->board_quads_length1)) {
					break;
				}
				j = self->priv->board_quads[i + 4] * 3;
				glNormal3f (self->priv->board_normals[j], self->priv->board_normals[j + 1], self->priv->board_normals[j + 2]);
				j = self->priv->board_quads[i] * 3;
				glVertex3f (self->priv->board_vertices[j], self->priv->board_vertices[j + 1], self->priv->board_vertices[j + 2]);
				j = self->priv->board_quads[i + 1] * 3;
				glVertex3f (self->priv->board_vertices[j], self->priv->board_vertices[j + 1], self->priv->board_vertices[j + 2]);
				j = self->priv->board_quads[i + 2] * 3;
				glVertex3f (self->priv->board_vertices[j], self->priv->board_vertices[j + 1], self->priv->board_vertices[j + 2]);
				j = self->priv->board_quads[i + 3] * 3;
				glVertex3f (self->priv->board_vertices[j], self->priv->board_vertices[j + 1], self->priv->board_vertices[j + 2]);
			}
		}
	}
	glEnd ();
	glEnable (GL_TEXTURE_2D);
	_tmp1_ = chess_view3_d_get_board_texture (self);
	glBindTexture (GL_TEXTURE_2D, _tmp1_);
	glNormal3f ((GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					rank++;
				}
				_tmp2_ = FALSE;
				if (!(rank < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp3_;
						_tmp3_ = TRUE;
						while (TRUE) {
							GLfloat x0;
							GLfloat x1;
							GLfloat z0;
							GLfloat z1;
							if (!_tmp3_) {
								file++;
							}
							_tmp3_ = FALSE;
							if (!(file < 8)) {
								break;
							}
							if (((file + rank) % 2) == 0) {
								glColor3f ((GLfloat) (0xee / 255.f), (GLfloat) (0xee / 255.f), (GLfloat) (0xec / 255.f));
							} else {
								glColor3f ((GLfloat) (0xba / 255.f), (GLfloat) (0xbd / 255.f), (GLfloat) (0xb6 / 255.f));
							}
							glBegin (GL_QUADS);
							x0 = self->priv->BOARD_BORDER + (file * self->priv->SQUARE_WIDTH);
							x1 = x0 + self->priv->SQUARE_WIDTH;
							z0 = self->priv->BOARD_BORDER + (rank * self->priv->SQUARE_WIDTH);
							z1 = z0 + self->priv->SQUARE_WIDTH;
							glTexCoord2f ((GLfloat) 0.0f, (GLfloat) 0.0f);
							glVertex3f (x0, (GLfloat) 0.0f, -z0);
							glTexCoord2f ((GLfloat) 1.0f, (GLfloat) 0.0f);
							glVertex3f (x1, (GLfloat) 0.0f, -z0);
							glTexCoord2f ((GLfloat) 1.0f, (GLfloat) 1.0f);
							glVertex3f (x1, (GLfloat) 0.0f, -z1);
							glTexCoord2f ((GLfloat) 0.0f, (GLfloat) 1.0f);
							glVertex3f (x0, (GLfloat) 0.0f, -z1);
							glEnd ();
						}
					}
				}
			}
		}
	}
	glDisable (GL_TEXTURE_2D);
	glDisable (GL_COLOR_MATERIAL);
}


static void chess_view3_d_draw_numbering (ChessView3D* self) {
	GLfloat text_width;
	GLfloat text_offset;
	GLfloat offset;
	GLfloat white_z_offset;
	GLfloat black_z_offset;
	GLfloat left_offset;
	GLfloat right_offset;
	GLuint _tmp0_;
	g_return_if_fail (self != NULL);
	text_width = self->priv->BOARD_BORDER * 0.8f;
	text_offset = (self->priv->BOARD_BORDER + self->priv->BOARD_CHAMFER) * 0.5f;
	offset = self->priv->BOARD_BORDER + (self->priv->SQUARE_WIDTH * 0.5f);
	white_z_offset = -text_offset;
	black_z_offset = (-self->priv->BOARD_OUTER_WIDTH) + text_offset;
	left_offset = text_offset;
	right_offset = self->priv->BOARD_OUTER_WIDTH - text_offset;
	glDisable (GL_DEPTH_TEST);
	glEnable (GL_TEXTURE_2D);
	glEnable (GL_COLOR_MATERIAL);
	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	_tmp0_ = chess_view3_d_get_numbering_texture (self);
	glBindTexture (GL_TEXTURE_2D, _tmp0_);
	glColor3f ((GLfloat) 1, (GLfloat) 1, (GLfloat) 1);
	glNormal3f ((GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				chess_view3_d_draw_label (self, left_offset, -offset, text_width, i + 8);
				chess_view3_d_draw_label (self, right_offset, -offset, text_width, i + 8);
				chess_view3_d_draw_label (self, offset, white_z_offset, text_width, i);
				chess_view3_d_draw_label (self, offset, black_z_offset, text_width, i);
				offset = offset + self->priv->SQUARE_WIDTH;
			}
		}
	}
	glDisable (GL_BLEND);
	glDisable (GL_COLOR_MATERIAL);
	glDisable (GL_TEXTURE_2D);
}


static void chess_view3_d_draw_label (ChessView3D* self, GLfloat x, GLfloat z, GLfloat width, gint cell) {
	GLfloat w;
	GLfloat l;
	g_return_if_fail (self != NULL);
	w = (GLfloat) (1.0f / 16);
	l = (GLfloat) (cell / 16.0f);
	glPushMatrix ();
	glTranslatef (x, (GLfloat) 0.0f, z);
	glBegin (GL_QUADS);
	glTexCoord2f (l, (GLfloat) 0.0f);
	glVertex3f ((-width) / 2, (GLfloat) 0.0f, (-width) / 2);
	glTexCoord2f (l, (GLfloat) 1.0f);
	glVertex3f ((-width) / 2, (GLfloat) 0.0f, width / 2);
	glTexCoord2f (l + w, (GLfloat) 1.0f);
	glVertex3f (width / 2, (GLfloat) 0.0f, width / 2);
	glTexCoord2f (l + w, (GLfloat) 0.0f);
	glVertex3f (width / 2, (GLfloat) 0.0f, (-width) / 2);
	glEnd ();
	glPopMatrix ();
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static void chess_view3_d_draw_pieces (ChessView3D* self) {
	ChessScene* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
	GLuint _tmp2_;
	ChessScene* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_view_get_scene ((ChessView*) self);
	_tmp1_ = chess_scene_get_game (_tmp0_);
	if (_tmp1_ == NULL) {
		return;
	}
	glEnable (GL_DEPTH_TEST);
	glEnable (GL_TEXTURE_2D);
	_tmp2_ = chess_view3_d_get_piece_texture (self);
	glBindTexture (GL_TEXTURE_2D, _tmp2_);
	_tmp3_ = chess_view_get_scene ((ChessView*) self);
	{
		GList* model_collection;
		GList* model_it;
		model_collection = _tmp3_->pieces;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp4_;
			ChessModel* model;
			_tmp4_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp4_;
			{
				glPushMatrix ();
				glTranslatef ((self->priv->BOARD_BORDER + (((GLfloat) model->x) * self->priv->SQUARE_WIDTH)) + (self->priv->SQUARE_WIDTH / 2), (GLfloat) 0.0f, -((self->priv->BOARD_BORDER + (((GLfloat) model->y) * self->priv->SQUARE_WIDTH)) + (self->priv->SQUARE_WIDTH / 2)));
				if (model->is_selected) {
					glTranslatef ((GLfloat) 0.0f, self->priv->SQUARE_WIDTH * 0.4f, (GLfloat) 0.0f);
				}
				chess_view3_d_render_piece (self, model->piece, (GLfloat) 1.0f);
				glPopMatrix ();
				_chess_model_unref0 (model);
			}
		}
	}
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				if (!_tmp5_) {
					rank++;
				}
				_tmp5_ = FALSE;
				if (!(rank < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_ = FALSE;
							ChessScene* _tmp8_ = NULL;
							gboolean _tmp9_;
							if (!_tmp6_) {
								file++;
							}
							_tmp6_ = FALSE;
							if (!(file < 8)) {
								break;
							}
							_tmp8_ = chess_view_get_scene ((ChessView*) self);
							_tmp9_ = chess_scene_get_show_move_hints (_tmp8_);
							if (_tmp9_) {
								ChessScene* _tmp10_ = NULL;
								gboolean _tmp11_;
								_tmp10_ = chess_view_get_scene ((ChessView*) self);
								_tmp11_ = chess_scene_can_move (_tmp10_, rank, file);
								_tmp7_ = _tmp11_;
							} else {
								_tmp7_ = FALSE;
							}
							if (_tmp7_) {
								ChessScene* _tmp12_ = NULL;
								ChessPiece* _tmp13_ = NULL;
								ChessPiece* _tmp14_;
								glPushMatrix ();
								glTranslatef ((self->priv->BOARD_BORDER + (file * self->priv->SQUARE_WIDTH)) + (self->priv->SQUARE_WIDTH / 2), (GLfloat) 0.0f, -((self->priv->BOARD_BORDER + (rank * self->priv->SQUARE_WIDTH)) + (self->priv->SQUARE_WIDTH / 2)));
								glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
								glEnable (GL_BLEND);
								glDisable (GL_DEPTH_TEST);
								_tmp12_ = chess_view_get_scene ((ChessView*) self);
								_tmp13_ = chess_scene_get_selected_piece (_tmp12_);
								_tmp14_ = _tmp13_;
								chess_view3_d_render_piece (self, _tmp14_, (GLfloat) 0.1f);
								_chess_piece_unref0 (_tmp14_);
								glEnable (GL_DEPTH_TEST);
								glDisable (GL_BLEND);
								glPopMatrix ();
							}
						}
					}
				}
			}
		}
	}
	glDisable (GL_TEXTURE_2D);
}


static void chess_view3_d_render_piece (ChessView3D* self, ChessPiece* piece, GLfloat alpha) {
	static const GLfloat black[] = {(GLfloat) 0.0f, (GLfloat) 0.0f, (GLfloat) 0.0f, (GLfloat) 0.0f};
	g_return_if_fail (self != NULL);
	g_return_if_fail (piece != NULL);
	self->priv->white_piece_color[3] = alpha;
	self->priv->black_piece_color[3] = alpha;
	if (piece->player->color == COLOR_WHITE) {
		glMaterialfv (GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, self->priv->white_piece_color);
		glMaterialfv (GL_FRONT_AND_BACK, GL_SPECULAR, self->priv->white_piece_specular);
	} else {
		glMaterialfv (GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, self->priv->black_piece_color);
		glMaterialfv (GL_FRONT_AND_BACK, GL_SPECULAR, self->priv->black_piece_specular);
	}
	glMaterialfv (GL_FRONT_AND_BACK, GL_EMISSION, black);
	glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, (GLfloat) 64.0f);
	if (piece->player->color == COLOR_BLACK) {
		glRotatef ((GLfloat) 180.0f, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	}
	switch (piece->type) {
		case PIECE_TYPE_PAWN:
		{
			tds_model_render (self->priv->pawn_model);
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			tds_model_render (self->priv->rook_model);
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			tds_model_render (self->priv->knight_model);
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			tds_model_render (self->priv->bishop_model);
			break;
		}
		case PIECE_TYPE_QUEEN:
		{
			tds_model_render (self->priv->queen_model);
			break;
		}
		case PIECE_TYPE_KING:
		{
			tds_model_render (self->priv->king_model);
			break;
		}
		default:
		break;
	}
}


static gboolean chess_view3_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView3D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp3_;
	GLuint buffer[20] = {0};
	gint _tmp4_;
	gint _tmp5_;
	GLint* _tmp6_ = NULL;
	GLint* viewport;
	gint viewport_length1;
	gint _viewport_size_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	ChessScene* _tmp10_ = NULL;
	gdouble _tmp11_;
	GLint _tmp14_;
	GLint n_hits;
	self = (ChessView3D*) base;
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = chess_scene_get_game (_tmp1_);
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*event).button != 1;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = chess_view3_d_start_gl (self);
	if (!_tmp3_) {
		result = TRUE;
		return result;
	}
	glSelectBuffer ((GLsizei) 20, buffer);
	glRenderMode (GL_SELECT);
	glInitNames ();
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	_tmp4_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp5_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp6_ = g_new0 (GLint, 4);
	_tmp6_[0] = (GLint) 0;
	_tmp6_[1] = (GLint) 0;
	_tmp6_[2] = (GLint) _tmp4_;
	_tmp6_[3] = (GLint) _tmp5_;
	viewport = _tmp6_;
	viewport_length1 = 4;
	_viewport_size_ = 4;
	_tmp7_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	gluPickMatrix ((GLdouble) (*event).x, (GLdouble) (((gfloat) _tmp7_) - (*event).y), (GLdouble) 1.0, (GLdouble) 1.0, viewport);
	_tmp8_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp9_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	gluPerspective ((GLdouble) 60.0, (GLdouble) (((gfloat) _tmp8_) / ((gfloat) _tmp9_)), (GLdouble) 0, (GLdouble) 1);
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	chess_view3_d_transform_camera (self);
	_tmp10_ = chess_view_get_scene ((ChessView*) self);
	_tmp11_ = chess_scene_get_board_angle (_tmp10_);
	glRotatef ((GLfloat) _tmp11_, (GLfloat) 0.0f, (GLfloat) 1.0f, (GLfloat) 0.0f);
	glTranslatef (-self->priv->OFFSET, (GLfloat) 0.0f, self->priv->OFFSET);
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				if (!_tmp12_) {
					rank++;
				}
				_tmp12_ = FALSE;
				if (!(rank < 8)) {
					break;
				}
				glPushName ((GLuint) rank);
				{
					gint file;
					file = 0;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							GLfloat x0;
							GLfloat x1;
							GLfloat z0;
							GLfloat z1;
							if (!_tmp13_) {
								file++;
							}
							_tmp13_ = FALSE;
							if (!(file < 8)) {
								break;
							}
							glPushName ((GLuint) file);
							glBegin (GL_QUADS);
							x0 = self->priv->BOARD_BORDER + (file * self->priv->SQUARE_WIDTH);
							x1 = x0 + self->priv->SQUARE_WIDTH;
							z0 = self->priv->BOARD_BORDER + (rank * self->priv->SQUARE_WIDTH);
							z1 = z0 + self->priv->SQUARE_WIDTH;
							glVertex3f (x0, (GLfloat) 0.0f, -z0);
							glVertex3f (x1, (GLfloat) 0.0f, -z0);
							glVertex3f (x1, (GLfloat) 0.0f, -z1);
							glVertex3f (x0, (GLfloat) 0.0f, -z1);
							glEnd ();
							glPopName ();
						}
					}
				}
				glPopName ();
			}
		}
	}
	glFlush ();
	_tmp14_ = glRenderMode (GL_RENDER);
	n_hits = _tmp14_;
	if (n_hits > 0) {
		GLuint rank;
		GLuint file;
		ChessScene* _tmp15_ = NULL;
		rank = buffer[3];
		file = buffer[4];
		_tmp15_ = chess_view_get_scene ((ChessView*) self);
		chess_scene_select_square (_tmp15_, (gint) file, (gint) rank);
	}
	result = TRUE;
	viewport = (g_free (viewport), NULL);
	return result;
}


static void chess_view3_d_transform_camera (ChessView3D* self) {
	g_return_if_fail (self != NULL);
	glLoadIdentity ();
	gluLookAt ((GLdouble) 0.0, (GLdouble) 80.0, (GLdouble) 40.0, (GLdouble) 0.0, (GLdouble) 0.0, (GLdouble) 5.0, (GLdouble) 0.0, (GLdouble) 1.0, (GLdouble) 0.0);
}


static GLuint chess_view3_d_load_texture (ChessView3D* self, const gchar* filename) {
	GLuint result = 0U;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GLenum format = 0U;
	gint _tmp2_;
	GLuint textures[1] = {0};
	GLuint t;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	void* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (filename != NULL, 0U);
	_tmp0_ = gdk_pixbuf_new_from_file (filename, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch14_g_error;
	}
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp1_;
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("chess-view-3d.vala:579: Error loading texture %s: %s", filename, e->message);
		result = (GLuint) 0;
		_g_error_free0 (e);
		_g_object_unref0 (pixbuf);
		return result;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	_tmp2_ = gdk_pixbuf_get_n_channels (pixbuf);
	if (_tmp2_ == 1) {
		format = GL_LUMINANCE;
	} else {
		gint _tmp3_;
		_tmp3_ = gdk_pixbuf_get_n_channels (pixbuf);
		if (_tmp3_ == 3) {
			format = GL_RGB;
		} else {
			gint _tmp4_;
			_tmp4_ = gdk_pixbuf_get_n_channels (pixbuf);
			if (_tmp4_ == 4) {
				format = GL_RGBA;
			} else {
				g_warning ("chess-view-3d.vala:592: Unknown format image");
				result = (GLuint) 0;
				_g_object_unref0 (pixbuf);
				return result;
			}
		}
	}
	glGenTextures ((GLsizei) 1, textures);
	t = textures[0];
	glBindTexture (GL_TEXTURE_2D, t);
	glPixelStorei (GL_UNPACK_ALIGNMENT, (GLint) 1);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (GLint) GL_LINEAR);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (GLint) GL_LINEAR);
	_tmp5_ = gdk_pixbuf_get_n_channels (pixbuf);
	_tmp6_ = gdk_pixbuf_get_width (pixbuf);
	_tmp7_ = gdk_pixbuf_get_height (pixbuf);
	_tmp8_ = gdk_pixbuf_get_pixels (pixbuf);
	gluBuild2DMipmaps (GL_TEXTURE_2D, (GLint) _tmp5_, (GLsizei) _tmp6_, (GLsizei) _tmp7_, format, GL_UNSIGNED_BYTE, _tmp8_);
	result = t;
	_g_object_unref0 (pixbuf);
	return result;
}


static GLuint chess_view3_d_make_numbering_texture (ChessView3D* self) {
	GLuint result = 0U;
	gint width;
	gint height;
	gint texture_width;
	gint texture_height;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* surface;
	cairo_t* _tmp1_ = NULL;
	cairo_t* c;
	cairo_font_extents_t extents = {0};
	cairo_font_extents_t _tmp2_ = {0};
	gdouble scale;
	gdouble yoffset;
	gdouble xoffset;
	GLuint textures[1] = {0};
	GLuint t;
	guchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	width = 64;
	height = 64;
	texture_width = width * 16;
	texture_height = height;
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_A8, texture_width, texture_height);
	surface = _tmp0_;
	_tmp1_ = cairo_create (surface);
	c = _tmp1_;
	cairo_set_source_rgba (c, 1.0, 1.0, 1.0, 1.0);
	cairo_select_font_face (c, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (c, (gdouble) width);
	cairo_font_extents (c, &_tmp2_);
	extents = _tmp2_;
	scale = width / (extents.ascent + extents.descent);
	yoffset = height * 0.5;
	xoffset = width * 0.5;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* _tmp4_ = NULL;
				gchar* f;
				gchar* _tmp5_ = NULL;
				gchar* r;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				_tmp4_ = g_strdup_printf ("%c", 'a' + i);
				f = _tmp4_;
				_tmp5_ = g_strdup_printf ("%c", '1' + i);
				r = _tmp5_;
				chess_view3_d_draw_centered_text (self, c, xoffset, yoffset, scale, f);
				chess_view3_d_draw_centered_text (self, c, xoffset + (width * 8), yoffset, scale, r);
				xoffset = xoffset + ((gdouble) width);
				_g_free0 (r);
				_g_free0 (f);
			}
		}
	}
	glGenTextures ((GLsizei) 1, textures);
	t = textures[0];
	glBindTexture (GL_TEXTURE_2D, t);
	glPixelStorei (GL_UNPACK_ALIGNMENT, (GLint) 1);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, (GLint) GL_REPEAT);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (GLint) GL_LINEAR);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (GLint) GL_LINEAR);
	_tmp6_ = cairo_image_surface_get_data (surface);
	gluBuild2DMipmaps (GL_TEXTURE_2D, (GLint) GL_ALPHA, (GLsizei) texture_width, (GLsizei) texture_height, GL_ALPHA, GL_UNSIGNED_BYTE, _tmp6_);
	result = t;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


static void chess_view3_d_draw_centered_text (ChessView3D* self, cairo_t* c, gdouble x, gdouble y, gdouble scale, const gchar* text) {
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (text != NULL);
	cairo_text_extents (c, text, &_tmp0_);
	extents = _tmp0_;
	cairo_save (c);
	cairo_translate (c, x, y);
	cairo_move_to (c, ((-extents.width) * scale) / 2, (extents.height * scale) / 2);
	cairo_scale (c, scale, scale);
	cairo_show_text (c, text);
	cairo_restore (c);
}


static GLuint chess_view3_d_get_board_texture (ChessView3D* self) {
	GLuint result;
	g_return_val_if_fail (self != NULL, 0U);
	if (self->priv->_board_texture == 0) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GLuint _tmp2_;
		_tmp0_ = g_build_filename (PKGDATADIR, "textures", "board.png", NULL, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = chess_view3_d_load_texture (self, _tmp1_);
		self->priv->_board_texture = _tmp2_;
		_g_free0 (_tmp1_);
	}
	result = self->priv->_board_texture;
	return result;
}


static GLuint chess_view3_d_get_numbering_texture (ChessView3D* self) {
	GLuint result;
	g_return_val_if_fail (self != NULL, 0U);
	if (self->priv->_numbering_texture == 0) {
		GLuint _tmp0_;
		_tmp0_ = chess_view3_d_make_numbering_texture (self);
		self->priv->_numbering_texture = _tmp0_;
	}
	result = self->priv->_numbering_texture;
	return result;
}


static GLuint chess_view3_d_get_piece_texture (ChessView3D* self) {
	GLuint result;
	g_return_val_if_fail (self != NULL, 0U);
	if (self->priv->_piece_texture == 0) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GLuint _tmp2_;
		_tmp0_ = g_build_filename (PKGDATADIR, "textures", "piece.png", NULL, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = chess_view3_d_load_texture (self, _tmp1_);
		self->priv->_piece_texture = _tmp2_;
		_g_free0 (_tmp1_);
	}
	result = self->priv->_piece_texture;
	return result;
}


static void chess_view3_d_class_init (ChessView3DClass * klass) {
	chess_view3_d_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessView3DPrivate));
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view3_d_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = chess_view3_d_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view3_d_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view3_d_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view3_d_finalize;
}


static void chess_view3_d_instance_init (ChessView3D * self) {
	self->priv = CHESS_VIEW3_D_GET_PRIVATE (self);
	self->priv->context = (GLXContext) NULL;
	self->priv->border = 6;
	self->priv->_board_texture = (GLuint) 0;
	self->priv->_numbering_texture = (GLuint) 0;
	self->priv->_piece_texture = (GLuint) 0;
}


static void chess_view3_d_finalize (GObject* obj) {
	ChessView3D * self;
	self = CHESS_VIEW3_D (obj);
	_tds_model_unref0 (self->priv->pawn_model);
	_tds_model_unref0 (self->priv->knight_model);
	_tds_model_unref0 (self->priv->bishop_model);
	_tds_model_unref0 (self->priv->rook_model);
	_tds_model_unref0 (self->priv->queen_model);
	_tds_model_unref0 (self->priv->king_model);
	self->priv->board_vertices = (g_free (self->priv->board_vertices), NULL);
	self->priv->board_normals = (g_free (self->priv->board_normals), NULL);
	self->priv->board_quads = (g_free (self->priv->board_quads), NULL);
	G_OBJECT_CLASS (chess_view3_d_parent_class)->finalize (obj);
}


GType chess_view3_d_get_type (void) {
	static volatile gsize chess_view3_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view3_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView3DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view3_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView3D), 0, (GInstanceInitFunc) chess_view3_d_instance_init, NULL };
		GType chess_view3_d_type_id;
		chess_view3_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView3D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view3_d_type_id__volatile, chess_view3_d_type_id);
	}
	return chess_view3_d_type_id__volatile;
}


static void _vala_chess_view3_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView3D * self;
	self = CHESS_VIEW3_D (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



