/* chess-view-2d.c generated by valac 0.11.6, the Vala compiler
 * generated from chess-view-2d.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <config.h>
#include <stdio.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessView2DPrivate ChessView2DPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView2D {
	ChessView parent_instance;
	ChessView2DPrivate * priv;
};

struct _ChessView2DClass {
	ChessViewClass parent_class;
};

struct _ChessView2DPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};


static gpointer chess_view2_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view2_d_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW2_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW2_D, ChessView2DPrivate))
enum  {
	CHESS_VIEW2_D_DUMMY_PROPERTY
};
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view2_d_load_theme (ChessView2D* self);
static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view2_d_get_border_size (ChessView2D* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
const gchar* chess_scene_get_board_side (ChessScene* self);
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view2_d_finalize (GObject* obj);
static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView2D* chess_view2_d_construct (GType object_type) {
	ChessView2D * self = NULL;
	self = (ChessView2D*) chess_view_construct (object_type);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	return self;
}


ChessView2D* chess_view2_d_new (void) {
	return chess_view2_d_construct (TYPE_CHESS_VIEW2_D);
}


static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint short_edge;
	gdouble _tmp3_;
	gdouble extra;
	self = (ChessView2D*) base;
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	short_edge = _tmp2_;
	_tmp3_ = floor ((short_edge - (2 * self->priv->border)) / 9.0);
	self->priv->square_size = (gint) _tmp3_;
	extra = self->priv->square_size * 0.1;
	if (extra < 3) {
		extra = (gdouble) 3;
	}
	self->priv->selected_square_size = self->priv->square_size + (2 * ((gint) (extra + 0.5)));
	result = TRUE;
	return result;
}


static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	ChessScene* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RsvgHandle* _tmp5_ = NULL;
	RsvgHandle* _tmp6_;
	RsvgHandle* _tmp7_;
	RsvgHandle* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c1 != NULL);
	g_return_if_fail (c2 != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = chess_view_get_scene ((ChessView*) self);
	_tmp1_ = chess_scene_get_theme_name (_tmp0_);
	_tmp2_ = g_strconcat (name, ".svg", NULL);
	_tmp3_ = g_build_filename (PKGDATADIR, "pieces", _tmp1_, _tmp2_, NULL, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rsvg_handle_new_from_file (_tmp4_, &_inner_error_);
	_tmp7_ = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	_tmp8_ = _tmp7_;
	_g_object_unref0 (handle);
	handle = _tmp8_;
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Failed to load piece svg: %s", e->message);
		_g_error_free0 (e);
		_g_object_unref0 (handle);
		return;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (handle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	cairo_save (c1);
	cairo_translate (c1, (gdouble) (self->priv->square_size * offset), (gdouble) 0);
	cairo_scale (c1, ((gdouble) self->priv->square_size) / (g_object_get (handle, "width", &_tmp9_, NULL), _tmp9_), ((gdouble) self->priv->square_size) / (g_object_get (handle, "height", &_tmp10_, NULL), _tmp10_));
	rsvg_handle_render_cairo (handle, c1);
	cairo_restore (c1);
	cairo_save (c2);
	cairo_translate (c2, (gdouble) (self->priv->selected_square_size * offset), (gdouble) 0);
	cairo_scale (c2, ((gdouble) self->priv->selected_square_size) / (g_object_get (handle, "width", &_tmp11_, NULL), _tmp11_), ((gdouble) self->priv->selected_square_size) / (g_object_get (handle, "height", &_tmp12_, NULL), _tmp12_));
	rsvg_handle_render_cairo (handle, c2);
	cairo_restore (c2);
	_g_object_unref0 (handle);
}


static void chess_view2_d_load_theme (ChessView2D* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_ = NULL;
	cairo_surface_t* _tmp8_;
	cairo_t* _tmp9_ = NULL;
	cairo_t* c1;
	cairo_t* _tmp10_ = NULL;
	cairo_t* c2;
	ChessScene* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
	_tmp3_ = chess_scene_get_theme_name (_tmp2_);
	if (g_strcmp0 (_tmp3_, self->priv->loaded_theme_name) == 0) {
		_tmp1_ = self->priv->model_surface != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp4_;
		_tmp4_ = cairo_image_surface_get_height (self->priv->model_surface);
		_tmp0_ = self->priv->square_size == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * self->priv->square_size, self->priv->square_size);
	_tmp6_ = _tmp5_;
	_cairo_surface_destroy0 (self->priv->model_surface);
	self->priv->model_surface = _tmp6_;
	_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * self->priv->selected_square_size, self->priv->selected_square_size);
	_tmp8_ = _tmp7_;
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	self->priv->selected_model_surface = _tmp8_;
	_tmp9_ = cairo_create (self->priv->model_surface);
	c1 = _tmp9_;
	_tmp10_ = cairo_create (self->priv->selected_model_surface);
	c2 = _tmp10_;
	chess_view2_d_render_piece (self, c1, c2, "whitePawn", 0);
	chess_view2_d_render_piece (self, c1, c2, "whiteRook", 1);
	chess_view2_d_render_piece (self, c1, c2, "whiteKnight", 2);
	chess_view2_d_render_piece (self, c1, c2, "whiteBishop", 3);
	chess_view2_d_render_piece (self, c1, c2, "whiteQueen", 4);
	chess_view2_d_render_piece (self, c1, c2, "whiteKing", 5);
	chess_view2_d_render_piece (self, c1, c2, "blackPawn", 6);
	chess_view2_d_render_piece (self, c1, c2, "blackRook", 7);
	chess_view2_d_render_piece (self, c1, c2, "blackKnight", 8);
	chess_view2_d_render_piece (self, c1, c2, "blackBishop", 9);
	chess_view2_d_render_piece (self, c1, c2, "blackQueen", 10);
	chess_view2_d_render_piece (self, c1, c2, "blackKing", 11);
	_tmp11_ = chess_view_get_scene ((ChessView*) self);
	_tmp12_ = chess_scene_get_theme_name (_tmp11_);
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (self->priv->loaded_theme_name);
	self->priv->loaded_theme_name = _tmp14_;
	_cairo_destroy0 (c2);
	_cairo_destroy0 (c1);
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView2D * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	ChessScene* _tmp2_ = NULL;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gint board_size;
	ChessScene* _tmp8_ = NULL;
	gboolean _tmp9_;
	ChessScene* _tmp37_ = NULL;
	self = (ChessView2D*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	chess_view2_d_load_theme (self);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_translate (c, (gdouble) (_tmp0_ / 2), (gdouble) (_tmp1_ / 2));
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
	_tmp3_ = chess_scene_get_board_angle (_tmp2_);
	cairo_rotate (c, (G_PI * _tmp3_) / 180.0);
	_tmp4_ = chess_view2_d_get_border_size (self);
	_tmp5_ = ceil ((self->priv->square_size * 4) + _tmp4_);
	board_size = (gint) _tmp5_;
	cairo_set_source_rgb (c, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
	cairo_rectangle (c, (gdouble) (-board_size), (gdouble) (-board_size), (gdouble) (board_size * 2), (gdouble) (board_size * 2));
	cairo_fill (c);
	{
		gint file;
		file = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					file++;
				}
				_tmp6_ = FALSE;
				if (!(file < 8)) {
					break;
				}
				{
					gint rank;
					rank = 0;
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint x;
							gint y;
							if (!_tmp7_) {
								rank++;
							}
							_tmp7_ = FALSE;
							if (!(rank < 8)) {
								break;
							}
							x = (gint) ((file - 4) * self->priv->square_size);
							y = (gint) ((3 - rank) * self->priv->square_size);
							cairo_rectangle (c, (gdouble) x, (gdouble) y, (gdouble) self->priv->square_size, (gdouble) self->priv->square_size);
							if (((file + rank) % 2) == 0) {
								cairo_set_source_rgb (c, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
							} else {
								cairo_set_source_rgb (c, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
							}
							cairo_fill (c);
						}
					}
				}
			}
		}
	}
	_tmp8_ = chess_view_get_scene ((ChessView*) self);
	_tmp9_ = chess_scene_get_show_numbering (_tmp8_);
	if (_tmp9_) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_ = NULL;
		gchar** files;
		gint files_length1;
		gint _files_size_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar** _tmp27_ = NULL;
		gchar** ranks;
		gint ranks_length1;
		gint _ranks_size_;
		gdouble _tmp28_;
		cairo_text_extents_t extents = {0};
		cairo_text_extents_t _tmp29_ = {0};
		gdouble y_offset;
		gdouble top;
		gdouble _tmp30_;
		gdouble bottom;
		gdouble file_offset;
		gdouble rank_offset;
		_tmp10_ = g_strdup ("a");
		_tmp11_ = g_strdup ("b");
		_tmp12_ = g_strdup ("c");
		_tmp13_ = g_strdup ("d");
		_tmp14_ = g_strdup ("e");
		_tmp15_ = g_strdup ("f");
		_tmp16_ = g_strdup ("g");
		_tmp17_ = g_strdup ("h");
		_tmp18_ = g_new0 (gchar*, 8 + 1);
		_tmp18_[0] = _tmp10_;
		_tmp18_[1] = _tmp11_;
		_tmp18_[2] = _tmp12_;
		_tmp18_[3] = _tmp13_;
		_tmp18_[4] = _tmp14_;
		_tmp18_[5] = _tmp15_;
		_tmp18_[6] = _tmp16_;
		_tmp18_[7] = _tmp17_;
		files = _tmp18_;
		files_length1 = 8;
		_files_size_ = 8;
		_tmp19_ = g_strdup ("8");
		_tmp20_ = g_strdup ("7");
		_tmp21_ = g_strdup ("6");
		_tmp22_ = g_strdup ("5");
		_tmp23_ = g_strdup ("4");
		_tmp24_ = g_strdup ("3");
		_tmp25_ = g_strdup ("2");
		_tmp26_ = g_strdup ("1");
		_tmp27_ = g_new0 (gchar*, 8 + 1);
		_tmp27_[0] = _tmp19_;
		_tmp27_[1] = _tmp20_;
		_tmp27_[2] = _tmp21_;
		_tmp27_[3] = _tmp22_;
		_tmp27_[4] = _tmp23_;
		_tmp27_[5] = _tmp24_;
		_tmp27_[6] = _tmp25_;
		_tmp27_[7] = _tmp26_;
		ranks = _tmp27_;
		ranks_length1 = 8;
		_ranks_size_ = 8;
		cairo_set_source_rgb (c, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
		_tmp28_ = chess_view2_d_get_border_size (self);
		cairo_set_font_size (c, _tmp28_ * 0.6);
		cairo_select_font_face (c, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		cairo_text_extents (c, "abcdefgh", &_tmp29_);
		extents = _tmp29_;
		y_offset = ((((self->priv->square_size / 2) - extents.height) / 2) + extents.height) + extents.y_bearing;
		top = -((self->priv->square_size * 4) + y_offset);
		_tmp30_ = chess_view2_d_get_border_size (self);
		bottom = ((self->priv->square_size * 4) + _tmp30_) - y_offset;
		file_offset = -(self->priv->square_size * 3.5);
		rank_offset = -(self->priv->square_size * 3.5);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp31_;
				_tmp31_ = TRUE;
				while (TRUE) {
					cairo_text_extents_t _tmp32_ = {0};
					cairo_text_extents_t _tmp33_ = {0};
					gdouble _tmp34_;
					gdouble _tmp35_;
					gdouble _tmp36_;
					if (!_tmp31_) {
						i++;
					}
					_tmp31_ = FALSE;
					if (!(i < 8)) {
						break;
					}
					cairo_text_extents (c, ranks[i], &_tmp32_);
					extents = _tmp32_;
					cairo_save (c);
					cairo_move_to (c, file_offset - (extents.width / 2), top);
					cairo_show_text (c, files[i]);
					cairo_restore (c);
					cairo_save (c);
					cairo_move_to (c, file_offset - (extents.width / 2), bottom);
					cairo_show_text (c, files[i]);
					cairo_restore (c);
					cairo_text_extents (c, ranks[i], &_tmp33_);
					extents = _tmp33_;
					y_offset = -(extents.y_bearing + (extents.height / 2));
					cairo_save (c);
					_tmp34_ = chess_view2_d_get_border_size (self);
					_tmp35_ = chess_view2_d_get_border_size (self);
					cairo_move_to (c, -(((((gdouble) self->priv->square_size) * 4) + _tmp34_) - ((_tmp35_ - extents.width) / 2)), rank_offset + y_offset);
					cairo_show_text (c, ranks[i]);
					cairo_restore (c);
					cairo_save (c);
					_tmp36_ = chess_view2_d_get_border_size (self);
					cairo_move_to (c, (((gdouble) self->priv->square_size) * 4) + ((_tmp36_ - extents.width) / 2), rank_offset + y_offset);
					cairo_show_text (c, ranks[i]);
					cairo_restore (c);
					file_offset = file_offset + ((gdouble) self->priv->square_size);
					rank_offset = rank_offset + ((gdouble) self->priv->square_size);
				}
			}
		}
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp37_ = chess_view_get_scene ((ChessView*) self);
	{
		GList* model_collection;
		GList* model_it;
		model_collection = _tmp37_->pieces;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp38_;
			ChessModel* model;
			_tmp38_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp38_;
			{
				ChessScene* _tmp39_ = NULL;
				gdouble _tmp40_;
				cairo_surface_t* _tmp41_ = NULL;
				gdouble _tmp42_ = 0.0;
				gboolean _tmp43_ = FALSE;
				cairo_save (c);
				cairo_translate (c, (model->x - 4) * self->priv->square_size, (3 - model->y) * self->priv->square_size);
				cairo_translate (c, (gdouble) (self->priv->square_size / 2), (gdouble) (self->priv->square_size / 2));
				_tmp39_ = chess_view_get_scene ((ChessView*) self);
				_tmp40_ = chess_scene_get_board_angle (_tmp39_);
				cairo_rotate (c, ((-G_PI) * _tmp40_) / 180.0);
				if (model->is_selected) {
					_tmp41_ = self->priv->selected_model_surface;
				} else {
					_tmp41_ = self->priv->model_surface;
				}
				if (model->under_threat) {
					ChessScene* _tmp44_ = NULL;
					gboolean _tmp45_;
					_tmp44_ = chess_view_get_scene ((ChessView*) self);
					_tmp45_ = chess_scene_get_show_move_hints (_tmp44_);
					_tmp43_ = _tmp45_;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					_tmp42_ = 0.8;
				} else {
					_tmp42_ = 1.0;
				}
				chess_view2_d_draw_piece (self, c, _tmp41_, model->piece, _tmp42_);
				cairo_restore (c);
				_chess_model_unref0 (model);
			}
		}
	}
	{
		gint rank;
		rank = 0;
		{
			gboolean _tmp46_;
			_tmp46_ = TRUE;
			while (TRUE) {
				if (!_tmp46_) {
					rank++;
				}
				_tmp46_ = FALSE;
				if (!(rank < 8)) {
					break;
				}
				{
					gint file;
					file = 0;
					{
						gboolean _tmp47_;
						_tmp47_ = TRUE;
						while (TRUE) {
							gboolean _tmp48_ = FALSE;
							ChessScene* _tmp49_ = NULL;
							gboolean _tmp50_;
							if (!_tmp47_) {
								file++;
							}
							_tmp47_ = FALSE;
							if (!(file < 8)) {
								break;
							}
							_tmp49_ = chess_view_get_scene ((ChessView*) self);
							_tmp50_ = chess_scene_get_show_move_hints (_tmp49_);
							if (_tmp50_) {
								ChessScene* _tmp51_ = NULL;
								gboolean _tmp52_;
								_tmp51_ = chess_view_get_scene ((ChessView*) self);
								_tmp52_ = chess_scene_can_move (_tmp51_, rank, file);
								_tmp48_ = _tmp52_;
							} else {
								_tmp48_ = FALSE;
							}
							if (_tmp48_) {
								ChessScene* _tmp53_ = NULL;
								gdouble _tmp54_;
								ChessScene* _tmp55_ = NULL;
								ChessPiece* _tmp56_ = NULL;
								ChessPiece* _tmp57_;
								cairo_save (c);
								cairo_translate (c, (gdouble) ((file - 4) * self->priv->square_size), (gdouble) ((3 - rank) * self->priv->square_size));
								cairo_translate (c, (gdouble) (self->priv->square_size / 2), (gdouble) (self->priv->square_size / 2));
								_tmp53_ = chess_view_get_scene ((ChessView*) self);
								_tmp54_ = chess_scene_get_board_angle (_tmp53_);
								cairo_rotate (c, ((-G_PI) * _tmp54_) / 180.0);
								_tmp55_ = chess_view_get_scene ((ChessView*) self);
								_tmp56_ = chess_scene_get_selected_piece (_tmp55_);
								_tmp57_ = _tmp56_;
								chess_view2_d_draw_piece (self, c, self->priv->model_surface, _tmp57_, 0.1);
								_chess_piece_unref0 (_tmp57_);
								cairo_restore (c);
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, ChessPiece* piece, gdouble alpha) {
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp4_;
	gint size;
	gint offset;
	Color _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (piece != NULL);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = chess_scene_get_board_side (_tmp1_);
	if (g_strcmp0 (_tmp2_, "facetoface") == 0) {
		Color _tmp3_;
		_tmp3_ = chess_piece_get_color (piece);
		_tmp0_ = _tmp3_ == COLOR_BLACK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		cairo_rotate (c, G_PI);
	}
	_tmp4_ = cairo_image_surface_get_height (surface);
	size = _tmp4_;
	cairo_translate (c, (gdouble) ((-size) / 2), (gdouble) ((-size) / 2));
	offset = (gint) piece->type;
	_tmp5_ = chess_piece_get_color (piece);
	if (_tmp5_ == COLOR_BLACK) {
		offset = offset + 6;
	}
	cairo_set_source_surface (c, surface, (gdouble) ((-offset) * size), (gdouble) 0);
	cairo_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) size, (gdouble) size);
	cairo_clip (c);
	cairo_paint_with_alpha (c, alpha);
}


static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gint _tmp3_;
	gdouble _tmp4_;
	gint file;
	gint _tmp5_;
	gdouble _tmp6_;
	gint rank;
	ChessScene* _tmp7_ = NULL;
	gdouble _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ChessScene* _tmp12_ = NULL;
	self = (ChessView2D*) base;
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = chess_scene_get_game (_tmp1_);
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*event).button != 1;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp4_ = floor ((((*event).x - (0.5 * _tmp3_)) + (self->priv->square_size * 4)) / self->priv->square_size);
	file = (gint) _tmp4_;
	_tmp5_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp6_ = floor ((((*event).y - (0.5 * _tmp5_)) + (self->priv->square_size * 4)) / self->priv->square_size);
	rank = 7 - ((gint) _tmp6_);
	_tmp7_ = chess_view_get_scene ((ChessView*) self);
	_tmp8_ = chess_scene_get_board_angle (_tmp7_);
	if (_tmp8_ == 180.0) {
		rank = 7 - rank;
		file = 7 - file;
	}
	if (file < 0) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = file >= 8;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = rank < 0;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = rank >= 8;
	}
	if (_tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = chess_view_get_scene ((ChessView*) self);
	chess_scene_select_square (_tmp12_, file, rank);
	result = TRUE;
	return result;
}


static gdouble chess_view2_d_get_border_size (ChessView2D* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = (gdouble) (self->priv->square_size / 2);
	return result;
}


static void chess_view2_d_class_init (ChessView2DClass * klass) {
	chess_view2_d_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessView2DPrivate));
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view2_d_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = chess_view2_d_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view2_d_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view2_d_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view2_d_finalize;
}


static void chess_view2_d_instance_init (ChessView2D * self) {
	gchar* _tmp0_;
	self->priv = CHESS_VIEW2_D_GET_PRIVATE (self);
	self->priv->border = 6;
	_tmp0_ = g_strdup ("");
	self->priv->loaded_theme_name = _tmp0_;
}


static void chess_view2_d_finalize (GObject* obj) {
	ChessView2D * self;
	self = CHESS_VIEW2_D (obj);
	_cairo_surface_destroy0 (self->priv->model_surface);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	_g_free0 (self->priv->loaded_theme_name);
	G_OBJECT_CLASS (chess_view2_d_parent_class)->finalize (obj);
}


GType chess_view2_d_get_type (void) {
	static volatile gsize chess_view2_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view2_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView2DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view2_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView2D), 0, (GInstanceInitFunc) chess_view2_d_instance_init, NULL };
		GType chess_view2_d_type_id;
		chess_view2_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView2D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view2_d_type_id__volatile, chess_view2_d_type_id);
	}
	return chess_view2_d_type_id__volatile;
}


static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView2D * self;
	self = CHESS_VIEW2_D (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



