untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAfvrym3aujNaI9KBQDZqxy4Mth1m965Nz+iydkpJguXXzI6epeyEOspzqNueZeoIz3DZRQKslIt4x/N0IlqvPQQI=

OpenBSD 7.5 errata 025, April 13, 2025:

In Perl, non-ASCII bytes in the left-hand-side of the `tr` operator
can overflow an insufficiently sized buffer.  CVE-2024-56406

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 025_perl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install perl:
    cd /usr/src/gnu/usr.bin/perl
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install

Index: gnu/usr.bin/perl/op.c
===================================================================
RCS file: /cvs/src/gnu/usr.bin/perl/op.c,v
diff -u -p -r1.27 op.c
--- gnu/usr.bin/perl/op.c	8 Jul 2023 14:18:35 -0000	1.27
+++ gnu/usr.bin/perl/op.c	10 Apr 2025 16:04:19 -0000
@@ -7605,6 +7605,7 @@ S_pmtrans(pTHX_ OP *o, OP *expr, OP *rep
                  * same time.  But otherwise one crosses before the other */
                 if (t_cp < 256 && r_cp_end > 255 && r_cp != t_cp) {
                     can_force_utf8 = TRUE;
+                    max_expansion = MAX(2, max_expansion);
                 }
             }
 
