untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAfqoQow3N+KWimaeO6ZSsro8ODIZB5gbbZ4r08q9m5AMYJ4O+nCX4gqaihBSk6rnGvyBlEHwAYRWuEjUUUNplkgQ=

OpenBSD 7.5 errata 017, February 18, 2025:

sshd(8) denial of service relating to SSH2_MSG_PING handling.
ssh(1) server impersonation when VerifyHostKeyDNS enabled.

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 017_ssh.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install OpenSSH:
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/krl.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/krl.c,v
diff -u -p -r1.59 krl.c
--- usr.bin/ssh/krl.c	17 Jul 2023 05:22:30 -0000	1.59
+++ usr.bin/ssh/krl.c	7 Feb 2025 17:28:59 -0000
@@ -672,6 +672,7 @@ revoked_certs_generate(struct revoked_ce
 			break;
 		case KRL_SECTION_CERT_SERIAL_BITMAP:
 			if (rs->lo - bitmap_start > INT_MAX) {
+				r = SSH_ERR_INVALID_FORMAT;
 				error_f("insane bitmap gap");
 				goto out;
 			}
@@ -1057,6 +1058,7 @@ ssh_krl_from_blob(struct sshbuf *buf, st
 	}
 
 	if ((krl = ssh_krl_init()) == NULL) {
+		r = SSH_ERR_ALLOC_FAIL;
 		error_f("alloc failed");
 		goto out;
 	}
Index: usr.bin/ssh/packet.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/packet.c,v
diff -u -p -r1.313 packet.c
--- usr.bin/ssh/packet.c	18 Dec 2023 14:45:17 -0000	1.313
+++ usr.bin/ssh/packet.c	7 Feb 2025 17:28:59 -0000
@@ -1752,6 +1752,14 @@ ssh_packet_read_poll_seqnr(struct ssh *s
 			if ((r = sshpkt_get_string_direct(ssh, &d, &len)) != 0)
 				return r;
 			DBG(debug("Received SSH2_MSG_PING len %zu", len));
+			if (!ssh->state->after_authentication) {
+				DBG(debug("Won't reply to PING in preauth"));
+				break;
+			}
+			if (ssh_packet_is_rekeying(ssh)) {
+				DBG(debug("Won't reply to PING during KEX"));
+				break;
+			}
 			if ((r = sshpkt_start(ssh, SSH2_MSG_PONG)) != 0 ||
 			    (r = sshpkt_put_string(ssh, d, len)) != 0 ||
 			    (r = sshpkt_send(ssh)) != 0)
Index: usr.bin/ssh/ssh-agent.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-agent.c,v
diff -u -p -r1.306 ssh-agent.c
--- usr.bin/ssh/ssh-agent.c	9 Mar 2024 05:12:13 -0000	1.306
+++ usr.bin/ssh/ssh-agent.c	7 Feb 2025 17:28:59 -0000
@@ -1195,6 +1195,7 @@ parse_key_constraint_extension(struct ss
 	    "restrict-destination-v00@openssh.com") == 0) {
 		if (*dcsp != NULL) {
 			error_f("%s already set", ext_name);
+			r = SSH_ERR_INVALID_FORMAT;
 			goto out;
 		}
 		if ((r = sshbuf_froms(m, &b)) != 0) {
@@ -1204,6 +1205,7 @@ parse_key_constraint_extension(struct ss
 		while (sshbuf_len(b) != 0) {
 			if (*ndcsp >= AGENT_MAX_DEST_CONSTRAINTS) {
 				error_f("too many %s constraints", ext_name);
+				r = SSH_ERR_INVALID_FORMAT;
 				goto out;
 			}
 			*dcsp = xrecallocarray(*dcsp, *ndcsp, *ndcsp + 1,
@@ -1221,6 +1223,7 @@ parse_key_constraint_extension(struct ss
 		}
 		if (*certs != NULL) {
 			error_f("%s already set", ext_name);
+			r = SSH_ERR_INVALID_FORMAT;
 			goto out;
 		}
 		if ((r = sshbuf_get_u8(m, &v)) != 0 ||
@@ -1232,6 +1235,7 @@ parse_key_constraint_extension(struct ss
 		while (sshbuf_len(b) != 0) {
 			if (*ncerts >= AGENT_MAX_EXT_CERTS) {
 				error_f("too many %s constraints", ext_name);
+				r = SSH_ERR_INVALID_FORMAT;
 				goto out;
 			}
 			*certs = xrecallocarray(*certs, *ncerts, *ncerts + 1,
@@ -1728,6 +1732,7 @@ process_ext_session_bind(SocketEntry *e)
 	/* record new key/sid */
 	if (e->nsession_ids >= AGENT_MAX_SESSION_IDS) {
 		error_f("too many session IDs recorded");
+		r = -1;
 		goto out;
 	}
 	e->session_ids = xrecallocarray(e->session_ids, e->nsession_ids,
Index: usr.bin/ssh/ssh-sk-client.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-sk-client.c,v
diff -u -p -r1.12 ssh-sk-client.c
--- usr.bin/ssh/ssh-sk-client.c	14 Jan 2022 03:34:00 -0000	1.12
+++ usr.bin/ssh/ssh-sk-client.c	7 Feb 2025 17:28:59 -0000
@@ -429,6 +429,7 @@ sshsk_load_resident(const char *provider
 		}
 		if ((srk = calloc(1, sizeof(*srk))) == NULL) {
 			error_f("calloc failed");
+			r = SSH_ERR_ALLOC_FAIL;
 			goto out;
 		}
 		srk->key = key;
@@ -440,6 +441,7 @@ sshsk_load_resident(const char *provider
 		if ((tmp = recallocarray(srks, nsrks, nsrks + 1,
 		    sizeof(*srks))) == NULL) {
 			error_f("recallocarray keys failed");
+			r = SSH_ERR_ALLOC_FAIL;
 			goto out;
 		}
 		debug_f("srks[%zu]: %s %s uidlen %zu", nsrks,
Index: usr.bin/ssh/sshconnect2.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/sshconnect2.c,v
diff -u -p -r1.372 sshconnect2.c
--- usr.bin/ssh/sshconnect2.c	8 Jan 2024 00:34:34 -0000	1.372
+++ usr.bin/ssh/sshconnect2.c	7 Feb 2025 17:29:00 -0000
@@ -96,7 +96,7 @@ verify_host_key_callback(struct sshkey *
 	    options.required_rsa_size)) != 0)
 		fatal_r(r, "Bad server host key");
 	if (verify_host_key(xxx_host, xxx_hostaddr, hostkey,
-	    xxx_conn_info) == -1)
+	    xxx_conn_info) != 0)
 		fatal("Host key verification failed.");
 	return 0;
 }
@@ -693,6 +693,7 @@ input_userauth_pk_ok(int type, u_int32_t
 
 	if ((pktype = sshkey_type_from_name(pkalg)) == KEY_UNSPEC) {
 		debug_f("server sent unknown pkalg %s", pkalg);
+		r = SSH_ERR_INVALID_FORMAT;
 		goto done;
 	}
 	if ((r = sshkey_from_blob(pkblob, blen, &key)) != 0) {
@@ -703,6 +704,7 @@ input_userauth_pk_ok(int type, u_int32_t
 		error("input_userauth_pk_ok: type mismatch "
 		    "for decoded key (received %d, expected %d)",
 		    key->type, pktype);
+		r = SSH_ERR_INVALID_FORMAT;
 		goto done;
 	}
 
@@ -722,6 +724,7 @@ input_userauth_pk_ok(int type, u_int32_t
 		    SSH_FP_DEFAULT);
 		error_f("server replied with unknown key: %s %s",
 		    sshkey_type(key), fp == NULL ? "<ERROR>" : fp);
+		r = SSH_ERR_INVALID_FORMAT;
 		goto done;
 	}
 	ident = format_identity(id);
Index: usr.bin/ssh/sshsig.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/sshsig.c,v
diff -u -p -r1.35 sshsig.c
--- usr.bin/ssh/sshsig.c	8 Mar 2024 22:16:32 -0000	1.35
+++ usr.bin/ssh/sshsig.c	7 Feb 2025 17:29:00 -0000
@@ -872,6 +872,7 @@ cert_filter_principals(const char *path,
 	}
 	if ((principals = sshbuf_dup_string(nprincipals)) == NULL) {
 		error_f("buffer error");
+		r = SSH_ERR_ALLOC_FAIL;
 		goto out;
 	}
 	/* success */
