untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajSv3sOifp9YSzVOYcltzqAysl2u0YmOTe+al8x+z1+wSuWo5vmpDxA+zQHU+MuFU0BPO9aj7Od1g6pn3c4NepQ0=

OpenBSD 7.4 errata 017, June 26, 2024:

Repair a withdraw desyncronization problem in bgpd(8).

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 017_bgpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install bgpd:
    cd /usr/src/usr.sbin/bgpd
    make obj
    make
    make install

Index: usr.sbin/bgpd/rde_prefix.c
===================================================================
RCS file: /cvs/src/usr.sbin/bgpd/rde_prefix.c,v
diff -u -p -u -r1.50 rde_prefix.c
--- usr.sbin/bgpd/rde_prefix.c	12 Jul 2023 14:45:43 -0000	1.50
+++ usr.sbin/bgpd/rde_prefix.c	25 Jun 2024 15:59:26 -0000
@@ -567,6 +567,9 @@ pt_writebuf(struct ibuf *buf, struct pt_
 		goto fail;
 	}
 
+	/* keep 2 bytes reserved in the withdraw case for IPv4 encoding */
+	if (withdraw && ibuf_left(buf) < ibuf_size(tmp) + 2)
+		goto fail;
 	if (ibuf_add_buf(buf, tmp) == -1)
 		goto fail;
 	ibuf_free(tmp);
