untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2qa51GQoCWnUxwiJ9TEiQIOeVuan6C6DmqWoH3dWRB+pKk/1e+6tXAgtcpDItVu2ZZLuOfvAseAfangOp+FG0Ac=

OpenBSD 6.8 errata 026, July 25, 2021:

On mips64, the strchr/index/strrchr/rindex functions in libc handled
signed characters incorrectly.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 026_strchr.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install libc, and statically linked binaries:
    cd /usr/src/lib/libc
    make obj && make && make install
    cd /usr/src/bin
    make obj && make && make install
    cd /usr/src/sbin
    make obj && make && make install
    cd /usr/src/usr.bin/kdump
    make obj && make && make install
    cd /usr/src/usr.bin/ktrace
    make obj && make && make install
    cd /usr/src/usr.sbin/chroot
    make obj && make && make install
    cd /usr/src/usr.sbin/installboot
    make obj && make && make install
    cd /usr/src/usr.sbin/watchdogd
    make obj && make && make install

Index: lib/libc/arch/mips64/string/strchr.S
===================================================================
RCS file: /cvs/src/lib/libc/arch/mips64/string/strchr.S,v
diff -u -p -u -r1.3 strchr.S
--- lib/libc/arch/mips64/string/strchr.S	31 Aug 2015 02:53:56 -0000	1.3
+++ lib/libc/arch/mips64/string/strchr.S	24 Jul 2021 14:56:36 -0000
@@ -37,6 +37,7 @@ WEAK_ALIAS(index, strchr)
 
 LEAF(strchr, 0)
 	.set	reorder
+	andi	a1, 0xff
 0:
 	lbu	a2, 0(a0)		# get a byte
 	daddu	a0, a0, 1
Index: lib/libc/arch/mips64/string/strrchr.S
===================================================================
RCS file: /cvs/src/lib/libc/arch/mips64/string/strrchr.S,v
diff -u -p -u -r1.3 strrchr.S
--- lib/libc/arch/mips64/string/strrchr.S	31 Aug 2015 02:53:56 -0000	1.3
+++ lib/libc/arch/mips64/string/strrchr.S	24 Jul 2021 14:56:36 -0000
@@ -38,6 +38,7 @@ WEAK_ALIAS(rindex, strrchr)
 LEAF(strrchr, 0)
 	.set	reorder
 	move	v0, zero		# default if not found
+	andi	a1, 0xff
 1:
 	lbu	a3, 0(a0)		# get a byte
 	daddu	a0, a0, 1
