untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQwi8ADWKm5MD49usniTW+3acahh4QRbBhir2p4OjstAS3G83AzLDhR9Oe//OJzpFMU7vNC81lVROFYgQGUWSFwQ=

OpenBSD 6.0 errata 031, August 3, 2017:

An out-of-bound read in vfs_getcwd_scandir() (mainly used for FUSE)
may result in a kernel panic or info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 031_fuse.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/vfs_getcwd.c
===================================================================
RCS file: /cvs/src/sys/kern/vfs_getcwd.c,v
--- sys/kern/vfs_getcwd.c	19 Mar 2016 12:04:15 -0000	1.26
+++ sys/kern/vfs_getcwd.c	2 Aug 2017 16:27:05 -0000
@@ -102,18 +102,20 @@ vfs_getcwd_scandir(struct vnode **lvpp, 
 
 	/* If we don't care about the pathname, we're done */
 	if (bufp == NULL) {
-		vrele(lvp);
-		*lvpp = NULL;
-		return (0);
+		error = 0;
+		goto out;
 	}
 
 	fileno = va.va_fileid;
 
 	dirbuflen = DIRBLKSIZ;
-
 	if (dirbuflen < va.va_blocksize)
 		dirbuflen = va.va_blocksize;
-
+	/* XXX we need some limit for fuse, 1 MB should be enough */
+	if (dirbuflen > 0xfffff) {
+		error = EINVAL;
+		goto out;
+	}
 	dirbuf = malloc(dirbuflen, M_TEMP, M_WAITOK);
 
 	off = 0;
@@ -159,15 +161,20 @@ vfs_getcwd_scandir(struct vnode **lvpp, 
 			reclen = dp->d_reclen;
 
 			/* Check for malformed directory */
-			if (reclen < DIRENT_RECSIZE(1)) {
+			if (reclen < DIRENT_RECSIZE(1) || reclen > len) {
 				error = EINVAL;
 				goto out;
 			}
 
 			if (dp->d_fileno == fileno) {
 				char *bp = *bpp;
-				bp -= dp->d_namlen;
 
+				if (offsetof(struct dirent, d_name) +
+				    dp->d_namlen > reclen) {
+					error = EINVAL;
+					goto out;
+				}
+				bp -= dp->d_namlen;
 				if (bp <= bufp) {
 					error = ERANGE;
 					goto out;
