untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwYYht8Up5vKYL6HwbPCj/eSG7J/p94oFAmSiSOJ3MYpZFVIUCR4Ro5YumxOdhcIQgZb5KMjHNuczsKkCSYfWjAk=

OpenBSD 5.9 errata 33, Jan 5, 2017:

Avoid possible side-channel leak of ECDSA private keys when signing.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 033_libcrypto.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
        cd /usr/src/lib/libcrypto
        make obj
        make depend
        make
        make install

Index: lib/libssl/src/crypto/ecdsa/ecs_ossl.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/crypto/ecdsa/Attic/ecs_ossl.c,v
retrieving revision 1.6
retrieving revision 1.6.2.1
diff -u -p -r1.6 -r1.6.2.1
--- lib/libssl/src/crypto/ecdsa/ecs_ossl.c	8 Feb 2015 13:35:07 -0000	1.6
+++ lib/libssl/src/crypto/ecdsa/ecs_ossl.c	5 Jan 2017 13:27:17 -0000	1.6.2.1
@@ -141,6 +141,8 @@ ecdsa_sign_setup(EC_KEY *eckey, BN_CTX *
 		if (BN_num_bits(k) <= BN_num_bits(order))
 			if (!BN_add(k, k, order))
 				goto err;
+
+		BN_set_flags(k, BN_FLG_CONSTTIME);
 
 		/* compute r the x-coordinate of generator * k */
 		if (!EC_POINT_mul(group, tmp_point, k, NULL, NULL, ctx)) {
