untrusted comment: signature from openbsd 5.8 base secret key
RWQNNZXtC/MqPx+WZ+0dAb9KnvuYrRnubLYHbxubzn2iRSDihWJQjzaue/tox3C6yJX9WKp+fpXKKYRJyQRr0k4N8a2ylwSzAwA=

OpenBSD 5.8 errata 25, Aug 02, 2016:

A missing NULL check in sysctl code results in a crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-58-base.pub -x 025_sysctl.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/vfs_subr.c
===================================================================
RCS file: /cvs/src/sys/kern/vfs_subr.c,v
retrieving revision 1.232
diff -u -p -r1.232 vfs_subr.c
--- sys/kern/vfs_subr.c	16 Jul 2015 18:17:27 -0000	1.232
+++ sys/kern/vfs_subr.c	29 Jul 2016 19:04:47 -0000
@@ -1258,7 +1258,7 @@ vfs_sysctl(int *name, u_int namelen, voi
 			if (vfsp->vfc_typenum == name[0])
 				break;
 
-		if (vfsp == NULL)
+		if (vfsp == NULL || vfsp->vfc_vfsops->vfs_sysctl == NULL)
 			return (EOPNOTSUPP);
 
 		return ((*vfsp->vfc_vfsops->vfs_sysctl)(&name[1], namelen - 1,
