untrusted comment: signature from openbsd 5.7 base secret key
RWSvUZXnw9gUb1W0cLwIa4jEVqEbfbRAGS88N9kYbqEIPQoOeEh4Pc+hQ0bFi3PPqyyPKzSvWUqZM4EgYQiyqB5UbOi/TwjyLg4=

OpenBSD 5.7 errata 10, July 14, 2015

A TCP socket can become confused and not properly cleanup resources.

Apply patch using:

    signify -Vep /etc/signify/openbsd-57-base.pub -x 010_tcp_persist.patch.sig \
        -m - | (cd /usr/src && patch -p0)

Then build and install a new kernel

    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/netinet/tcp_output.c
===================================================================
RCS file: /data/mirror/openbsd/cvs/src/sys/netinet/tcp_output.c,v
retrieving revision 1.108
diff -u -p -r1.108 tcp_output.c
--- sys/netinet/tcp_output.c	19 Dec 2014 17:14:40 -0000	1.108
+++ sys/netinet/tcp_output.c	13 Jul 2015 16:09:43 -0000
@@ -1008,6 +1008,32 @@ send:
 				tp->t_rxtshift = 0;
 			}
 		}
+
+		if (len == 0 && so->so_snd.sb_cc &&
+		    TCP_TIMER_ISARMED(tp, TCPT_REXMT) == 0 &&
+		    TCP_TIMER_ISARMED(tp, TCPT_PERSIST) == 0) {
+			/*
+			 * Avoid a situation where we do not set persist timer
+			 * after a zero window condition. For example:
+			 * 1) A -> B: packet with enough data to fill the window
+			 * 2) B -> A: ACK for #1 + new data (0 window
+			 *    advertisement)
+			 * 3) A -> B: ACK for #2, 0 len packet
+			 *
+			 * In this case, A will not activate the persist timer,
+			 * because it chose to send a packet. Unless tcp_output
+			 * is called for some other reason (delayed ack timer,
+			 * another input packet from B, socket syscall), A will
+			 * not send zero window probes.
+			 *
+			 * So, if you send a 0-length packet, but there is data
+			 * in the socket buffer, and neither the rexmt or
+			 * persist timer is already set, then activate the
+			 * persist timer.
+			 */
+			tp->t_rxtshift = 0;
+			tcp_setpersist(tp);
+		}
 	} else
 		if (SEQ_GT(tp->snd_nxt + len, tp->snd_max))
 			tp->snd_max = tp->snd_nxt + len;
