#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 26 "parse.y"
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet/ip_ipsp.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <endian.h>
#include <err.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "bgpd.h"
#include "session.h"
#include "rde.h"
#include "log.h"

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	u_char			*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;
struct file	*pushfile(const char *, int);
int		 popfile(void);
int		 check_file_secrecy(int, const char *);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};
int		 symset(const char *, const char *, int);
char		*symget(const char *);

static struct bgpd_config	*conf;
static struct network_head	*netconf;
static struct peer_head		*new_peers, *cur_peers;
static struct peer		*curpeer;
static struct peer		*curgroup;
static struct rde_rib		*currib;
static struct l3vpn		*curvpn;
static struct prefixset		*curpset, *curoset;
static struct prefixset_tree	*curpsitree;
static struct filter_head	*filter_l;
static struct filter_head	*peerfilter_l;
static struct filter_head	*groupfilter_l;
static struct filter_rule	*curpeer_filter[2];
static struct filter_rule	*curgroup_filter[2];

struct filter_rib_l {
	struct filter_rib_l	*next;
	char			 name[PEER_DESCR_LEN];
};

struct filter_peers_l {
	struct filter_peers_l	*next;
	struct filter_peers	 p;
};

struct filter_prefix_l {
	struct filter_prefix_l	*next;
	struct filter_prefix	 p;
};

struct filter_prefixlen {
	enum comp_ops		op;
	int			len_min;
	int			len_max;
};

struct filter_as_l {
	struct filter_as_l	*next;
	struct filter_as	 a;
};

struct filter_match_l {
	struct filter_match	 m;
	struct filter_prefix_l	*prefix_l;
	struct filter_as_l	*as_l;
	struct filter_prefixset	*prefixset;
} fmopts;

struct peer	*alloc_peer(void);
struct peer	*new_peer(void);
struct peer	*new_group(void);
int		 add_mrtconfig(enum mrt_type, char *, int, struct peer *,
		    char *);
struct rde_rib	*add_rib(char *);
struct rde_rib	*find_rib(char *);
int		 rib_add_fib(struct rde_rib *, u_int);
int		 get_id(struct peer *);
int		 merge_prefixspec(struct filter_prefix *,
		    struct filter_prefixlen *);
int		 expand_rule(struct filter_rule *, struct filter_rib_l *,
		    struct filter_peers_l *, struct filter_match_l *,
		    struct filter_set_head *);
int		 str2key(char *, char *, size_t);
int		 neighbor_consistent(struct peer *);
int		 merge_filterset(struct filter_set_head *, struct filter_set *);
void		 optimize_filters(struct filter_head *);
struct filter_rule	*get_rule(enum action_types);

int		 parsecommunity(struct community *, int, char *);
int		 parseextcommunity(struct community *, char *,
		    char *);
static int	 new_as_set(char *);
static void	 add_as_set(u_int32_t);
static void	 done_as_set(void);
static struct prefixset	*new_prefix_set(char *, int);
static void	 add_roa_set(struct prefixset_item *, u_int32_t, u_int8_t);

typedef struct {
	union {
		long long		 number;
		char			*string;
		struct bgpd_addr	 addr;
		u_int8_t		 u8;
		struct filter_rib_l	*filter_rib;
		struct filter_peers_l	*filter_peers;
		struct filter_match_l	 filter_match;
		struct filter_prefixset	*filter_prefixset;
		struct filter_prefix_l	*filter_prefix;
		struct filter_as_l	*filter_as;
		struct filter_set	*filter_set;
		struct filter_set_head	*filter_set_head;
		struct {
			struct bgpd_addr	prefix;
			u_int8_t		len;
		}			prefix;
		struct filter_prefixlen	prefixlen;
		struct prefixset_item	*prefixset_item;
		struct {
			u_int8_t		enc_alg;
			char			enc_key[IPSEC_ENC_KEY_LEN];
			u_int8_t		enc_key_len;
		}			encspec;
	} v;
	int lineno;
} YYSTYPE;

#line 183 "parse.c"
#define AS 257
#define ROUTERID 258
#define HOLDTIME 259
#define YMIN 260
#define LISTEN 261
#define ON 262
#define FIBUPDATE 263
#define FIBPRIORITY 264
#define RTABLE 265
#define NONE 266
#define UNICAST 267
#define VPN 268
#define RD 269
#define EXPORT 270
#define EXPORTTRGT 271
#define IMPORTTRGT 272
#define DEFAULTROUTE 273
#define RDE 274
#define RIB 275
#define EVALUATE 276
#define IGNORE 277
#define COMPARE 278
#define GROUP 279
#define NEIGHBOR 280
#define NETWORK 281
#define EBGP 282
#define IBGP 283
#define LOCALAS 284
#define REMOTEAS 285
#define DESCR 286
#define LOCALADDR 287
#define MULTIHOP 288
#define PASSIVE 289
#define MAXPREFIX 290
#define RESTART 291
#define ANNOUNCE 292
#define CAPABILITIES 293
#define REFRESH 294
#define AS4BYTE 295
#define CONNECTRETRY 296
#define DEMOTE 297
#define ENFORCE 298
#define NEIGHBORAS 299
#define ASOVERRIDE 300
#define REFLECTOR 301
#define DEPEND 302
#define DOWN 303
#define DUMP 304
#define IN 305
#define OUT 306
#define SOCKET 307
#define RESTRICTED 308
#define LOG 309
#define TRANSPARENT 310
#define TCP 311
#define MD5SIG 312
#define PASSWORD 313
#define KEY 314
#define TTLSECURITY 315
#define ALLOW 316
#define DENY 317
#define MATCH 318
#define QUICK 319
#define FROM 320
#define TO 321
#define ANY 322
#define CONNECTED 323
#define STATIC 324
#define COMMUNITY 325
#define EXTCOMMUNITY 326
#define LARGECOMMUNITY 327
#define DELETE 328
#define PREFIX 329
#define PREFIXLEN 330
#define PREFIXSET 331
#define ROASET 332
#define ORIGINSET 333
#define OVS 334
#define ASSET 335
#define SOURCEAS 336
#define TRANSITAS 337
#define PEERAS 338
#define MAXASLEN 339
#define MAXASSEQ 340
#define SET 341
#define LOCALPREF 342
#define MED 343
#define METRIC 344
#define NEXTHOP 345
#define REJECT 346
#define BLACKHOLE 347
#define NOMODIFY 348
#define SELF 349
#define PREPEND_SELF 350
#define PREPEND_PEER 351
#define PFTABLE 352
#define WEIGHT 353
#define RTLABEL 354
#define ORIGIN 355
#define PRIORITY 356
#define ERROR 357
#define INCLUDE 358
#define IPSEC 359
#define ESP 360
#define AH 361
#define SPI 362
#define IKE 363
#define IPV4 364
#define IPV6 365
#define QUALIFY 366
#define VIA 367
#define NE 368
#define LE 369
#define GE 370
#define XRANGE 371
#define LONGER 372
#define MAXLEN 373
#define STRING 374
#define NUMBER 375
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    1,    2,    2,    3,    3,
   15,   15,   11,   53,   54,   67,   55,   55,   66,   66,
   70,   56,   56,   69,   69,   19,   72,   57,   57,   73,
   58,   58,   71,   71,   60,   60,   60,   60,   60,   60,
   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
   60,   60,   60,   60,   60,   77,   59,   76,   76,   76,
   78,   78,   75,   74,   74,   74,   74,   74,   12,   12,
   13,   13,   16,   17,   17,   18,   18,    4,    4,   79,
   61,   80,   80,   80,   80,   81,   81,   81,   81,   81,
   82,   84,   62,   85,   63,   86,   86,   86,   86,   86,
   83,   83,   83,   88,   88,   88,   88,   87,   87,   87,
   87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
   87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
   87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
   87,   87,   87,   87,    8,    8,    6,    6,    7,    7,
    7,   10,   10,    5,    5,   52,   52,   64,   20,   20,
   20,   21,   21,   22,   22,   25,   25,   25,   26,   26,
   27,   30,   30,   29,   29,   28,   28,   28,   28,   28,
   28,   46,   46,   46,   46,   47,   47,   47,   45,   45,
   44,   36,   36,   38,   38,   37,   37,   37,   39,   39,
   39,   35,   35,   34,   34,   34,   34,   33,   89,   33,
   31,   31,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   40,   40,   40,   40,   40,   51,
   51,   51,   51,   42,   42,   42,   43,   43,   24,   24,
   23,   23,   41,   41,   41,   41,   41,   41,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
   41,   41,   41,   41,   41,   41,   41,   41,    9,   14,
   65,   65,   68,   68,   68,   68,   48,   48,   48,   48,
   48,   48,   49,   49,   50,   50,
};
const short yylen[] =
	{                                         2,
    0,    2,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    1,    1,    1,    1,    1,
    2,    1,    1,    3,    2,    0,    8,    5,    1,    3,
    0,    8,    5,    1,    3,    2,    0,    7,    4,    0,
    8,    5,    3,    5,    2,    3,    2,    2,    3,    3,
    2,    2,    2,    2,    1,    4,    6,    1,    3,    3,
    4,    4,    2,    2,    3,    0,    5,    1,    3,    2,
    0,    2,    5,    3,    4,    5,    5,    4,    1,    1,
    1,    0,    1,    3,    3,    1,    1,    0,    1,    0,
    8,    0,    2,    3,    3,    2,    3,    3,    2,    1,
    0,    0,    5,    0,    6,    0,    2,    3,    3,    3,
    4,    3,    0,    0,    2,    3,    3,    2,    2,    3,
    2,    2,    2,    1,    1,    2,    2,    2,    3,    3,
    3,    3,    3,    3,    2,    2,    3,    3,    2,    3,
    4,    4,    3,    8,    2,    2,    6,    1,    1,    2,
    3,    2,    2,    2,    0,    2,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    2,    7,    1,    1,
    1,    0,    1,    1,    1,    0,    2,    6,    1,    3,
    1,    1,    5,    1,    3,    1,    1,    2,    2,    1,
    1,    2,    2,    2,    4,    1,    3,    4,    1,    3,
    2,    1,    3,    1,    3,    2,    4,    3,    1,    3,
    4,    1,    3,    1,    1,    2,    3,    0,    0,    2,
    1,    2,    1,    1,    2,    2,    2,    3,    3,    2,
    2,    3,    2,    2,    0,    1,    2,    3,    4,    1,
    1,    1,    1,    0,    2,    6,    3,    1,    1,    1,
    0,    1,    2,    3,    3,    2,    3,    3,    2,    3,
    3,    2,    3,    3,    2,    2,    2,    2,    2,    2,
    2,    1,    2,    2,    3,    4,    4,    2,    1,    1,
    0,    2,    0,    1,    2,    3,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,
};
const short yydefred[] =
	{                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  169,  170,
  171,    0,    0,    0,    0,    0,    0,    0,    2,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   55,   58,    0,   15,   17,   16,   18,    0,
   83,   47,    0,   48,    0,   23,   52,   51,   63,    0,
    0,    0,    0,   22,    0,    0,  157,  158,    0,    0,
    0,    0,   64,    0,    0,    0,   54,   53,    0,    0,
    0,    0,    0,   25,    0,  173,    0,    3,    4,    5,
    6,    7,    8,    9,   10,   11,   12,   13,   14,    0,
   46,   49,   50,    0,   66,    0,   59,   60,   21,    0,
    0,    0,    0,  163,  162,    0,    0,    0,    0,   74,
    0,   79,   80,    0,    0,   81,   65,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   86,   87,  102,
   90,    0,   61,  106,   75,   84,   85,    0,    0,   78,
  272,  249,    0,  250,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  245,    0,   89,   56,
    0,    0,  282,   39,    0,    0,    0,   62,  181,    0,
  177,  174,  175,    0,    0,    0,    0,    0,    0,   67,
   68,    0,   76,   77,  252,    0,  253,    0,    0,  256,
    0,    0,  259,    0,    0,  267,  266,  268,  269,  265,
  270,  271,  273,  262,    0,    0,  274,  279,  278,    0,
    0,    0,   73,   33,    0,    0,    0,    0,   42,    0,
   28,    0,    0,    0,    0,  190,  191,  186,    0,  187,
  182,    0,    0,  103,   92,   72,    0,   70,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  124,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  107,  105,    0,  148,    0,    0,    0,
  254,  255,  257,  258,  260,  261,  263,  264,  248,    0,
  275,   57,   34,    0,    0,  236,    0,   36,    0,    0,
    0,    0,    0,    0,   19,   20,   29,    0,    0,  179,
  188,  189,    0,    0,    0,  114,    0,    0,   69,  110,
    0,  128,  135,  136,  127,    0,  118,    0,  122,  123,
    0,    0,    0,    0,    0,    0,  152,    0,    0,  139,
  150,    0,  126,    0,  154,  153,    0,  145,    0,  146,
  164,  165,    0,  109,  108,  277,  276,    0,    0,    0,
    0,  288,  289,  291,    0,  287,  290,  292,    0,  237,
   43,    0,    0,   38,    0,    0,    0,    0,    0,    0,
  184,    0,  168,  240,    0,    0,    0,    0,    0,  241,
  242,  243,    0,    0,    0,    0,    0,    0,    0,    0,
  221,  224,  202,  223,    0,    0,  112,    0,    0,    0,
    0,    0,   93,   91,  100,    0,  129,  120,    0,  140,
  133,  131,  132,  134,  159,  160,  161,  130,  138,  137,
  151,    0,    0,    0,  143,    0,  246,  247,   32,   35,
  296,  295,    0,  238,  286,    0,   41,   27,   30,  178,
  180,    0,    0,    0,    0,    0,    0,  194,    0,  233,
  280,  234,  225,  226,  231,  230,  192,  193,  204,    0,
  227,  222,  215,    0,  294,  293,    0,    0,  206,    0,
    0,  115,  111,    0,   95,   99,   96,    0,    0,   94,
  156,    0,    0,    0,    0,  239,   44,  183,  185,  229,
  228,    0,  199,    0,    0,  201,  232,    0,  203,    0,
  208,    0,  212,    0,    0,    0,  216,  117,  116,   97,
   98,    0,    0,    0,    0,  195,  285,  205,    0,    0,
  207,  217,  147,    0,    0,  200,    0,  213,    0,  198,
  211,    0,  144,  167,
};
const short yydgoto[] =
	{                                       1,
  306,   50,  478,  170,  353,   71,  428,  420,  219,  118,
   57,  125,  127,  462,   65,  240,  226,  140,  227,   30,
   87,  184,  196,  166,  136,  309,  181,  241,  382,  242,
  400,  401,  314,  513,  514,  402,  403,  470,  515,  298,
  289,  120,  290,  503,  504,  404,  505,  369,  480,  443,
  405,  543,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,  130,  308,  232,  303,  294,  225,
  228,  175,  230,   43,  277,  190,  142,  191,  186,  318,
  416,   45,  244,  185,  110,  192,  278,  406,  315,
};
const short yysindex[] =
	{                                      0,
  142,   88, -150, -274, -225, -159, -267, -265, -248, -244,
 -167, -241,  235, -226, -186, -211, -195, -267,    0,    0,
    0, -176,   79, -166, -156, -137, -143,  154,    0,  -81,
  237,  239,  254,  264,  270,  273,  281,  289,  296,  309,
  310,  315,    0,    0,   51,    0,    0,    0,    0,  -23,
    0,    0,  -11,    0, -274,    0,    0,    0,    0,  108,
   10,   96,  -49,    0,   14,   17,    0,    0,  348,  355,
  110,   63,    0,   35, -235,  105,    0,    0,  292,  407,
  301,  305,   62,    0, -241,    0,  155,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -139,
    0,    0,    0,   61,    0,   66,    0,    0,    0,  308,
   63,   75,   80,    0,    0,   71,   82,   63,  642,    0,
   93,    0,    0,   95,   97,    0,    0,  407,  407,  311,
  407,  407,   98,   14, -107,  -64,  348,    0,    0,    0,
    0, -213,    0,    0,    0,    0,    0,   63,   63,    0,
    0,    0,  109,    0,  -31,  -30,  -25, -104,  101,  103,
  107,  -21,  111,  114,  407,  109,    0,  119,    0,    0,
   95,  328,    0,    0, -113,  329,  331,    0,    0,  407,
    0,    0,    0,  -92,  359,  361, -267,  120,  221,    0,
    0,  293,    0,    0,    0, -251,    0,  132,  134,    0,
  138,  144,    0,  146,  151,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  152,  153,    0,    0,    0,  788,
  160,   95,    0,    0, -113, -277,  200,   58,    0, -113,
    0,  -77,  164, -150,  167,    0,    0,    0,  407,    0,
    0,    0,  404,    0,    0,    0,  285,    0,  540, -222,
 -172,  182, -150, -150, -241, -274,  183,    0,  184, -151,
  186,  -67, -267, -274,  295,  190,  191,  193, -267,  257,
 -267,  740,  -59,    0,    0,  562,    0,  563,  201,  202,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   58,
    0,    0,    0,   58,   57,    0,  199,    0,  -77,  407,
  576,  462, -113,   58,    0,    0,    0,   58,   58,    0,
    0,    0, -218,   63,  716,    0,  463,   -3,    0,    0,
  214,    0,    0,    0,    0,  -23,    0,   14,    0,    0,
  307, -267, -267, -267, -267,  -46,    0, -267, -267,    0,
    0,  218,    0,    3,    0,    0,   -9,    0,  407,    0,
    0,    0, -170,    0,    0,    0,    0,  476,  788,  480,
 -113,    0,    0,    0,  -35,    0,    0,    0,  231,    0,
    0,    0,  407,    0,  271,  486,  487,  -77,  488,  164,
    0,   58,    0,    0, -237, -102,  241,  242,  244,    0,
    0,    0,  245,  246, -165, -277, -277, -126,  248,  716,
    0,    0,    0,    0,   73,  358,    0,  609, -267,  249,
  250,  251,    0,    0,    0,  616,    0,    0,  252,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -241, -241,  788,    0,  267,    0,    0,    0,    0,
    0,    0,  255,    0,    0,  -77,    0,    0,    0,    0,
    0,  506, -218,  261,  262,  -98, -277,    0, -277,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   23,
    0,    0,    0,  263,    0,    0,   15,  -35,    0,  -77,
  628,    0,    0,  629,    0,    0,    0,  266,  275,    0,
    0,   14,   14,   58,  276,    0,    0,    0,    0,    0,
    0, -113,    0,   69,  528,    0,    0,  407,    0, -126,
    0,  140,    0,   69,  529,  -77,    0,    0,    0,    0,
    0,  532,  290,   34, -113,    0,    0,    0,   48,  140,
    0,    0,    0,  297,  -98,    0,   15,    0,  298,    0,
    0,  302,    0,    0,};
const short yyrindex[] =
	{                                      0,
  386,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -200,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  660,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  554,    0,    0,    0,    0,    0,
    0,  668,    0,    0,    0,  670,    0,    0,    0,  -88,
    0,    0,    0,    0,    0,    0,  -10,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  668,    0,    0,    0,    0,    0,    0,  668,    0,    0,
    0,    0,    0,  237,    0,    0,    0,  -88,  459,  -62,
  -88,  -88,    0,  671,    0,    0,   39,    0,    0,    0,
    0,  672,    0,    0,    0,    0,    0,  668,  668,    0,
    0,    0, -228,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  809,  312,    0,    0,    0,    0,
   49,  -51,    0,    0,    0,    5,   37,    0,    0,  313,
    0,    0,    0,    0,  673,    0,    0,    0,    0,    0,
    0,  386,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  237,    0,    0,    0,    7,    0,  -85,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -210,    0,
    0,  165,    0,    0,    0,    0,  672,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   53,    0,   64,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  774,
    0,    0,    0,  -85,    0,    0,    0,    0,    0,  605,
  493,    0,    0,  -85,    0,    0,    0,  -85,  -79,    0,
    0,    0,    0,  668,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   67,    0,   70,    0,    0,
   72,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  809,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  683,  571,    0,    0,    0,    0,    0,    0,    0,
    0,  -99,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  206,  206,    0,    0,   -8,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   22,    0,  206,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  -97,
    0,    0,    0,    0,    0,    0,    0,    1,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   74,   78,  774,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -82,    0,    0,    0,  187,    0,    0,
    0,    0,    0,   94,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   45,    0,    0,    0,    0,  143,    0,
    0,    0,    0,    0,  559,    0,  572,    0,   81,    0,
    0,    0,    0,    0,};
const short yygindex[] =
	{                                      0,
   31, -125, -209, -111,    0,  438,    0,    0,    0,    0,
  -17,  350,    0,    0,  -55,   -1,  -13,    0, -189,    0,
    0,    0,  543, -259,    0,    0, -229, -285,    0,    0,
    0,  318,    0, -376,  198,    0, -305,    0,  174, -163,
  -78,  -63,  278, -359,  219,    0,  185,    0,    0,  247,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  530,    0,    0, -123,    0,    0,  171,    0,    0,
  494,    0,    0,  405,  725,    0,    0,  481,    0,    0,
    0,    0,    0,    0,    0,    0, -224,    0,    0,
};
#define YYTABLESIZE 1164
const short yytable[] =
	{                                      72,
   78,  220,   52,  310,  172,  173,  413,  176,  177,  442,
  214,  198,  201,  199,  202,  180,  235,  204,  317,  205,
  456,  215,  307,  216,  502,  281,  458,  381,  479,  134,
  239,  235,  508,   49,   53,  293,  281,  321,  234,  281,
  167,  220,  196,  508,  214,  281,  281,  145,   83,  187,
  235,  188,  295,  103,  150,  399,  233,  508,   88,  223,
  235,  214,  149,  236,  237,  235,  301,  300,  281,  122,
  123,  281,  281,  125,  172,  476,  119,  301,  508,  121,
  101,  155,  279,  141,  193,  194,  139,  142,   74,  371,
  166,  301,  469,  323,  296,  297,  454,   46,  138,   51,
  324,  301,   55,  238,  302,  251,   56,   61,  311,   58,
  292,  281,  301,  375,  465,  313,  367,  366,  368,  172,
  172,  414,  280,  214,  189,  214,   59,  326,  327,   60,
  384,  235,   64,  476,  122,  123,  455,  512,  124,  332,
  399,  333,  334,  335,  235,  251,  235,  509,   73,   54,
  451,   29,  322,  538,  283,   51,  210,  283,  535,  283,
   56,   83,   76,  281,  234,  536,  358,  499,  449,  246,
  360,  440,  537,   88,  218,   62,  372,  149,   77,  283,
  376,  484,  283,  283,  377,  379,  235,   75,  125,  236,
  237,  119,  435,  350,  121,  477,  155,   79,  141,  328,
  476,   80,  142,  283,  528,  166,   63,   81,   51,  390,
  391,  392,   67,   68,   85,  235,  338,   82,  209,  425,
  426,  427,  283,   47,   48,  434,  107,  108,   83,  238,
   84,  339,  467,  468,  137,   70,  497,   86,  283,  283,
  283,  206,  207,  208,  209,  340,   88,  281,   89,  445,
  383,  346,  408,  348,  329,  182,  183,  214,  452,  409,
   69,   70,  341,   90,   49,  410,  179,  411,  412,   51,
  517,   69,   70,   91,  283,   69,   70,   13,  235,   92,
  438,   51,   93,   49,   49,  281,  281,  219,  283,  283,
   94,  283,  283,  506,  283,  507,  305,   48,   95,  214,
  351,  352,  274,  432,  433,   96,  532,  122,  123,  176,
  176,   37,   37,  473,  421,  422,  423,  424,   97,   98,
  429,  430,   31,   31,   99,  214,  214,  214,  235,  214,
  100,  214,  220,  214,  214,  441,  214,  214,  214,  214,
  214,  214,  235,  197,  200,  214,  235,  235,  235,  203,
  235,   48,  235,  214,  235,  235,  418,  235,  235,  235,
  235,  235,  235,  102,  214,  214,  235,  482,  214,  104,
  522,  473,  457,  106,  214,  214,  492,  493,   40,   40,
  235,  235,  475,  105,  527,  235,  235,  109,  305,   48,
  111,  486,  283,  466,  112,  235,  235,    2,    3,    4,
    5,  113,    6,  119,    7,    8,    9,  474,  121,   10,
   26,   26,  126,  316,  128,   11,  129,  275,  283,  283,
   12,  219,   13,  131,  362,  363,  364,  132,  133,  135,
  144,  365,  114,  115,  141,  174,  195,   14,  473,  143,
  475,  283,  457,  281,  148,   15,  305,   48,   16,  146,
   17,   18,  224,  229,  147,  231,  149,   19,   20,   21,
  359,  283,  235,  116,  361,  117,  168,  283,  283,  169,
  171,  178,   22,   23,   24,  211,   25,  212,  378,  380,
  213,  243,  483,  245,  217,  281,   26,  218,  457,  219,
  219,  219,  222,  219,  247,  219,  248,  219,  219,   27,
  219,  219,  219,  219,  219,  218,  281,  475,  282,  219,
  283,  457,  283,  305,   48,   28,  283,  283,  284,  281,
  285,  457,  281,  281,  281,  286,  287,  288,  219,  219,
  235,  235,  235,  291,  235,  299,  235,  179,  235,  235,
  312,  235,  235,  235,  235,  235,  235,  187,  249,  320,
  235,  250,  453,  284,  281,  325,  342,  330,  331,  337,
  281,  281,  251,  343,  344,   66,  345,  252,  347,  235,
  235,  354,  355,  370,  356,  357,  253,  254,  255,  256,
  257,  258,  259,  281,  260,  373,  374,  407,  417,  261,
  262,  431,  263,  264,  265,  266,  267,  419,   67,   68,
  437,  268,  269,  270,  439,  444,  446,  271,   69,   70,
  447,  448,  450,  481,  459,  460,  250,  461,  485,  463,
  464,  471,  487,  488,  489,  490,  491,  251,  495,  496,
  498,  281,  252,  272,  500,  501,  511,  518,  519,  520,
  510,  253,  254,  255,  256,  257,  258,  259,  521,  260,
  523,  273,  526,  531,  261,  262,  533,  263,  264,  265,
  266,  267,  250,  534,  359,  101,  268,  269,  270,   45,
  539,  542,  271,  251,  525,  544,  104,  244,  252,   82,
   24,   71,  113,  197,  530,  251,  281,  253,  254,  255,
  256,  257,  258,  259,  525,  260,  210,  336,  272,  530,
  261,  262,  436,  263,  264,  265,  266,  267,  221,  529,
  541,  494,  268,  269,  270,  281,  273,  472,  271,  540,
  524,  276,  415,  304,  516,   44,    0,  319,    0,  281,
    0,    0,    0,    0,    0,    0,    0,  281,    0,    0,
  281,  281,    0,    0,  272,    0,    0,    0,    0,  284,
    0,    0,    0,    0,    0,    0,    0,  281,  281,    0,
    0,    0,  273,    0,  165,    0,    0,    0,    0,    0,
    0,  284,    0,    0,  284,  284,    0,    0,    0,    0,
  281,    0,    0,  281,  281,  281,    0,    0,    0,    0,
    0,  284,  284,    0,  281,  281,  281,    0,    0,    0,
  281,  281,  281,  281,    0,    0,    0,  282,  281,  281,
  281,  281,  281,  281,  284,    0,    0,  284,  284,  284,
    0,    0,    0,    0,    0,    0,  281,  281,  284,  284,
  284,    0,  281,  281,  284,  284,  284,  284,  398,    0,
    0,    0,  284,  284,  284,  284,  284,  284,    0,  281,
    0,    0,  281,  281,    0,    0,    0,    0,    0,    0,
  284,  281,  349,    0,    0,    0,  284,  284,    0,  281,
  281,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  281,    0,    0,  281,  281,    0,    0,
    0,    0,  281,    0,    0,  281,  281,  281,  281,    0,
    0,    0,    0,    0,  281,    0,  281,  281,  281,    0,
    0,    0,  281,  281,  281,  281,    0,    0,    0,    0,
  281,  281,  281,  281,  281,  281,  281,    0,    0,  281,
  281,  281,    0,    0,    0,    0,    0,    0,  281,  285,
    0,  151,    0,    0,  281,  281,  281,  281,  281,  281,
    0,    0,    0,    0,  281,  281,  281,  281,  281,  281,
    0,  285,    0,    0,  285,  285,  152,  153,  154,    0,
    0,    0,  384,    0,    0,    0,    0,    0,  281,  281,
    0,    0,  285,  155,  156,  157,  158,    0,    0,    0,
    0,  159,  160,  161,  162,  163,  164,    0,    0,    0,
    0,    0,    0,    0,  285,    0,    0,  285,  285,  285,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  285,  285,  285,  285,    0,    0,
    0,    0,  285,  285,  285,  285,  285,  285,    0,  151,
  152,  385,  154,    0,  386,    0,  387,    0,  388,  389,
    0,  390,  391,  392,  393,  394,  285,  285,    0,    0,
  395,    0,    0,    0,  152,  153,  154,    0,    0,    0,
    0,    0,    0,  283,    0,    0,    0,    0,    0,  396,
  397,  155,  156,  157,  158,    0,    0,  151,    0,  159,
  160,  161,  162,  163,  164,    0,    0,    0,  283,  283,
  283,    0,    0,    0,    0,    0,    0,    0,  281,    0,
    0,    0,  152,  153,  154,  283,  283,  283,  283,    0,
    0,    0,    0,  283,  283,  283,  283,  283,  283,  155,
  156,  157,  158,  281,  281,  281,    0,  159,  160,  161,
  162,  163,  164,    0,    0,    0,    0,    0,    0,    0,
  281,  281,  281,  281,    0,    0,    0,    0,  281,  281,
  281,  281,  281,  281,
};
const short yycheck[] =
	{                                      13,
   18,   10,    4,  233,  128,  129,   10,  131,  132,   45,
   10,   43,   43,   45,   45,  123,   10,   43,  243,   45,
  123,   43,  232,   45,  123,  125,  386,  313,  405,   85,
  123,   10,   10,    3,  260,  225,  125,  260,  257,  125,
  119,  165,  125,   10,   44,  125,  257,  111,   10,  263,
   44,  265,  330,   55,  118,  315,  180,   10,   10,  171,
  279,   61,   10,  282,  283,   44,   44,   10,  279,  305,
  306,  282,  283,   10,  275,   61,   10,   44,   10,   10,
   50,   10,  334,   10,  148,  149,  100,   10,  275,  299,
   10,   44,  398,  266,  372,  373,  334,   10,  100,  374,
  273,   44,  262,  322,  228,  334,  374,  275,  234,  375,
  222,  322,   44,  303,  280,  239,   60,   61,   62,  320,
  321,  125,  374,  123,  142,  125,  375,  253,  254,  374,
  257,  125,  374,   61,  305,  306,  374,  123,  374,  291,
  400,  293,  294,  295,  123,  374,  125,  125,  375,  375,
  380,   10,  375,  530,   61,  374,  158,  257,  125,  257,
  374,  123,  374,  374,  257,  525,  290,  453,  378,  187,
  294,  361,  125,  125,   10,  343,  300,  125,  374,  279,
  304,  406,  282,  283,  308,  309,  279,  374,  125,  282,
  283,  125,  363,  272,  125,  123,  125,  374,  125,  255,
   61,  123,  125,   61,  510,  125,  374,  374,  374,  336,
  337,  338,  364,  365,   61,   10,  284,  374,  125,  266,
  267,  268,  322,  374,  375,  349,  276,  277,  366,  322,
  374,  299,  396,  397,  374,  375,  446,  319,  336,  337,
  338,  346,  347,  348,  349,  263,   10,   61,   10,  373,
  314,  269,  256,  271,  256,  320,  321,  257,  382,  263,
  374,  375,  264,   10,  234,  269,  374,  271,  272,  374,
  480,  374,  375,   10,  374,  374,  375,  281,  257,   10,
  359,  374,   10,  253,  254,  374,  375,  123,  374,  375,
   10,  374,  375,  457,  374,  459,  374,  375,   10,  299,
  360,  361,   10,  313,  314,   10,  516,  305,  306,  320,
  321,  374,  375,  299,  332,  333,  334,  335,   10,   10,
  338,  339,  374,  375,   10,  325,  326,  327,  123,  329,
  280,  331,  341,  333,  334,  371,  336,  337,  338,  339,
  340,  341,  336,  375,  375,  345,  325,  326,  327,  375,
  329,  375,  331,  375,  333,  334,  326,  336,  337,  338,
  339,  340,  341,  375,  364,  365,  345,   10,  368,  262,
  494,  299,  386,  278,  374,  375,  432,  433,  374,  375,
  374,  375,  368,  374,  508,  364,  365,  374,  374,  375,
  374,  409,  299,  395,   47,  374,  375,  256,  257,  258,
  259,   47,  261,  341,  263,  264,  265,  335,  374,  268,
  374,  375,  308,   10,  123,  274,   10,  125,  374,  375,
  279,  257,  281,  123,  368,  369,  370,  123,  367,  275,
  123,  375,  323,  324,  374,  125,  328,  296,  299,  374,
  368,  299,  456,  257,  374,  304,  374,  375,  307,  375,
  309,  310,  125,  125,  375,  125,  375,  316,  317,  318,
  290,  368,  257,  354,  294,  356,  374,  374,  375,  375,
  374,  374,  331,  332,  333,  375,  335,  375,  308,  309,
  374,  123,  125,  123,  374,  299,  345,  374,  502,  325,
  326,  327,  374,  329,  375,  331,  276,  333,  334,  358,
  336,  337,  338,  339,  340,  341,  375,  368,  375,  345,
  368,  525,  375,  374,  375,  374,  374,  375,  375,   61,
  375,  535,  336,  337,  338,  375,  375,  375,  364,  365,
  325,  326,  327,  374,  329,  336,  331,  374,  333,  334,
  374,  336,  337,  338,  339,  340,  341,  263,  256,   10,
  345,  259,  382,   61,  368,  374,  262,  375,  375,  374,
  374,  375,  270,  374,  374,  331,  374,  275,  312,  364,
  365,   10,   10,  375,  374,  374,  284,  285,  286,  287,
  288,  289,  290,  125,  292,   10,  125,  125,  375,  297,
  298,  374,  300,  301,  302,  303,  304,  291,  364,  365,
  125,  309,  310,  311,  125,  375,  336,  315,  374,  375,
  125,  125,  125,  256,  374,  374,  259,  374,   10,  375,
  375,  374,  374,  374,  374,   10,  375,  270,  362,  375,
  125,   61,  275,  341,  374,  374,  374,   10,   10,  374,
  470,  284,  285,  286,  287,  288,  289,  290,  374,  292,
  375,  359,  125,  125,  297,  298,  125,  300,  301,  302,
  303,  304,  259,  374,  494,  280,  309,  310,  311,   10,
  374,  374,  315,  270,  504,  374,  123,   10,  275,   10,
   10,   10,   10,  125,  514,  374,  374,  284,  285,  286,
  287,  288,  289,  290,  524,  292,  125,  260,  341,  529,
  297,  298,  353,  300,  301,  302,  303,  304,  166,  512,
  537,  434,  309,  310,  311,  257,  359,  400,  315,  535,
  502,  192,  318,  230,  478,    1,   -1,  247,   -1,  125,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,   -1,
  282,  283,   -1,   -1,  341,   -1,   -1,   -1,   -1,  257,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,  300,   -1,
   -1,   -1,  359,   -1,  123,   -1,   -1,   -1,   -1,   -1,
   -1,  279,   -1,   -1,  282,  283,   -1,   -1,   -1,   -1,
  322,   -1,   -1,  325,  326,  327,   -1,   -1,   -1,   -1,
   -1,  299,  300,   -1,  336,  337,  338,   -1,   -1,   -1,
  342,  343,  344,  345,   -1,   -1,   -1,  125,  350,  351,
  352,  353,  354,  355,  322,   -1,   -1,  325,  326,  327,
   -1,   -1,   -1,   -1,   -1,   -1,  368,  257,  336,  337,
  338,   -1,  374,  375,  342,  343,  344,  345,  123,   -1,
   -1,   -1,  350,  351,  352,  353,  354,  355,   -1,  279,
   -1,   -1,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1,
  368,  257,  123,   -1,   -1,   -1,  374,  375,   -1,  299,
  300,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  279,   -1,   -1,  282,  283,   -1,   -1,
   -1,   -1,  322,   -1,   -1,  325,  326,  327,  125,   -1,
   -1,   -1,   -1,   -1,  300,   -1,  336,  337,  338,   -1,
   -1,   -1,  342,  343,  344,  345,   -1,   -1,   -1,   -1,
  350,  351,  352,  353,  354,  355,  322,   -1,   -1,  325,
  326,  327,   -1,   -1,   -1,   -1,   -1,   -1,  368,  257,
   -1,  300,   -1,   -1,  374,  375,  342,  343,  344,  345,
   -1,   -1,   -1,   -1,  350,  351,  352,  353,  354,  355,
   -1,  279,   -1,   -1,  282,  283,  325,  326,  327,   -1,
   -1,   -1,  257,   -1,   -1,   -1,   -1,   -1,  374,  375,
   -1,   -1,  300,  342,  343,  344,  345,   -1,   -1,   -1,
   -1,  350,  351,  352,  353,  354,  355,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  322,   -1,   -1,  325,  326,  327,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  342,  343,  344,  345,   -1,   -1,
   -1,   -1,  350,  351,  352,  353,  354,  355,   -1,  300,
  325,  326,  327,   -1,  329,   -1,  331,   -1,  333,  334,
   -1,  336,  337,  338,  339,  340,  374,  375,   -1,   -1,
  345,   -1,   -1,   -1,  325,  326,  327,   -1,   -1,   -1,
   -1,   -1,   -1,  300,   -1,   -1,   -1,   -1,   -1,  364,
  365,  342,  343,  344,  345,   -1,   -1,  300,   -1,  350,
  351,  352,  353,  354,  355,   -1,   -1,   -1,  325,  326,
  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  325,  326,  327,  342,  343,  344,  345,   -1,
   -1,   -1,   -1,  350,  351,  352,  353,  354,  355,  342,
  343,  344,  345,  325,  326,  327,   -1,  350,  351,  352,
  353,  354,  355,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  342,  343,  344,  345,   -1,   -1,   -1,   -1,  350,  351,
  352,  353,  354,  355,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 375
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,"'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,0,0,"'<'",
"'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,"AS","ROUTERID","HOLDTIME","YMIN","LISTEN","ON","FIBUPDATE",
"FIBPRIORITY","RTABLE","NONE","UNICAST","VPN","RD","EXPORT","EXPORTTRGT",
"IMPORTTRGT","DEFAULTROUTE","RDE","RIB","EVALUATE","IGNORE","COMPARE","GROUP",
"NEIGHBOR","NETWORK","EBGP","IBGP","LOCALAS","REMOTEAS","DESCR","LOCALADDR",
"MULTIHOP","PASSIVE","MAXPREFIX","RESTART","ANNOUNCE","CAPABILITIES","REFRESH",
"AS4BYTE","CONNECTRETRY","DEMOTE","ENFORCE","NEIGHBORAS","ASOVERRIDE",
"REFLECTOR","DEPEND","DOWN","DUMP","IN","OUT","SOCKET","RESTRICTED","LOG",
"TRANSPARENT","TCP","MD5SIG","PASSWORD","KEY","TTLSECURITY","ALLOW","DENY",
"MATCH","QUICK","FROM","TO","ANY","CONNECTED","STATIC","COMMUNITY",
"EXTCOMMUNITY","LARGECOMMUNITY","DELETE","PREFIX","PREFIXLEN","PREFIXSET",
"ROASET","ORIGINSET","OVS","ASSET","SOURCEAS","TRANSITAS","PEERAS","MAXASLEN",
"MAXASSEQ","SET","LOCALPREF","MED","METRIC","NEXTHOP","REJECT","BLACKHOLE",
"NOMODIFY","SELF","PREPEND_SELF","PREPEND_PEER","PFTABLE","WEIGHT","RTLABEL",
"ORIGIN","PRIORITY","ERROR","INCLUDE","IPSEC","ESP","AH","SPI","IKE","IPV4",
"IPV6","QUALIFY","VIA","NE","LE","GE","XRANGE","LONGER","MAXLEN","STRING",
"NUMBER",
};
const char * const yyrule[] =
	{"$accept : grammar",
"grammar :",
"grammar : grammar '\\n'",
"grammar : grammar varset '\\n'",
"grammar : grammar include '\\n'",
"grammar : grammar as_set '\\n'",
"grammar : grammar prefixset '\\n'",
"grammar : grammar roa_set '\\n'",
"grammar : grammar origin_set '\\n'",
"grammar : grammar rib '\\n'",
"grammar : grammar conf_main '\\n'",
"grammar : grammar l3vpn '\\n'",
"grammar : grammar neighbor '\\n'",
"grammar : grammar group '\\n'",
"grammar : grammar filterrule '\\n'",
"grammar : grammar error '\\n'",
"asnumber : NUMBER",
"as4number : STRING",
"as4number : asnumber",
"as4number_any : STRING",
"as4number_any : asnumber",
"string : string STRING",
"string : STRING",
"yesno : STRING",
"varset : STRING '=' string",
"include : INCLUDE STRING",
"$$1 :",
"as_set : ASSET STRING '{' optnl $$1 as_set_l optnl '}'",
"as_set : ASSET STRING '{' optnl '}'",
"as_set_l : as4number_any",
"as_set_l : as_set_l comma as4number_any",
"$$2 :",
"prefixset : PREFIXSET STRING '{' optnl $$2 prefixset_l optnl '}'",
"prefixset : PREFIXSET STRING '{' optnl '}'",
"prefixset_l : prefixset_item",
"prefixset_l : prefixset_l comma prefixset_item",
"prefixset_item : prefix prefixlenop",
"$$3 :",
"roa_set : ROASET '{' optnl $$3 roa_set_l optnl '}'",
"roa_set : ROASET '{' optnl '}'",
"$$4 :",
"origin_set : ORIGINSET STRING '{' optnl $$4 roa_set_l optnl '}'",
"origin_set : ORIGINSET STRING '{' optnl '}'",
"roa_set_l : prefixset_item SOURCEAS as4number_any",
"roa_set_l : roa_set_l comma prefixset_item SOURCEAS as4number_any",
"conf_main : AS as4number",
"conf_main : AS as4number asnumber",
"conf_main : ROUTERID address",
"conf_main : HOLDTIME NUMBER",
"conf_main : HOLDTIME YMIN NUMBER",
"conf_main : LISTEN ON address",
"conf_main : FIBPRIORITY NUMBER",
"conf_main : FIBUPDATE yesno",
"conf_main : TRANSPARENT yesno",
"conf_main : LOG STRING",
"conf_main : network",
"conf_main : DUMP STRING STRING optnumber",
"conf_main : DUMP RIB STRING STRING STRING optnumber",
"conf_main : mrtdump",
"conf_main : RDE STRING EVALUATE",
"conf_main : RDE STRING IGNORE",
"conf_main : RDE MED COMPARE STRING",
"conf_main : NEXTHOP QUALIFY VIA STRING",
"conf_main : RTABLE NUMBER",
"conf_main : CONNECTRETRY NUMBER",
"conf_main : SOCKET STRING restricted",
"$$5 :",
"rib : RDE RIB STRING $$5 ribopts",
"ribopts : fibupdate",
"ribopts : RTABLE NUMBER fibupdate",
"ribopts : yesno EVALUATE",
"fibupdate :",
"fibupdate : FIBUPDATE yesno",
"mrtdump : DUMP STRING inout STRING optnumber",
"network : NETWORK prefix filter_set",
"network : NETWORK PREFIXSET STRING filter_set",
"network : NETWORK family RTLABEL STRING filter_set",
"network : NETWORK family PRIORITY NUMBER filter_set",
"network : NETWORK family nettype filter_set",
"inout : IN",
"inout : OUT",
"restricted : RESTRICTED",
"restricted :",
"address : STRING",
"prefix : STRING '/' NUMBER",
"prefix : NUMBER '/' NUMBER",
"addrspec : address",
"addrspec : prefix",
"optnumber :",
"optnumber : NUMBER",
"$$6 :",
"l3vpn : VPN STRING ON STRING $$6 '{' l3vpnopts_l '}'",
"l3vpnopts_l :",
"l3vpnopts_l : l3vpnopts_l '\\n'",
"l3vpnopts_l : l3vpnopts_l l3vpnopts '\\n'",
"l3vpnopts_l : l3vpnopts_l error '\\n'",
"l3vpnopts : RD STRING",
"l3vpnopts : EXPORTTRGT STRING STRING",
"l3vpnopts : IMPORTTRGT STRING STRING",
"l3vpnopts : FIBUPDATE yesno",
"l3vpnopts : network",
"$$7 :",
"$$8 :",
"neighbor : $$7 NEIGHBOR addrspec $$8 peeropts_h",
"$$9 :",
"group : GROUP string $$9 '{' groupopts_l '}'",
"groupopts_l :",
"groupopts_l : groupopts_l '\\n'",
"groupopts_l : groupopts_l peeropts '\\n'",
"groupopts_l : groupopts_l neighbor '\\n'",
"groupopts_l : groupopts_l error '\\n'",
"peeropts_h : '{' '\\n' peeropts_l '}'",
"peeropts_h : '{' peeropts '}'",
"peeropts_h :",
"peeropts_l :",
"peeropts_l : peeropts_l '\\n'",
"peeropts_l : peeropts_l peeropts '\\n'",
"peeropts_l : peeropts_l error '\\n'",
"peeropts : REMOTEAS as4number",
"peeropts : LOCALAS as4number",
"peeropts : LOCALAS as4number asnumber",
"peeropts : DESCR string",
"peeropts : LOCALADDR address",
"peeropts : MULTIHOP NUMBER",
"peeropts : PASSIVE",
"peeropts : DOWN",
"peeropts : DOWN STRING",
"peeropts : RIB STRING",
"peeropts : HOLDTIME NUMBER",
"peeropts : HOLDTIME YMIN NUMBER",
"peeropts : ANNOUNCE family safi",
"peeropts : ANNOUNCE CAPABILITIES yesno",
"peeropts : ANNOUNCE REFRESH yesno",
"peeropts : ANNOUNCE RESTART yesno",
"peeropts : ANNOUNCE AS4BYTE yesno",
"peeropts : EXPORT NONE",
"peeropts : EXPORT DEFAULTROUTE",
"peeropts : ENFORCE NEIGHBORAS yesno",
"peeropts : ENFORCE LOCALAS yesno",
"peeropts : ASOVERRIDE yesno",
"peeropts : MAXPREFIX NUMBER restart",
"peeropts : TCP MD5SIG PASSWORD string",
"peeropts : TCP MD5SIG KEY string",
"peeropts : IPSEC espah IKE",
"peeropts : IPSEC espah inout SPI NUMBER STRING STRING encspec",
"peeropts : TTLSECURITY yesno",
"peeropts : SET filter_set_opt",
"peeropts : SET '{' optnl filter_set_l optnl '}'",
"peeropts : mrtdump",
"peeropts : REFLECTOR",
"peeropts : REFLECTOR address",
"peeropts : DEPEND ON STRING",
"peeropts : DEMOTE STRING",
"peeropts : TRANSPARENT yesno",
"peeropts : LOG STRING",
"restart :",
"restart : RESTART NUMBER",
"family : IPV4",
"family : IPV6",
"safi : NONE",
"safi : UNICAST",
"safi : VPN",
"nettype : STATIC",
"nettype : CONNECTED",
"espah : ESP",
"espah : AH",
"encspec :",
"encspec : STRING STRING",
"filterrule : action quick filter_rib_h direction filter_peer_h filter_match_h filter_set",
"action : ALLOW",
"action : DENY",
"action : MATCH",
"quick :",
"quick : QUICK",
"direction : FROM",
"direction : TO",
"filter_rib_h :",
"filter_rib_h : RIB filter_rib",
"filter_rib_h : RIB '{' optnl filter_rib_l optnl '}'",
"filter_rib_l : filter_rib",
"filter_rib_l : filter_rib_l comma filter_rib",
"filter_rib : STRING",
"filter_peer_h : filter_peer",
"filter_peer_h : '{' optnl filter_peer_l optnl '}'",
"filter_peer_l : filter_peer",
"filter_peer_l : filter_peer_l comma filter_peer",
"filter_peer : ANY",
"filter_peer : address",
"filter_peer : AS as4number",
"filter_peer : GROUP STRING",
"filter_peer : EBGP",
"filter_peer : IBGP",
"filter_prefix_h : IPV4 prefixlenop",
"filter_prefix_h : IPV6 prefixlenop",
"filter_prefix_h : PREFIX filter_prefix",
"filter_prefix_h : PREFIX '{' filter_prefix_m '}'",
"filter_prefix_m : filter_prefix_l",
"filter_prefix_m : '{' filter_prefix_l '}'",
"filter_prefix_m : '{' filter_prefix_l '}' filter_prefix_m",
"filter_prefix_l : filter_prefix",
"filter_prefix_l : filter_prefix_l comma filter_prefix",
"filter_prefix : prefix prefixlenop",
"filter_as_h : filter_as_t",
"filter_as_h : '{' filter_as_t_l '}'",
"filter_as_t_l : filter_as_t",
"filter_as_t_l : filter_as_t_l comma filter_as_t",
"filter_as_t : filter_as_type filter_as",
"filter_as_t : filter_as_type '{' filter_as_l_h '}'",
"filter_as_t : filter_as_type ASSET STRING",
"filter_as_l_h : filter_as_l",
"filter_as_l_h : '{' filter_as_l '}'",
"filter_as_l_h : '{' filter_as_l '}' filter_as_l_h",
"filter_as_l : filter_as",
"filter_as_l : filter_as_l comma filter_as",
"filter_as : as4number_any",
"filter_as : NEIGHBORAS",
"filter_as : equalityop as4number_any",
"filter_as : as4number_any binaryop as4number_any",
"filter_match_h :",
"$$10 :",
"filter_match_h : $$10 filter_match",
"filter_match : filter_elm",
"filter_match : filter_match filter_elm",
"filter_elm : filter_prefix_h",
"filter_elm : filter_as_h",
"filter_elm : MAXASLEN NUMBER",
"filter_elm : MAXASSEQ NUMBER",
"filter_elm : community STRING",
"filter_elm : EXTCOMMUNITY STRING STRING",
"filter_elm : EXTCOMMUNITY OVS STRING",
"filter_elm : NEXTHOP address",
"filter_elm : NEXTHOP NEIGHBOR",
"filter_elm : PREFIXSET STRING prefixlenop",
"filter_elm : ORIGINSET STRING",
"filter_elm : OVS validity",
"prefixlenop :",
"prefixlenop : LONGER",
"prefixlenop : MAXLEN NUMBER",
"prefixlenop : PREFIXLEN unaryop NUMBER",
"prefixlenop : PREFIXLEN NUMBER binaryop NUMBER",
"filter_as_type : AS",
"filter_as_type : SOURCEAS",
"filter_as_type : TRANSITAS",
"filter_as_type : PEERAS",
"filter_set :",
"filter_set : SET filter_set_opt",
"filter_set : SET '{' optnl filter_set_l optnl '}'",
"filter_set_l : filter_set_l comma filter_set_opt",
"filter_set_l : filter_set_opt",
"community : COMMUNITY",
"community : LARGECOMMUNITY",
"delete :",
"delete : DELETE",
"filter_set_opt : LOCALPREF NUMBER",
"filter_set_opt : LOCALPREF '+' NUMBER",
"filter_set_opt : LOCALPREF '-' NUMBER",
"filter_set_opt : MED NUMBER",
"filter_set_opt : MED '+' NUMBER",
"filter_set_opt : MED '-' NUMBER",
"filter_set_opt : METRIC NUMBER",
"filter_set_opt : METRIC '+' NUMBER",
"filter_set_opt : METRIC '-' NUMBER",
"filter_set_opt : WEIGHT NUMBER",
"filter_set_opt : WEIGHT '+' NUMBER",
"filter_set_opt : WEIGHT '-' NUMBER",
"filter_set_opt : NEXTHOP address",
"filter_set_opt : NEXTHOP BLACKHOLE",
"filter_set_opt : NEXTHOP REJECT",
"filter_set_opt : NEXTHOP NOMODIFY",
"filter_set_opt : NEXTHOP SELF",
"filter_set_opt : PREPEND_SELF NUMBER",
"filter_set_opt : PREPEND_PEER NUMBER",
"filter_set_opt : ASOVERRIDE",
"filter_set_opt : PFTABLE STRING",
"filter_set_opt : RTLABEL STRING",
"filter_set_opt : community delete STRING",
"filter_set_opt : EXTCOMMUNITY delete STRING STRING",
"filter_set_opt : EXTCOMMUNITY delete OVS STRING",
"filter_set_opt : ORIGIN origincode",
"origincode : STRING",
"validity : STRING",
"optnl :",
"optnl : '\\n' optnl",
"comma :",
"comma : ','",
"comma : '\\n' optnl",
"comma : ',' '\\n' optnl",
"unaryop : '='",
"unaryop : NE",
"unaryop : LE",
"unaryop : '<'",
"unaryop : GE",
"unaryop : '>'",
"equalityop : '='",
"equalityop : NE",
"binaryop : '-'",
"binaryop : XRANGE",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
int yyparse(void);
#line 2719 "parse.y"

struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*msg;

	file->errors++;
	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1)
		fatalx("yyerror vasprintf");
	va_end(ap);
	logit(LOG_CRIT, "%s:%d: %s", file->name, yylval.lineno, msg);
	free(msg);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* this has to be sorted always */
	static const struct keywords keywords[] = {
		{ "AS",			AS},
		{ "IPv4",		IPV4},
		{ "IPv6",		IPV6},
		{ "ah",			AH},
		{ "allow",		ALLOW},
		{ "announce",		ANNOUNCE},
		{ "any",		ANY},
		{ "as-4byte",		AS4BYTE },
		{ "as-override",	ASOVERRIDE},
		{ "as-set",		ASSET },
		{ "blackhole",		BLACKHOLE},
		{ "capabilities",	CAPABILITIES},
		{ "community",		COMMUNITY},
		{ "compare",		COMPARE},
		{ "connect-retry",	CONNECTRETRY},
		{ "connected",		CONNECTED},
		{ "default-route",	DEFAULTROUTE},
		{ "delete",		DELETE},
		{ "demote",		DEMOTE},
		{ "deny",		DENY},
		{ "depend",		DEPEND},
		{ "descr",		DESCR},
		{ "down",		DOWN},
		{ "dump",		DUMP},
		{ "ebgp",		EBGP},
		{ "enforce",		ENFORCE},
		{ "esp",		ESP},
		{ "evaluate",		EVALUATE},
		{ "export",		EXPORT},
		{ "export-target",	EXPORTTRGT},
		{ "ext-community",	EXTCOMMUNITY},
		{ "fib-priority",	FIBPRIORITY},
		{ "fib-update",		FIBUPDATE},
		{ "from",		FROM},
		{ "group",		GROUP},
		{ "holdtime",		HOLDTIME},
		{ "ibgp",		IBGP},
		{ "ignore",		IGNORE},
		{ "ike",		IKE},
		{ "import-target",	IMPORTTRGT},
		{ "in",			IN},
		{ "include",		INCLUDE},
		{ "inet",		IPV4},
		{ "inet6",		IPV6},
		{ "ipsec",		IPSEC},
		{ "key",		KEY},
		{ "large-community",	LARGECOMMUNITY},
		{ "listen",		LISTEN},
		{ "local-address",	LOCALADDR},
		{ "local-as",		LOCALAS},
		{ "localpref",		LOCALPREF},
		{ "log",		LOG},
		{ "match",		MATCH},
		{ "max-as-len",		MAXASLEN},
		{ "max-as-seq",		MAXASSEQ},
		{ "max-prefix",		MAXPREFIX},
		{ "maxlen",		MAXLEN},
		{ "md5sig",		MD5SIG},
		{ "med",		MED},
		{ "metric",		METRIC},
		{ "min",		YMIN},
		{ "multihop",		MULTIHOP},
		{ "neighbor",		NEIGHBOR},
		{ "neighbor-as",	NEIGHBORAS},
		{ "network",		NETWORK},
		{ "nexthop",		NEXTHOP},
		{ "no-modify",		NOMODIFY},
		{ "none",		NONE},
		{ "on",			ON},
		{ "or-longer",		LONGER},
		{ "origin",		ORIGIN},
		{ "origin-set",		ORIGINSET},
		{ "out",		OUT},
		{ "ovs",		OVS},
		{ "passive",		PASSIVE},
		{ "password",		PASSWORD},
		{ "peer-as",		PEERAS},
		{ "pftable",		PFTABLE},
		{ "prefix",		PREFIX},
		{ "prefix-set",		PREFIXSET},
		{ "prefixlen",		PREFIXLEN},
		{ "prepend-neighbor",	PREPEND_PEER},
		{ "prepend-self",	PREPEND_SELF},
		{ "priority",		PRIORITY},
		{ "qualify",		QUALIFY},
		{ "quick",		QUICK},
		{ "rd",			RD},
		{ "rde",		RDE},
		{ "refresh",		REFRESH },
		{ "reject",		REJECT},
		{ "remote-as",		REMOTEAS},
		{ "restart",		RESTART},
		{ "restricted",		RESTRICTED},
		{ "rib",		RIB},
		{ "roa-set",		ROASET },
		{ "route-reflector",	REFLECTOR},
		{ "router-id",		ROUTERID},
		{ "rtable",		RTABLE},
		{ "rtlabel",		RTLABEL},
		{ "self",		SELF},
		{ "set",		SET},
		{ "socket",		SOCKET },
		{ "source-as",		SOURCEAS},
		{ "spi",		SPI},
		{ "static",		STATIC},
		{ "tcp",		TCP},
		{ "to",			TO},
		{ "transit-as",		TRANSITAS},
		{ "transparent-as",	TRANSPARENT},
		{ "ttl-security",	TTLSECURITY},
		{ "unicast",		UNICAST},
		{ "via",		VIA},
		{ "vpn",		VPN},
		{ "weight",		WEIGHT}
	};
	const struct keywords	*p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return (c);
}

int
lgetc(int quotec)
{
	int		c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return (EOF);
			return (quotec);
		}
		return (c);
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return ('\n');
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return (EOF);
			c = igetc();
		}
	}
	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			err(1, "lungetc");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* skip to either EOF or the first real EOL */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
yylex(void)
{
	u_char	 buf[8096];
	u_char	*p, *val;
	int	 quotec, next, c;
	int	 token;

top:
	p = buf;
	while ((c = lgetc(0)) == ' ' || c == '\t')
		; /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#')
		while ((c = lgetc(0)) != '\n' && c != EOF)
			; /* nothing */
	if (c == '$' && !expanding) {
		while (1) {
			if ((c = lgetc(0)) == EOF)
				return (0);

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro '%s' not defined", buf);
			return (findeol());
		}
		p = val + strlen(val) - 1;
		lungetc(DONE_EXPAND);
		while (p >= val) {
			lungetc(*p);
			p--;
		}
		lungetc(START_EXPAND);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			if ((c = lgetc(quotec)) == EOF)
				return (0);
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				if ((next = lgetc(quotec)) == EOF)
					return (0);
				if (next == quotec || next == ' ' ||
				    next == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("syntax error: unterminated quote");
				return (findeol());
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			fatal("yylex: strdup");
		return (STRING);
	case '!':
		next = lgetc(0);
		if (next == '=')
			return (NE);
		lungetc(next);
		break;
	case '<':
		next = lgetc(0);
		if (next == '=')
			return (LE);
		lungetc(next);
		break;
	case '>':
		next = lgetc(0);
		if (next == '<')
			return (XRANGE);
		else if (next == '=')
			return (GE);
		lungetc(next);
		break;
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return (findeol());
			}
			return (NUMBER);
		} else {
nodigits:
			while (p > buf + 1)
				lungetc(*--p);
			c = *--p;
			if (c == '-')
				return (c);
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && x != '<' && x != '>' && \
	x != '!' && x != '=' && x != '/' && x != '#' && \
	x != ','))

	if (isalnum(c) || c == ':' || c == '_' || c == '*') {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		if ((token = lookup(buf)) == STRING)
			if ((yylval.v.string = strdup(buf)) == NULL)
				fatal("yylex: strdup");
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

int
check_file_secrecy(int fd, const char *fname)
{
	struct stat	st;

	if (fstat(fd, &st)) {
		log_warn("cannot stat %s", fname);
		return (-1);
	}
	return (0);
}

struct file *
pushfile(const char *name, int secret)
{
	struct file	*nfile;

	if ((nfile = calloc(1, sizeof(struct file))) == NULL) {
		log_warn("%s", __func__);
		return (NULL);
	}
	if ((nfile->name = strdup(name)) == NULL) {
		log_warn("%s", __func__);
		free(nfile);
		return (NULL);
	}
	if ((nfile->stream = fopen(nfile->name, "r")) == NULL) {
		log_warn("%s: %s", __func__, nfile->name);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	if (secret &&
	    check_file_secrecy(fileno(nfile->stream), nfile->name)) {
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = malloc(nfile->ungetsize);
	if (nfile->ungetbuf == NULL) {
		log_warn("%s", __func__);
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return (nfile);
}

int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return (file ? 0 : EOF);
}

static void
init_config(struct bgpd_config *c)
{
	u_int rdomid;

	c->min_holdtime = MIN_HOLDTIME;
	c->holdtime = INTERVAL_HOLD;
	c->connectretry = INTERVAL_CONNECTRETRY;
	c->bgpid = get_bgpid();
	c->fib_priority = RTP_BGP;
	c->default_tableid = getrtable();
	ktable_exists(c->default_tableid, &rdomid);
	if (rdomid != c->default_tableid)
		fatalx("current routing table %u is not a routing domain",
		    c->default_tableid);

	if (asprintf(&c->csock, "%s.%d", SOCKET_NAME, c->default_tableid) == -1)
		fatal(NULL);
}

struct bgpd_config *
parse_config(char *filename, struct peer_head *ph)
{
	struct sym		*sym, *next;
	struct rde_rib		*rr;
	struct network		*n;
	int			 errors = 0;

	conf = new_config();
	init_config(conf);

	if ((filter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((peerfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((groupfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	TAILQ_INIT(filter_l);
	TAILQ_INIT(peerfilter_l);
	TAILQ_INIT(groupfilter_l);

	curpeer = NULL;
	curgroup = NULL;

	cur_peers = ph;
	new_peers = &conf->peers;
	netconf = &conf->networks;

	if ((rr = add_rib("Adj-RIB-In")) == NULL)
		fatal("add_rib failed");
	rr->flags = F_RIB_NOFIB | F_RIB_NOEVALUATE;
	if ((rr = add_rib("Loc-RIB")) == NULL)
		fatal("add_rib failed");
	rib_add_fib(rr, conf->default_tableid);
	rr->flags = F_RIB_LOCAL;

	if ((file = pushfile(filename, 1)) == NULL)
		goto errors;
	topfile = file;

	yyparse();
	errors = file->errors;
	popfile();

	/* check that we dont try to announce our own routes */
	TAILQ_FOREACH(n, netconf, entry)
	    if (n->net.priority == conf->fib_priority) {
		    errors++;
		    logit(LOG_CRIT, "network priority %d == fib-priority "
			"%d is not allowed.",
			n->net.priority, conf->fib_priority);
	    }

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		if ((cmd_opts & BGPD_OPT_VERBOSE2) && !sym->used)
			fprintf(stderr, "warning: macro \"%s\" not "
			    "used\n", sym->nam);
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (!conf->as) {
		log_warnx("configuration error: AS not given");
		errors++;
	}

	/* clear the globals */
	curpeer = NULL;
	curgroup = NULL;
	cur_peers = NULL;
	new_peers = NULL;
	netconf = NULL;

	if (errors) {
errors:
		while ((rr = SIMPLEQ_FIRST(&ribnames)) != NULL) {
			SIMPLEQ_REMOVE_HEAD(&ribnames, entry);
			free(rr);
		}

		filterlist_free(filter_l);
		filterlist_free(peerfilter_l);
		filterlist_free(groupfilter_l);

		free_config(conf);
		return (NULL);
	} else {
		/* update clusterid in case it was not set explicitly */
		if ((conf->flags & BGPD_FLAG_REFLECTOR) && conf->clusterid == 0)
			conf->clusterid = conf->bgpid;

		/*
		 * Concatenate filter list and static group and peer filtersets
		 * together. Static group sets come first then peer sets
		 * last normal filter rules.
		 */
		TAILQ_CONCAT(conf->filters, groupfilter_l, entry);
		TAILQ_CONCAT(conf->filters, peerfilter_l, entry);
		TAILQ_CONCAT(conf->filters, filter_l, entry);

		optimize_filters(conf->filters);

		free(filter_l);
		free(peerfilter_l);
		free(groupfilter_l);

		return (conf);
	}
}

int
symset(const char *nam, const char *val, int persist)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0)
			break;
	}

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	if ((sym = calloc(1, sizeof(*sym))) == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	ret;

	if ((val = strrchr(s, '=')) == NULL)
		return (-1);
	sym = strndup(s, val - s);
	if (sym == NULL)
		fatal("%s: strndup", __func__);
	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	}
	return (NULL);
}

static int
getcommunity(char *s, int large, u_int32_t *val, u_int32_t *flag)
{
	long long	 max = USHRT_MAX;
	const char	*errstr;

	*flag = 0;
	*val = 0;
	if (strcmp(s, "*") == 0) {
		*flag = COMMUNITY_ANY;
		return 0;
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		return 0;
	} else if (strcmp(s, "local-as") == 0) {
		*flag =  COMMUNITY_LOCAL_AS;
		return 0;
	}
	if (large)
		max = UINT_MAX;
	*val = strtonum(s, 0, max, &errstr);
	if (errstr) {
		yyerror("Community %s is %s (max: %lld)", s, errstr, max);
		return -1;
	}
	return 0;
}

static void
setcommunity(struct community *c, u_int32_t as, u_int32_t data,
    u_int32_t asflag, u_int32_t dataflag)
{
	c->flags = COMMUNITY_TYPE_BASIC;
	c->flags |= asflag << 8;
	c->flags |= dataflag << 16;
	c->data1 = as;
	c->data2 = data;
	c->data3 = 0;
}

static int
parselargecommunity(struct community *c, char *s)
{
	char *p, *q;
	u_int32_t dflag1, dflag2, dflag3;

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if ((q = strchr(p, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*q++ = 0;

	if (getcommunity(s, 1, &c->data1, &dflag1) == -1 ||
	    getcommunity(p, 1, &c->data2, &dflag2) == -1 ||
	    getcommunity(q, 1, &c->data3, &dflag3) == -1)
		return (-1);
	c->flags = COMMUNITY_TYPE_LARGE;
	c->flags |= dflag1 << 8;;
	c->flags |= dflag2 << 16;;
	c->flags |= dflag3 << 24;;
	return (0);
}

int
parsecommunity(struct community *c, int type, char *s)
{
	char *p;
	u_int32_t as, data, asflag, dataflag;

	if (type == COMMUNITY_TYPE_LARGE)
		return parselargecommunity(c, s);

	/* Well-known communities */
	if (strcasecmp(s, "GRACEFUL_SHUTDOWN") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_GRACEFUL_SHUTDOWN, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPORT, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_ADVERTISE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_ADVERTISE, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT_SUBCONFED") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPSUBCONFED, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_PEER") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_PEER, 0, 0);
		return (0);
	} else if (strcasecmp(s, "BLACKHOLE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_BLACKHOLE, 0, 0);
		return (0);
	}

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if (getcommunity(s, 0, &as, &asflag) == -1 ||
	    getcommunity(p, 0, &data, &dataflag) == -1)
		return (-1);
	setcommunity(c, as, data, asflag, dataflag);
	return (0);
}

static int
parsesubtype(char *name, int *type, int *subtype)
{
	const struct ext_comm_pairs *cp;
	int found = 0;

	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (strcmp(name, cp->subname) == 0) {
			if (found == 0) {
				*type = cp->type;
				*subtype = cp->subtype;
			}
			found++;
		}
	}
	if (found > 1)
		*type = -1;
	return (found);
}

static int
parseextvalue(int type, char *s, u_int32_t *v, u_int32_t *flag)
{
	const char	*errstr;
	char		*p;
	struct in_addr	 ip;
	u_int32_t	 uvalh, uval;

	if (type != -1) {
		/* nothing */
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if (strcmp(s, "local-as") == 0) {
		*flag = COMMUNITY_LOCAL_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if ((p = strchr(s, '.')) == NULL) {
		/* AS_PLAIN number (4 or 2 byte) */
		strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr == NULL)
			type = EXT_COMMUNITY_TRANS_TWO_AS;
		else
			type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if (strchr(p + 1, '.') == NULL) {
		/* AS_DOT number (4-byte) */
		type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else {
		/* more than one dot -> IP address */
		type = EXT_COMMUNITY_TRANS_IPV4;
	}

	switch (type) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
		uval = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		*v = uval;
		break;
	case EXT_COMMUNITY_TRANS_FOUR_AS:
		if ((p = strchr(s, '.')) == NULL) {
			uval = strtonum(s, 0, UINT_MAX, &errstr);
			if (errstr) {
				yyerror("Bad ext-community %s is %s", s,
				    errstr);
				return (-1);
			}
			*v = uval;
			break;
		}
		*p++ = '\0';
		uvalh = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		uval = strtonum(p, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", p, errstr);
			return (-1);
		}
		*v = uval | (uvalh << 16);
		break;
	case EXT_COMMUNITY_TRANS_IPV4:
		if (inet_aton(s, &ip) == 0) {
			yyerror("Bad ext-community %s not parseable", s);
			return (-1);
		}
		*v = ntohl(ip.s_addr);
		break;
	default:
		fatalx("%s: unexpected type %d", __func__, type);
	}
	return (type);
}

int
parseextcommunity(struct community *c, char *t, char *s)
{
	const struct ext_comm_pairs *cp;
	char		*p, *ep;
	u_int64_t	 ullval;
	u_int32_t	 uval, uval2, dflag1 = 0, dflag2 = 0;
	int		 type = 0, subtype = 0;

	if (strcmp(t, "*") == 0 && strcmp(s, "*") == 0) {
		c->flags = COMMUNITY_TYPE_EXT;
		c->flags |= COMMUNITY_ANY << 24;
		return (0);
	}
	if (parsesubtype(t, &type, &subtype) == 0) {
		yyerror("Bad ext-community unknown type");
		return (-1);
	}

	switch (type) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
	case EXT_COMMUNITY_TRANS_FOUR_AS:
	case EXT_COMMUNITY_TRANS_IPV4:
	case -1:
		if (strcmp(s, "*") == 0) {
			dflag1 = COMMUNITY_ANY;
			break;
		}
		if ((p = strchr(s, ':')) == NULL) {
			yyerror("Bad ext-community %s", s);
			return (-1);
		}
		*p++ = '\0';
		if ((type = parseextvalue(type, s, &uval, &dflag1)) == -1)
			return (-1);

		switch (type) {
		case EXT_COMMUNITY_TRANS_TWO_AS:
			if (getcommunity(p, 1, &uval2, &dflag2) == -1)
				return (-1);
			break;
		case EXT_COMMUNITY_TRANS_IPV4:
		case EXT_COMMUNITY_TRANS_FOUR_AS:
			if (getcommunity(p, 0, &uval2, &dflag2) == -1)
				return (-1);
			break;
		default:
			fatalx("parseextcommunity: unexpected result");
		}

		c->data1 = uval;
		c->data2 = uval2;
		break;
	case EXT_COMMUNITY_TRANS_OPAQUE:
	case EXT_COMMUNITY_TRANS_EVPN:
		if (strcmp(s, "*") == 0) {
			dflag1 = COMMUNITY_ANY;
			break;
		}
		errno = 0;
		ullval = strtoull(s, &ep, 0);
		if (s[0] == '\0' || *ep != '\0') {
			yyerror("Bad ext-community bad value");
			return (-1);
		}
		if (errno == ERANGE && ullval > EXT_COMMUNITY_OPAQUE_MAX) {
			yyerror("Bad ext-community value too big");
			return (-1);
		}
		c->data1 = ullval >> 32;
		c->data2 = ullval;
		break;
	case EXT_COMMUNITY_NON_TRANS_OPAQUE:
		if (subtype == EXT_COMMUNITY_SUBTYPE_OVS) {
			if (strcmp(s, "valid") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_VALID;
				break;
			} else if (strcmp(s, "invalid") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_INVALID;
				break;
			} else if (strcmp(s, "not-found") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_NOTFOUND;
				break;
			} else if (strcmp(s, "*") == 0) {
				dflag1 = COMMUNITY_ANY;
				break;
			}
		}
		yyerror("Bad ext-community %s", s);
		return (-1);
	}

	c->data3 = type << 8 | subtype;

	/* special handling of ext-community rt * since type is not known */
	if (dflag1 == COMMUNITY_ANY && type == -1) {
		c->flags = COMMUNITY_TYPE_EXT;
		c->flags |= dflag1 << 8;
		return (0);
	}

	/* verify type/subtype combo */
	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (cp->type == type && cp->subtype == subtype) {
			c->flags = COMMUNITY_TYPE_EXT;
			c->flags |= dflag1 << 8;
			c->flags |= dflag2 << 16;
			return (0);
		}
	}

	yyerror("Bad ext-community bad format for type");
	return (-1);
}

struct peer *
alloc_peer(void)
{
	struct peer	*p;
	u_int8_t	 i;

	if ((p = calloc(1, sizeof(struct peer))) == NULL)
		fatal("new_peer");

	/* some sane defaults */
	p->state = STATE_NONE;
	p->reconf_action = RECONF_REINIT;
	p->conf.distance = 1;
	p->conf.export_type = EXPORT_UNSET;
	p->conf.announce_capa = 1;
	for (i = 0; i < AID_MAX; i++)
		p->conf.capabilities.mp[i] = 0;
	p->conf.capabilities.refresh = 1;
	p->conf.capabilities.grestart.restart = 1;
	p->conf.capabilities.as4byte = 1;
	p->conf.local_as = conf->as;
	p->conf.local_short_as = conf->short_as;

	if (conf->flags & BGPD_FLAG_DECISION_TRANS_AS)
		p->conf.flags |= PEERFLAG_TRANS_AS;

	return (p);
}

struct peer *
new_peer(void)
{
	struct peer		*p;

	p = alloc_peer();

	if (curgroup != NULL) {
		memcpy(p, curgroup, sizeof(struct peer));
		if (strlcpy(p->conf.group, curgroup->conf.group,
		    sizeof(p->conf.group)) >= sizeof(p->conf.group))
			fatalx("new_peer group strlcpy");
		if (strlcpy(p->conf.descr, curgroup->conf.descr,
		    sizeof(p->conf.descr)) >= sizeof(p->conf.descr))
			fatalx("new_peer descr strlcpy");
		p->conf.groupid = curgroup->conf.id;
		p->conf.local_as = curgroup->conf.local_as;
		p->conf.local_short_as = curgroup->conf.local_short_as;
	}
	return (p);
}

struct peer *
new_group(void)
{
	return (alloc_peer());
}

int
add_mrtconfig(enum mrt_type type, char *name, int timeout, struct peer *p,
    char *rib)
{
	struct mrt	*m, *n;

	LIST_FOREACH(m, conf->mrt, entry) {
		if ((rib && strcmp(rib, m->rib)) ||
		    (!rib && *m->rib))
			continue;
		if (p == NULL) {
			if (m->peer_id != 0 || m->group_id != 0)
				continue;
		} else {
			if (m->peer_id != p->conf.id ||
			    m->group_id != p->conf.groupid)
				continue;
		}
		if (m->type == type) {
			yyerror("only one mrtdump per type allowed.");
			return (-1);
		}
	}

	if ((n = calloc(1, sizeof(struct mrt_config))) == NULL)
		fatal("add_mrtconfig");

	n->type = type;
	if (strlcpy(MRT2MC(n)->name, name, sizeof(MRT2MC(n)->name)) >=
	    sizeof(MRT2MC(n)->name)) {
		yyerror("filename \"%s\" too long: max %zu",
		    name, sizeof(MRT2MC(n)->name) - 1);
		free(n);
		return (-1);
	}
	MRT2MC(n)->ReopenTimerInterval = timeout;
	if (p != NULL) {
		if (curgroup == p) {
			n->peer_id = 0;
			n->group_id = p->conf.id;
		} else {
			n->peer_id = p->conf.id;
			n->group_id = 0;
		}
	}
	if (rib) {
		if (!find_rib(rib)) {
			yyerror("rib \"%s\" does not exist.", rib);
			free(n);
			return (-1);
		}
		if (strlcpy(n->rib, rib, sizeof(n->rib)) >=
		    sizeof(n->rib)) {
			yyerror("rib name \"%s\" too long: max %zu",
			    name, sizeof(n->rib) - 1);
			free(n);
			return (-1);
		}
	}

	LIST_INSERT_HEAD(conf->mrt, n, entry);

	return (0);
}

struct rde_rib *
add_rib(char *name)
{
	struct rde_rib	*rr;

	if ((rr = find_rib(name)) == NULL) {
		if ((rr = calloc(1, sizeof(*rr))) == NULL) {
			log_warn("add_rib");
			return (NULL);
		}
		if (strlcpy(rr->name, name, sizeof(rr->name)) >=
		    sizeof(rr->name)) {
			yyerror("rib name \"%s\" too long: max %zu",
			    name, sizeof(rr->name) - 1);
			free(rr);
			return (NULL);
		}
		rr->flags = F_RIB_NOFIB;
		SIMPLEQ_INSERT_TAIL(&ribnames, rr, entry);
	}
	return (rr);
}

struct rde_rib *
find_rib(char *name)
{
	struct rde_rib	*rr;

	SIMPLEQ_FOREACH(rr, &ribnames, entry) {
		if (!strcmp(rr->name, name))
			return (rr);
	}
	return (NULL);
}

int
rib_add_fib(struct rde_rib *rr, u_int rtableid)
{
	u_int	rdom;

	if (ktable_exists(rtableid, &rdom) != 1) {
		yyerror("rtable id %u does not exist", rtableid);
		return (-1);
	}
	/*
	 * conf->default_tableid is also a rdomain because that is checked
	 * in init_config()
	 */
	if (rdom != conf->default_tableid) {
		log_warnx("rtable %u does not belong to rdomain %u",
		    rtableid, conf->default_tableid);
		return (-1);
	}
	rr->rtableid = rtableid;
	rr->flags &= ~F_RIB_NOFIB;
	return (0);
}

struct prefixset *
find_prefixset(char *name, struct prefixset_head *p)
{
	struct prefixset *ps;

	SIMPLEQ_FOREACH(ps, p, entry) {
		if (!strcmp(ps->name, name))
			return (ps);
	}
	return (NULL);
}

int
get_id(struct peer *newpeer)
{
	static u_int32_t id = PEER_ID_STATIC_MIN;
	struct peer	*p = NULL;

	/* check if the peer already existed before */
	if (newpeer->conf.remote_addr.aid) {
		/* neighbor */
		if (cur_peers)
			RB_FOREACH(p, peer_head, cur_peers)
				if (memcmp(&p->conf.remote_addr,
				    &newpeer->conf.remote_addr,
				    sizeof(p->conf.remote_addr)) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.id;
			return (0);
		}
	} else {
		/* group */
		if (cur_peers)
			RB_FOREACH(p, peer_head, cur_peers)
				if (strcmp(p->conf.group,
				    newpeer->conf.group) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.groupid;
			return (0);
		}
	}

	/* else new one */
	if (id < PEER_ID_STATIC_MAX) {
		newpeer->conf.id = id++;
		return (0);
	}

	return (-1);
}

int
merge_prefixspec(struct filter_prefix *p, struct filter_prefixlen *pl)
{
	u_int8_t max_len = 0;

	switch (p->addr.aid) {
	case AID_INET:
	case AID_VPN_IPv4:
		max_len = 32;
		break;
	case AID_INET6:
	case AID_VPN_IPv6:
		max_len = 128;
		break;
	}

	if (pl->op == OP_NONE) {
		p->len_min = p->len_max = p->len;
		return (0);
	}

	if (pl->len_min == -1)
		pl->len_min = p->len;
	if (pl->len_max == -1)
		pl->len_max = max_len;

	if (pl->len_max > max_len) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_max, max_len);
		return (-1);
	}
	if (pl->len_min > pl->len_max) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_min, pl->len_max);
		return (-1);
	}
	if (pl->len_min < p->len) {
		yyerror("prefixlen %d smaller than prefix, limit %d",
		    pl->len_min, p->len);
		return (-1);
	}

	p->op = pl->op;
	p->len_min = pl->len_min;
	p->len_max = pl->len_max;
	return (0);
}

int
expand_rule(struct filter_rule *rule, struct filter_rib_l *rib,
    struct filter_peers_l *peer, struct filter_match_l *match,
    struct filter_set_head *set)
{
	struct filter_rule	*r;
	struct filter_rib_l	*rb, *rbnext;
	struct filter_peers_l	*p, *pnext;
	struct filter_prefix_l	*prefix, *prefix_next;
	struct filter_as_l	*a, *anext;
	struct filter_set	*s;

	rb = rib;
	do {
		p = peer;
		do {
			a = match->as_l;
			do {
				prefix = match->prefix_l;
				do {
					if ((r = calloc(1,
					    sizeof(struct filter_rule))) ==
						 NULL) {
						log_warn("expand_rule");
						return (-1);
					}

					memcpy(r, rule, sizeof(struct filter_rule));
					memcpy(&r->match, match,
					    sizeof(struct filter_match));
					TAILQ_INIT(&r->set);
					copy_filterset(set, &r->set);

					if (rb != NULL)
						strlcpy(r->rib, rb->name,
						     sizeof(r->rib));

					if (p != NULL)
						memcpy(&r->peer, &p->p,
						    sizeof(struct filter_peers));

					if (prefix != NULL)
						memcpy(&r->match.prefix, &prefix->p,
						    sizeof(r->match.prefix));

					if (a != NULL)
						memcpy(&r->match.as, &a->a,
						    sizeof(struct filter_as));

					TAILQ_INSERT_TAIL(filter_l, r, entry);

					if (prefix != NULL)
						prefix = prefix->next;
				} while (prefix != NULL);

				if (a != NULL)
					a = a->next;
			} while (a != NULL);

			if (p != NULL)
				p = p->next;
		} while (p != NULL);

		if (rb != NULL)
			rb = rb->next;
	} while (rb != NULL);

	for (rb = rib; rb != NULL; rb = rbnext) {
		rbnext = rb->next;
		free(rb);
	}

	for (p = peer; p != NULL; p = pnext) {
		pnext = p->next;
		free(p);
	}

	for (a = match->as_l; a != NULL; a = anext) {
		anext = a->next;
		free(a);
	}

	for (prefix = match->prefix_l; prefix != NULL; prefix = prefix_next) {
		prefix_next = prefix->next;
		free(prefix);
	}

	if (set != NULL) {
		while ((s = TAILQ_FIRST(set)) != NULL) {
			TAILQ_REMOVE(set, s, entry);
			free(s);
		}
		free(set);
	}

	return (0);
}

int
str2key(char *s, char *dest, size_t max_len)
{
	unsigned	i;
	char		t[3];

	if (strlen(s) / 2 > max_len) {
		yyerror("key too long");
		return (-1);
	}

	if (strlen(s) % 2) {
		yyerror("key must be of even length");
		return (-1);
	}

	for (i = 0; i < strlen(s) / 2; i++) {
		t[0] = s[2*i];
		t[1] = s[2*i + 1];
		t[2] = 0;
		if (!isxdigit(t[0]) || !isxdigit(t[1])) {
			yyerror("key must be specified in hex");
			return (-1);
		}
		dest[i] = strtoul(t, NULL, 16);
	}

	return (0);
}

int
neighbor_consistent(struct peer *p)
{
	/* local-address and peer's address: same address family */
	if (p->conf.local_addr.aid &&
	    p->conf.local_addr.aid != p->conf.remote_addr.aid) {
		yyerror("local-address and neighbor address "
		    "must be of the same address family");
		return (-1);
	}

	/* with any form of ipsec local-address is required */
	if ((p->conf.auth.method == AUTH_IPSEC_IKE_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_IKE_AH ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    !p->conf.local_addr.aid) {
		yyerror("neighbors with any form of IPsec configured "
		    "need local-address to be specified");
		return (-1);
	}

	/* with static keying we need both directions */
	if ((p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    (!p->conf.auth.spi_in || !p->conf.auth.spi_out)) {
		yyerror("with manual keyed IPsec, SPIs and keys "
		    "for both directions are required");
		return (-1);
	}

	if (!conf->as) {
		yyerror("AS needs to be given before neighbor definitions");
		return (-1);
	}

	/* set default values if they where undefined */
	p->conf.ebgp = (p->conf.remote_as != conf->as);
	if (p->conf.enforce_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_as = p->conf.ebgp ?
		    ENFORCE_AS_ON : ENFORCE_AS_OFF;
	if (p->conf.enforce_local_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_local_as = ENFORCE_AS_ON;

	if (p->conf.remote_as == 0 && !p->conf.template) {
		yyerror("peer AS may not be zero");
		return (-1);
	}

	/* EBGP neighbors are not allowed in route reflector clusters */
	if (p->conf.reflector_client && p->conf.ebgp) {
		yyerror("EBGP neighbors are not allowed in route "
		    "reflector clusters");
		return (-1);
	}

	return (0);
}

static void
filterset_add(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		if (s->type < t->type) {
			TAILQ_INSERT_BEFORE(t, s, entry);
			return;
		}
		if (s->type == t->type) {
			switch (s->type) {
			case ACTION_SET_COMMUNITY:
			case ACTION_DEL_COMMUNITY:
				if (memcmp(&s->action.community,
				    &t->action.community,
				    sizeof(s->action.community)) < 0) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				} else if (memcmp(&s->action.community,
				    &t->action.community,
				    sizeof(s->action.community)) == 0)
					break;
				continue;
			case ACTION_SET_NEXTHOP:
				/* only last nexthop per AF matters */
				if (s->action.nexthop.aid <
				    t->action.nexthop.aid) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				} else if (s->action.nexthop.aid ==
				    t->action.nexthop.aid) {
					t->action.nexthop = s->action.nexthop;
					break;
				}
				continue;
			case ACTION_SET_NEXTHOP_BLACKHOLE:
			case ACTION_SET_NEXTHOP_REJECT:
			case ACTION_SET_NEXTHOP_NOMODIFY:
			case ACTION_SET_NEXTHOP_SELF:
				/* set it only once */
				break;
			case ACTION_SET_LOCALPREF:
			case ACTION_SET_MED:
			case ACTION_SET_WEIGHT:
				/* only last set matters */
				t->action.metric = s->action.metric;
				break;
			case ACTION_SET_RELATIVE_LOCALPREF:
			case ACTION_SET_RELATIVE_MED:
			case ACTION_SET_RELATIVE_WEIGHT:
				/* sum all relative numbers */
				t->action.relative += s->action.relative;
				break;
			case ACTION_SET_ORIGIN:
				/* only last set matters */
				t->action.origin = s->action.origin;
				break;
			case ACTION_PFTABLE:
				/* only last set matters */
				strlcpy(t->action.pftable, s->action.pftable,
				    sizeof(t->action.pftable));
				break;
			case ACTION_RTLABEL:
				/* only last set matters */
				strlcpy(t->action.rtlabel, s->action.rtlabel,
				    sizeof(t->action.rtlabel));
				break;
			default:
				break;
			}
			free(s);
			return;
		}
	}

	TAILQ_INSERT_TAIL(sh, s, entry);
}

int
merge_filterset(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		/*
		 * need to cycle across the full list because even
		 * if types are not equal filterset_cmp() may return 0.
		 */
		if (filterset_cmp(s, t) == 0) {
			if (s->type == ACTION_SET_COMMUNITY)
				yyerror("community is already set");
			else if (s->type == ACTION_DEL_COMMUNITY)
				yyerror("community will already be deleted");
			else
				yyerror("redefining set parameter %s",
				    filterset_name(s->type));
			return (-1);
		}
	}

	filterset_add(sh, s);
	return (0);
}

static int
filter_equal(struct filter_rule *fa, struct filter_rule *fb)
{
	if (fa == NULL || fb == NULL)
		return 0;
	if (fa->action != fb->action || fa->quick != fb->quick ||
	    fa->dir != fb->dir)
		return 0;
	if (memcmp(&fa->peer, &fb->peer, sizeof(fa->peer)))
		return 0;
	if (memcmp(&fa->match, &fb->match, sizeof(fa->match)))
		return 0;

	return 1;
}

/* do a basic optimization by folding equal rules together */
void
optimize_filters(struct filter_head *fh)
{
	struct filter_rule *r, *nr;

	TAILQ_FOREACH_SAFE(r, fh, entry, nr) {
		while (filter_equal(r, nr)) {
			struct filter_set	*t;

			while ((t = TAILQ_FIRST(&nr->set)) != NULL) {
				TAILQ_REMOVE(&nr->set, t, entry);
				filterset_add(&r->set, t);
			}

			TAILQ_REMOVE(fh, nr, entry);
			free(nr);
			nr = TAILQ_NEXT(r, entry);
		}
	}
}

struct filter_rule *
get_rule(enum action_types type)
{
	struct filter_rule	*r;
	int			 out;

	switch (type) {
	case ACTION_SET_PREPEND_SELF:
	case ACTION_SET_NEXTHOP_NOMODIFY:
	case ACTION_SET_NEXTHOP_SELF:
		out = 1;
		break;
	default:
		out = 0;
		break;
	}
	r = (curpeer == curgroup) ? curgroup_filter[out] : curpeer_filter[out];
	if (r == NULL) {
		if ((r = calloc(1, sizeof(struct filter_rule))) == NULL)
			fatal(NULL);
		r->quick = 0;
		r->dir = out ? DIR_OUT : DIR_IN;
		r->action = ACTION_NONE;
		TAILQ_INIT(&r->set);
		if (curpeer == curgroup) {
			/* group */
			r->peer.groupid = curgroup->conf.id;
			curgroup_filter[out] = r;
		} else {
			/* peer */
			r->peer.peerid = curpeer->conf.id;
			curpeer_filter[out] = r;
		}
	}
	return (r);
}

struct set_table *curset;
static int
new_as_set(char *name)
{
	struct as_set *aset;

	if (as_sets_lookup(&conf->as_sets, name) != NULL) {
		yyerror("as-set \"%s\" already exists", name);
		return -1;
	}

	aset = as_sets_new(&conf->as_sets, name, 0, sizeof(u_int32_t));
	if (aset == NULL)
		fatal(NULL);

	curset = aset->set;
	return 0;
}

static void
add_as_set(u_int32_t as)
{
	if (curset == NULL)
		fatalx("%s: bad mojo jojo", __func__);

	if (set_add(curset, &as, 1) != 0)
		fatal(NULL);
}

static void
done_as_set(void)
{
	curset = NULL;
}

static struct prefixset *
new_prefix_set(char *name, int is_roa)
{
	const char *type = "prefix-set";
	struct prefixset_head *sets = &conf->prefixsets;
	struct prefixset *pset;

	if (is_roa) {
		type = "roa-set";
		sets = &conf->originsets;
	}

	if (find_prefixset(name, sets) != NULL)  {
		yyerror("%s \"%s\" already exists", type, name);
		return NULL;
	}
	if ((pset = calloc(1, sizeof(*pset))) == NULL)
		fatal("prefixset");
	if (strlcpy(pset->name, name, sizeof(pset->name)) >=
	    sizeof(pset->name)) {
		yyerror("%s \"%s\" too long: max %zu", type,
		    name, sizeof(pset->name) - 1);
		free(pset);
		return NULL;
	}
	RB_INIT(&pset->psitems);
	return pset;
}

static void
add_roa_set(struct prefixset_item *npsi, u_int32_t as, u_int8_t max)
{
	struct prefixset_item	*psi;
	struct roa_set rs;

	/* no prefixlen option in this tree */
	npsi->p.op = OP_NONE;
	npsi->p.len_max = npsi->p.len_min = npsi->p.len;
	psi = RB_INSERT(prefixset_tree, curpsitree, npsi);
	if (psi == NULL)
		psi = npsi;

	if (psi->set == NULL)
		if ((psi->set = set_new(1, sizeof(rs))) == NULL)
			fatal("set_new");
	rs.as = as;
	rs.maxlen = max;
	if (set_add(psi->set, &rs, 1) != 0)
		fatal("as_set_new");
}
#line 2938 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss); /* overflow check above */
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs); /* overflow check above */
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 15:
#line 261 "parse.y"
{ file->errors++; }
break;
case 16:
#line 264 "parse.y"
{
			/*
			 * According to iana 65535 and 4294967295 are reserved
			 * but enforcing this is not duty of the parser.
			 */
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > UINT_MAX) {
				yyerror("AS too big: max %u", UINT_MAX);
				YYERROR;
			}
		}
break;
case 17:
#line 275 "parse.y"
{
			const char	*errstr;
			char		*dot;
			u_int32_t	 uvalh = 0, uval;

			if ((dot = strchr(yyvsp[0].v.string,'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum(yyvsp[0].v.string, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", yyvsp[0].v.string, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				free(yyvsp[0].v.string);
			} else {
				yyerror("AS %s is bad", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (uvalh == 0 && (uval == AS_TRANS || uval == 0)) {
				yyerror("AS %u is reserved and may not be used",
				    uval);
				YYERROR;
			}
			yyval.v.number = uval | (uvalh << 16);
		}
break;
case 18:
#line 307 "parse.y"
{
			if (yyvsp[0].v.number == AS_TRANS || yyvsp[0].v.number == 0) {
				yyerror("AS %u is reserved and may not be used",
				    (u_int32_t)yyvsp[0].v.number);
				YYERROR;
			}
			yyval.v.number = yyvsp[0].v.number;
		}
break;
case 19:
#line 317 "parse.y"
{
			const char	*errstr;
			char		*dot;
			u_int32_t	 uvalh = 0, uval;

			if ((dot = strchr(yyvsp[0].v.string,'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum(yyvsp[0].v.string, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", yyvsp[0].v.string, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free(yyvsp[0].v.string);
					YYERROR;
				}
				free(yyvsp[0].v.string);
			} else {
				yyerror("AS %s is bad", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			yyval.v.number = uval | (uvalh << 16);
		}
break;
case 20:
#line 344 "parse.y"
{
			yyval.v.number = yyvsp[0].v.number;
		}
break;
case 21:
#line 349 "parse.y"
{
			if (asprintf(&yyval.v.string, "%s %s", yyvsp[-1].v.string, yyvsp[0].v.string) == -1)
				fatal("string: asprintf");
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 23:
#line 358 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "yes"))
				yyval.v.number = 1;
			else if (!strcmp(yyvsp[0].v.string, "no"))
				yyval.v.number = 0;
			else {
				yyerror("syntax error, "
				    "either yes or no expected");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 24:
#line 373 "parse.y"
{
			char *s = yyvsp[-2].v.string;
			if (cmd_opts & BGPD_OPT_VERBOSE)
				printf("%s = \"%s\"\n", yyvsp[-2].v.string, yyvsp[0].v.string);
			while (*s++) {
				if (isspace((unsigned char)*s)) {
					yyerror("macro name cannot contain "
					    "whitespace");
					free(yyvsp[-2].v.string);
					free(yyvsp[0].v.string);
					YYERROR;
				}
			}
			if (symset(yyvsp[-2].v.string, yyvsp[0].v.string, 0) == -1)
				fatal("cannot store variable");
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 25:
#line 393 "parse.y"
{
			struct file	*nfile;

			if ((nfile = pushfile(yyvsp[0].v.string, 1)) == NULL) {
				yyerror("failed to include file %s", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			file = nfile;
			lungetc('\n');
		}
break;
case 26:
#line 408 "parse.y"
{
			if (strlen(yyvsp[-2].v.string) >= SET_NAME_LEN) {
				yyerror("as-set name %s too long", yyvsp[-2].v.string);
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			if (new_as_set(yyvsp[-2].v.string) != 0) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
		}
break;
case 27:
#line 419 "parse.y"
{
			done_as_set();
		}
break;
case 28:
#line 422 "parse.y"
{
			if (new_as_set(yyvsp[-3].v.string) != 0) {
				free(yyvsp[-3].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
		}
break;
case 29:
#line 430 "parse.y"
{ add_as_set(yyvsp[0].v.number); }
break;
case 30:
#line 431 "parse.y"
{ add_as_set(yyvsp[0].v.number); }
break;
case 31:
#line 433 "parse.y"
{
			if ((curpset = new_prefix_set(yyvsp[-2].v.string, 0)) == NULL) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
		}
break;
case 32:
#line 439 "parse.y"
{
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
break;
case 33:
#line 443 "parse.y"
{
			if ((curpset = new_prefix_set(yyvsp[-3].v.string, 0)) == NULL) {
				free(yyvsp[-3].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
break;
case 34:
#line 453 "parse.y"
{
			struct prefixset_item	*psi;
			if (yyvsp[0].v.prefixset_item->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, yyvsp[0].v.prefixset_item);
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&yyvsp[0].v.prefixset_item->p.addr), yyvsp[0].v.prefixset_item->p.len);
				free(yyvsp[0].v.prefixset_item);
			}
		}
break;
case 35:
#line 467 "parse.y"
{
			struct prefixset_item	*psi;
			if (yyvsp[0].v.prefixset_item->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, yyvsp[0].v.prefixset_item);
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&yyvsp[0].v.prefixset_item->p.addr), yyvsp[0].v.prefixset_item->p.len);
				free(yyvsp[0].v.prefixset_item);
			}
		}
break;
case 36:
#line 483 "parse.y"
{
			if (yyvsp[0].v.prefixlen.op != OP_NONE && yyvsp[0].v.prefixlen.op != OP_RANGE) {
				yyerror("unsupported prefixlen operation in "
				    "prefix-set");
				YYERROR;
			}
			if ((yyval.v.prefixset_item = calloc(1, sizeof(*yyval.v.prefixset_item))) == NULL)
				fatal(NULL);
			memcpy(&yyval.v.prefixset_item->p.addr, &yyvsp[-1].v.prefix.prefix, sizeof(yyval.v.prefixset_item->p.addr));
			yyval.v.prefixset_item->p.len = yyvsp[-1].v.prefix.len;
			if (merge_prefixspec(&yyval.v.prefixset_item->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.prefixset_item);
				YYERROR;
			}
		}
break;
case 37:
#line 500 "parse.y"
{
			curpsitree = &conf->roa;
		}
break;
case 38:
#line 502 "parse.y"
{
			curpsitree = NULL;
		}
break;
case 40:
#line 508 "parse.y"
{
			if ((curoset = new_prefix_set(yyvsp[-2].v.string, 1)) == NULL) {
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			curpsitree = &curoset->psitems;
			free(yyvsp[-2].v.string);
		}
break;
case 41:
#line 515 "parse.y"
{
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curpsitree = NULL;
		}
break;
case 42:
#line 520 "parse.y"
{
			if ((curoset = new_prefix_set(yyvsp[-3].v.string, 1)) == NULL) {
				free(yyvsp[-3].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curpsitree = NULL;
		}
break;
case 43:
#line 532 "parse.y"
{
			if (yyvsp[-2].v.prefixset_item->p.len_min != yyvsp[-2].v.prefixset_item->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free(yyvsp[-2].v.prefixset_item);
				YYERROR;
			}
			add_roa_set(yyvsp[-2].v.prefixset_item, yyvsp[0].v.number, yyvsp[-2].v.prefixset_item->p.len_max);
		}
break;
case 44:
#line 541 "parse.y"
{
			if (yyvsp[-2].v.prefixset_item->p.len_min != yyvsp[-2].v.prefixset_item->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free(yyvsp[-2].v.prefixset_item);
				YYERROR;
			}
			add_roa_set(yyvsp[-2].v.prefixset_item, yyvsp[0].v.number, yyvsp[-2].v.prefixset_item->p.len_max);
		}
break;
case 45:
#line 552 "parse.y"
{
			conf->as = yyvsp[0].v.number;
			if (yyvsp[0].v.number > USHRT_MAX)
				conf->short_as = AS_TRANS;
			else
				conf->short_as = yyvsp[0].v.number;
		}
break;
case 46:
#line 559 "parse.y"
{
			conf->as = yyvsp[-1].v.number;
			conf->short_as = yyvsp[0].v.number;
		}
break;
case 47:
#line 563 "parse.y"
{
			if (yyvsp[0].v.addr.aid != AID_INET) {
				yyerror("router-id must be an IPv4 address");
				YYERROR;
			}
			conf->bgpid = yyvsp[0].v.addr.v4.s_addr;
		}
break;
case 48:
#line 570 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->holdtime = yyvsp[0].v.number;
		}
break;
case 49:
#line 578 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->min_holdtime = yyvsp[0].v.number;
		}
break;
case 50:
#line 586 "parse.y"
{
			struct listen_addr	*la;
			struct sockaddr		*sa;

			if ((la = calloc(1, sizeof(struct listen_addr))) ==
			    NULL)
				fatal("parse conf_main listen on calloc");

			la->fd = -1;
			la->reconf = RECONF_REINIT;
			sa = addr2sa(&yyvsp[0].v.addr, BGP_PORT, &la->sa_len);
			memcpy(&la->sa, sa, la->sa_len);
			TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
		}
break;
case 51:
#line 600 "parse.y"
{
			if (yyvsp[0].v.number <= RTP_NONE || yyvsp[0].v.number > RTP_MAX) {
				yyerror("invalid fib-priority");
				YYERROR;
			}
			conf->fib_priority = yyvsp[0].v.number;
		}
break;
case 52:
#line 607 "parse.y"
{
			struct rde_rib *rr;
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE can not find the main RIB!");

			if (yyvsp[0].v.number == 0)
				rr->flags |= F_RIB_NOFIBSYNC;
			else
				rr->flags &= ~F_RIB_NOFIBSYNC;
		}
break;
case 53:
#line 618 "parse.y"
{
			if (yyvsp[0].v.number == 1)
				conf->flags |= BGPD_FLAG_DECISION_TRANS_AS;
			else
				conf->flags &= ~BGPD_FLAG_DECISION_TRANS_AS;
		}
break;
case 54:
#line 624 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "updates"))
				conf->log |= BGPD_LOG_UPDATES;
			else {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 56:
#line 634 "parse.y"
{
			int action;

			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad timeout");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!strcmp(yyvsp[-2].v.string, "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp(yyvsp[-2].v.string, "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp(yyvsp[-2].v.string, "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, NULL, NULL) == -1) {
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 57:
#line 662 "parse.y"
{
			int action;

			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad timeout");
				free(yyvsp[-3].v.string);
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!strcmp(yyvsp[-2].v.string, "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp(yyvsp[-2].v.string, "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp(yyvsp[-2].v.string, "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free(yyvsp[-3].v.string);
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, NULL, yyvsp[-3].v.string) == -1) {
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			free(yyvsp[-1].v.string);
		}
break;
case 59:
#line 695 "parse.y"
{
			if (!strcmp(yyvsp[-1].v.string, "route-age"))
				conf->flags |= BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 60:
#line 705 "parse.y"
{
			if (!strcmp(yyvsp[-1].v.string, "route-age"))
				conf->flags &= ~BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 61:
#line 715 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "always"))
				conf->flags |= BGPD_FLAG_DECISION_MED_ALWAYS;
			else if (!strcmp(yyvsp[0].v.string, "strict"))
				conf->flags &= ~BGPD_FLAG_DECISION_MED_ALWAYS;
			else {
				yyerror("rde med compare: "
				    "unknown setting \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 62:
#line 728 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "bgp"))
				conf->flags |= BGPD_FLAG_NEXTHOP_BGP;
			else if (!strcmp(yyvsp[0].v.string, "default"))
				conf->flags |= BGPD_FLAG_NEXTHOP_DEFAULT;
			else {
				yyerror("nexthop depend on: "
				    "unknown setting \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 63:
#line 741 "parse.y"
{
			struct rde_rib *rr;
			if (yyvsp[0].v.number > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", yyvsp[0].v.number,
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (ktable_exists(yyvsp[0].v.number, NULL) != 1) {
				yyerror("rtable id %lld does not exist", yyvsp[0].v.number);
				YYERROR;
			}
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE can not find the main RIB!");
			rr->rtableid = yyvsp[0].v.number;
		}
break;
case 64:
#line 757 "parse.y"
{
			if (yyvsp[0].v.number > USHRT_MAX || yyvsp[0].v.number < 1) {
				yyerror("invalid connect-retry");
				YYERROR;
			}
			conf->connectretry = yyvsp[0].v.number;
		}
break;
case 65:
#line 764 "parse.y"
{
			if (strlen(yyvsp[-1].v.string) >=
			    sizeof(((struct sockaddr_un *)0)->sun_path)) {
				yyerror("socket path too long");
				YYERROR;
			}
			if (yyvsp[0].v.number) {
				free(conf->rcsock);
				conf->rcsock = yyvsp[-1].v.string;
			} else {
				free(conf->csock);
				conf->csock = yyvsp[-1].v.string;
			}
		}
break;
case 66:
#line 780 "parse.y"
{
			if ((currib = add_rib(yyvsp[0].v.string)) == NULL) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 67:
#line 786 "parse.y"
{
			currib = NULL;
		}
break;
case 69:
#line 791 "parse.y"
{
			if (yyvsp[-1].v.number > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", yyvsp[-1].v.number,
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (rib_add_fib(currib, yyvsp[-1].v.number) == -1)
				YYERROR;
		}
break;
case 70:
#line 800 "parse.y"
{
			if (yyvsp[-1].v.number) {
				yyerror("bad rde rib definition");
				YYERROR;
			}
			currib->flags |= F_RIB_NOEVALUATE;
		}
break;
case 72:
#line 810 "parse.y"
{
			if (yyvsp[0].v.number == 0)
				currib->flags |= F_RIB_NOFIBSYNC;
			else
				currib->flags &= ~F_RIB_NOFIBSYNC;
		}
break;
case 73:
#line 818 "parse.y"
{
			int action;

			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad timeout");
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!strcmp(yyvsp[-3].v.string, "all"))
				action = yyvsp[-2].v.number ? MRT_ALL_IN : MRT_ALL_OUT;
			else if (!strcmp(yyvsp[-3].v.string, "updates"))
				action = yyvsp[-2].v.number ? MRT_UPDATE_IN : MRT_UPDATE_OUT;
			else {
				yyerror("unknown mrt msg dump type");
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (add_mrtconfig(action, yyvsp[-1].v.string, yyvsp[0].v.number, curpeer, NULL) ==
			    -1) {
				free(yyvsp[-3].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-3].v.string);
			free(yyvsp[-1].v.string);
		}
break;
case 74:
#line 848 "parse.y"
{
			struct network	*n, *m;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			memcpy(&n->net.prefix, &yyvsp[-1].v.prefix.prefix,
			    sizeof(n->net.prefix));
			n->net.prefixlen = yyvsp[-1].v.prefix.len;
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);
			TAILQ_FOREACH(m, netconf, entry) {
				if (n->net.type == m->net.type &&
				    n->net.prefixlen == m->net.prefixlen &&
				    prefix_compare(&n->net.prefix,
				    &m->net.prefix, n->net.prefixlen) == 0)
					yyerror("duplicate prefix "
					    "in network statement");
			}

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 75:
#line 869 "parse.y"
{
			struct prefixset *ps;
			struct network	*n;
			if ((ps = find_prefixset(yyvsp[-1].v.string, &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			if (ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s has prefixlen operators "
				    "and cannot be used in network statements.",
				    ps->name);
				free(yyvsp[-1].v.string);
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			strlcpy(n->net.psname, ps->name, sizeof(n->net.psname));
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			n->net.type = NETWORK_PREFIXSET;
			TAILQ_INSERT_TAIL(netconf, n, entry);
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.filter_set_head);
		}
break;
case 76:
#line 898 "parse.y"
{
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid(yyvsp[-3].v.number, SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown family");
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			n->net.type = NETWORK_RTLABEL;
			n->net.rtlabel = rtlabel_name2id(yyvsp[-1].v.string);
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 77:
#line 917 "parse.y"
{
			struct network	*n;
			if (yyvsp[-1].v.number < RTP_LOCAL && yyvsp[-1].v.number > RTP_MAX) {
				yyerror("priority %lld > max %d or < min %d", yyvsp[-1].v.number,
				    RTP_MAX, RTP_LOCAL);
				YYERROR;
			}

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid(yyvsp[-3].v.number, SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown family");
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			n->net.type = NETWORK_PRIORITY;
			n->net.priority = yyvsp[-1].v.number;
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 78:
#line 941 "parse.y"
{
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid(yyvsp[-2].v.number, SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown family");
				filterset_free(yyvsp[0].v.filter_set_head);
				free(yyvsp[0].v.filter_set_head);
				YYERROR;
			}
			n->net.type = yyvsp[-1].v.number ? NETWORK_STATIC : NETWORK_CONNECTED;
			filterset_move(yyvsp[0].v.filter_set_head, &n->net.attrset);
			free(yyvsp[0].v.filter_set_head);

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
break;
case 79:
#line 961 "parse.y"
{ yyval.v.number = 1; }
break;
case 80:
#line 962 "parse.y"
{ yyval.v.number = 0; }
break;
case 81:
#line 965 "parse.y"
{ yyval.v.number = 1; }
break;
case 82:
#line 966 "parse.y"
{ yyval.v.number = 0; }
break;
case 83:
#line 969 "parse.y"
{
			u_int8_t	len;

			if (!host(yyvsp[0].v.string, &yyval.v.addr, &len)) {
				yyerror("could not parse address spec \"%s\"",
				    yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			if ((yyval.v.addr.aid == AID_INET && len != 32) ||
			    (yyval.v.addr.aid == AID_INET6 && len != 128)) {
				/* unreachable */
				yyerror("got prefixlen %u, expected %u",
				    len, yyval.v.addr.aid == AID_INET ? 32 : 128);
				YYERROR;
			}
		}
break;
case 84:
#line 990 "parse.y"
{
			char	*s;
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("bad prefixlen %lld", yyvsp[0].v.number);
				free(yyvsp[-2].v.string);
				YYERROR;
			}
			if (asprintf(&s, "%s/%lld", yyvsp[-2].v.string, yyvsp[0].v.number) == -1)
				fatal(NULL);
			free(yyvsp[-2].v.string);

			if (!host(s, &yyval.v.prefix.prefix, &yyval.v.prefix.len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
break;
case 85:
#line 1008 "parse.y"
{
			char	*s;

			/* does not match IPv6 */
			if (yyvsp[-2].v.number < 0 || yyvsp[-2].v.number > 255 || yyvsp[0].v.number < 0 || yyvsp[0].v.number > 32) {
				yyerror("bad prefix %lld/%lld", yyvsp[-2].v.number, yyvsp[0].v.number);
				YYERROR;
			}
			if (asprintf(&s, "%lld/%lld", yyvsp[-2].v.number, yyvsp[0].v.number) == -1)
				fatal(NULL);

			if (!host(s, &yyval.v.prefix.prefix, &yyval.v.prefix.len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
break;
case 86:
#line 1028 "parse.y"
{
			memcpy(&yyval.v.prefix.prefix, &yyvsp[0].v.addr, sizeof(struct bgpd_addr));
			if (yyval.v.prefix.prefix.aid == AID_INET)
				yyval.v.prefix.len = 32;
			else
				yyval.v.prefix.len = 128;
		}
break;
case 88:
#line 1038 "parse.y"
{ yyval.v.number = 0; }
break;
case 90:
#line 1042 "parse.y"
{
			u_int rdomain, label;

			if (get_mpe_config(yyvsp[0].v.string, &rdomain, &label) == -1) {
				if ((cmd_opts & BGPD_OPT_NOACTION) == 0) {
					yyerror("troubles getting config of %s",
					    yyvsp[0].v.string);
					free(yyvsp[0].v.string);
					free(yyvsp[-2].v.string);
					YYERROR;
				}
			}

			if (!(curvpn = calloc(1, sizeof(struct l3vpn))))
				fatal(NULL);
			strlcpy(curvpn->ifmpe, yyvsp[0].v.string, IFNAMSIZ);

			if (strlcpy(curvpn->descr, yyvsp[-2].v.string,
			    sizeof(curvpn->descr)) >=
			    sizeof(curvpn->descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    yyvsp[-2].v.string, sizeof(curvpn->descr) - 1);
				free(yyvsp[-2].v.string);
				free(yyvsp[0].v.string);
				free(curvpn);
				curvpn = NULL;
				YYERROR;
			}
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);

			TAILQ_INIT(&curvpn->import);
			TAILQ_INIT(&curvpn->export);
			TAILQ_INIT(&curvpn->net_l);
			curvpn->label = label;
			curvpn->rtableid = rdomain;
			netconf = &curvpn->net_l;
		}
break;
case 91:
#line 1079 "parse.y"
{
			/* insert into list */
			SIMPLEQ_INSERT_TAIL(&conf->l3vpns, curvpn, entry);
			curvpn = NULL;
			netconf = &conf->networks;
		}
break;
case 96:
#line 1093 "parse.y"
{
			struct community	ext;

			memset(&ext, 0, sizeof(ext));
			if (parseextcommunity(&ext, "rt", yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			/*
			 * RD is almost encoded like an ext-community,
			 * but only almost so convert here.
			 */
			if (community_to_rd(&ext, &curvpn->rd) == -1) {
				yyerror("bad encoding of rd");
				YYERROR;
			}
		}
break;
case 97:
#line 1111 "parse.y"
{
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				free(yyvsp[-1].v.string);
				free(set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			free(yyvsp[-1].v.string);
			TAILQ_INSERT_TAIL(&curvpn->export, set, entry);
		}
break;
case 98:
#line 1129 "parse.y"
{
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				free(yyvsp[-1].v.string);
				free(set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			free(yyvsp[-1].v.string);
			TAILQ_INSERT_TAIL(&curvpn->import, set, entry);
		}
break;
case 99:
#line 1147 "parse.y"
{
			if (yyvsp[0].v.number == 0)
				curvpn->flags |= F_RIB_NOFIBSYNC;
			else
				curvpn->flags &= ~F_RIB_NOFIBSYNC;
		}
break;
case 101:
#line 1156 "parse.y"
{	curpeer = new_peer(); }
break;
case 102:
#line 1157 "parse.y"
{
			memcpy(&curpeer->conf.remote_addr, &yyvsp[0].v.prefix.prefix,
			    sizeof(curpeer->conf.remote_addr));
			curpeer->conf.remote_masklen = yyvsp[0].v.prefix.len;
			if ((yyvsp[0].v.prefix.prefix.aid == AID_INET && yyvsp[0].v.prefix.len != 32) ||
			    (yyvsp[0].v.prefix.prefix.aid == AID_INET6 && yyvsp[0].v.prefix.len != 128))
				curpeer->conf.template = 1;
			curpeer->conf.capabilities.mp[
			    curpeer->conf.remote_addr.aid] = 1;
			if (get_id(curpeer)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
break;
case 103:
#line 1171 "parse.y"
{
			if (curpeer_filter[0] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[0], entry);
			if (curpeer_filter[1] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[1], entry);
			curpeer_filter[0] = NULL;
			curpeer_filter[1] = NULL;

			if (neighbor_consistent(curpeer) == -1)
				YYERROR;
			if (RB_INSERT(peer_head, new_peers, curpeer) != NULL)
				fatalx("%s: peer tree is corrupt", __func__);
			curpeer = curgroup;
		}
break;
case 104:
#line 1189 "parse.y"
{
			curgroup = curpeer = new_group();
			if (strlcpy(curgroup->conf.group, yyvsp[0].v.string,
			    sizeof(curgroup->conf.group)) >=
			    sizeof(curgroup->conf.group)) {
				yyerror("group name \"%s\" too long: max %zu",
				    yyvsp[0].v.string, sizeof(curgroup->conf.group) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			if (get_id(curgroup)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
break;
case 105:
#line 1204 "parse.y"
{
			if (curgroup_filter[0] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[0], entry);
			if (curgroup_filter[1] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[1], entry);
			curgroup_filter[0] = NULL;
			curgroup_filter[1] = NULL;

			free(curgroup);
			curgroup = NULL;
		}
break;
case 118:
#line 1237 "parse.y"
{
			curpeer->conf.remote_as = yyvsp[0].v.number;
		}
break;
case 119:
#line 1240 "parse.y"
{
			curpeer->conf.local_as = yyvsp[0].v.number;
			if (yyvsp[0].v.number > USHRT_MAX)
				curpeer->conf.local_short_as = AS_TRANS;
			else
				curpeer->conf.local_short_as = yyvsp[0].v.number;
		}
break;
case 120:
#line 1247 "parse.y"
{
			curpeer->conf.local_as = yyvsp[-1].v.number;
			curpeer->conf.local_short_as = yyvsp[0].v.number;
		}
break;
case 121:
#line 1251 "parse.y"
{
			if (strlcpy(curpeer->conf.descr, yyvsp[0].v.string,
			    sizeof(curpeer->conf.descr)) >=
			    sizeof(curpeer->conf.descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    yyvsp[0].v.string, sizeof(curpeer->conf.descr) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 122:
#line 1262 "parse.y"
{
			memcpy(&curpeer->conf.local_addr, &yyvsp[0].v.addr,
			    sizeof(curpeer->conf.local_addr));
		}
break;
case 123:
#line 1266 "parse.y"
{
			if (yyvsp[0].v.number < 2 || yyvsp[0].v.number > 255) {
				yyerror("invalid multihop distance %lld", yyvsp[0].v.number);
				YYERROR;
			}
			curpeer->conf.distance = yyvsp[0].v.number;
		}
break;
case 124:
#line 1273 "parse.y"
{
			curpeer->conf.passive = 1;
		}
break;
case 125:
#line 1276 "parse.y"
{
			curpeer->conf.down = 1;
		}
break;
case 126:
#line 1279 "parse.y"
{
			curpeer->conf.down = 1;
			if (strlcpy(curpeer->conf.shutcomm, yyvsp[0].v.string,
				sizeof(curpeer->conf.shutcomm)) >=
				sizeof(curpeer->conf.shutcomm)) {
				    yyerror("shutdown reason too long");
				    free(yyvsp[0].v.string);
				    YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 127:
#line 1290 "parse.y"
{
			if (!find_rib(yyvsp[0].v.string)) {
				yyerror("rib \"%s\" does not exist.", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(curpeer->conf.rib, yyvsp[0].v.string,
			    sizeof(curpeer->conf.rib)) >=
			    sizeof(curpeer->conf.rib)) {
				yyerror("rib name \"%s\" too long: max %zu",
				    yyvsp[0].v.string, sizeof(curpeer->conf.rib) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 128:
#line 1306 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.holdtime = yyvsp[0].v.number;
		}
break;
case 129:
#line 1314 "parse.y"
{
			if (yyvsp[0].v.number < MIN_HOLDTIME || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.min_holdtime = yyvsp[0].v.number;
		}
break;
case 130:
#line 1322 "parse.y"
{
			u_int8_t	aid, safi;
			u_int16_t	afi;

			if (yyvsp[0].v.number == SAFI_NONE) {
				for (aid = 0; aid < AID_MAX; aid++) {
					if (aid2afi(aid, &afi, &safi) == -1 ||
					    afi != yyvsp[-1].v.number)
						continue;
					curpeer->conf.capabilities.mp[aid] = 0;
				}
			} else {
				if (afi2aid(yyvsp[-1].v.number, yyvsp[0].v.number, &aid) == -1) {
					yyerror("unknown AFI/SAFI pair");
					YYERROR;
				}
				curpeer->conf.capabilities.mp[aid] = 1;
			}
		}
break;
case 131:
#line 1341 "parse.y"
{
			curpeer->conf.announce_capa = yyvsp[0].v.number;
		}
break;
case 132:
#line 1344 "parse.y"
{
			curpeer->conf.capabilities.refresh = yyvsp[0].v.number;
		}
break;
case 133:
#line 1347 "parse.y"
{
			curpeer->conf.capabilities.grestart.restart = yyvsp[0].v.number;
		}
break;
case 134:
#line 1350 "parse.y"
{
			curpeer->conf.capabilities.as4byte = yyvsp[0].v.number;
		}
break;
case 135:
#line 1353 "parse.y"
{
			curpeer->conf.export_type = EXPORT_NONE;
		}
break;
case 136:
#line 1356 "parse.y"
{
			curpeer->conf.export_type = EXPORT_DEFAULT_ROUTE;
		}
break;
case 137:
#line 1359 "parse.y"
{
			if (yyvsp[0].v.number)
				curpeer->conf.enforce_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_as = ENFORCE_AS_OFF;
		}
break;
case 138:
#line 1365 "parse.y"
{
			if (yyvsp[0].v.number)
				curpeer->conf.enforce_local_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_local_as = ENFORCE_AS_OFF;
		}
break;
case 139:
#line 1371 "parse.y"
{
			if (yyvsp[0].v.number) {
				struct filter_rule	*r;
				struct filter_set	*s;

				if ((s = calloc(1, sizeof(struct filter_set)))
				    == NULL)
					fatal(NULL);
				s->type = ACTION_SET_AS_OVERRIDE;

				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
		}
break;
case 140:
#line 1386 "parse.y"
{
			if (yyvsp[-1].v.number < 0 || yyvsp[-1].v.number > UINT_MAX) {
				yyerror("bad maximum number of prefixes");
				YYERROR;
			}
			curpeer->conf.max_prefix = yyvsp[-1].v.number;
			curpeer->conf.max_prefix_restart = yyvsp[0].v.number;
		}
break;
case 141:
#line 1394 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(curpeer->conf.auth.md5key, yyvsp[0].v.string,
			    sizeof(curpeer->conf.auth.md5key)) >=
			    sizeof(curpeer->conf.auth.md5key)) {
				yyerror("tcp md5sig password too long: max %zu",
				    sizeof(curpeer->conf.auth.md5key) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen(yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 142:
#line 1412 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[0].v.string);
				YYERROR;
			}

			if (str2key(yyvsp[0].v.string, curpeer->conf.auth.md5key,
			    sizeof(curpeer->conf.auth.md5key)) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen(yyvsp[0].v.string) / 2;
			free(yyvsp[0].v.string);
		}
break;
case 143:
#line 1428 "parse.y"
{
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				YYERROR;
			}
			if (yyvsp[-1].v.number)
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_ESP;
			else
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_AH;
		}
break;
case 144:
#line 1438 "parse.y"
{
			u_int32_t	auth_alg;
			u_int8_t	keylen;

			if (curpeer->conf.auth.method &&
			    (((curpeer->conf.auth.spi_in && yyvsp[-5].v.number == 1) ||
			    (curpeer->conf.auth.spi_out && yyvsp[-5].v.number == 0)) ||
			    (yyvsp[-6].v.number == 1 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_ESP) ||
			    (yyvsp[-6].v.number == 0 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_AH))) {
				yyerror("auth method cannot be redefined");
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (!strcmp(yyvsp[-2].v.string, "sha1")) {
				auth_alg = SADB_AALG_SHA1HMAC;
				keylen = 20;
			} else if (!strcmp(yyvsp[-2].v.string, "md5")) {
				auth_alg = SADB_AALG_MD5HMAC;
				keylen = 16;
			} else {
				yyerror("unknown auth algorithm \"%s\"", yyvsp[-2].v.string);
				free(yyvsp[-2].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			free(yyvsp[-2].v.string);

			if (strlen(yyvsp[-1].v.string) / 2 != keylen) {
				yyerror("auth key len: must be %u bytes, "
				    "is %zu bytes", keylen, strlen(yyvsp[-1].v.string) / 2);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (yyvsp[-6].v.number)
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_ESP;
			else {
				if (yyvsp[0].v.encspec.enc_alg) {
					yyerror("\"ipsec ah\" doesn't take "
					    "encryption keys");
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_AH;
			}

			if (yyvsp[-3].v.number <= SPI_RESERVED_MAX || yyvsp[-3].v.number > UINT_MAX) {
				yyerror("bad spi number %lld", yyvsp[-3].v.number);
				free(yyvsp[-1].v.string);
				YYERROR;
			}

			if (yyvsp[-5].v.number == 1) {
				if (str2key(yyvsp[-1].v.string, curpeer->conf.auth.auth_key_in,
				    sizeof(curpeer->conf.auth.auth_key_in)) ==
				    -1) {
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.spi_in = yyvsp[-3].v.number;
				curpeer->conf.auth.auth_alg_in = auth_alg;
				curpeer->conf.auth.enc_alg_in = yyvsp[0].v.encspec.enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_in,
				    &yyvsp[0].v.encspec.enc_key,
				    sizeof(curpeer->conf.auth.enc_key_in));
				curpeer->conf.auth.enc_keylen_in =
				    yyvsp[0].v.encspec.enc_key_len;
				curpeer->conf.auth.auth_keylen_in = keylen;
			} else {
				if (str2key(yyvsp[-1].v.string, curpeer->conf.auth.auth_key_out,
				    sizeof(curpeer->conf.auth.auth_key_out)) ==
				    -1) {
					free(yyvsp[-1].v.string);
					YYERROR;
				}
				curpeer->conf.auth.spi_out = yyvsp[-3].v.number;
				curpeer->conf.auth.auth_alg_out = auth_alg;
				curpeer->conf.auth.enc_alg_out = yyvsp[0].v.encspec.enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_out,
				    &yyvsp[0].v.encspec.enc_key,
				    sizeof(curpeer->conf.auth.enc_key_out));
				curpeer->conf.auth.enc_keylen_out =
				    yyvsp[0].v.encspec.enc_key_len;
				curpeer->conf.auth.auth_keylen_out = keylen;
			}
			free(yyvsp[-1].v.string);
		}
break;
case 145:
#line 1531 "parse.y"
{
			curpeer->conf.ttlsec = yyvsp[0].v.number;
		}
break;
case 146:
#line 1534 "parse.y"
{
			struct filter_rule	*r;

			r = get_rule(yyvsp[0].v.filter_set->type);
			if (merge_filterset(&r->set, yyvsp[0].v.filter_set) == -1)
				YYERROR;
		}
break;
case 147:
#line 1541 "parse.y"
{
			struct filter_rule	*r;
			struct filter_set	*s;

			while ((s = TAILQ_FIRST(yyvsp[-2].v.filter_set_head)) != NULL) {
				TAILQ_REMOVE(yyvsp[-2].v.filter_set_head, s, entry);
				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
			free(yyvsp[-2].v.filter_set_head);
		}
break;
case 149:
#line 1554 "parse.y"
{
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != 0) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
		}
break;
case 150:
#line 1564 "parse.y"
{
			if (yyvsp[0].v.addr.aid != AID_INET) {
				yyerror("route reflector cluster-id must be "
				    "an IPv4 address");
				YYERROR;
			}
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != yyvsp[0].v.addr.v4.s_addr) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
			conf->clusterid = yyvsp[0].v.addr.v4.s_addr;
		}
break;
case 151:
#line 1580 "parse.y"
{
			if (strlcpy(curpeer->conf.if_depend, yyvsp[0].v.string,
			    sizeof(curpeer->conf.if_depend)) >=
			    sizeof(curpeer->conf.if_depend)) {
				yyerror("interface name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string,
				    sizeof(curpeer->conf.if_depend) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 152:
#line 1592 "parse.y"
{
#ifdef HAVE_CARP
			if (strlcpy(curpeer->conf.demote_group, yyvsp[0].v.string,
			    sizeof(curpeer->conf.demote_group)) >=
			    sizeof(curpeer->conf.demote_group)) {
				yyerror("demote group name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string,
				    sizeof(curpeer->conf.demote_group) - 1);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			if (carp_demote_init(curpeer->conf.demote_group,
			    cmd_opts & BGPD_OPT_FORCE_DEMOTE) == -1) {
				yyerror("error initializing group \"%s\"",
				    curpeer->conf.demote_group);
				YYERROR;
			}
#else
			yyerror("carp demote not supported");
			free(yyvsp[0].v.string);
			YYERROR;
#endif
		}
break;
case 153:
#line 1616 "parse.y"
{
			if (yyvsp[0].v.number == 1)
				curpeer->conf.flags |= PEERFLAG_TRANS_AS;
			else
				curpeer->conf.flags &= ~PEERFLAG_TRANS_AS;
		}
break;
case 154:
#line 1622 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "updates"))
				curpeer->conf.flags |= PEERFLAG_LOG_UPDATES;
			else if (!strcmp(yyvsp[0].v.string, "no"))
				curpeer->conf.flags &= ~PEERFLAG_LOG_UPDATES;
			else {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 155:
#line 1635 "parse.y"
{ yyval.v.number = 0; }
break;
case 156:
#line 1636 "parse.y"
{
			if (yyvsp[0].v.number < 1 || yyvsp[0].v.number > USHRT_MAX) {
				yyerror("restart out of range. 1 to %u minutes",
				    USHRT_MAX);
				YYERROR;
			}
			yyval.v.number = yyvsp[0].v.number;
		}
break;
case 157:
#line 1646 "parse.y"
{ yyval.v.number = AFI_IPv4; }
break;
case 158:
#line 1647 "parse.y"
{ yyval.v.number = AFI_IPv6; }
break;
case 159:
#line 1650 "parse.y"
{ yyval.v.number = SAFI_NONE; }
break;
case 160:
#line 1651 "parse.y"
{ yyval.v.number = SAFI_UNICAST; }
break;
case 161:
#line 1652 "parse.y"
{ yyval.v.number = SAFI_MPLSVPN; }
break;
case 162:
#line 1655 "parse.y"
{ yyval.v.number = 1; }
break;
case 163:
#line 1656 "parse.y"
{ yyval.v.number = 0; }
break;
case 164:
#line 1659 "parse.y"
{ yyval.v.number = 1; }
break;
case 165:
#line 1660 "parse.y"
{ yyval.v.number = 0; }
break;
case 166:
#line 1663 "parse.y"
{
			bzero(&yyval.v.encspec, sizeof(yyval.v.encspec));
		}
break;
case 167:
#line 1666 "parse.y"
{
			bzero(&yyval.v.encspec, sizeof(yyval.v.encspec));
			if (!strcmp(yyvsp[-1].v.string, "3des") || !strcmp(yyvsp[-1].v.string, "3des-cbc")) {
				yyval.v.encspec.enc_alg = SADB_EALG_3DESCBC;
				yyval.v.encspec.enc_key_len = 21; /* XXX verify */
			} else if (!strcmp(yyvsp[-1].v.string, "aes") ||
			    !strcmp(yyvsp[-1].v.string, "aes-128-cbc")) {
				yyval.v.encspec.enc_alg = SADB_X_EALG_AES;
				yyval.v.encspec.enc_key_len = 16;
			} else {
				yyerror("unknown enc algorithm \"%s\"", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);

			if (strlen(yyvsp[0].v.string) / 2 != yyval.v.encspec.enc_key_len) {
				yyerror("enc key length wrong: should be %u "
				    "bytes, is %zu bytes",
				    yyval.v.encspec.enc_key_len * 2, strlen(yyvsp[0].v.string));
				free(yyvsp[0].v.string);
				YYERROR;
			}

			if (str2key(yyvsp[0].v.string, yyval.v.encspec.enc_key, sizeof(yyval.v.encspec.enc_key)) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 168:
#line 1701 "parse.y"
{
			struct filter_rule	 r;
			struct filter_rib_l	 *rb, *rbnext;

			bzero(&r, sizeof(r));
			r.action = yyvsp[-6].v.u8;
			r.quick = yyvsp[-5].v.u8;
			r.dir = yyvsp[-3].v.u8;
			if (yyvsp[-4].v.filter_rib) {
				if (r.dir != DIR_IN) {
					yyerror("rib only allowed on \"from\" "
					    "rules.");

					for (rb = yyvsp[-4].v.filter_rib; rb != NULL; rb = rbnext) {
						rbnext = rb->next;
						free(rb);
					}
					YYERROR;
				}
			}
			if (expand_rule(&r, yyvsp[-4].v.filter_rib, yyvsp[-2].v.filter_peers, &yyvsp[-1].v.filter_match, yyvsp[0].v.filter_set_head) == -1)
				YYERROR;
		}
break;
case 169:
#line 1726 "parse.y"
{ yyval.v.u8 = ACTION_ALLOW; }
break;
case 170:
#line 1727 "parse.y"
{ yyval.v.u8 = ACTION_DENY; }
break;
case 171:
#line 1728 "parse.y"
{ yyval.v.u8 = ACTION_NONE; }
break;
case 172:
#line 1731 "parse.y"
{ yyval.v.u8 = 0; }
break;
case 173:
#line 1732 "parse.y"
{ yyval.v.u8 = 1; }
break;
case 174:
#line 1735 "parse.y"
{ yyval.v.u8 = DIR_IN; }
break;
case 175:
#line 1736 "parse.y"
{ yyval.v.u8 = DIR_OUT; }
break;
case 176:
#line 1739 "parse.y"
{ yyval.v.filter_rib = NULL; }
break;
case 177:
#line 1740 "parse.y"
{ yyval.v.filter_rib = yyvsp[0].v.filter_rib; }
break;
case 178:
#line 1741 "parse.y"
{ yyval.v.filter_rib = yyvsp[-2].v.filter_rib; }
break;
case 179:
#line 1743 "parse.y"
{ yyval.v.filter_rib = yyvsp[0].v.filter_rib; }
break;
case 180:
#line 1744 "parse.y"
{
			yyvsp[0].v.filter_rib->next = yyvsp[-2].v.filter_rib;
			yyval.v.filter_rib = yyvsp[0].v.filter_rib;
		}
break;
case 181:
#line 1750 "parse.y"
{
			if (!find_rib(yyvsp[0].v.string)) {
				yyerror("rib \"%s\" does not exist.", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if ((yyval.v.filter_rib = calloc(1, sizeof(struct filter_rib_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_rib->next = NULL;
			if (strlcpy(yyval.v.filter_rib->name, yyvsp[0].v.string, sizeof(yyval.v.filter_rib->name)) >=
			    sizeof(yyval.v.filter_rib->name)) {
				yyerror("rib name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string, sizeof(yyval.v.filter_rib->name) - 1);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_rib);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 183:
#line 1773 "parse.y"
{ yyval.v.filter_peers = yyvsp[-2].v.filter_peers; }
break;
case 184:
#line 1776 "parse.y"
{ yyval.v.filter_peers = yyvsp[0].v.filter_peers; }
break;
case 185:
#line 1777 "parse.y"
{
			yyvsp[0].v.filter_peers->next = yyvsp[-2].v.filter_peers;
			yyval.v.filter_peers = yyvsp[0].v.filter_peers;
		}
break;
case 186:
#line 1783 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.peerid = yyval.v.filter_peers->p.groupid = 0;
			yyval.v.filter_peers->next = NULL;
		}
break;
case 187:
#line 1790 "parse.y"
{
			struct peer *p;

			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.remote_as = yyval.v.filter_peers->p.groupid = yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->next = NULL;
			RB_FOREACH(p, peer_head, new_peers)
				if (!memcmp(&p->conf.remote_addr,
				    &yyvsp[0].v.addr, sizeof(p->conf.remote_addr))) {
					yyval.v.filter_peers->p.peerid = p->conf.id;
					break;
				}
			if (yyval.v.filter_peers->p.peerid == 0) {
				yyerror("no such peer: %s", log_addr(&yyvsp[0].v.addr));
				free(yyval.v.filter_peers);
				YYERROR;
			}
		}
break;
case 188:
#line 1810 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.groupid = yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->p.remote_as = yyvsp[0].v.number;
		}
break;
case 189:
#line 1817 "parse.y"
{
			struct peer *p;

			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.remote_as = yyval.v.filter_peers->p.peerid = 0;
			yyval.v.filter_peers->next = NULL;
			RB_FOREACH(p, peer_head, new_peers)
				if (!strcmp(p->conf.group, yyvsp[0].v.string)) {
					yyval.v.filter_peers->p.groupid = p->conf.groupid;
					break;
				}
			if (yyval.v.filter_peers->p.groupid == 0) {
				yyerror("no such group: \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_peers);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 190:
#line 1838 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.ebgp = 1;
		}
break;
case 191:
#line 1844 "parse.y"
{
			if ((yyval.v.filter_peers = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_peers->p.ibgp = 1;
		}
break;
case 192:
#line 1852 "parse.y"
{
			if (yyvsp[0].v.prefixlen.op == OP_NONE) {
				yyvsp[0].v.prefixlen.op = OP_RANGE;
				yyvsp[0].v.prefixlen.len_min = 0;
				yyvsp[0].v.prefixlen.len_max = -1;
			}
			if ((yyval.v.filter_prefix = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_prefix->p.addr.aid = AID_INET;
			if (merge_prefixspec(&yyval.v.filter_prefix->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.filter_prefix);
				YYERROR;
			}
		}
break;
case 193:
#line 1867 "parse.y"
{
			if (yyvsp[0].v.prefixlen.op == OP_NONE) {
				yyvsp[0].v.prefixlen.op = OP_RANGE;
				yyvsp[0].v.prefixlen.len_min = 0;
				yyvsp[0].v.prefixlen.len_max = -1;
			}
			if ((yyval.v.filter_prefix = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_prefix->p.addr.aid = AID_INET6;
			if (merge_prefixspec(&yyval.v.filter_prefix->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.filter_prefix);
				YYERROR;
			}
		}
break;
case 194:
#line 1882 "parse.y"
{ yyval.v.filter_prefix = yyvsp[0].v.filter_prefix; }
break;
case 195:
#line 1883 "parse.y"
{ yyval.v.filter_prefix = yyvsp[-1].v.filter_prefix; }
break;
case 197:
#line 1887 "parse.y"
{ yyval.v.filter_prefix = yyvsp[-1].v.filter_prefix; }
break;
case 198:
#line 1889 "parse.y"
{
			struct filter_prefix_l  *p;

			/* merge, both can be lists */
			for (p = yyvsp[-2].v.filter_prefix; p != NULL && p->next != NULL; p = p->next)
				;       /* nothing */
			if (p != NULL)
				p->next = yyvsp[0].v.filter_prefix;
			yyval.v.filter_prefix = yyvsp[-2].v.filter_prefix;
		}
break;
case 199:
#line 1900 "parse.y"
{ yyval.v.filter_prefix = yyvsp[0].v.filter_prefix; }
break;
case 200:
#line 1901 "parse.y"
{
			yyvsp[0].v.filter_prefix->next = yyvsp[-2].v.filter_prefix;
			yyval.v.filter_prefix = yyvsp[0].v.filter_prefix;
		}
break;
case 201:
#line 1907 "parse.y"
{
			if ((yyval.v.filter_prefix = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			memcpy(&yyval.v.filter_prefix->p.addr, &yyvsp[-1].v.prefix.prefix,
			    sizeof(yyval.v.filter_prefix->p.addr));
			yyval.v.filter_prefix->p.len = yyvsp[-1].v.prefix.len;

			if (merge_prefixspec(&yyval.v.filter_prefix->p, &yyvsp[0].v.prefixlen) == -1) {
				free(yyval.v.filter_prefix);
				YYERROR;
			}
		}
break;
case 203:
#line 1923 "parse.y"
{ yyval.v.filter_as = yyvsp[-1].v.filter_as; }
break;
case 205:
#line 1927 "parse.y"
{
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = yyvsp[-2].v.filter_as; a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = yyvsp[0].v.filter_as;
			yyval.v.filter_as = yyvsp[-2].v.filter_as;
		}
break;
case 206:
#line 1939 "parse.y"
{
			yyval.v.filter_as = yyvsp[0].v.filter_as;
			yyval.v.filter_as->a.type = yyvsp[-1].v.u8;
		}
break;
case 207:
#line 1943 "parse.y"
{
			struct filter_as_l	*a;

			yyval.v.filter_as = yyvsp[-1].v.filter_as;
			for (a = yyval.v.filter_as; a != NULL; a = a->next)
				a->a.type = yyvsp[-3].v.u8;
		}
break;
case 208:
#line 1950 "parse.y"
{
			if (as_sets_lookup(&conf->as_sets, yyvsp[0].v.string) == NULL) {
				yyerror("as-set \"%s\" not defined", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.type = yyvsp[-2].v.u8;
			yyval.v.filter_as->a.flags = AS_FLAG_AS_SET_NAME;
			if (strlcpy(yyval.v.filter_as->a.name, yyvsp[0].v.string, sizeof(yyval.v.filter_as->a.name)) >=
			    sizeof(yyval.v.filter_as->a.name)) {
				yyerror("as-set name \"%s\" too long: "
				    "max %zu", yyvsp[0].v.string, sizeof(yyval.v.filter_as->a.name) - 1);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_as);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 210:
#line 1974 "parse.y"
{ yyval.v.filter_as = yyvsp[-1].v.filter_as; }
break;
case 211:
#line 1976 "parse.y"
{
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = yyvsp[-2].v.filter_as; a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = yyvsp[0].v.filter_as;
			yyval.v.filter_as = yyvsp[-2].v.filter_as;
		}
break;
case 213:
#line 1989 "parse.y"
{
			yyvsp[0].v.filter_as->next = yyvsp[-2].v.filter_as;
			yyval.v.filter_as = yyvsp[0].v.filter_as;
		}
break;
case 214:
#line 1995 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.as_min = yyvsp[0].v.number;
			yyval.v.filter_as->a.as_max = yyvsp[0].v.number;
			yyval.v.filter_as->a.op = OP_EQ;
		}
break;
case 215:
#line 2003 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.flags = AS_FLAG_NEIGHBORAS;
		}
break;
case 216:
#line 2009 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			yyval.v.filter_as->a.op = yyvsp[-1].v.u8;
			yyval.v.filter_as->a.as_min = yyvsp[0].v.number;
			yyval.v.filter_as->a.as_max = yyvsp[0].v.number;
		}
break;
case 217:
#line 2017 "parse.y"
{
			if ((yyval.v.filter_as = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			if (yyvsp[-2].v.number >= yyvsp[0].v.number) {
				yyerror("start AS is bigger than end");
				YYERROR;
			}
			yyval.v.filter_as->a.op = yyvsp[-1].v.u8;
			yyval.v.filter_as->a.as_min = yyvsp[-2].v.number;
			yyval.v.filter_as->a.as_max = yyvsp[0].v.number;
		}
break;
case 218:
#line 2031 "parse.y"
{
			bzero(&yyval.v.filter_match, sizeof(yyval.v.filter_match));
		}
break;
case 219:
#line 2034 "parse.y"
{
			bzero(&fmopts, sizeof(fmopts));
		}
break;
case 220:
#line 2037 "parse.y"
{
			memcpy(&yyval.v.filter_match, &fmopts, sizeof(yyval.v.filter_match));
		}
break;
case 223:
#line 2046 "parse.y"
{
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified");
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("\"prefix-set\" already specified, "
				    "cannot be used with \"prefix\" in the "
				    "same filter rule");
				YYERROR;
			}
			fmopts.prefix_l = yyvsp[0].v.filter_prefix;
		}
break;
case 224:
#line 2059 "parse.y"
{
			if (fmopts.as_l != NULL) {
				yyerror("AS filters already specified");
				YYERROR;
			}
			fmopts.as_l = yyvsp[0].v.filter_as;
		}
break;
case 225:
#line 2066 "parse.y"
{
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad max-as-len %lld", yyvsp[0].v.number);
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_MAX;
			fmopts.m.aslen.aslen = yyvsp[0].v.number;
		}
break;
case 226:
#line 2078 "parse.y"
{
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad max-as-seq %lld", yyvsp[0].v.number);
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_SEQ;
			fmopts.m.aslen.aslen = yyvsp[0].v.number;
		}
break;
case 227:
#line 2090 "parse.y"
{
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (parsecommunity(&fmopts.m.community[i], yyvsp[-1].v.u8, yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 228:
#line 2108 "parse.y"
{
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 229:
#line 2130 "parse.y"
{
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    "ovs", yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 230:
#line 2149 "parse.y"
{
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.addr = yyvsp[0].v.addr;
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_ADDR;
		}
break;
case 231:
#line 2157 "parse.y"
{
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_NEIGHBOR;
		}
break;
case 232:
#line 2164 "parse.y"
{
			struct prefixset *ps;
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified, cannot "
				    "be used with \"prefix-set\" in the same "
				    "filter rule");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("prefix-set filter already specified");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if ((ps = find_prefixset(yyvsp[-1].v.string, &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (strlcpy(fmopts.m.prefixset.name, yyvsp[-1].v.string,
			    sizeof(fmopts.m.prefixset.name)) >=
			    sizeof(fmopts.m.prefixset.name)) {
				yyerror("prefix-set name too long");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (!(yyvsp[0].v.prefixlen.op == OP_NONE ||
			    (yyvsp[0].v.prefixlen.op == OP_RANGE &&
			     yyvsp[0].v.prefixlen.len_min == -1 && yyvsp[0].v.prefixlen.len_max == -1))) {
				yyerror("prefix-sets can only use option "
				    "or-longer");
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (yyvsp[0].v.prefixlen.op == OP_RANGE && ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s contains prefixlen "
				    "operators and cannot be used with an "
				    "or-longer filter", yyvsp[-1].v.string);
				free(yyvsp[-1].v.string);
				YYERROR;
			}
			if (yyvsp[0].v.prefixlen.op == OP_RANGE && yyvsp[0].v.prefixlen.len_min == -1 &&
			    yyvsp[0].v.prefixlen.len_min == -1)
				fmopts.m.prefixset.flags |=
				    PREFIXSET_FLAG_LONGER;
			fmopts.m.prefixset.flags |= PREFIXSET_FLAG_FILTER;
			free(yyvsp[-1].v.string);
		}
break;
case 233:
#line 2213 "parse.y"
{
			if (fmopts.m.originset.name[0] != '\0') {
				yyerror("origin-set filter already specified");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (find_prefixset(yyvsp[0].v.string, &conf->originsets) == NULL) {
				yyerror("origin-set '%s' not defined", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			if (strlcpy(fmopts.m.originset.name, yyvsp[0].v.string,
			    sizeof(fmopts.m.originset.name)) >=
			    sizeof(fmopts.m.originset.name)) {
				yyerror("origin-set name too long");
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 234:
#line 2233 "parse.y"
{
			if (fmopts.m.ovs.is_set) {
				yyerror("ovs filter already specified");
				YYERROR;
			}
			fmopts.m.ovs.validity = yyvsp[0].v.number;
			fmopts.m.ovs.is_set = 1;
		}
break;
case 235:
#line 2243 "parse.y"
{ bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen)); }
break;
case 236:
#line 2244 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			yyval.v.prefixlen.op = OP_RANGE;
			yyval.v.prefixlen.len_min = -1;
			yyval.v.prefixlen.len_max = -1;
		}
break;
case 237:
#line 2250 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}

			yyval.v.prefixlen.op = OP_RANGE;
			yyval.v.prefixlen.len_min = -1;
			yyval.v.prefixlen.len_max = yyvsp[0].v.number;
		}
break;
case 238:
#line 2261 "parse.y"
{
			int min, max;

			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}
			/*
			 * convert the unary operation into the equivalent
			 * range check
			 */
			yyval.v.prefixlen.op = OP_RANGE;

			switch (yyvsp[-1].v.u8) {
			case OP_NE:
				yyval.v.prefixlen.op = yyvsp[-1].v.u8;
			case OP_EQ:
				min = max = yyvsp[0].v.number;
				break;
			case OP_LT:
				if (yyvsp[0].v.number == 0) {
					yyerror("prefixlen must be > 0");
					YYERROR;
				}
				yyvsp[0].v.number -= 1;
			case OP_LE:
				min = -1;
				max = yyvsp[0].v.number;
				break;
			case OP_GT:
				yyvsp[0].v.number += 1;
			case OP_GE:
				min = yyvsp[0].v.number;
				max = -1;
				break;
			default:
				yyerror("unknown prefixlen operation");
				YYERROR;
			}
			yyval.v.prefixlen.len_min = min;
			yyval.v.prefixlen.len_max = max;
		}
break;
case 239:
#line 2304 "parse.y"
{
			bzero(&yyval.v.prefixlen, sizeof(yyval.v.prefixlen));
			if (yyvsp[-2].v.number < 0 || yyvsp[-2].v.number > 128 || yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("prefixlen must be < 128");
				YYERROR;
			}
			if (yyvsp[-2].v.number > yyvsp[0].v.number) {
				yyerror("start prefixlen is bigger than end");
				YYERROR;
			}
			yyval.v.prefixlen.op = yyvsp[-1].v.u8;
			yyval.v.prefixlen.len_min = yyvsp[-2].v.number;
			yyval.v.prefixlen.len_max = yyvsp[0].v.number;
		}
break;
case 240:
#line 2320 "parse.y"
{ yyval.v.u8 = AS_ALL; }
break;
case 241:
#line 2321 "parse.y"
{ yyval.v.u8 = AS_SOURCE; }
break;
case 242:
#line 2322 "parse.y"
{ yyval.v.u8 = AS_TRANSIT; }
break;
case 243:
#line 2323 "parse.y"
{ yyval.v.u8 = AS_PEER; }
break;
case 244:
#line 2326 "parse.y"
{ yyval.v.filter_set_head = NULL; }
break;
case 245:
#line 2327 "parse.y"
{
			if ((yyval.v.filter_set_head = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT(yyval.v.filter_set_head);
			TAILQ_INSERT_TAIL(yyval.v.filter_set_head, yyvsp[0].v.filter_set, entry);
		}
break;
case 246:
#line 2334 "parse.y"
{ yyval.v.filter_set_head = yyvsp[-2].v.filter_set_head; }
break;
case 247:
#line 2337 "parse.y"
{
			yyval.v.filter_set_head = yyvsp[-2].v.filter_set_head;
			if (merge_filterset(yyval.v.filter_set_head, yyvsp[0].v.filter_set) == 1)
				YYERROR;
		}
break;
case 248:
#line 2342 "parse.y"
{
			if ((yyval.v.filter_set_head = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT(yyval.v.filter_set_head);
			TAILQ_INSERT_TAIL(yyval.v.filter_set_head, yyvsp[0].v.filter_set, entry);
		}
break;
case 249:
#line 2351 "parse.y"
{ yyval.v.u8 = COMMUNITY_TYPE_BASIC; }
break;
case 250:
#line 2352 "parse.y"
{ yyval.v.u8 = COMMUNITY_TYPE_LARGE; }
break;
case 251:
#line 2355 "parse.y"
{ yyval.v.u8 = 0; }
break;
case 252:
#line 2356 "parse.y"
{ yyval.v.u8 = 1; }
break;
case 253:
#line 2359 "parse.y"
{
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad localpref %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number >= 0) {
				yyval.v.filter_set->type = ACTION_SET_LOCALPREF;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 254:
#line 2374 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad localpref +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 255:
#line 2384 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad localpref -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_LOCALPREF;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 256:
#line 2394 "parse.y"
{
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad metric %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number >= 0) {
				yyval.v.filter_set->type = ACTION_SET_MED;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 257:
#line 2409 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 258:
#line 2419 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 259:
#line 2429 "parse.y"
{	/* alias for MED */
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad metric %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number >= 0) {
				yyval.v.filter_set->type = ACTION_SET_MED;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 260:
#line 2444 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.metric = yyvsp[0].v.number;
		}
break;
case 261:
#line 2454 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad metric -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_MED;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 262:
#line 2464 "parse.y"
{
			if (yyvsp[0].v.number < -INT_MAX || yyvsp[0].v.number > UINT_MAX) {
				yyerror("bad weight %lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[0].v.number > 0) {
				yyval.v.filter_set->type = ACTION_SET_WEIGHT;
				yyval.v.filter_set->action.metric = yyvsp[0].v.number;
			} else {
				yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
				yyval.v.filter_set->action.relative = yyvsp[0].v.number;
			}
		}
break;
case 263:
#line 2479 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad weight +%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
			yyval.v.filter_set->action.relative = yyvsp[0].v.number;
		}
break;
case 264:
#line 2489 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > INT_MAX) {
				yyerror("bad weight -%lld", yyvsp[0].v.number);
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_RELATIVE_WEIGHT;
			yyval.v.filter_set->action.relative = -yyvsp[0].v.number;
		}
break;
case 265:
#line 2499 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP;
			memcpy(&yyval.v.filter_set->action.nexthop, &yyvsp[0].v.addr,
			    sizeof(yyval.v.filter_set->action.nexthop));
		}
break;
case 266:
#line 2506 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_BLACKHOLE;
		}
break;
case 267:
#line 2511 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_REJECT;
		}
break;
case 268:
#line 2516 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_NOMODIFY;
		}
break;
case 269:
#line 2521 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_NEXTHOP_SELF;
		}
break;
case 270:
#line 2526 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_PREPEND_SELF;
			yyval.v.filter_set->action.prepend = yyvsp[0].v.number;
		}
break;
case 271:
#line 2536 "parse.y"
{
			if (yyvsp[0].v.number < 0 || yyvsp[0].v.number > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_PREPEND_PEER;
			yyval.v.filter_set->action.prepend = yyvsp[0].v.number;
		}
break;
case 272:
#line 2546 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_AS_OVERRIDE;
		}
break;
case 273:
#line 2551 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_PFTABLE;
			if (!(cmd_opts & BGPD_OPT_NOACTION) &&
			    pftable_exists(yyvsp[0].v.string) != 0) {
				yyerror("pftable name does not exist");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			if (strlcpy(yyval.v.filter_set->action.pftable, yyvsp[0].v.string,
			    sizeof(yyval.v.filter_set->action.pftable)) >=
			    sizeof(yyval.v.filter_set->action.pftable)) {
				yyerror("pftable name too long");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			if (pftable_add(yyvsp[0].v.string) != 0) {
				yyerror("Couldn't register table");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 274:
#line 2578 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_RTLABEL;
			if (strlcpy(yyval.v.filter_set->action.rtlabel, yyvsp[0].v.string,
			    sizeof(yyval.v.filter_set->action.rtlabel)) >=
			    sizeof(yyval.v.filter_set->action.rtlabel)) {
				yyerror("rtlabel name too long");
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 275:
#line 2592 "parse.y"
{
			u_int8_t f1, f2, f3;

			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[-1].v.u8)
				yyval.v.filter_set->type = ACTION_DEL_COMMUNITY;
			else
				yyval.v.filter_set->type = ACTION_SET_COMMUNITY;

			if (parsecommunity(&yyval.v.filter_set->action.community, yyvsp[-2].v.u8, yyvsp[0].v.string) ==
			    -1) {
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
			/* Don't allow setting of any match */
			f1 = yyval.v.filter_set->action.community.flags >> 8;
			f2 = yyval.v.filter_set->action.community.flags >> 16;
			f3 = yyval.v.filter_set->action.community.flags >> 24;
			if (!yyvsp[-1].v.u8 && (f1 == COMMUNITY_ANY ||
			    f2 == COMMUNITY_ANY || f3 == COMMUNITY_ANY)) {
				yyerror("'*' is not allowed in set community");
				free(yyval.v.filter_set);
				YYERROR;
			}
		}
break;
case 276:
#line 2620 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[-2].v.u8)
				yyval.v.filter_set->type = ACTION_DEL_COMMUNITY;
			else
				yyval.v.filter_set->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&yyval.v.filter_set->action.community,
			    yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 277:
#line 2638 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if (yyvsp[-2].v.u8)
				yyval.v.filter_set->type = ACTION_DEL_COMMUNITY;
			else
				yyval.v.filter_set->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&yyval.v.filter_set->action.community,
			    "ovs", yyvsp[0].v.string) == -1) {
				free(yyvsp[0].v.string);
				free(yyval.v.filter_set);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 278:
#line 2654 "parse.y"
{
			if ((yyval.v.filter_set = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			yyval.v.filter_set->type = ACTION_SET_ORIGIN;
			yyval.v.filter_set->action.origin = yyvsp[0].v.number;
		}
break;
case 279:
#line 2662 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "egp"))
				yyval.v.number = ORIGIN_EGP;
			else if (!strcmp(yyvsp[0].v.string, "igp"))
				yyval.v.number = ORIGIN_IGP;
			else if (!strcmp(yyvsp[0].v.string, "incomplete"))
				yyval.v.number = ORIGIN_INCOMPLETE;
			else {
				yyerror("unknown origin \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 280:
#line 2677 "parse.y"
{
			if (!strcmp(yyvsp[0].v.string, "not-found"))
				yyval.v.number = ROA_NOTFOUND;
			else if (!strcmp(yyvsp[0].v.string, "invalid"))
				yyval.v.number = ROA_INVALID;
			else if (!strcmp(yyvsp[0].v.string, "valid"))
				yyval.v.number = ROA_VALID;
			else {
				yyerror("unknown validity \"%s\"", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);
		}
break;
case 287:
#line 2702 "parse.y"
{ yyval.v.u8 = OP_EQ; }
break;
case 288:
#line 2703 "parse.y"
{ yyval.v.u8 = OP_NE; }
break;
case 289:
#line 2704 "parse.y"
{ yyval.v.u8 = OP_LE; }
break;
case 290:
#line 2705 "parse.y"
{ yyval.v.u8 = OP_LT; }
break;
case 291:
#line 2706 "parse.y"
{ yyval.v.u8 = OP_GE; }
break;
case 292:
#line 2707 "parse.y"
{ yyval.v.u8 = OP_GT; }
break;
case 293:
#line 2710 "parse.y"
{ yyval.v.u8 = OP_EQ; }
break;
case 294:
#line 2711 "parse.y"
{ yyval.v.u8 = OP_NE; }
break;
case 295:
#line 2714 "parse.y"
{ yyval.v.u8 = OP_RANGE; }
break;
case 296:
#line 2715 "parse.y"
{ yyval.v.u8 = OP_XRANGE; }
break;
#line 6127 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
