/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import jde.debugger.Etc;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class DebugThread
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.m_args.remove(0), "thread ID");
        ThreadReference tRef = (ThreadReference)this.m_debugger.getStore().get(uniqueID);
        if (tRef == null) {
            throw new JDEException("Invalid thread ID or the thread is dead");
        }
        this.m_debugger.getVM().suspend();
        try {
            String locationRep = Rep.getLocationRep(tRef.frame(0).location());
            String lispForm = "(list 'jde-dbo-step-event " + locationRep + ")";
            JDE.signal(this.m_debugger.getProcID(), "event-set", "\"thread\" " + Rep.getThreadRep(tRef) + Protocol.BR + lispForm);
            this.m_debugger.signalCommandResult(this.m_cmdID, null, true);
        }
        catch (IncompatibleThreadStateException exc) {
            throw new JDEException(exc.toString());
        }
    }

    public Object clone() {
        return new DebugThread();
    }
}

