/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command;

import java.util.EnumSet;
import java.util.function.Consumer;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.CommandRuntime;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.converter.ConverterInvocationProvider;
import org.aesh.command.impl.AeshCommandRuntime;
import org.aesh.command.impl.activator.AeshCommandActivatorProvider;
import org.aesh.command.impl.activator.AeshOptionActivatorProvider;
import org.aesh.command.impl.completer.AeshCompleterInvocationProvider;
import org.aesh.command.impl.converter.AeshConverterInvocationProvider;
import org.aesh.command.impl.invocation.AeshCommandInvocationProvider;
import org.aesh.command.impl.invocation.DefaultCommandInvocationBuilder;
import org.aesh.command.impl.registry.MutableCommandRegistryImpl;
import org.aesh.command.impl.validator.AeshValidatorInvocationProvider;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationBuilder;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.operator.OperatorType;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.command.validator.ValidatorInvocationProvider;
import org.aesh.readline.AeshContext;
import org.aesh.readline.DefaultAeshContext;

public class AeshCommandRuntimeBuilder<CI extends CommandInvocation> {
    public static final EnumSet<OperatorType> ALL_OPERATORS = EnumSet.allOf(OperatorType.class);
    private static final EnumSet<OperatorType> NO_OPERATORS = EnumSet.noneOf(OperatorType.class);
    private CommandRegistry<CI> registry;
    private CommandInvocationProvider<CI> commandInvocationProvider;
    private CommandNotFoundHandler commandNotFoundHandler;
    private CompleterInvocationProvider<? extends CompleterInvocation> completerInvocationProvider;
    private ConverterInvocationProvider<? extends ConverterInvocation> converterInvocationProvider;
    private ValidatorInvocationProvider<? extends ValidatorInvocation> validatorInvocationProvider;
    private OptionActivatorProvider<? extends OptionActivator> optionActivatorProvider;
    private CommandActivatorProvider<? extends CommandActivator> commandActivatorProvider;
    private AeshContext ctx;
    private CommandInvocationBuilder<CI> commandInvocationBuilder;
    private Shell shell;
    private boolean parseBrackets;
    private EnumSet<OperatorType> operators;

    private AeshCommandRuntimeBuilder() {
    }

    public static <T extends CommandInvocation> AeshCommandRuntimeBuilder<T> builder() {
        return new AeshCommandRuntimeBuilder();
    }

    public AeshCommandRuntimeBuilder<CI> parseBrackets(boolean parseBrackets) {
        this.parseBrackets = parseBrackets;
        return this;
    }

    public AeshCommandRuntimeBuilder<CI> operators(EnumSet<OperatorType> operators) {
        this.operators = operators;
        return this;
    }

    public AeshCommandRuntimeBuilder<CI> commandRegistry(CommandRegistry<CI> registry) {
        this.registry = registry;
        return this;
    }

    private AeshCommandRuntimeBuilder<CI> apply(Consumer<AeshCommandRuntimeBuilder<CI>> consumer) {
        consumer.accept(this);
        return this;
    }

    public AeshCommandRuntimeBuilder<CI> commandInvocationProvider(CommandInvocationProvider<CI> commandInvocationProvider) {
        return this.apply(c -> {
            c.commandInvocationProvider = commandInvocationProvider;
        });
    }

    public AeshCommandRuntimeBuilder<CI> commandNotFoundHandler(CommandNotFoundHandler commandNotFoundHandler) {
        return this.apply(c -> {
            c.commandNotFoundHandler = commandNotFoundHandler;
        });
    }

    public AeshCommandRuntimeBuilder<CI> completerInvocationProvider(CompleterInvocationProvider<? extends CompleterInvocation> completerInvocationProvider) {
        return this.apply(c -> {
            c.completerInvocationProvider = completerInvocationProvider;
        });
    }

    public AeshCommandRuntimeBuilder<CI> converterInvocationProvider(ConverterInvocationProvider<? extends ConverterInvocation> converterInvocationProvider) {
        return this.apply(c -> {
            c.converterInvocationProvider = converterInvocationProvider;
        });
    }

    public AeshCommandRuntimeBuilder<CI> validatorInvocationProvider(ValidatorInvocationProvider<? extends ValidatorInvocation> validatorInvocationProvider) {
        return this.apply(c -> {
            c.validatorInvocationProvider = validatorInvocationProvider;
        });
    }

    public AeshCommandRuntimeBuilder<CI> optionActivatorProvider(OptionActivatorProvider<? extends OptionActivator> optionActivatorProvider) {
        return this.apply(c -> {
            c.optionActivatorProvider = optionActivatorProvider;
        });
    }

    public AeshCommandRuntimeBuilder<CI> commandActivatorProvider(CommandActivatorProvider<? extends CommandActivator> commandActivatorProvider) {
        return this.apply(c -> {
            c.commandActivatorProvider = commandActivatorProvider;
        });
    }

    public AeshCommandRuntimeBuilder<CI> shell(Shell shell) {
        return this.apply(c -> {
            c.shell = shell;
        });
    }

    public AeshCommandRuntimeBuilder<CI> commandInvocationBuilder(CommandInvocationBuilder commandInvocationBuilder) {
        return this.apply(c -> {
            c.commandInvocationBuilder = commandInvocationBuilder;
        });
    }

    public AeshCommandRuntimeBuilder<CI> aeshContext(AeshContext ctx) {
        return this.apply(c -> {
            c.ctx = ctx;
        });
    }

    public AeshCommandRuntimeBuilder<CI> settings(Settings<? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings) {
        return this.apply(c -> {
            c.commandInvocationProvider = settings.commandInvocationProvider();
            c.commandNotFoundHandler = settings.commandNotFoundHandler();
            c.completerInvocationProvider = settings.completerInvocationProvider();
            c.converterInvocationProvider = settings.converterInvocationProvider();
            c.validatorInvocationProvider = settings.validatorInvocationProvider();
            c.optionActivatorProvider = settings.optionActivatorProvider();
            c.commandActivatorProvider = settings.commandActivatorProvider();
            c.registry = settings.commandRegistry();
            c.ctx = settings.aeshContext();
            c.operators = settings.operatorParserEnabled() ? EnumSet.allOf(OperatorType.class) : null;
        });
    }

    public CommandRuntime<CI> build() {
        if (this.registry == null) {
            this.registry = new MutableCommandRegistryImpl();
        }
        if (this.commandInvocationProvider == null) {
            this.commandInvocationProvider = new AeshCommandInvocationProvider();
        }
        if (this.completerInvocationProvider == null) {
            this.completerInvocationProvider = new AeshCompleterInvocationProvider();
        }
        if (this.converterInvocationProvider == null) {
            this.converterInvocationProvider = new AeshConverterInvocationProvider();
        }
        if (this.validatorInvocationProvider == null) {
            this.validatorInvocationProvider = new AeshValidatorInvocationProvider();
        }
        if (this.optionActivatorProvider == null) {
            this.optionActivatorProvider = new AeshOptionActivatorProvider();
        }
        if (this.commandActivatorProvider == null) {
            this.commandActivatorProvider = new AeshCommandActivatorProvider();
        }
        if (this.commandInvocationBuilder == null) {
            this.commandInvocationBuilder = new DefaultCommandInvocationBuilder(this.shell);
        }
        if (this.ctx == null) {
            this.ctx = new DefaultAeshContext();
        }
        if (this.operators == null) {
            this.operators = NO_OPERATORS;
        }
        return new AeshCommandRuntime<CI>(this.ctx, this.registry, this.commandInvocationProvider, this.commandNotFoundHandler, this.completerInvocationProvider, this.converterInvocationProvider, this.validatorInvocationProvider, this.optionActivatorProvider, this.commandActivatorProvider, this.commandInvocationBuilder, this.parseBrackets, this.operators);
    }
}

