/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.GetCapabilitiesParseHelper;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.LayerDetails;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class WMSImagery {
    private static final String CAPABILITIES_QUERY_STRING = "SERVICE=WMS&REQUEST=GetCapabilities";
    public static final String WMS_NS_URL = "http://www.opengis.net/wms";
    private static final QName CAPABILITITES_ROOT_130 = new QName("WMS_Capabilities", "http://www.opengis.net/wms");
    private static final QName QN_ABSTRACT = new QName("http://www.opengis.net/wms", "Abstract");
    private static final QName QN_CAPABILITY = new QName("http://www.opengis.net/wms", "Capability");
    private static final QName QN_CRS = new QName("http://www.opengis.net/wms", "CRS");
    private static final QName QN_DCPTYPE = new QName("http://www.opengis.net/wms", "DCPType");
    private static final QName QN_FORMAT = new QName("http://www.opengis.net/wms", "Format");
    private static final QName QN_GET = new QName("http://www.opengis.net/wms", "Get");
    private static final QName QN_GETMAP = new QName("http://www.opengis.net/wms", "GetMap");
    private static final QName QN_HTTP = new QName("http://www.opengis.net/wms", "HTTP");
    private static final QName QN_LAYER = new QName("http://www.opengis.net/wms", "Layer");
    private static final QName QN_NAME = new QName("http://www.opengis.net/wms", "Name");
    private static final QName QN_REQUEST = new QName("http://www.opengis.net/wms", "Request");
    private static final QName QN_SERVICE = new QName("http://www.opengis.net/wms", "Service");
    private static final QName QN_STYLE = new QName("http://www.opengis.net/wms", "Style");
    private static final QName QN_TITLE = new QName("http://www.opengis.net/wms", "Title");
    private static final QName QN_BOUNDINGBOX = new QName("http://www.opengis.net/wms", "BoundingBox");
    private static final QName QN_EX_GEOGRAPHIC_BBOX = new QName("http://www.opengis.net/wms", "EX_GeographicBoundingBox");
    private static final QName QN_WESTBOUNDLONGITUDE = new QName("http://www.opengis.net/wms", "westBoundLongitude");
    private static final QName QN_EASTBOUNDLONGITUDE = new QName("http://www.opengis.net/wms", "eastBoundLongitude");
    private static final QName QN_SOUTHBOUNDLATITUDE = new QName("http://www.opengis.net/wms", "southBoundLatitude");
    private static final QName QN_NORTHBOUNDLATITUDE = new QName("http://www.opengis.net/wms", "northBoundLatitude");
    private static final QName QN_ONLINE_RESOURCE = new QName("http://www.opengis.net/wms", "OnlineResource");
    private static final QName CAPABILITIES_ROOT_111 = new QName("WMT_MS_Capabilities");
    private static final QName QN_SRS = new QName("SRS");
    private static final QName QN_LATLONBOUNDINGBOX = new QName("LatLonBoundingBox");
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private String version = "1.1.1";
    private String getMapUrl;
    private URL capabilitiesUrl;
    private final List<String> formats = new ArrayList<String>();
    private List<LayerDetails> layers = new ArrayList<LayerDetails>();
    private String title;

    public WMSImagery(String url) throws IOException, WMSGetCapabilitiesException {
        this(url, null);
    }

    public WMSImagery(String url, Map<String, String> headers) throws IOException, WMSGetCapabilitiesException {
        if (headers != null) {
            this.headers.putAll(headers);
        }
        IOException savedExc = null;
        String workingAddress = null;
        block6: for (String z : new String[]{WMSImagery.normalizeUrl(url), url, url + CAPABILITIES_QUERY_STRING}) {
            for (String ver : new String[]{"", "&VERSION=1.3.0", "&VERSION=1.1.1"}) {
                try {
                    this.attemptGetCapabilities(z + ver);
                    workingAddress = z;
                    this.calculateChildren();
                    savedExc = null;
                    break block6;
                }
                catch (IOException e) {
                    savedExc = e;
                    Logging.warn(e);
                }
            }
        }
        if (workingAddress != null) {
            try {
                this.capabilitiesUrl = new URL(workingAddress);
            }
            catch (MalformedURLException e) {
                if (savedExc == null) {
                    savedExc = e;
                }
                try {
                    this.capabilitiesUrl = new File(workingAddress).toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    Logging.trace(e1);
                }
            }
        }
        if (savedExc != null) {
            throw savedExc;
        }
    }

    private void calculateChildren() {
        Map<LayerDetails, List<LayerDetails>> layerChildren = this.layers.stream().filter(x -> x.getParent() != null).collect(Collectors.groupingBy(LayerDetails::getParent));
        for (LayerDetails ld : this.layers) {
            if (!layerChildren.containsKey(ld)) continue;
            ld.setChildren(layerChildren.get(ld));
        }
        this.layers = this.layers.stream().filter(x -> x.getParent() == null).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<LayerDetails> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public Collection<String> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public String getPreferredFormat() {
        if (this.formats.contains("image/png")) {
            return "image/png";
        }
        if (this.formats.contains("image/jpeg")) {
            return "image/jpeg";
        }
        if (this.formats.isEmpty()) {
            return null;
        }
        return this.formats.get(0);
    }

    public String buildRootUrl() {
        if (this.getMapUrl == null && this.capabilitiesUrl == null) {
            return null;
        }
        if (this.getMapUrl != null) {
            return this.getMapUrl;
        }
        URL serviceUrl = this.capabilitiesUrl;
        StringBuilder a = new StringBuilder(serviceUrl.getProtocol());
        a.append("://").append(serviceUrl.getHost());
        if (serviceUrl.getPort() != -1) {
            a.append(':').append(serviceUrl.getPort());
        }
        a.append(serviceUrl.getPath()).append('?');
        if (serviceUrl.getQuery() != null) {
            a.append(serviceUrl.getQuery());
            if (!serviceUrl.getQuery().isEmpty() && !serviceUrl.getQuery().endsWith("&")) {
                a.append('&');
            }
        }
        return a.toString();
    }

    public String buildGetMapUrl(List<DefaultLayer> selectedLayers, boolean transparent) {
        return this.buildGetMapUrl(this.getLayers(selectedLayers), selectedLayers.stream().map(DefaultLayer::getStyle).collect(Collectors.toList()), transparent);
    }

    public String buildGetMapUrl(List<LayerDetails> selectedLayers, List<String> selectedStyles, boolean transparent) {
        return this.buildGetMapUrl(selectedLayers.stream().map(LayerDetails::getName).collect(Collectors.toList()), selectedStyles, this.getPreferredFormat(), transparent);
    }

    public String buildGetMapUrl(List<String> selectedLayers, Collection<String> selectedStyles, String format, boolean transparent) {
        Utils.ensure(selectedStyles == null || selectedLayers.size() == selectedStyles.size(), I18n.tr("Styles size {0} does not match layers size {1}", new Object[0]), selectedStyles == null ? 0 : selectedStyles.size(), selectedLayers.size());
        return this.buildRootUrl() + "FORMAT=" + format + (WMSImagery.imageFormatHasTransparency(format) && transparent ? "&TRANSPARENT=TRUE" : "") + "&VERSION=" + this.version + "&SERVICE=WMS&REQUEST=GetMap&LAYERS=" + selectedLayers.stream().collect(Collectors.joining(",")) + "&STYLES=" + (selectedStyles != null ? Utils.join(",", selectedStyles) : "") + "&" + (this.belowWMS130() ? "SRS" : "CRS") + "={proj}&WIDTH={width}&HEIGHT={height}&BBOX={bbox}";
    }

    private boolean tagEquals(QName a, QName b) {
        boolean ret = a.equals(b);
        if (ret) {
            return ret;
        }
        if (this.belowWMS130()) {
            return a.getLocalPart().equals(b.getLocalPart());
        }
        return false;
    }

    private void attemptGetCapabilities(String url) throws IOException, WMSGetCapabilitiesException {
        Logging.debug("Trying WMS getcapabilities with url {0}", url);
        try (CachedFile cf = new CachedFile(url);
             InputStream in = cf.setHttpHeaders(this.headers).setMaxAge(7L * CachedFile.DAYS).setCachingStrategy(CachedFile.CachingStrategy.IfModifiedSince).getInputStream();){
            try {
                XMLStreamReader reader = GetCapabilitiesParseHelper.getReader(in);
                int event = reader.getEventType();
                while (reader.hasNext()) {
                    if (event == 1) {
                        if (this.tagEquals(CAPABILITIES_ROOT_111, reader.getName())) {
                            this.version = reader.getAttributeValue(null, "version");
                            if (this.version == null) {
                                this.version = "1.1.1";
                            }
                        }
                        if (this.tagEquals(CAPABILITITES_ROOT_130, reader.getName())) {
                            this.version = reader.getAttributeValue(WMS_NS_URL, "version");
                        }
                        if (this.tagEquals(QN_SERVICE, reader.getName())) {
                            this.parseService(reader);
                        }
                        if (this.tagEquals(QN_CAPABILITY, reader.getName())) {
                            this.parseCapability(reader);
                        }
                    }
                    event = reader.next();
                }
            }
            catch (XMLStreamException e) {
                String content = new String(cf.getByteContent(), StandardCharsets.UTF_8);
                cf.clear();
                throw new WMSGetCapabilitiesException(e, content);
            }
        }
    }

    private void parseService(XMLStreamReader reader) throws XMLStreamException {
        if (GetCapabilitiesParseHelper.moveReaderToTag(reader, this::tagEquals, QN_TITLE)) {
            this.title = reader.getElementText();
            int event = reader.getEventType();
            while (reader.hasNext() && (event != 2 || !this.tagEquals(QN_SERVICE, reader.getName()))) {
                event = reader.next();
            }
        }
    }

    private void parseCapability(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !this.tagEquals(QN_CAPABILITY, reader.getName()))) {
            if (event == 1) {
                if (this.tagEquals(QN_REQUEST, reader.getName())) {
                    this.parseRequest(reader);
                }
                if (this.tagEquals(QN_LAYER, reader.getName())) {
                    this.parseLayer(reader, null);
                }
            }
            event = reader.next();
        }
    }

    private void parseRequest(XMLStreamReader reader) throws XMLStreamException {
        String mode = "";
        String getMapUrl = "";
        if (GetCapabilitiesParseHelper.moveReaderToTag(reader, this::tagEquals, QN_GETMAP)) {
            int event = reader.getEventType();
            while (reader.hasNext() && (event != 2 || !this.tagEquals(QN_GETMAP, reader.getName()))) {
                if (event == 1) {
                    String value;
                    if (this.tagEquals(QN_FORMAT, reader.getName()) && WMSImagery.isImageFormatSupportedWarn(value = reader.getElementText()) && !this.formats.contains(value)) {
                        this.formats.add(value);
                    }
                    if (this.tagEquals(QN_DCPTYPE, reader.getName()) && GetCapabilitiesParseHelper.moveReaderToTag(reader, this::tagEquals, QN_HTTP, QN_GET)) {
                        mode = reader.getName().getLocalPart();
                        if (GetCapabilitiesParseHelper.moveReaderToTag(reader, this::tagEquals, QN_ONLINE_RESOURCE)) {
                            getMapUrl = reader.getAttributeValue("http://www.w3.org/1999/xlink", "href");
                        }
                        if ("GET".equalsIgnoreCase(mode) && getMapUrl != null && !"".equals(getMapUrl)) {
                            try {
                                String query = new URL(getMapUrl).getQuery();
                                this.getMapUrl = query == null ? getMapUrl + "?" : getMapUrl;
                            }
                            catch (MalformedURLException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                    }
                }
                event = reader.next();
            }
        }
    }

    private void parseLayer(XMLStreamReader reader, LayerDetails parentLayer) throws XMLStreamException {
        LayerDetails ret = new LayerDetails(parentLayer);
        int event = reader.next();
        while (reader.hasNext() && (event != 2 || !this.tagEquals(QN_LAYER, reader.getName()))) {
            if (event == 1) {
                if (this.tagEquals(QN_NAME, reader.getName())) {
                    ret.setName(reader.getElementText());
                } else if (this.tagEquals(QN_ABSTRACT, reader.getName())) {
                    ret.setAbstract(GetCapabilitiesParseHelper.getElementTextWithSubtags(reader));
                } else if (this.tagEquals(QN_TITLE, reader.getName())) {
                    ret.setTitle(reader.getElementText());
                } else if (this.tagEquals(QN_CRS, reader.getName())) {
                    ret.addCrs(reader.getElementText());
                } else if (this.tagEquals(QN_SRS, reader.getName()) && this.belowWMS130()) {
                    ret.addCrs(reader.getElementText());
                } else if (this.tagEquals(QN_STYLE, reader.getName())) {
                    this.parseAndAddStyle(reader, ret);
                } else if (this.tagEquals(QN_LAYER, reader.getName())) {
                    this.parseLayer(reader, ret);
                } else if (this.tagEquals(QN_EX_GEOGRAPHIC_BBOX, reader.getName()) && ret.getBounds() == null) {
                    ret.setBounds(this.parseExGeographic(reader));
                } else if (this.tagEquals(QN_BOUNDINGBOX, reader.getName())) {
                    Projection conv = this.belowWMS130() ? Projections.getProjectionByCode(reader.getAttributeValue(WMS_NS_URL, "SRS")) : Projections.getProjectionByCode(reader.getAttributeValue(WMS_NS_URL, "CRS"));
                    if (ret.getBounds() == null && conv != null) {
                        ret.setBounds(this.parseBoundingBox(reader, conv));
                    }
                } else if (this.tagEquals(QN_LATLONBOUNDINGBOX, reader.getName()) && this.belowWMS130() && ret.getBounds() == null) {
                    ret.setBounds(this.parseBoundingBox(reader, null));
                } else {
                    GetCapabilitiesParseHelper.moveReaderToEndCurrentTag(reader);
                }
            }
            event = reader.next();
        }
        this.layers.add(ret);
    }

    public boolean belowWMS130() {
        return "1.1.1".equals(this.version) || "1.1".equals(this.version) || "1.0".equals(this.version);
    }

    private void parseAndAddStyle(XMLStreamReader reader, LayerDetails ld) throws XMLStreamException {
        String name = null;
        String title = null;
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !this.tagEquals(QN_STYLE, reader.getName()))) {
            if (event == 1) {
                if (this.tagEquals(QN_NAME, reader.getName())) {
                    name = reader.getElementText();
                }
                if (this.tagEquals(QN_TITLE, reader.getName())) {
                    title = reader.getElementText();
                }
            }
            event = reader.next();
        }
        if (name == null) {
            name = "";
        }
        ld.addStyle(name, title);
    }

    private Bounds parseExGeographic(XMLStreamReader reader) throws XMLStreamException {
        String minx = null;
        String maxx = null;
        String maxy = null;
        String miny = null;
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !this.tagEquals(QN_EX_GEOGRAPHIC_BBOX, reader.getName()))) {
            if (event == 1) {
                if (this.tagEquals(QN_WESTBOUNDLONGITUDE, reader.getName())) {
                    minx = reader.getElementText();
                }
                if (this.tagEquals(QN_EASTBOUNDLONGITUDE, reader.getName())) {
                    maxx = reader.getElementText();
                }
                if (this.tagEquals(QN_SOUTHBOUNDLATITUDE, reader.getName())) {
                    miny = reader.getElementText();
                }
                if (this.tagEquals(QN_NORTHBOUNDLATITUDE, reader.getName())) {
                    maxy = reader.getElementText();
                }
            }
            event = reader.next();
        }
        return WMSImagery.parseBBox(null, miny, minx, maxy, maxx);
    }

    private Bounds parseBoundingBox(XMLStreamReader reader, Projection conv) {
        UnaryOperator attrGetter = tag -> this.belowWMS130() ? reader.getAttributeValue(null, (String)tag) : reader.getAttributeValue(WMS_NS_URL, (String)tag);
        return WMSImagery.parseBBox(conv, (String)attrGetter.apply("miny"), (String)attrGetter.apply("minx"), (String)attrGetter.apply("maxy"), (String)attrGetter.apply("maxx"));
    }

    private static Bounds parseBBox(Projection conv, String miny, String minx, String maxy, String maxx) {
        if (miny == null || minx == null || maxy == null || maxx == null) {
            return null;
        }
        if (conv != null) {
            return new Bounds(conv.eastNorth2latlon(new EastNorth(WMSImagery.getDecimalDegree(minx), WMSImagery.getDecimalDegree(miny))), conv.eastNorth2latlon(new EastNorth(WMSImagery.getDecimalDegree(maxx), WMSImagery.getDecimalDegree(maxy))));
        }
        return new Bounds(WMSImagery.getDecimalDegree(miny), WMSImagery.getDecimalDegree(minx), WMSImagery.getDecimalDegree(maxy), WMSImagery.getDecimalDegree(maxx));
    }

    private static double getDecimalDegree(String value) {
        return Double.parseDouble(value.replace(',', '.'));
    }

    private static String normalizeUrl(String serviceUrlStr) throws MalformedURLException {
        URL getCapabilitiesUrl = null;
        String ret = null;
        ret = !Pattern.compile(".*GetCapabilities.*", 2).matcher(serviceUrlStr).matches() ? ((getCapabilitiesUrl = new URL(serviceUrlStr)).getQuery() == null ? serviceUrlStr + '?' + CAPABILITIES_QUERY_STRING : (!getCapabilitiesUrl.getQuery().isEmpty() && !getCapabilitiesUrl.getQuery().endsWith("&") ? serviceUrlStr + '&' + CAPABILITIES_QUERY_STRING : serviceUrlStr + CAPABILITIES_QUERY_STRING)) : serviceUrlStr;
        return ret;
    }

    private static boolean isImageFormatSupportedWarn(String format) {
        boolean isFormatSupported = WMSImagery.isImageFormatSupported(format);
        if (!isFormatSupported) {
            Logging.info("Skipping unsupported image format {0}", format);
        }
        return isFormatSupported;
    }

    static boolean isImageFormatSupported(String format) {
        return ImageIO.getImageReadersByMIMEType(format).hasNext() || WMSImagery.isImageFormatSupported(format, "tiff", "geotiff") || WMSImagery.isImageFormatSupported(format, "png") || WMSImagery.isImageFormatSupported(format, "svg") || WMSImagery.isImageFormatSupported(format, "bmp");
    }

    static boolean isImageFormatSupported(String format, String ... mimeFormats) {
        for (String mime : mimeFormats) {
            if (!format.startsWith("image/" + mime)) continue;
            return ImageIO.getImageReadersBySuffix(mimeFormats[0]).hasNext();
        }
        return false;
    }

    static boolean imageFormatHasTransparency(String format) {
        return format != null && (format.startsWith("image/png") || format.startsWith("image/gif") || format.startsWith("image/svg") || format.startsWith("image/tiff"));
    }

    public ImageryInfo toImageryInfo(String name, List<LayerDetails> selectedLayers, List<String> selectedStyles, boolean transparent) {
        ImageryInfo i = new ImageryInfo(name, this.buildGetMapUrl(selectedLayers, selectedStyles, transparent));
        if (selectedLayers != null && !selectedLayers.isEmpty()) {
            i.setServerProjections(this.getServerProjections(selectedLayers));
        }
        return i;
    }

    public Collection<String> getServerProjections(List<LayerDetails> selectedLayers) {
        if (selectedLayers.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> proj = new HashSet<String>(selectedLayers.get(0).getCrs());
        for (LayerDetails ld : selectedLayers) {
            proj.retainAll(ld.getCrs());
        }
        return proj;
    }

    public List<LayerDetails> getLayers(List<DefaultLayer> defaultLayers) {
        Collection layerNames = defaultLayers.stream().map(DefaultLayer::getLayerName).collect(Collectors.toList());
        return this.layers.stream().flatMap(LayerDetails::flattened).filter(x -> layerNames.contains(x.getName())).collect(Collectors.toList());
    }

    public String getTitle() {
        return this.title;
    }

    public static class WMSGetCapabilitiesException
    extends Exception {
        private final String incomingData;

        public WMSGetCapabilitiesException(Throwable cause, String incomingData) {
            super(cause);
            this.incomingData = incomingData;
        }

        public WMSGetCapabilitiesException(String message, String incomingData) {
            super(message);
            this.incomingData = incomingData;
        }

        public String getIncomingData() {
            return this.incomingData;
        }
    }
}

