/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsUtils;

public final class ServerName {
    private final short nameType;
    private final byte[] nameData;

    public ServerName(short s2, byte[] byArray) {
        if (!TlsUtils.isValidUint8(s2)) {
            throw new IllegalArgumentException("'nameType' must be from 0 to 255");
        }
        if (null == byArray) {
            throw new NullPointerException("'nameData' cannot be null");
        }
        if (byArray.length < 1 || !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'nameData' must have length from 1 to 65535");
        }
        this.nameType = s2;
        this.nameData = byArray;
    }

    public short getNameType() {
        return this.nameType;
    }

    public byte[] getNameData() {
        return this.nameData;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.nameType, outputStream);
        TlsUtils.writeOpaque16(this.nameData, outputStream);
    }

    public static ServerName parse(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        return new ServerName(s2, byArray);
    }
}

