/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import com.sun.java.swing.plaf.motif.MotifTextAreaUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.ComponentPeer;
import java.awt.peer.TextAreaPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

final class XTextAreaPeer
extends XComponentPeer
implements TextAreaPeer {
    private final AWTTextPane textPane;
    private final AWTTextArea jtext;
    private final boolean firstChangeSkipped;
    private final JavaMouseEventHandler javaMouseEventHandler = new JavaMouseEventHandler(this);

    XTextAreaPeer(TextArea textArea) {
        super(textArea);
        this.target = textArea;
        String string = textArea.getText();
        this.jtext = new AWTTextArea(string, this);
        this.jtext.setWrapStyleWord(true);
        this.jtext.getDocument().addDocumentListener(this.jtext);
        XToolkit.specialPeerMap.put(this.jtext, this);
        this.textPane = new AWTTextPane(this.jtext, this, textArea.getParent());
        this.setBounds(this.x, this.y, this.width, this.height, 3);
        this.textPane.setVisible(true);
        this.textPane.validate();
        AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
        this.foreground = componentAccessor.getForeground(textArea);
        if (this.foreground == null) {
            this.foreground = SystemColor.textText;
        }
        this.setForeground(this.foreground);
        this.background = componentAccessor.getBackground(textArea);
        if (this.background == null) {
            this.background = textArea.isEditable() ? SystemColor.text : SystemColor.control;
        }
        this.setBackground(this.background);
        if (!textArea.isBackgroundSet()) {
            componentAccessor.setBackground(textArea, this.background);
        }
        if (!textArea.isForegroundSet()) {
            textArea.setForeground(SystemColor.textText);
        }
        this.setFont(this.font);
        this.setTextImpl(textArea.getText());
        int n = textArea.getSelectionStart();
        int n2 = textArea.getSelectionEnd();
        this.setCaretPosition(Math.min(n2, string.length()));
        if (n2 > n) {
            this.select(n, n2);
        }
        this.setEditable(textArea.isEditable());
        this.setScrollBarVisibility();
        this.firstChangeSkipped = true;
    }

    @Override
    public void dispose() {
        XToolkit.specialPeerMap.remove(this.jtext);
        this.jtext.getCaret().setVisible(false);
        this.jtext.removeNotify();
        this.textPane.removeNotify();
        super.dispose();
    }

    @Override
    public void pSetCursor(Cursor cursor, boolean bl) {
        if (bl || this.javaMouseEventHandler == null) {
            super.pSetCursor(cursor, true);
            return;
        }
        Point point = new Point();
        ((XGlobalCursorManager)XGlobalCursorManager.getCursorManager()).getCursorPos(point);
        Point point2 = this.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        this.javaMouseEventHandler.setPointerToUnderPoint(point3);
        this.javaMouseEventHandler.setCursor();
    }

    private void setScrollBarVisibility() {
        int n = ((TextArea)this.target).getScrollbarVisibility();
        this.jtext.setLineWrap(false);
        if (n == 3) {
            this.textPane.setHorizontalScrollBarPolicy(31);
            this.textPane.setVerticalScrollBarPolicy(21);
            this.jtext.setLineWrap(true);
        } else if (n == 0) {
            this.textPane.setHorizontalScrollBarPolicy(32);
            this.textPane.setVerticalScrollBarPolicy(22);
        } else if (n == 1) {
            this.textPane.setHorizontalScrollBarPolicy(31);
            this.textPane.setVerticalScrollBarPolicy(22);
            this.jtext.setLineWrap(true);
        } else if (n == 2) {
            this.textPane.setVerticalScrollBarPolicy(21);
            this.textPane.setHorizontalScrollBarPolicy(32);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    @Override
    public Dimension getPreferredSize(int n, int n2) {
        return this.getMinimumSize(n, n2);
    }

    @Override
    public Dimension getMinimumSize(int n, int n2) {
        JScrollBar jScrollBar;
        int n3 = 0;
        int n4 = 0;
        JScrollBar jScrollBar2 = this.textPane.getVerticalScrollBar();
        if (jScrollBar2 != null) {
            n3 = jScrollBar2.getMinimumSize().width;
        }
        if ((jScrollBar = this.textPane.getHorizontalScrollBar()) != null) {
            n4 = jScrollBar.getMinimumSize().height;
        }
        Font font = this.jtext.getFont();
        FontMetrics fontMetrics = this.jtext.getFontMetrics(font);
        return new Dimension(fontMetrics.charWidth('0') * n2 + n3, fontMetrics.getHeight() * n + n4);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.textPane != null) {
            this.textPane.setVisible(bl);
        }
    }

    void repaintText() {
        this.jtext.repaintNow();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.jtext.forwardFocusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.jtext.forwardFocusLost(focusEvent);
    }

    @Override
    public void repaint() {
        if (this.textPane != null) {
            this.textPane.repaint();
        }
    }

    @Override
    void paintPeer(Graphics graphics) {
        if (this.textPane != null) {
            this.textPane.paint(graphics);
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        super.setBounds(n, n2, n3, n4, n5);
        if (this.textPane != null) {
            int n6 = n;
            int n7 = n2;
            Container container = this.target.getParent();
            while (container.isLightweight()) {
                n6 -= container.getX();
                n7 -= container.getY();
                container = container.getParent();
            }
            this.textPane.setBounds(n6, n7, n3, n4);
            this.textPane.validate();
        }
    }

    @Override
    void handleJavaKeyEvent(KeyEvent keyEvent) {
        AWTAccessor.getComponentAccessor().processEvent(this.jtext, keyEvent);
    }

    @Override
    public boolean handlesWheelScrolling() {
        return true;
    }

    @Override
    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        AWTAccessor.getComponentAccessor().processEvent(this.textPane, mouseWheelEvent);
    }

    @Override
    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        this.javaMouseEventHandler.handle(mouseEvent);
    }

    @Override
    void handleJavaInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.jtext != null) {
            this.jtext.processInputMethodEventPublic(inputMethodEvent);
        }
    }

    @Override
    public void select(int n, int n2) {
        this.jtext.select(n, n2);
        this.jtext.repaint();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.jtext != null) {
            this.jtext.setBackground(color);
            this.jtext.setSelectedTextColor(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.jtext != null) {
            this.jtext.setForeground(this.foreground);
            this.jtext.setSelectionColor(this.foreground);
            this.jtext.setCaretColor(this.foreground);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.jtext != null) {
            this.jtext.setFont(this.font);
        }
        this.textPane.validate();
    }

    @Override
    public void setEditable(boolean bl) {
        if (this.jtext != null) {
            this.jtext.setEditable(bl);
        }
        this.repaintText();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.jtext != null) {
            this.jtext.setEnabled(bl);
            this.jtext.repaint();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.jtext != null) {
            return this.jtext.getInputMethodRequests();
        }
        return null;
    }

    @Override
    public int getSelectionStart() {
        return this.jtext.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.jtext.getSelectionEnd();
    }

    @Override
    public String getText() {
        return this.jtext.getText();
    }

    @Override
    public void setText(String string) {
        this.setTextImpl(string);
        this.repaintText();
    }

    private void setTextImpl(String string) {
        if (this.jtext != null) {
            this.jtext.getDocument().removeDocumentListener(this.jtext);
            this.jtext.setText(string);
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.target, 900));
            }
            this.jtext.getDocument().addDocumentListener(this.jtext);
        }
    }

    @Override
    public void insert(String string, int n) {
        if (this.jtext != null) {
            JScrollBar jScrollBar;
            boolean bl = n >= this.jtext.getDocument().getLength() && this.jtext.getDocument().getLength() != 0;
            this.jtext.insert(string, n);
            this.textPane.validate();
            if (bl && (jScrollBar = this.textPane.getVerticalScrollBar()) != null) {
                jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount());
            }
        }
    }

    @Override
    public void replaceRange(String string, int n, int n2) {
        if (this.jtext != null) {
            this.jtext.getDocument().removeDocumentListener(this.jtext);
            this.jtext.replaceRange(string, n, n2);
            this.postEvent(new TextEvent(this.target, 900));
            this.jtext.getDocument().addDocumentListener(this.jtext);
        }
    }

    @Override
    public void setCaretPosition(int n) {
        this.jtext.setCaretPosition(n);
    }

    @Override
    public int getCaretPosition() {
        return this.jtext.getCaretPosition();
    }

    private static final class JavaMouseEventHandler {
        private final XTextAreaPeer outer;
        private final Pointer current = new Pointer();
        private boolean grabbed = false;

        JavaMouseEventHandler(XTextAreaPeer xTextAreaPeer) {
            this.outer = xTextAreaPeer;
        }

        void handle(MouseEvent mouseEvent) {
            if (!this.grabbed) {
                this.setPointerToUnderPoint(mouseEvent.getPoint());
            }
            this.dispatch(mouseEvent);
            boolean bl = this.grabbed;
            this.grabbed_update(mouseEvent);
            if (bl && !this.grabbed) {
                this.setPointerToUnderPoint(mouseEvent.getPoint());
            }
            this.setCursor();
        }

        private void dispatch(MouseEvent mouseEvent) {
            switch (this.current.getType()) {
                case TEXT: {
                    Point point = JavaMouseEventHandler.toViewportChildLocalSpace(this.outer.textPane.getViewport(), mouseEvent.getPoint());
                    AWTTextArea aWTTextArea = this.outer.jtext;
                    MouseEvent mouseEvent2 = JavaMouseEventHandler.newMouseEvent(aWTTextArea, point, mouseEvent);
                    int n = mouseEvent2.getID();
                    if (n == 503 || n == 506) {
                        aWTTextArea.processMouseMotionEventPublic(mouseEvent2);
                        break;
                    }
                    aWTTextArea.processMouseEventPublic(mouseEvent2);
                    break;
                }
                case BAR: 
                case BUTTON: {
                    JComponent jComponent = this.current.getBar();
                    Point point = JavaMouseEventHandler.toLocalSpace(jComponent, mouseEvent.getPoint());
                    if (this.current.getType() == Pointer.Type.BUTTON) {
                        jComponent = this.current.getButton();
                        point = JavaMouseEventHandler.toLocalSpace(jComponent, point);
                    }
                    AWTAccessor.getComponentAccessor().processEvent(jComponent, JavaMouseEventHandler.newMouseEvent(jComponent, point, mouseEvent));
                }
            }
        }

        private static MouseEvent newMouseEvent(Component component, Point point, MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = mouseEvent;
            MouseEvent mouseEvent3 = new MouseEvent(component, mouseEvent2.getID(), mouseEvent2.getWhen(), mouseEvent2.getModifiersEx() | mouseEvent2.getModifiers(), point.x, point.y, mouseEvent2.getXOnScreen(), mouseEvent2.getYOnScreen(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger(), mouseEvent2.getButton());
            SunToolkit.setSystemGenerated(mouseEvent3);
            return mouseEvent3;
        }

        private void setCursor() {
            if (this.current.getType() == Pointer.Type.TEXT) {
                this.outer.pSetCursor(this.outer.target.getCursor(), true);
            } else {
                this.outer.pSetCursor(this.outer.textPane.getCursor(), true);
            }
        }

        private void grabbed_update(MouseEvent mouseEvent) {
            this.grabbed = (mouseEvent.getModifiersEx() & 0x1C00) != 0;
        }

        private static Point toLocalSpace(Component component, Point point) {
            Point point2 = point;
            Point point3 = component.getLocation();
            return new Point(point2.x - point3.x, point2.y - point3.y);
        }

        private static Point toViewportChildLocalSpace(JViewport jViewport, Point point) {
            Point point2 = JavaMouseEventHandler.toLocalSpace(jViewport, point);
            Point point3 = jViewport.getViewPosition();
            point2.x += point3.x;
            point2.y += point3.y;
            return point2;
        }

        private void setPointerToUnderPoint(Point point) {
            if (this.outer.textPane.getViewport().getBounds().contains(point)) {
                this.current.setText();
            } else if (!this.setPointerIfPointOverScrollbar(this.outer.textPane.getVerticalScrollBar(), point) && !this.setPointerIfPointOverScrollbar(this.outer.textPane.getHorizontalScrollBar(), point)) {
                this.current.setNone();
            }
        }

        private boolean setPointerIfPointOverScrollbar(JScrollBar jScrollBar, Point point) {
            if (!jScrollBar.getBounds().contains(point)) {
                return false;
            }
            this.current.setBar(jScrollBar);
            Point point2 = JavaMouseEventHandler.toLocalSpace(jScrollBar, point);
            XAWTScrollBarUI xAWTScrollBarUI = (XAWTScrollBarUI)jScrollBar.getUI();
            if (!this.setPointerIfPointOverButton(xAWTScrollBarUI.getIncreaseButton(), point2)) {
                this.setPointerIfPointOverButton(xAWTScrollBarUI.getDecreaseButton(), point2);
            }
            return true;
        }

        private boolean setPointerIfPointOverButton(JButton jButton, Point point) {
            if (!jButton.getBounds().contains(point)) {
                return false;
            }
            this.current.setButton(jButton);
            return true;
        }

        private static final class Pointer {
            private Type type;
            private JScrollBar bar;
            private JButton button;

            private Pointer() {
            }

            Type getType() {
                return this.type;
            }

            boolean isNone() {
                return this.type == Type.NONE;
            }

            JScrollBar getBar() {
                boolean bl;
                boolean bl2 = bl = this.type == Type.BAR || this.type == Type.BUTTON;
                assert (bl);
                return bl ? this.bar : null;
            }

            JButton getButton() {
                boolean bl;
                boolean bl2 = bl = this.type == Type.BUTTON;
                assert (bl);
                return bl ? this.button : null;
            }

            void setNone() {
                this.type = Type.NONE;
            }

            void setText() {
                this.type = Type.TEXT;
            }

            void setBar(JScrollBar jScrollBar) {
                this.bar = jScrollBar;
                this.type = Type.BAR;
            }

            void setButton(JButton jButton) {
                this.button = jButton;
                this.type = Type.BUTTON;
            }

            static enum Type {
                NONE,
                TEXT,
                BAR,
                BUTTON;

            }
        }
    }

    static class BevelBorder
    extends AbstractBorder
    implements UIResource {
        private Color darkShadow = SystemColor.controlDkShadow;
        private Color lightShadow = SystemColor.controlLtHighlight;
        private Color control = SystemColor.controlShadow;
        private boolean isRaised;

        BevelBorder(boolean bl, Color color, Color color2) {
            this.isRaised = bl;
            this.darkShadow = color;
            this.lightShadow = color2;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + n4 - 1, n, n2 + 1);
            graphics.setColor(this.control);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + 1);
            graphics.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + 1);
            graphics.setColor(this.control);
            graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
            graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }

        public boolean isOpaque(Component component) {
            return true;
        }
    }

    private class AWTTextPane
    extends JScrollPane
    implements FocusListener {
        private final JTextArea jtext;
        private final XWindow xwin;
        private final Color control;
        private final Color focus;

        AWTTextPane(JTextArea jTextArea, XWindow xWindow, Container container) {
            super(jTextArea);
            this.control = SystemColor.control;
            this.focus = SystemColor.activeCaptionBorder;
            this.xwin = xWindow;
            this.setDoubleBuffered(true);
            jTextArea.addFocusListener(this);
            AWTAccessor.getComponentAccessor().setParent(this, container);
            this.setViewportBorder(new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight));
            this.jtext = jTextArea;
            this.setFocusable(false);
            this.addNotify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            Object object = this.getTreeLock();
            synchronized (object) {
                Container container = this.getParent();
                AWTAccessor.getComponentAccessor().setParent(this, null);
                try {
                    super.invalidate();
                }
                finally {
                    AWTAccessor.getComponentAccessor().setParent(this, container);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Graphics graphics = this.getGraphics();
            Rectangle rectangle = this.getViewportBorderBounds();
            graphics.setColor(this.focus);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Graphics graphics = this.getGraphics();
            Rectangle rectangle = this.getViewportBorderBounds();
            graphics.setColor(this.control);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }

        public Window getRealParent() {
            return (Window)this.xwin.target;
        }

        @Override
        public ComponentPeer getPeer() {
            return (ComponentPeer)((Object)this.xwin);
        }

        @Override
        public void updateUI() {
            XAWTScrollPaneUI xAWTScrollPaneUI = new XAWTScrollPaneUI();
            this.setUI((ComponentUI)xAWTScrollPaneUI);
        }

        @Override
        public JScrollBar createVerticalScrollBar() {
            return new XAWTScrollBar(1);
        }

        @Override
        public JScrollBar createHorizontalScrollBar() {
            return new XAWTScrollBar(0);
        }

        public JTextArea getTextArea() {
            return this.jtext;
        }

        @Override
        public Graphics getGraphics() {
            return this.xwin.getGraphics();
        }

        final class XAWTScrollBar
        extends JScrollPane.ScrollBar {
            XAWTScrollBar(int n) {
                super(AWTTextPane.this, n);
                this.setFocusable(false);
            }

            @Override
            public void updateUI() {
                XAWTScrollBarUI xAWTScrollBarUI = new XAWTScrollBarUI();
                this.setUI((ComponentUI)xAWTScrollBarUI);
            }
        }
    }

    final class XAWTScrollPaneUI
    extends BasicScrollPaneUI {
        private final Border vsbMarginBorderR = new EmptyBorder(0, 2, 0, 0);
        private final Border vsbMarginBorderL = new EmptyBorder(0, 0, 0, 2);
        private final Border hsbMarginBorder = new EmptyBorder(2, 0, 0, 0);
        private Border vsbBorder;
        private Border hsbBorder;
        private PropertyChangeListener propertyChangeHandler;

        XAWTScrollPaneUI() {
        }

        @Override
        protected void installListeners(JScrollPane jScrollPane) {
            super.installListeners(jScrollPane);
            this.propertyChangeHandler = this.createPropertyChangeHandler();
            jScrollPane.addPropertyChangeListener(this.propertyChangeHandler);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Border border = this.scrollpane.getViewportBorder();
            if (border != null) {
                Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
                border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        @Override
        protected void uninstallListeners(JComponent jComponent) {
            super.uninstallListeners(jComponent);
            jComponent.removePropertyChangeListener(this.propertyChangeHandler);
        }

        private PropertyChangeListener createPropertyChangeHandler() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JScrollPane jScrollPane;
                    JScrollBar jScrollBar;
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("componentOrientation") && (jScrollBar = (jScrollPane = (JScrollPane)propertyChangeEvent.getSource()).getVerticalScrollBar()) != null) {
                        if (XAWTScrollPaneUI.this.isLeftToRight(jScrollPane)) {
                            XAWTScrollPaneUI.this.vsbBorder = new CompoundBorder(new EmptyBorder(0, 4, 0, -4), jScrollBar.getBorder());
                        } else {
                            XAWTScrollPaneUI.this.vsbBorder = new CompoundBorder(new EmptyBorder(0, -4, 0, 4), jScrollBar.getBorder());
                        }
                        jScrollBar.setBorder(XAWTScrollPaneUI.this.vsbBorder);
                    }
                }
            };
        }

        boolean isLeftToRight(Component component) {
            return component.getComponentOrientation().isLeftToRight();
        }

        @Override
        protected void installDefaults(JScrollPane jScrollPane) {
            JScrollBar jScrollBar;
            Border border = jScrollPane.getBorder();
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            jScrollPane.setBorder(uIDefaults.getBorder("ScrollPane.border"));
            jScrollPane.setBackground(uIDefaults.getColor("ScrollPane.background"));
            jScrollPane.setViewportBorder(uIDefaults.getBorder("TextField.border"));
            JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
            if (jScrollBar2 != null) {
                this.vsbBorder = this.isLeftToRight(jScrollPane) ? new CompoundBorder(this.vsbMarginBorderR, jScrollBar2.getBorder()) : new CompoundBorder(this.vsbMarginBorderL, jScrollBar2.getBorder());
                jScrollBar2.setBorder(this.vsbBorder);
            }
            if ((jScrollBar = jScrollPane.getHorizontalScrollBar()) != null) {
                this.hsbBorder = new CompoundBorder(this.hsbMarginBorder, jScrollBar.getBorder());
                jScrollBar.setBorder(this.hsbBorder);
            }
        }

        @Override
        protected void uninstallDefaults(JScrollPane jScrollPane) {
            JScrollBar jScrollBar;
            super.uninstallDefaults(jScrollPane);
            JScrollBar jScrollBar2 = this.scrollpane.getVerticalScrollBar();
            if (jScrollBar2 != null) {
                if (jScrollBar2.getBorder() == this.vsbBorder) {
                    jScrollBar2.setBorder(null);
                }
                this.vsbBorder = null;
            }
            if ((jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null) {
                if (jScrollBar.getBorder() == this.hsbBorder) {
                    jScrollBar.setBorder(null);
                }
                this.hsbBorder = null;
            }
        }
    }

    final class AWTTextArea
    extends JTextArea
    implements DocumentListener {
        private boolean isFocused;
        private final XTextAreaPeer peer;

        AWTTextArea(String string, XTextAreaPeer xTextAreaPeer2) {
            super(string);
            this.isFocused = false;
            this.setFocusable(false);
            this.peer = xTextAreaPeer2;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        void forwardFocusGained(FocusEvent focusEvent) {
            this.isFocused = true;
            FocusEvent focusEvent2 = CausedFocusEvent.retarget(focusEvent, this);
            super.processFocusEvent(focusEvent2);
        }

        void forwardFocusLost(FocusEvent focusEvent) {
            this.isFocused = false;
            FocusEvent focusEvent2 = CausedFocusEvent.retarget(focusEvent, this);
            super.processFocusEvent(focusEvent2);
        }

        @Override
        public boolean hasFocus() {
            return this.isFocused;
        }

        public void repaintNow() {
            this.paintImmediately(this.getBounds());
        }

        public void processMouseEventPublic(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEventPublic(MouseEvent mouseEvent) {
            this.processMouseMotionEvent(mouseEvent);
        }

        public void processInputMethodEventPublic(InputMethodEvent inputMethodEvent) {
            this.processInputMethodEvent(inputMethodEvent);
        }

        @Override
        public void updateUI() {
            AWTTextAreaUI aWTTextAreaUI = new AWTTextAreaUI();
            this.setUI((ComponentUI)aWTTextAreaUI);
        }

        @Override
        public void setTransferHandler(TransferHandler transferHandler) {
            TransferHandler transferHandler2 = (TransferHandler)this.getClientProperty(AWTAccessor.getClientPropertyKeyAccessor().getJComponent_TRANSFER_HANDLER());
            this.putClientProperty(AWTAccessor.getClientPropertyKeyAccessor().getJComponent_TRANSFER_HANDLER(), transferHandler);
            this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
        }
    }

    final class XAWTScrollBarUI
    extends BasicScrollBarUI {
        XAWTScrollBarUI() {
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            this.scrollbar.setBorder(new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight));
        }

        @Override
        protected void configureScrollBarColors() {
            Color color;
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            Color color2 = this.scrollbar.getBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.scrollbar.setBackground(uIDefaults.getColor("ScrollBar.background"));
            }
            if ((color = this.scrollbar.getForeground()) == null || color instanceof UIResource) {
                this.scrollbar.setForeground(uIDefaults.getColor("ScrollBar.foreground"));
            }
            this.thumbHighlightColor = uIDefaults.getColor("ScrollBar.thumbHighlight");
            this.thumbLightShadowColor = uIDefaults.getColor("ScrollBar.thumbShadow");
            this.thumbDarkShadowColor = uIDefaults.getColor("ScrollBar.thumbDarkShadow");
            this.thumbColor = uIDefaults.getColor("ScrollBar.thumb");
            this.trackColor = uIDefaults.getColor("ScrollBar.track");
            this.trackHighlightColor = uIDefaults.getColor("ScrollBar.trackHighlight");
        }

        @Override
        protected JButton createDecreaseButton(int n) {
            XAWTScrollBarButton xAWTScrollBarButton = new XAWTScrollBarButton(n);
            return xAWTScrollBarButton;
        }

        @Override
        protected JButton createIncreaseButton(int n) {
            XAWTScrollBarButton xAWTScrollBarButton = new XAWTScrollBarButton(n);
            return xAWTScrollBarButton;
        }

        public JButton getDecreaseButton() {
            return this.decrButton;
        }

        public JButton getIncreaseButton() {
            return this.incrButton;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            this.paintTrack(graphics, jComponent, this.getTrackBounds());
            Rectangle rectangle = this.getThumbBounds();
            this.paintThumb(graphics, jComponent, rectangle);
        }

        @Override
        public void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
            if (!this.scrollbar.isEnabled()) {
                return;
            }
            if (rectangle.isEmpty()) {
                rectangle = this.getTrackBounds();
            }
            int n = rectangle.width;
            int n2 = rectangle.height;
            graphics.translate(rectangle.x, rectangle.y);
            graphics.setColor(this.thumbColor);
            graphics.fillRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(this.thumbHighlightColor);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(1, 0, n - 1, 0);
            graphics.setColor(this.thumbLightShadowColor);
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    final class XAWTScrollBarButton
    extends BasicArrowButton {
        private UIDefaults uidefaults;
        private Color darkShadow;
        private Color lightShadow;
        private Color buttonBack;

        XAWTScrollBarButton(int n) {
            super(n);
            this.uidefaults = XToolkit.getUIDefaults();
            this.darkShadow = SystemColor.controlShadow;
            this.lightShadow = SystemColor.controlLtHighlight;
            this.buttonBack = this.uidefaults.getColor("ScrollBar.track");
            switch (n) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    this.direction = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid direction");
                }
            }
            this.setRequestFocusEnabled(false);
            this.setOpaque(true);
            this.setBackground(this.uidefaults.getColor("ScrollBar.thumb"));
            this.setForeground(this.uidefaults.getColor("ScrollBar.foreground"));
        }

        @Override
        public Dimension getPreferredSize() {
            switch (this.direction) {
                case 1: 
                case 5: {
                    return new Dimension(11, 12);
                }
            }
            return new Dimension(12, 11);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void paint(Graphics graphics) {
            boolean bl;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.isOpaque()) {
                graphics.setColor(this.buttonBack);
                graphics.fillRect(0, 0, n, n2);
            }
            Color color = (bl = this.getModel().isPressed()) ? this.darkShadow : this.lightShadow;
            Color color2 = bl ? this.lightShadow : this.darkShadow;
            Color color3 = this.getBackground();
            int n3 = n / 2;
            int n4 = n2 / 2;
            int n5 = Math.min(n, n2);
            switch (this.direction) {
                case 1: {
                    graphics.setColor(color);
                    graphics.drawLine(n3, 0, n3, 0);
                    int n6 = n3 - 1;
                    int n7 = 1;
                    for (int i = 1; i <= n5 - 2; i += 2) {
                        graphics.setColor(color);
                        graphics.drawLine(n6, i, n6, i);
                        if (i >= n5 - 2) {
                            graphics.drawLine(n6, i + 1, n6, i + 1);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(n6 + 1, i, n6 + n7, i);
                        if (i < n5 - 2) {
                            graphics.drawLine(n6, i + 1, n6 + n7 + 1, i + 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(n6 + n7 + 1, i, n6 + n7 + 1, i);
                        if (i >= n5 - 2) {
                            graphics.drawLine(n6 + 1, i + 1, n6 + n7 + 1, i + 1);
                        }
                        n7 += 2;
                        --n6;
                    }
                    break;
                }
                case 5: {
                    graphics.setColor(color2);
                    graphics.drawLine(n3, n5, n3, n5);
                    int n8 = n3 - 1;
                    int n9 = 1;
                    for (int i = n5 - 1; i >= 1; i -= 2) {
                        graphics.setColor(color);
                        graphics.drawLine(n8, i, n8, i);
                        if (i <= 2) {
                            graphics.drawLine(n8, i - 1, n8 + n9 + 1, i - 1);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(n8 + 1, i, n8 + n9, i);
                        if (i > 2) {
                            graphics.drawLine(n8, i - 1, n8 + n9 + 1, i - 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(n8 + n9 + 1, i, n8 + n9 + 1, i);
                        n9 += 2;
                        --n8;
                    }
                    break;
                }
                case 3: {
                    graphics.setColor(color);
                    graphics.drawLine(n5, n4, n5, n4);
                    int n10 = n4 - 1;
                    int n11 = 1;
                    for (int i = n5 - 1; i >= 1; i -= 2) {
                        graphics.setColor(color);
                        graphics.drawLine(i, n10, i, n10);
                        if (i <= 2) {
                            graphics.drawLine(i - 1, n10, i - 1, n10 + n11 + 1);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(i, n10 + 1, i, n10 + n11);
                        if (i > 2) {
                            graphics.drawLine(i - 1, n10, i - 1, n10 + n11 + 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(i, n10 + n11 + 1, i, n10 + n11 + 1);
                        n11 += 2;
                        --n10;
                    }
                    break;
                }
                case 7: {
                    graphics.setColor(color2);
                    graphics.drawLine(0, n4, 0, n4);
                    int n12 = n4 - 1;
                    int n13 = 1;
                    for (int i = 1; i <= n5 - 2; i += 2) {
                        graphics.setColor(color);
                        graphics.drawLine(i, n12, i, n12);
                        if (i >= n5 - 2) {
                            graphics.drawLine(i + 1, n12, i + 1, n12);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(i, n12 + 1, i, n12 + n13);
                        if (i < n5 - 2) {
                            graphics.drawLine(i + 1, n12, i + 1, n12 + n13 + 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(i, n12 + n13 + 1, i, n12 + n13 + 1);
                        if (i >= n5 - 2) {
                            graphics.drawLine(i + 1, n12 + 1, i + 1, n12 + n13 + 1);
                        }
                        n13 += 2;
                        --n12;
                    }
                    break;
                }
            }
        }
    }

    static final class XAWTCaret
    extends DefaultCaret {
        XAWTCaret() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            if (this.getComponent().isEnabled()) {
                super.setVisible(true);
            }
            this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.getComponent().repaint();
        }

        @Override
        public void setSelectionVisible(boolean bl) {
            if (bl) {
                super.setSelectionVisible(bl);
            } else {
                this.setDot(this.getDot());
            }
        }
    }

    final class AWTTextAreaUI
    extends MotifTextAreaUI {
        private JTextArea jta;

        AWTTextAreaUI() {
        }

        @Override
        protected String getPropertyPrefix() {
            return "TextArea";
        }

        @Override
        public void installUI(JComponent jComponent) {
            Color color;
            Color color2;
            Color color3;
            Color color4;
            Color color5;
            Color color6;
            super.installUI(jComponent);
            JTextArea jTextArea = this.jta = (JTextArea)jComponent;
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            Font font = jTextArea.getFont();
            if (font == null || font instanceof UIResource) {
                jTextArea.setFont(uIDefaults.getFont(string + ".font"));
            }
            if ((color6 = jTextArea.getBackground()) == null || color6 instanceof UIResource) {
                jTextArea.setBackground(uIDefaults.getColor(string + ".background"));
            }
            if ((color5 = jTextArea.getForeground()) == null || color5 instanceof UIResource) {
                jTextArea.setForeground(uIDefaults.getColor(string + ".foreground"));
            }
            if ((color4 = jTextArea.getCaretColor()) == null || color4 instanceof UIResource) {
                jTextArea.setCaretColor(uIDefaults.getColor(string + ".caretForeground"));
            }
            if ((color3 = jTextArea.getSelectionColor()) == null || color3 instanceof UIResource) {
                jTextArea.setSelectionColor(uIDefaults.getColor(string + ".selectionBackground"));
            }
            if ((color2 = jTextArea.getSelectedTextColor()) == null || color2 instanceof UIResource) {
                jTextArea.setSelectedTextColor(uIDefaults.getColor(string + ".selectionForeground"));
            }
            if ((color = jTextArea.getDisabledTextColor()) == null || color instanceof UIResource) {
                jTextArea.setDisabledTextColor(uIDefaults.getColor(string + ".inactiveForeground"));
            }
            BevelBorder bevelBorder = new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight);
            jTextArea.setBorder(new BorderUIResource.CompoundBorderUIResource(bevelBorder, new EmptyBorder(2, 2, 2, 2)));
            Insets insets = jTextArea.getMargin();
            if (insets == null || insets instanceof UIResource) {
                jTextArea.setMargin(uIDefaults.getInsets(string + ".margin"));
            }
        }

        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            JTextComponent jTextComponent = this.getComponent();
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            InputMap inputMap = (InputMap)uIDefaults.get(string + ".focusInputMap");
            if (inputMap != null) {
                SwingUtilities.replaceUIInputMap(jTextComponent, 0, inputMap);
            }
        }

        @Override
        protected Caret createCaret() {
            return new XAWTCaret();
        }
    }
}

