/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCLookupSetElement
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int LOOKUPFLAGS;

    public LLVMOrcCLookupSetElement(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOrcCLookupSetElement.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCLookupSetElement.nName(this.address());
    }

    @NativeType(value="LLVMOrcSymbolLookupFlags")
    public int LookupFlags() {
        return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
    }

    public LLVMOrcCLookupSetElement Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCLookupSetElement.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
        LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement set(long Name, int LookupFlags) {
        this.Name(Name);
        this.LookupFlags(LookupFlags);
        return this;
    }

    public LLVMOrcCLookupSetElement set(LLVMOrcCLookupSetElement src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOrcCLookupSetElement malloc() {
        return (LLVMOrcCLookupSetElement)LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LLVMOrcCLookupSetElement calloc() {
        return (LLVMOrcCLookupSetElement)LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LLVMOrcCLookupSetElement create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LLVMOrcCLookupSetElement)LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LLVMOrcCLookupSetElement create(long address) {
        return (LLVMOrcCLookupSetElement)LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, (long)address);
    }

    @Nullable
    public static LLVMOrcCLookupSetElement createSafe(long address) {
        return address == 0L ? null : (LLVMOrcCLookupSetElement)LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LLVMOrcCLookupSetElement.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LLVMOrcCLookupSetElement.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LLVMOrcCLookupSetElement.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCLookupSetElement.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LLVMOrcCLookupSetElement.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMOrcCLookupSetElement.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMOrcCLookupSetElement.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMOrcCLookupSetElement malloc(MemoryStack stack) {
        return (LLVMOrcCLookupSetElement)LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCLookupSetElement calloc(MemoryStack stack) {
        return (LLVMOrcCLookupSetElement)LLVMOrcCLookupSetElement.wrap(LLVMOrcCLookupSetElement.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOrcCLookupSetElement.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOrcCLookupSetElement.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NAME));
    }

    public static int nLookupFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOOKUPFLAGS);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)Checks.check((long)value));
    }

    public static void nLookupFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOOKUPFLAGS, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    static {
        Struct.Layout layout = LLVMOrcCLookupSetElement.__struct((Struct.Member[])new Struct.Member[]{LLVMOrcCLookupSetElement.__member((int)POINTER_SIZE), LLVMOrcCLookupSetElement.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        LOOKUPFLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCLookupSetElement, Buffer>
    implements NativeResource {
        private static final LLVMOrcCLookupSetElement ELEMENT_FACTORY = LLVMOrcCLookupSetElement.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOrcCLookupSetElement getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCLookupSetElement.nName(this.address());
        }

        @NativeType(value="LLVMOrcSymbolLookupFlags")
        public int LookupFlags() {
            return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCLookupSetElement.nName(this.address(), value);
            return this;
        }

        public Buffer LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
            LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
            return this;
        }
    }
}

