/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.BatchSubResponse;
import com.microsoft.azure.storage.blob.BlobBatchOperation;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.core.Utility;

public final class BlobDeleteBatchOperation
extends BlobBatchOperation<CloudBlob, Void> {
    public void addSubOperation(CloudBlob blob) {
        this.addSubOperation(blob, DeleteSnapshotsOption.NONE, null, null);
    }

    public void addSubOperation(CloudBlob blob, DeleteSnapshotsOption deleteSnapshotsOption, AccessCondition accessCondition, BlobRequestOptions options) {
        Utility.assertNotNull("blob", blob);
        Utility.assertNotNull("deleteSnapshotsOption", (Object)deleteSnapshotsOption);
        options = BlobRequestOptions.populateAndApplyDefaults(options, blob.properties.getBlobType(), blob.blobServiceClient);
        super.addSubOperation(blob.deleteImpl(deleteSnapshotsOption, accessCondition, options), blob);
    }

    @Override
    protected final Void convertResponse(BatchSubResponse response) {
        return null;
    }
}

