/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.event.LocationProvider;

public class LocationMap
implements LocationProvider {
    private String[] modules = new String[10];
    private int numberOfModules = 0;

    public int allocateLocationId(String module, int lineNumber) {
        if (module == null) {
            module = "*module with no systemId*";
        }
        int mod = -1;
        for (int m = this.numberOfModules - 1; m >= 0; --m) {
            if (!this.modules[m].equals(module)) continue;
            mod = m;
            break;
        }
        if (mod == -1) {
            if (this.numberOfModules >= this.modules.length) {
                String[] m2 = new String[this.numberOfModules * 2];
                System.arraycopy(this.modules, 0, m2, 0, this.numberOfModules);
                this.modules = m2;
            }
            mod = this.numberOfModules;
            this.modules[this.numberOfModules++] = module;
        }
        if (mod >= 1024) {
            mod = 1023;
            this.modules[mod] = "*unknown module uri*";
        }
        if (lineNumber > 999999) {
            lineNumber = 999999;
        }
        return (mod << 20) + lineNumber;
    }

    public String getSystemId(int locationId) {
        int m = locationId >> 20;
        if (m < 0 || m >= this.numberOfModules) {
            return null;
        }
        return this.modules[m];
    }

    public int getLineNumber(int locationId) {
        return 0xFFFFF & locationId;
    }

    public int getColumnNumber(int locationId) {
        return -1;
    }
}

