/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.OperationStatus;
import java.util.Set;

public class StoredKeySet
extends StoredCollection
implements Set {
    public StoredKeySet(Database database, EntryBinding entryBinding, boolean bl) {
        super(new DataView(database, entryBinding, null, null, bl, null));
    }

    StoredKeySet(DataView dataView) {
        super(dataView);
    }

    @Override
    public boolean add(Object object) {
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.putNoOverwrite(object, null, false);
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean remove(Object object) {
        return this.removeKey(object, null);
    }

    @Override
    public boolean contains(Object object) {
        return this.containsKey(object);
    }

    @Override
    boolean hasValues() {
        return false;
    }

    @Override
    Object makeIteratorData(BaseIterator baseIterator, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        return this.view.makeKey(databaseEntry, databaseEntry2);
    }

    @Override
    boolean iterateDuplicates() {
        return false;
    }
}

