/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.OLAPTree;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.object.SPObject;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OLAPDeleteSelectedAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(OLAPDeleteSelectedAction.class);
    private final OLAPEditSession editSession;
    private OLAPTree tree;

    public OLAPDeleteSelectedAction(ArchitectSwingSession session, OLAPEditSession editSession) {
        super(session, editSession.getOlapPlayPen(), "Delete Selected", "Delete selected item.", (String)null);
        this.editSession = editSession;
        this.tree = editSession.getOlapTree();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        List<OLAPObject> itemsToDelete = this.getDeletableItems();
        if (itemsToDelete.size() > 1) {
            int decision = JOptionPane.showConfirmDialog(this.editSession.getFrame(), "Are you sure you want to delete the following " + itemsToDelete.size() + " items?", "Multiple Delete", 0);
            if (decision != 0) {
                return;
            }
        } else if (itemsToDelete.size() < 1) {
            JOptionPane.showMessageDialog(this.getPlaypen(), "No items to delete!");
            return;
        }
        this.getPlaypen().getContentPane().begin("Deleting selected OLAP objects");
        try {
            this.getPlaypen().startCompoundEdit("OLAP Delete");
            for (OLAPObject oo : itemsToDelete) {
                if (this.parentWasDeleted(oo)) continue;
                try {
                    oo.getParent().removeChild((SPObject)oo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.getPlaypen().getContentPane().commit();
        }
        catch (Throwable e) {
            this.getPlaypen().getContentPane().rollback("Error: " + e.toString());
            throw new RuntimeException(e);
        }
        finally {
            this.getPlaypen().endCompoundEdit("OLAP Delete End");
        }
    }

    private boolean parentWasDeleted(OLAPObject oo) {
        if (oo == null) {
            return true;
        }
        if (oo instanceof MondrianModel.Schema) {
            return false;
        }
        return this.parentWasDeleted((OLAPObject)oo.getParent());
    }

    private List<OLAPObject> getDeletableItems() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        boolean usageLineSelected = false;
        if (selectionPaths == null) {
            return Collections.emptyList();
        }
        ArrayList<OLAPObject> deleteItems = new ArrayList<OLAPObject>(selectionPaths.length);
        for (int i = 0; i < selectionPaths.length; ++i) {
            if (selectionPaths[i].getPathCount() > 1 && selectionPaths[i].getPathComponent(0) == this.editSession.getOlapSession().getSchema()) {
                logger.debug((Object)("Adding item " + selectionPaths[i].getLastPathComponent() + " to be deleted."));
                deleteItems.add((OLAPObject)((Object)selectionPaths[i].getLastPathComponent()));
                continue;
            }
            logger.debug((Object)("Skipping non-deletable object: " + selectionPaths[i].getLastPathComponent()));
        }
        HashSet<SPObject> objectsWithSelectedItems = new HashSet<SPObject>();
        ListIterator it = deleteItems.listIterator();
        while (it.hasNext()) {
            OLAPObject item = (OLAPObject)((Object)it.next());
            if (item instanceof MondrianModel.Dimension) {
                if (!(item.getParent() instanceof MondrianModel.Cube)) continue;
                objectsWithSelectedItems.add(item.getParent());
                continue;
            }
            if (item instanceof MondrianModel.Measure) {
                objectsWithSelectedItems.add(item.getParent());
                continue;
            }
            if (item instanceof MondrianModel.DimensionUsage) {
                for (PlayPenComponent comp : this.getPlaypen().getSelectedItems()) {
                    if (!(comp instanceof UsageComponent)) continue;
                    usageLineSelected = true;
                    break;
                }
                if (usageLineSelected) continue;
                objectsWithSelectedItems.add(item.getParent());
                continue;
            }
            if (item instanceof MondrianModel.VirtualCubeDimension || item instanceof MondrianModel.VirtualCubeMeasure) {
                objectsWithSelectedItems.add(item.getParent());
                continue;
            }
            if (item instanceof MondrianModel.CubeUsage) {
                for (PlayPenComponent comp : this.getPlaypen().getSelectedItems()) {
                    if (!(comp instanceof UsageComponent)) continue;
                    usageLineSelected = true;
                    break;
                }
                if (usageLineSelected) continue;
                objectsWithSelectedItems.add(item.getParent().getParent());
                continue;
            }
            if (item instanceof MondrianModel.Hierarchy) {
                if (item.getParent().getParent() instanceof MondrianModel.Schema) {
                    objectsWithSelectedItems.add(item.getParent());
                    continue;
                }
                if (!(item.getParent().getParent() instanceof MondrianModel.Cube)) continue;
                objectsWithSelectedItems.add(item.getParent().getParent());
                continue;
            }
            if (!(item instanceof MondrianModel.Level) || !(item.getParent() instanceof MondrianModel.Hierarchy)) continue;
            if (item.getParent().getParent().getParent() instanceof MondrianModel.Schema) {
                objectsWithSelectedItems.add(item.getParent().getParent());
                continue;
            }
            if (!(item.getParent().getParent().getParent() instanceof MondrianModel.Cube)) continue;
            objectsWithSelectedItems.add(item.getParent().getParent().getParent());
        }
        deleteItems.removeAll(objectsWithSelectedItems);
        return deleteItems;
    }
}

