/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Preferences;
import processing.app.SketchCode;
import processing.core.PApplet;

public class Sketch {
    private Editor editor;
    private Mode mode;
    private File primaryFile;
    private String name;
    private boolean modified;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private SketchCode current;
    private int currentIndex;
    private int codeCount;
    private SketchCode[] code;
    boolean renamingCode;

    public Sketch(Editor editor, String path) throws IOException {
        this.editor = editor;
        this.mode = editor.getMode();
        this.primaryFile = new File(path);
        String mainFilename = this.primaryFile.getName();
        int suffixLength = this.mode.getDefaultExtension().length() + 1;
        this.name = mainFilename.substring(0, mainFilename.length() - suffixLength);
        this.folder = new File(new File(path).getParent());
        this.load();
    }

    protected void load() {
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        String[] list = this.folder.list();
        this.codeCount = 0;
        this.code = new SketchCode[list.length];
        String[] extensions = this.mode.getExtensions();
        for (String filename : list) {
            if (filename.startsWith(".") || new File(this.folder, filename).isDirectory()) continue;
            String base = filename;
            for (String extension : extensions) {
                if (!base.toLowerCase().endsWith("." + extension) || !Sketch.isSanitaryName(base = base.substring(0, base.length() - (extension.length() + 1)))) continue;
                this.code[this.codeCount++] = new SketchCode(new File(this.folder, filename), extension);
            }
        }
        this.code = (SketchCode[])PApplet.subset((Object)this.code, (int)0, (int)this.codeCount);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!this.code[i].getFile().equals(this.primaryFile)) continue;
            SketchCode temp = this.code[0];
            this.code[0] = this.code[i];
            this.code[i] = temp;
            break;
        }
        this.sortCode();
        if (this.editor != null) {
            this.setCurrentCode(0);
        }
    }

    public void reload() {
        this.current = null;
        this.load();
    }

    protected void replaceCode(SketchCode newCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].getFileName().equals(newCode.getFileName())) continue;
            this.code[i] = newCode;
            break;
        }
    }

    protected void insertCode(SketchCode newCode) {
        this.ensureExistence();
        this.code = (SketchCode[])PApplet.append((Object)this.code, (Object)newCode);
        ++this.codeCount;
    }

    protected void sortCode() {
        for (int i = 1; i < this.codeCount; ++i) {
            int who = i;
            for (int j = i + 1; j < this.codeCount; ++j) {
                if (this.code[j].getFileName().compareTo(this.code[who].getFileName()) >= 0) continue;
                who = j;
            }
            if (who == i) continue;
            SketchCode temp = this.code[who];
            this.code[who] = this.code[i];
            this.code[i] = temp;
        }
    }

    public void handleNewCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = false;
        this.editor.status.edit("Name for new file:", "");
    }

    public void handleRenameCode() {
        this.ensureExistence();
        if (this.currentIndex == 0 && this.editor.untitled) {
            Base.showMessage("Sketch is Untitled", "How about saving the sketch first \nbefore trying to rename it?");
            return;
        }
        if (this.isModified()) {
            Base.showMessage("Save", "Please save the sketch before renaming.");
            return;
        }
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = true;
        String prompt = this.currentIndex == 0 ? "New name for sketch:" : "New name for file:";
        String oldName = this.current.isExtension("pde") ? this.current.getPrettyName() : this.current.getFileName();
        this.editor.status.edit(prompt, oldName);
    }

    protected void nameCode(String newName) {
        String sanitaryName;
        this.ensureExistence();
        if (newName.indexOf(46) == -1) {
            newName = newName + "." + this.mode.getDefaultExtension();
        }
        if (this.renamingCode && newName.equalsIgnoreCase(this.current.getFileName())) {
            return;
        }
        if ((newName = newName.trim()).equals("")) {
            return;
        }
        int dot = newName.indexOf(46);
        if (dot == 0) {
            Base.showWarning("Problem with rename", "The name cannot start with a period.", null);
            return;
        }
        String newExtension = newName.substring(dot + 1).toLowerCase();
        if (!this.mode.validExtension(newExtension)) {
            Base.showWarning("Problem with rename", "\"." + newExtension + "\"" + "is not a valid extension.", null);
            return;
        }
        if (!this.mode.isDefaultExtension(newExtension) && this.renamingCode && this.current == this.code[0]) {
            Base.showWarning("Problem with rename", "The first tab cannot be ." + newExtension + " file.\n" + "(It may be time for your to graduate to a\n" + "\"real\" programming environment, hotshot.)", null);
            return;
        }
        String shortName = newName.substring(0, dot);
        if (!shortName.equals(sanitaryName = Sketch.sanitizeName(shortName))) {
            newName = sanitaryName + "." + newExtension;
        }
        for (SketchCode c : this.code) {
            if (!sanitaryName.equalsIgnoreCase(c.getPrettyName())) continue;
            Base.showMessage("Nope", "A file named \"" + c.getFileName() + "\" already exists\n" + "in \"" + this.folder.getAbsolutePath() + "\"");
            return;
        }
        File newFile = new File(this.folder, newName);
        if (this.renamingCode) {
            if (this.currentIndex == 0) {
                String folderName = newName.substring(0, newName.indexOf(46));
                File newFolder = new File(this.folder.getParentFile(), folderName);
                if (newFolder.exists()) {
                    Base.showWarning("Cannot Rename", "Sorry, a sketch (or folder) named \"" + newName + "\" already exists.", null);
                    return;
                }
                boolean success = this.folder.renameTo(newFolder);
                if (!success) {
                    Base.showWarning("Error", "Could not rename the sketch folder.", null);
                    return;
                }
                this.current.setFolder(newFolder);
                newFile = new File(newFolder, newName);
                if (!this.current.renameTo(newFile, newExtension)) {
                    Base.showWarning("Error", "Could not rename \"" + this.current.getFileName() + "\" to \"" + newFile.getName() + "\"", null);
                    return;
                }
                for (int i = 1; i < this.codeCount; ++i) {
                    this.code[i].setFolder(newFolder);
                }
                this.updateInternal(sanitaryName, newFolder);
            } else if (!this.current.renameTo(newFile, newExtension)) {
                Base.showWarning("Error", "Could not rename \"" + this.current.getFileName() + "\" to \"" + newFile.getName() + "\"", null);
                return;
            }
        } else {
            try {
                if (!newFile.createNewFile()) {
                    throw new IOException("createNewFile() returned false");
                }
            }
            catch (IOException e) {
                Base.showWarning("Error", "Could not create the file \"" + newFile + "\"\n" + "in \"" + this.folder.getAbsolutePath() + "\"", e);
                return;
            }
            SketchCode newCode = new SketchCode(newFile, newExtension);
            this.insertCode(newCode);
        }
        this.sortCode();
        this.setCurrentCode(newName);
        this.editor.header.rebuild();
    }

    public void handleDeleteCode() {
        Object[] options;
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String prompt = this.currentIndex == 0 ? "Are you sure you want to delete this sketch?" : "Are you sure you want to delete \"" + this.current.getPrettyName() + "\"?";
        int result = JOptionPane.showOptionDialog(this.editor, prompt, "Delete", 0, 3, null, options = new Object[]{"OK", "Cancel"}, options[0]);
        if (result == 0) {
            if (this.currentIndex == 0) {
                Base.removeDir(this.folder);
                this.editor.base.handleClose(this.editor, false);
            } else {
                if (!this.current.deleteFile()) {
                    Base.showMessage("Couldn't do it", "Could not delete \"" + this.current.getFileName() + "\".");
                    return;
                }
                this.removeCode(this.current);
                this.setCurrentCode(0);
                this.editor.header.repaint();
            }
        }
    }

    protected void removeCode(SketchCode which) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (this.code[i] != which) continue;
            for (int j = i; j < this.codeCount - 1; ++j) {
                this.code[j] = this.code[j + 1];
            }
            --this.codeCount;
            this.code = (SketchCode[])PApplet.shorten((Object)this.code);
            return;
        }
        System.err.println("removeCode: internal error.. could not find code");
    }

    public void handlePrevCode() {
        int prev = this.currentIndex - 1;
        if (prev < 0) {
            prev = this.codeCount - 1;
        }
        this.setCurrentCode(prev);
    }

    public void handleNextCode() {
        this.setCurrentCode((this.currentIndex + 1) % this.codeCount);
    }

    public void setModified(boolean state) {
        if (this.current.isModified() != state) {
            this.current.setModified(state);
            this.calcModified();
        }
    }

    protected void calcModified() {
        this.modified = false;
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.modified = true;
            break;
        }
        this.editor.header.repaint();
        if (Base.isMacOS()) {
            Boolean modifiedParam = this.modified ? Boolean.TRUE : Boolean.FALSE;
            this.editor.getRootPane().putClientProperty("windowModified", modifiedParam);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        this.current.setProgram(this.editor.getText());
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is read-only", "Some files are marked \"read-only\", so you'll\nneed to re-save this sketch to another location.");
            if (!this.saveAs()) {
                return false;
            }
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.code[i].save();
        }
        this.calcModified();
        return true;
    }

    protected boolean saveAs() throws IOException {
        File[] copyItems;
        String newParentDir = null;
        String newName = null;
        FileDialog fd = new FileDialog((Frame)this.editor, "Save sketch folder as...", 1);
        if (this.isReadOnly() || this.isUntitled()) {
            fd.setDirectory(Preferences.get("sketchbook.path"));
        } else {
            fd.setDirectory(this.folder.getParent());
        }
        String oldName = this.folder.getName();
        fd.setFile(oldName);
        fd.setVisible(true);
        newParentDir = fd.getDirectory();
        newName = fd.getFile();
        if (newName == null) {
            return false;
        }
        newName = Sketch.checkName(newName);
        File newFolder = new File(newParentDir, newName);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!newName.equalsIgnoreCase(this.code[i].getPrettyName())) continue;
            Base.showMessage("Nope", "You can't save the sketch as \"" + newName + "\"\n" + "because the sketch already has a tab with that name.");
            return false;
        }
        if (newFolder.equals(this.folder)) {
            return this.save();
        }
        try {
            String newPath = newFolder.getCanonicalPath() + File.separator;
            String oldPath = this.folder.getCanonicalPath() + File.separator;
            if (newPath.indexOf(oldPath) == 0) {
                Base.showWarning("How very Borges of you", "You cannot save the sketch into a folder\ninside itself. This would go on forever.", null);
                return false;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (newFolder.exists()) {
            Base.removeDir(newFolder);
        }
        newFolder.mkdirs();
        if (this.current.isModified()) {
            this.current.setProgram(this.editor.getText());
        }
        for (File copyable : copyItems = this.folder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName();
                if (name.equals(".") || name.equals("..")) {
                    return false;
                }
                for (String ignorable : Sketch.this.mode.getIgnorable()) {
                    if (!name.equals(ignorable)) continue;
                    return false;
                }
                for (String ext : Sketch.this.mode.getExtensions()) {
                    if (!name.endsWith(ext)) continue;
                    return false;
                }
                return !name.startsWith("screen-");
            }
        })) {
            if (copyable.isDirectory()) {
                Base.copyDir(copyable, new File(newFolder, copyable.getName()));
                continue;
            }
            Base.copyFile(copyable, new File(newFolder, copyable.getName()));
        }
        for (int i = 1; i < this.codeCount; ++i) {
            File newFile = new File(newFolder, this.code[i].getFileName());
            this.code[i].saveAs(newFile);
        }
        File newFile = new File(newFolder, newName + ".pde");
        this.code[0].saveAs(newFile);
        this.updateInternal(newName, newFolder);
        this.setUntitled(false);
        return true;
    }

    protected void updateInternal(String sketchName, File sketchFolder) {
        this.primaryFile = this.code[0].getFile();
        this.name = sketchName;
        this.folder = sketchFolder;
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        this.calcModified();
        this.editor.setTitle();
        this.editor.base.rebuildSketchbookMenus();
    }

    public void handleAddFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String prompt = "Select an image or other data file to copy to your sketch";
        FileDialog fd = new FileDialog((Frame)this.editor, prompt, 0);
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File sourceFile = new File(directory, filename);
        boolean result = this.addFile(sourceFile);
        if (result) {
            this.editor.statusNotice("One file added to the sketch.");
        }
    }

    public boolean addFile(File sourceFile) {
        boolean muchSuccess;
        String filename = sourceFile.getName();
        File destFile = null;
        String codeExtension = null;
        boolean replacement = false;
        if (filename.toLowerCase().endsWith(".class") || filename.toLowerCase().endsWith(".jar") || filename.toLowerCase().endsWith(".dll") || filename.toLowerCase().endsWith(".jnilib") || filename.toLowerCase().endsWith(".so")) {
            this.prepareCodeFolder();
            destFile = new File(this.codeFolder, filename);
        } else {
            for (String extension : this.mode.getExtensions()) {
                String lower = filename.toLowerCase();
                if (!lower.endsWith("." + extension)) continue;
                destFile = new File(this.folder, filename);
                codeExtension = extension;
            }
            if (codeExtension == null) {
                this.prepareDataFolder();
                destFile = new File(this.dataFolder, filename);
            }
        }
        if (destFile.exists()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            String prompt = "Replace the existing version of " + filename + "?";
            int result = JOptionPane.showOptionDialog(this.editor, prompt, "Replace", 0, 3, null, options, options[0]);
            if (result == 0) {
                replacement = true;
            } else {
                return false;
            }
        }
        if (replacement && !(muchSuccess = destFile.delete())) {
            Base.showWarning("Error adding file", "Could not delete the existing '" + filename + "' file.", null);
            return false;
        }
        if (codeExtension == null && sourceFile.equals(destFile)) {
            Base.showWarning("You can't fool me", "This file has already been copied to the\nlocation from which where you're trying to add it.\nI ain't not doin nuthin'.", null);
            return false;
        }
        if (!sourceFile.equals(destFile)) {
            try {
                Base.copyFile(sourceFile, destFile);
            }
            catch (IOException e) {
                Base.showWarning("Error adding file", "Could not add '" + filename + "' to the sketch.", e);
                return false;
            }
        }
        if (codeExtension != null) {
            SketchCode newCode = new SketchCode(destFile, codeExtension);
            if (replacement) {
                this.replaceCode(newCode);
            } else {
                this.insertCode(newCode);
                this.sortCode();
            }
            this.setCurrentCode(filename);
            this.editor.header.repaint();
            if (this.editor.untitled) {
                this.current.setModified(true);
            }
        } else if (this.editor.untitled) {
            this.code[0].setModified(true);
        }
        return true;
    }

    public void setCurrentCode(int which) {
        if (this.currentIndex == which && this.current != null) {
            return;
        }
        if (this.current != null) {
            this.current.setState(this.editor.getText(), this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        }
        this.current = this.code[which];
        this.currentIndex = which;
        this.current.visited = System.currentTimeMillis();
        this.editor.setCode(this.current);
        this.editor.header.repaint();
    }

    protected void setCurrentCode(String findName) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!findName.equals(this.code[i].getFileName()) && !findName.equals(this.code[i].getPrettyName())) continue;
            this.setCurrentCode(i);
            return;
        }
    }

    public File makeTempFolder() {
        try {
            File buildFolder = Base.createTempFolder(this.name, "temp");
            return buildFolder;
        }
        catch (IOException e) {
            Base.showWarning("Build folder bad", "Could not find a place to build the sketch.", e);
            return null;
        }
    }

    public void ensureExistence() {
        if (!this.folder.exists()) {
            Base.showWarning("Sketch Disappeared", "The sketch folder has disappeared.\n Will attempt to re-save in the same location,\nbut anything besides the code will be lost.", null);
            try {
                this.folder.mkdirs();
                this.modified = true;
                for (int i = 0; i < this.codeCount; ++i) {
                    this.code[i].save();
                }
                this.calcModified();
            }
            catch (Exception e) {
                Base.showWarning("Could not re-save sketch", "Could not properly re-save the sketch. You may be in trouble at this point,\nand it might be time to copy and paste your code to another text editor.", e);
            }
        }
    }

    public boolean isReadOnly() {
        Mode mode;
        String apath = this.folder.getAbsolutePath();
        if (apath.startsWith((mode = this.editor.getMode()).getExamplesFolder().getAbsolutePath()) || apath.startsWith(mode.getLibrariesFolder().getAbsolutePath())) {
            return true;
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified() || !this.code[i].fileReadOnly() || !this.code[i].fileExists()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public File getPrimaryFile() {
        return this.primaryFile;
    }

    public String getMainFilePath() {
        return this.primaryFile.getAbsolutePath();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public boolean hasDataFolder() {
        return this.dataFolder.exists();
    }

    public File prepareDataFolder() {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }

    public boolean hasCodeFolder() {
        return this.codeFolder != null && this.codeFolder.exists();
    }

    public File prepareCodeFolder() {
        if (!this.codeFolder.exists()) {
            this.codeFolder.mkdirs();
        }
        return this.codeFolder;
    }

    public SketchCode[] getCode() {
        return this.code;
    }

    public int getCodeCount() {
        return this.codeCount;
    }

    public SketchCode getCode(int index) {
        return this.code[index];
    }

    public int getCodeIndex(SketchCode who) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (who != this.code[i]) continue;
            return i;
        }
        return -1;
    }

    public SketchCode getCurrentCode() {
        return this.current;
    }

    public void setUntitled(boolean u) {
        this.editor.untitled = u;
    }

    public boolean isUntitled() {
        return this.editor.untitled;
    }

    public static String checkName(String origName) {
        String newName = Sketch.sanitizeName(origName);
        if (!newName.equals(origName)) {
            String msg = "The sketch name had to be modified. Sketch names can only consist\nof ASCII characters and numbers (but cannot start with a number).\nThey should also be less less than 64 characters long.";
            System.out.println(msg);
        }
        return newName;
    }

    public static boolean isSanitaryName(String name) {
        if (name.toLowerCase().endsWith(".pde")) {
            name = name.substring(0, name.length() - 4);
        }
        return Sketch.sanitizeName(name).equals(name);
    }

    public static String sanitizeName(String origName) {
        char[] c = origName.toCharArray();
        StringBuffer buffer = new StringBuffer();
        if (c[0] >= '0' && c[0] <= '9') {
            buffer.append('_');
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'z' || c[i] >= 'A' && c[i] <= 'Z') {
                buffer.append(c[i]);
                continue;
            }
            buffer.append('_');
        }
        if (buffer.length() > 63) {
            buffer.setLength(63);
        }
        return buffer.toString();
    }

    public Mode getMode() {
        return this.mode;
    }
}

