/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.JosmDecimalFormatSymbolsProvider;
import org.openstreetmap.josm.tools.Logging;

public abstract class DefaultPreferenceSetting
implements PreferenceSetting {
    private final boolean isExpert;

    public DefaultPreferenceSetting() {
        this(false);
    }

    public DefaultPreferenceSetting(boolean isExpert) {
        this.isExpert = isExpert;
    }

    @Override
    public boolean isExpert() {
        return this.isExpert;
    }

    protected static void saveBoolean(String prefName, JCheckBox cb) {
        Config.getPref().putBoolean(prefName, cb.isSelected());
    }

    protected static void saveDouble(String prefName, JTextField tf) {
        String text = tf.getText();
        try {
            Config.getPref().putDouble(prefName, JosmDecimalFormatSymbolsProvider.parseDouble(text));
        }
        catch (NumberFormatException e) {
            Logging.warn("Unable to save '" + text + "' as a double value for preference " + prefName);
            Logging.trace(e);
        }
    }

    protected static void saveInt(String prefName, JTextField tf) {
        String text = tf.getText();
        try {
            Config.getPref().putInt(prefName, Integer.parseInt(text));
        }
        catch (NumberFormatException e) {
            Logging.warn("Unable to save '" + text + "' as an integer value for preference " + prefName);
            Logging.trace(e);
        }
    }
}

