/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsmessage;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsname.DnsName;
import org.minidns.record.Record;

public class Question {
    public final DnsName name;
    public final Record.TYPE type;
    public final Record.CLASS clazz;
    private final boolean unicastQuery;
    private byte[] byteArray;

    public Question(CharSequence name, Record.TYPE type2, Record.CLASS clazz, boolean unicastQuery) {
        this(DnsName.from(name), type2, clazz, unicastQuery);
    }

    public Question(DnsName name, Record.TYPE type2, Record.CLASS clazz, boolean unicastQuery) {
        assert (name != null);
        assert (type2 != null);
        assert (clazz != null);
        this.name = name;
        this.type = type2;
        this.clazz = clazz;
        this.unicastQuery = unicastQuery;
    }

    public Question(DnsName name, Record.TYPE type2, Record.CLASS clazz) {
        this(name, type2, clazz, false);
    }

    public Question(DnsName name, Record.TYPE type2) {
        this(name, type2, Record.CLASS.IN);
    }

    public Question(CharSequence name, Record.TYPE type2, Record.CLASS clazz) {
        this(DnsName.from(name), type2, clazz);
    }

    public Question(CharSequence name, Record.TYPE type2) {
        this(DnsName.from(name), type2);
    }

    public Question(DataInputStream dis, byte[] data2) throws IOException {
        this.name = DnsName.parse(dis, data2);
        this.type = Record.TYPE.getType(dis.readUnsignedShort());
        this.clazz = Record.CLASS.getClass(dis.readUnsignedShort());
        this.unicastQuery = false;
    }

    public byte[] toByteArray() {
        if (this.byteArray == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                this.name.writeToStream(dos);
                dos.writeShort(this.type.getValue());
                dos.writeShort(this.clazz.getValue() | (this.unicastQuery ? 32768 : 0));
                dos.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.byteArray = baos.toByteArray();
        }
        return this.byteArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Question)) {
            return false;
        }
        byte[] t = this.toByteArray();
        byte[] o = ((Question)other).toByteArray();
        return Arrays.equals(t, o);
    }

    public String toString() {
        return this.name.getRawAce() + ".\t" + (Object)((Object)this.clazz) + '\t' + (Object)((Object)this.type);
    }

    public DnsMessage.Builder asMessageBuilder() {
        DnsMessage.Builder builder = DnsMessage.builder();
        builder.setQuestion(this);
        return builder;
    }

    public DnsMessage asQueryMessage() {
        return this.asMessageBuilder().build();
    }
}

