/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.utils;

import jadx.api.plugins.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonFileUtils.class);
    public static final File CWD = CommonFileUtils.getCWD();
    public static final Path CWD_PATH = CWD.toPath();
    private static final Set<String> ZIP_FILE_EXTS = Utils.constSet("zip", "jar", "apk");

    private static File getCWD() {
        try {
            return new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init current working dir constant", e);
        }
    }

    public static Path saveToTempFile(InputStream in, String suffix) throws IOException {
        return CommonFileUtils.saveToTempFile(null, in, suffix);
    }

    public static Path saveToTempFile(byte[] dataPrefix, InputStream in, String suffix) throws IOException {
        Path tempFile = Files.createTempFile("jadx-temp-", suffix, new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            if (dataPrefix != null) {
                out.write(dataPrefix);
            }
            CommonFileUtils.copyStream(in, out);
        }
        catch (Exception e) {
            throw new IOException("Failed to save temp file", e);
        }
        return tempFile;
    }

    public static boolean safeDeleteFile(File file) {
        try {
            return file.delete();
        }
        catch (Exception e) {
            LOG.warn("Failed to delete file: {}", (Object)file, (Object)e);
            return false;
        }
    }

    public static byte[] loadBytes(InputStream input) throws IOException {
        return CommonFileUtils.loadBytes(null, input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadBytes(byte[] dataPrefix, InputStream in) throws IOException {
        int estimateSize = dataPrefix == null ? in.available() : dataPrefix.length + in.available();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(estimateSize);){
            if (dataPrefix != null) {
                out.write(dataPrefix);
            }
            CommonFileUtils.copyStream(in, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new IOException("Failed to read input stream to bytes array", e);
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        while ((count = input.read(buffer)) != -1) {
            output.write(buffer, 0, count);
        }
    }

    @Nullable
    public static String getFileExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return fileName.substring(dotIndex + 1);
    }

    public static String removeFileExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, dotIndex);
    }

    public static boolean isZipFileExt(String fileName) {
        String ext = CommonFileUtils.getFileExtension(fileName);
        if (ext == null) {
            return false;
        }
        return ZIP_FILE_EXTS.contains(ext);
    }
}

