/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public class WindowsInstallationSupplier
implements InstallationSupplier {
    private final WindowsRegistry windowsRegistry;
    private final OperatingSystem os;

    public WindowsInstallationSupplier(WindowsRegistry registry, OperatingSystem os) {
        this.windowsRegistry = registry;
        this.os = os;
    }

    @Override
    public String getSourceName() {
        return "Windows Registry";
    }

    @Override
    public Set<InstallationLocation> get() {
        if (this.os.isWindows()) {
            return this.findInstallationsInRegistry();
        }
        return Collections.emptySet();
    }

    private Set<InstallationLocation> findInstallationsInRegistry() {
        Stream<String> openJdkInstallations = this.findOpenJDKs();
        Stream jvms = Stream.of("SOFTWARE\\JavaSoft\\JDK", "SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Development Kit", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Runtime Environment").map(this::findJvms).flatMap(Collection::stream);
        return Stream.concat(openJdkInstallations, jvms).map(javaHome -> InstallationLocation.autoDetected(new File((String)javaHome), this.getSourceName())).collect(Collectors.toSet());
    }

    private List<String> find(String sdkSubkey, String path, String value) {
        try {
            List<String> versions = this.getVersions(sdkSubkey);
            return versions.stream().map(version -> this.getValue(sdkSubkey, path, value, (String)version)).collect(Collectors.toList());
        }
        catch (MissingRegistryEntryException | NativeIntegrationUnavailableException e) {
            return Collections.emptyList();
        }
    }

    private List<String> getVersions(String sdkSubkey) {
        return this.windowsRegistry.getSubkeys(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, sdkSubkey);
    }

    private String getValue(String sdkSubkey, String path, String value, String version) {
        return this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, sdkSubkey + '\\' + version + path, value);
    }

    private Stream<String> findOpenJDKs() {
        return Stream.of("SOFTWARE\\AdoptOpenJDK\\JDK", "SOFTWARE\\Eclipse Adoptium\\JDK", "SOFTWARE\\Eclipse Foundation\\JDK").flatMap(key -> this.find((String)key, "\\hotspot\\MSI", "Path").stream());
    }

    private List<String> findJvms(String sdkSubkey) {
        return this.find(sdkSubkey, "", "JavaHome");
    }
}

