/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.action.enterprise.RefreshProjectAction;
import ca.sqlpower.architect.swingui.enterprise.PrivilegesEditorPanel;
import ca.sqlpower.enterprise.client.Grant;
import ca.sqlpower.enterprise.client.Group;
import ca.sqlpower.enterprise.client.GroupMember;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UserEditorPanel
implements DataEntryPanel {
    private static final ImageIcon RIGHT_ARROW = new ImageIcon(RefreshProjectAction.class.getResource("/icons/arrow-right.png"));
    private static final ImageIcon LEFT_ARROW = new ImageIcon(RefreshProjectAction.class.getResource("/icons/arrow-left.png"));
    private static final ImageIcon GROUP_ICON = new ImageIcon(UserEditorPanel.class.getResource("icons/group.png"));
    private final ArchitectSwingProject securityWorkspace;
    private final User user;
    private final JPanel panel;
    private final JLabel usernameLabel;
    private final JLabel fullnameLabel;
    private final JLabel emailLabel;
    private final JButton passwordButton;
    private final JTextField usernameField;
    private final JTextField fullnameField;
    private final JTextField emailField;
    private final JList currentGroupsList;
    private final JLabel currentGroupsLabel;
    private final JScrollPane currentGroupsScrollPane;
    private final JList availableGroupsList;
    private final JLabel availableGroupsLabel;
    private final JScrollPane availableGroupsScrollPane;
    private final String username;
    private final PrivilegesEditorPanel privilegesEditorPanel;
    private final Action closeAction;
    private final Action addAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selection = UserEditorPanel.this.availableGroupsList.getSelectedValues();
            if (selection.length == 0) {
                return;
            }
            UserEditorPanel.this.hasUnsavedChanges = true;
            DefaultListModel availableGroupsModel = (DefaultListModel)UserEditorPanel.this.availableGroupsList.getModel();
            DefaultListModel currentGroupsModel = (DefaultListModel)UserEditorPanel.this.currentGroupsList.getModel();
            for (Object object : selection) {
                availableGroupsModel.removeElement(object);
                currentGroupsModel.addElement(object);
            }
        }
    };
    private final Action removeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selection = UserEditorPanel.this.currentGroupsList.getSelectedValues();
            if (selection.length == 0) {
                return;
            }
            UserEditorPanel.this.hasUnsavedChanges = true;
            DefaultListModel currentGroupsModel = (DefaultListModel)UserEditorPanel.this.currentGroupsList.getModel();
            DefaultListModel availableGroupsModel = (DefaultListModel)UserEditorPanel.this.availableGroupsList.getModel();
            for (Object object : selection) {
                currentGroupsModel.removeElement(object);
                availableGroupsModel.addElement(object);
            }
        }
    };
    private final Action okAction = new AbstractAction("Apply"){

        @Override
        public void actionPerformed(ActionEvent e) {
            UserEditorPanel.this.applyChanges();
        }
    };
    private final Action cancelAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            UserEditorPanel.this.discardChanges();
            UserEditorPanel.this.closeAction.actionPerformed(e);
        }
    };
    private final Action changePasswordAction = new AbstractAction("Change Password"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Window parentWindow = SwingUtilities.getWindowAncestor(UserEditorPanel.this.panel);
            final JDialog dialog = new JDialog(parentWindow);
            final JPasswordField oldPasswordField = new JPasswordField(21);
            final JPasswordField newPasswordField = new JPasswordField(21);
            final JPasswordField newPasswordFiled2 = new JPasswordField(21);
            CellConstraints cc = new CellConstraints();
            DefaultFormBuilder dialogBuilder = new DefaultFormBuilder(new FormLayout("pref:grow", "pref, pref, pref, pref, pref, pref, pref"));
            if (UserEditorPanel.this.user.getName().equals(UserEditorPanel.this.username)) {
                dialogBuilder.add((Component)new JLabel("Enter your old password"), cc.xy(1, 1));
                dialogBuilder.add((Component)oldPasswordField, cc.xy(1, 2));
            }
            dialogBuilder.add((Component)new JLabel("Enter new password"), cc.xy(1, 3));
            dialogBuilder.add((Component)newPasswordField, cc.xy(1, 4));
            dialogBuilder.add((Component)new JLabel("Confirm new password"), cc.xy(1, 5));
            dialogBuilder.add((Component)newPasswordFiled2, cc.xy(1, 6));
            ButtonBarBuilder2 bbb = ButtonBarBuilder2.createLeftToRightBuilder();
            bbb.addGlue();
            bbb.addButton((JComponent)new JButton(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (newPasswordField.getText().equals(newPasswordFiled2.getText())) {
                        String oldPassword = UserEditorPanel.this.user.getName().equals(UserEditorPanel.this.username) ? oldPasswordField.getText() : null;
                        String newPassword = newPasswordField.getText();
                        ArchitectClientSideSession clientSession = (ArchitectClientSideSession)UserEditorPanel.this.securityWorkspace.getSession();
                        clientSession.updateUserPassword(UserEditorPanel.this.user, oldPassword, newPassword, UserEditorPanel.this.session);
                        dialog.dispose();
                    } else {
                        JOptionPane.showMessageDialog(UserEditorPanel.this.getPanel(), "The passwords you entered were not the same");
                    }
                }
            }));
            bbb.addRelatedGap();
            bbb.addButton((JComponent)new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            }));
            bbb.setDefaultButtonBarGapBorder();
            dialogBuilder.add((Component)bbb.getPanel(), cc.xy(1, 7));
            dialogBuilder.setDefaultDialogBorder();
            dialog.setContentPane(dialogBuilder.getPanel());
            dialog.pack();
            dialog.setLocationRelativeTo(parentWindow);
            dialog.setVisible(true);
        }
    };
    private boolean hasUnsavedChanges = false;
    private final DocumentListener textFieldListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            UserEditorPanel.this.hasUnsavedChanges = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UserEditorPanel.this.hasUnsavedChanges = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UserEditorPanel.this.hasUnsavedChanges = true;
        }
    };
    private final ArchitectSession session;

    public UserEditorPanel(User baseUser, String username, Action closeAction, ArchitectSession session) {
        this.user = baseUser;
        this.session = session;
        this.securityWorkspace = (ArchitectSwingProject)this.user.getParent();
        this.username = username;
        this.closeAction = closeAction;
        Dimension prefScrollPaneDimension = new Dimension(250, 300);
        this.usernameLabel = new JLabel("User Name");
        this.usernameField = new JTextField();
        this.usernameField.setText(this.user.getUsername());
        this.usernameField.getDocument().addDocumentListener(this.textFieldListener);
        this.fullnameLabel = new JLabel("Full Name");
        this.fullnameField = new JTextField();
        this.fullnameField.setText(this.user.getFullName());
        this.fullnameField.getDocument().addDocumentListener(this.textFieldListener);
        this.emailLabel = new JLabel("Email");
        this.emailField = new JTextField();
        this.emailField.setText(this.user.getEmail());
        this.emailField.getDocument().addDocumentListener(this.textFieldListener);
        DefaultListCellRenderer groupListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(GROUP_ICON);
                return this;
            }
        };
        this.availableGroupsLabel = new JLabel("Available Groups");
        this.availableGroupsList = new JList(new DefaultListModel());
        this.availableGroupsList.setCellRenderer(groupListCellRenderer);
        this.availableGroupsScrollPane = new JScrollPane(this.availableGroupsList);
        this.availableGroupsScrollPane.setPreferredSize(prefScrollPaneDimension);
        this.currentGroupsLabel = new JLabel("Current Groups");
        this.currentGroupsList = new JList(new DefaultListModel());
        this.currentGroupsList.setCellRenderer(groupListCellRenderer);
        this.currentGroupsScrollPane = new JScrollPane(this.currentGroupsList);
        this.currentGroupsScrollPane.setPreferredSize(prefScrollPaneDimension);
        Grant globalGrant = null;
        for (Grant grant : this.user.getChildren(Grant.class)) {
            if (!grant.isSystemLevel() || !grant.getType().equals(ArchitectSwingProject.class.getName())) continue;
            if (globalGrant != null) {
                throw new IllegalStateException("Multiple grants for Architect Project found");
            }
            globalGrant = grant;
        }
        this.privilegesEditorPanel = globalGrant != null ? new PrivilegesEditorPanel(globalGrant, (SPObject)this.user, null, ArchitectSwingProject.class.getName(), username, this.securityWorkspace) : new PrivilegesEditorPanel(null, (SPObject)this.user, null, ArchitectSwingProject.class.getName(), username, this.securityWorkspace);
        JButton addButton = new JButton(this.addAction);
        addButton.setIcon(RIGHT_ARROW);
        JButton removeButton = new JButton(this.removeAction);
        removeButton.setIcon(LEFT_ARROW);
        CellConstraints cc = new CellConstraints();
        DefaultFormBuilder upperPanelBuilder = new DefaultFormBuilder(new FormLayout("pref, 5dlu, pref:grow", "pref, pref, pref, pref, pref, 5dlu"));
        upperPanelBuilder.add((Component)this.usernameLabel, cc.xy(1, 1));
        upperPanelBuilder.add((Component)this.usernameField, cc.xyw(3, 1, 1));
        upperPanelBuilder.add((Component)this.fullnameLabel, cc.xy(1, 3));
        upperPanelBuilder.add((Component)this.fullnameField, cc.xyw(3, 3, 1));
        upperPanelBuilder.add((Component)this.emailLabel, cc.xy(1, 4));
        upperPanelBuilder.add((Component)this.emailField, cc.xy(3, 4));
        this.passwordButton = new JButton(this.changePasswordAction);
        ButtonBarBuilder2 passwordBuilder = ButtonBarBuilder2.createLeftToRightBuilder();
        passwordBuilder.addGlue();
        passwordBuilder.addButton((JComponent)this.passwordButton);
        DefaultFormBuilder buttonPanelBuilder = new DefaultFormBuilder(new FormLayout("pref", "pref:grow, pref, 5dlu, pref, pref:grow"));
        buttonPanelBuilder.add((Component)addButton, cc.xy(1, 2));
        buttonPanelBuilder.add((Component)removeButton, cc.xy(1, 5));
        DefaultFormBuilder centrePanelBuilder = new DefaultFormBuilder(new FormLayout("pref, 5dlu, pref, 5dlu, pref", "pref, pref:grow"));
        centrePanelBuilder.add((Component)this.availableGroupsLabel, cc.xy(1, 1));
        centrePanelBuilder.add((Component)this.currentGroupsLabel, cc.xy(5, 1));
        centrePanelBuilder.add((Component)this.availableGroupsScrollPane, cc.xy(1, 2));
        centrePanelBuilder.add((Component)buttonPanelBuilder.getPanel(), cc.xy(3, 2));
        centrePanelBuilder.add((Component)this.currentGroupsScrollPane, cc.xy(5, 2));
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow", "pref, pref, 3dlu, pref:grow, 5dlu, pref"));
        builder.add((Component)upperPanelBuilder.getPanel(), cc.xy(1, 1));
        builder.add((Component)passwordBuilder.getPanel(), cc.xy(1, 2));
        builder.add((Component)centrePanelBuilder.getPanel(), cc.xy(1, 4));
        DefaultFormBuilder bottomBuilder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref:grow", "pref, 3dlu, pref"));
        bottomBuilder.add((Component)new JLabel("System Privileges"), cc.xy(1, 1));
        bottomBuilder.add((Component)this.privilegesEditorPanel.getPanel(), cc.xy(1, 3));
        ButtonBarBuilder2 bbb = ButtonBarBuilder2.createLeftToRightBuilder();
        bbb.addGlue();
        bbb.addButton((JComponent)new JButton(this.okAction));
        bbb.addRelatedGap();
        bbb.addButton((JComponent)new JButton(this.cancelAction));
        bottomBuilder.add((Component)bbb.getPanel(), cc.xy(3, 3));
        builder.add((Component)bottomBuilder.getPanel(), cc.xy(1, 6));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
        this.fillGroupLists();
        this.disableIfNecessary();
    }

    private void fillGroupLists() {
        ArrayList availableGroups = new ArrayList(this.securityWorkspace.getChildren(Group.class));
        ArrayList<Group> currentGroups = new ArrayList<Group>();
        for (Group group : availableGroups) {
            for (GroupMember member : group.getChildren(GroupMember.class)) {
                if (!member.getUser().getUUID().equals(this.user.getUUID())) continue;
                currentGroups.add(group);
            }
        }
        availableGroups.removeAll(currentGroups);
        DefaultListModel availableGroupsModel = (DefaultListModel)this.availableGroupsList.getModel();
        availableGroupsModel.removeAllElements();
        for (Group group : availableGroups) {
            availableGroupsModel.addElement(group);
        }
        DefaultListModel currentGroupsModel = (DefaultListModel)this.currentGroupsList.getModel();
        currentGroupsModel.removeAllElements();
        for (Group group : currentGroups) {
            currentGroupsModel.addElement(group);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean applyChanges() {
        this.privilegesEditorPanel.applyChanges();
        try {
            if (this.hasUnsavedChanges()) {
                this.securityWorkspace.begin("Applying changes to the security model");
                if (!this.usernameField.getText().equals(this.user.getUsername())) {
                    this.user.setName(this.usernameField.getText());
                }
                if (!this.fullnameField.getText().equals(this.user.getFullName())) {
                    this.user.setFullName(this.fullnameField.getText());
                }
                if (!this.emailField.getText().equals(this.user.getEmail())) {
                    this.user.setEmail(this.emailField.getText());
                }
                ArrayList<Group> previousGroups = new ArrayList<Group>();
                for (Group group : this.securityWorkspace.getChildren(Group.class)) {
                    for (GroupMember member : group.getChildren(GroupMember.class)) {
                        if (!member.getUser().getUUID().equals(this.user.getUUID())) continue;
                        previousGroups.add(group);
                    }
                }
                DefaultListModel currentGroupsModel = (DefaultListModel)this.currentGroupsList.getModel();
                for (int i = 0; i < currentGroupsModel.size(); ++i) {
                    Group group = (Group)currentGroupsModel.get(i);
                    boolean addMe = true;
                    for (Group previousGroup : previousGroups) {
                        if (!previousGroup.getUUID().equals(group.getUUID())) continue;
                        addMe = false;
                    }
                    if (!addMe) continue;
                    group.addMember(new GroupMember(this.user));
                }
                DefaultListModel availableGroupsModel = (DefaultListModel)this.availableGroupsList.getModel();
                for (int i = 0; i < availableGroupsModel.size(); ++i) {
                    Group group = (Group)availableGroupsModel.get(i);
                    GroupMember removeMe = null;
                    for (Group previousGroup : previousGroups) {
                        if (!previousGroup.getUUID().equals(group.getUUID())) continue;
                        for (GroupMember member : group.getChildren(GroupMember.class)) {
                            if (!member.getUser().getUUID().equals(this.user.getUUID())) continue;
                            removeMe = member;
                        }
                    }
                    if (removeMe == null) continue;
                    group.removeMember(removeMe);
                }
                this.securityWorkspace.commit();
            }
            this.hasUnsavedChanges = false;
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to apply changes", e);
        }
    }

    public void disableIfNecessary() {
        User creatingUser = null;
        ArrayList<Grant> grantsForUser = new ArrayList<Grant>();
        for (User aUser : this.securityWorkspace.getChildren(User.class)) {
            if (!aUser.getUsername().equals(this.username)) continue;
            creatingUser = aUser;
        }
        if (creatingUser == null) {
            throw new IllegalStateException("User cannot possibly be null");
        }
        for (Grant g : creatingUser.getChildren(Grant.class)) {
            grantsForUser.add(g);
        }
        for (Grant g : this.securityWorkspace.getChildren(Group.class)) {
            for (GroupMember gm : g.getChildren(GroupMember.class)) {
                if (!gm.getUser().getUUID().equals(creatingUser.getUUID())) continue;
                for (Grant gr : g.getChildren(Grant.class)) {
                    grantsForUser.add(gr);
                }
            }
        }
        boolean disableModifyUser = true;
        boolean disableModifyGroups = true;
        if (this.username.equals(this.user.getUsername())) {
            disableModifyUser = false;
        }
        for (Grant g : grantsForUser) {
            if ((!g.isSystemLevel() && g.getSubject().equals(this.user.getUUID()) || g.isSystemLevel() && g.getType().equals(User.class.getName())) && g.isModifyPrivilege()) {
                disableModifyUser = false;
            }
            if (!g.isSystemLevel() || !g.getType().equals(Group.class.getName()) || !g.isModifyPrivilege()) continue;
            disableModifyGroups = false;
        }
        if (disableModifyUser) {
            this.usernameField.setEnabled(false);
            this.fullnameField.setEnabled(false);
            this.emailField.setEnabled(false);
            this.passwordButton.setEnabled(false);
        }
        if (disableModifyGroups) {
            this.addAction.setEnabled(false);
            this.removeAction.setEnabled(false);
            this.currentGroupsList.setEnabled(false);
            this.availableGroupsList.setEnabled(false);
        }
    }

    public void discardChanges() {
        this.privilegesEditorPanel.discardChanges();
        this.hasUnsavedChanges = false;
    }

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges || this.privilegesEditorPanel.hasUnsavedChanges();
    }
}

