/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.action.enterprise.RefreshProjectAction;
import ca.sqlpower.architect.swingui.enterprise.PrivilegesEditorPanel;
import ca.sqlpower.enterprise.client.Grant;
import ca.sqlpower.enterprise.client.Group;
import ca.sqlpower.enterprise.client.GroupMember;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GroupEditorPanel
implements DataEntryPanel {
    private static final ImageIcon RIGHT_ARROW = new ImageIcon(RefreshProjectAction.class.getResource("/icons/arrow-right.png"));
    private static final ImageIcon LEFT_ARROW = new ImageIcon(RefreshProjectAction.class.getResource("/icons/arrow-left.png"));
    private static final ImageIcon USER_ICON = new ImageIcon(GroupEditorPanel.class.getResource("icons/user.png"));
    private final Group group;
    private final JPanel panel;
    private final JLabel nameLabel;
    private final JTextField nameTextField;
    private final JList currentUsersList;
    private final JLabel currentUsersLabel;
    private final JScrollPane currentUsersScrollPane;
    private final JList availableUsersList;
    private final JLabel availableUsersLabel;
    private final JScrollPane availableUsersScrollPane;
    private final ArchitectSwingProject securityWorkspace;
    private final PrivilegesEditorPanel privilegesEditorPanel;
    private final Action closeAction;
    private final Action addAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selection = GroupEditorPanel.this.availableUsersList.getSelectedValues();
            if (selection.length == 0) {
                return;
            }
            GroupEditorPanel.this.hasUnsavedChanges = true;
            DefaultListModel availableUsersModel = (DefaultListModel)GroupEditorPanel.this.availableUsersList.getModel();
            DefaultListModel currentUsersModel = (DefaultListModel)GroupEditorPanel.this.currentUsersList.getModel();
            for (Object object : selection) {
                availableUsersModel.removeElement(object);
                currentUsersModel.addElement(object);
            }
        }
    };
    private final Action removeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selection = GroupEditorPanel.this.currentUsersList.getSelectedValues();
            if (selection.length == 0) {
                return;
            }
            GroupEditorPanel.this.hasUnsavedChanges = true;
            DefaultListModel currentUsersModel = (DefaultListModel)GroupEditorPanel.this.currentUsersList.getModel();
            DefaultListModel availableUsersModel = (DefaultListModel)GroupEditorPanel.this.availableUsersList.getModel();
            for (Object object : selection) {
                currentUsersModel.removeElement(object);
                availableUsersModel.addElement(object);
            }
        }
    };
    private boolean hasUnsavedChanges = false;
    private final DocumentListener textFieldListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            GroupEditorPanel.this.hasUnsavedChanges = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GroupEditorPanel.this.hasUnsavedChanges = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GroupEditorPanel.this.hasUnsavedChanges = true;
        }
    };
    private final Action okAction = new AbstractAction("Apply"){

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupEditorPanel.this.applyChanges();
        }
    };
    private final Action cancelAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupEditorPanel.this.discardChanges();
            GroupEditorPanel.this.closeAction.actionPerformed(e);
        }
    };
    private final String username;

    public GroupEditorPanel(Group baseGroup, String username, Action closeAction) {
        this.group = baseGroup;
        this.securityWorkspace = (ArchitectSwingProject)this.group.getParent();
        this.username = username;
        this.closeAction = closeAction;
        Dimension prefScrollPaneDimension = new Dimension(250, 300);
        this.nameLabel = new JLabel("Group Name");
        this.nameTextField = new JTextField(25);
        this.nameTextField.setText(this.group.getName());
        this.nameTextField.getDocument().addDocumentListener(this.textFieldListener);
        DefaultListCellRenderer userListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(USER_ICON);
                return this;
            }
        };
        this.availableUsersLabel = new JLabel("Available Users");
        this.availableUsersList = new JList(new DefaultListModel());
        this.availableUsersList.setCellRenderer(userListCellRenderer);
        this.availableUsersScrollPane = new JScrollPane(this.availableUsersList);
        this.availableUsersScrollPane.setPreferredSize(prefScrollPaneDimension);
        this.currentUsersLabel = new JLabel("Current Users");
        this.currentUsersList = new JList(new DefaultListModel());
        this.currentUsersList.setCellRenderer(userListCellRenderer);
        this.currentUsersScrollPane = new JScrollPane(this.currentUsersList);
        this.currentUsersScrollPane.setPreferredSize(prefScrollPaneDimension);
        Grant globalGrant = null;
        for (Grant grant : baseGroup.getChildren(Grant.class)) {
            if (!grant.isSystemLevel() || grant.getType() == null || !grant.getType().equals(ArchitectSwingProject.class.getName())) continue;
            if (globalGrant != null) {
                throw new IllegalStateException("Multiple grants for system level workspace under the same group found.");
            }
            globalGrant = grant;
        }
        this.privilegesEditorPanel = globalGrant != null ? new PrivilegesEditorPanel(globalGrant, (SPObject)baseGroup, null, ArchitectSwingProject.class.getName(), username, this.securityWorkspace) : new PrivilegesEditorPanel(null, (SPObject)baseGroup, null, ArchitectSwingProject.class.getName(), username, this.securityWorkspace);
        JButton addButton = new JButton(this.addAction);
        addButton.setIcon(RIGHT_ARROW);
        JButton removeButton = new JButton(this.removeAction);
        removeButton.setIcon(LEFT_ARROW);
        CellConstraints cc = new CellConstraints();
        DefaultFormBuilder upperPanelBuilder = new DefaultFormBuilder(new FormLayout("pref, 5dlu, pref:grow", "pref, 5dlu"));
        upperPanelBuilder.add((Component)this.nameLabel, cc.xy(1, 1));
        upperPanelBuilder.add((Component)this.nameTextField, cc.xyw(3, 1, 1));
        DefaultFormBuilder buttonPanelBuilder = new DefaultFormBuilder(new FormLayout("pref", "pref:grow, pref, 5dlu, pref, pref:grow"));
        buttonPanelBuilder.add((Component)addButton, cc.xy(1, 2));
        buttonPanelBuilder.add((Component)removeButton, cc.xy(1, 5));
        DefaultFormBuilder centrePanelBuilder = new DefaultFormBuilder(new FormLayout("pref, 5dlu, pref, 5dlu, pref", "pref, pref:grow"));
        centrePanelBuilder.add((Component)this.availableUsersLabel, cc.xy(1, 1));
        centrePanelBuilder.add((Component)this.currentUsersLabel, cc.xy(5, 1));
        centrePanelBuilder.add((Component)this.availableUsersScrollPane, cc.xy(1, 2));
        centrePanelBuilder.add((Component)buttonPanelBuilder.getPanel(), cc.xy(3, 2));
        centrePanelBuilder.add((Component)this.currentUsersScrollPane, cc.xy(5, 2));
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow", "pref, 3dlu, pref:grow, 5dlu, pref"));
        builder.add((Component)upperPanelBuilder.getPanel(), cc.xy(1, 1));
        builder.add((Component)centrePanelBuilder.getPanel(), cc.xy(1, 3));
        DefaultFormBuilder bottomBuilder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref:grow", "pref, 3dlu, pref"));
        bottomBuilder.add((Component)new JLabel("System Privileges"), cc.xy(1, 1));
        bottomBuilder.add((Component)this.privilegesEditorPanel.getPanel(), cc.xy(1, 3));
        ButtonBarBuilder2 bbb = ButtonBarBuilder2.createLeftToRightBuilder();
        bbb.addGlue();
        bbb.addButton((JComponent)new JButton(this.okAction));
        bbb.addRelatedGap();
        bbb.addButton((JComponent)new JButton(this.cancelAction));
        bottomBuilder.add((Component)bbb.getPanel(), cc.xy(3, 3));
        builder.add((Component)bottomBuilder.getPanel(), cc.xy(1, 5));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
        this.fillUserLists();
        this.disableIfNecessary();
    }

    private void fillUserLists() {
        ArrayList users = new ArrayList(this.securityWorkspace.getChildren(User.class));
        List groupMembers = this.group.getChildren(GroupMember.class);
        ArrayList<User> toRemove = new ArrayList<User>();
        for (User user : users) {
            for (GroupMember membership : groupMembers) {
                if (!membership.getUser().getUUID().equals(user.getUUID())) continue;
                toRemove.add(user);
            }
        }
        users.removeAll(toRemove);
        DefaultListModel availableUsersModel = (DefaultListModel)this.availableUsersList.getModel();
        availableUsersModel.removeAllElements();
        for (User user : users) {
            availableUsersModel.addElement(user);
        }
        DefaultListModel currentUsersModel = (DefaultListModel)this.currentUsersList.getModel();
        currentUsersModel.removeAllElements();
        for (GroupMember member : groupMembers) {
            currentUsersModel.addElement(member.getUser());
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean applyChanges() {
        this.privilegesEditorPanel.applyChanges();
        try {
            if (this.hasUnsavedChanges()) {
                this.securityWorkspace.begin("Applying changes to the security model");
                if (!this.group.getName().equals(this.nameTextField.getText())) {
                    this.group.setName(this.nameTextField.getText());
                }
                List previousUsers = this.group.getChildren(GroupMember.class);
                DefaultListModel currentUsersModel = (DefaultListModel)this.currentUsersList.getModel();
                for (int i = 0; i < currentUsersModel.size(); ++i) {
                    User user = (User)currentUsersModel.get(i);
                    boolean addMe = true;
                    for (GroupMember previousUser : previousUsers) {
                        if (!user.getUUID().equals(previousUser.getUser().getUUID())) continue;
                        addMe = false;
                    }
                    if (!addMe) continue;
                    this.group.addMember(new GroupMember(user));
                }
                DefaultListModel availableUsersModel = (DefaultListModel)this.availableUsersList.getModel();
                for (int i = 0; i < availableUsersModel.size(); ++i) {
                    User user = (User)availableUsersModel.get(i);
                    GroupMember removeMe = null;
                    for (GroupMember previousUser : previousUsers) {
                        if (!user.getUUID().equals(previousUser.getUser().getUUID())) continue;
                        removeMe = previousUser;
                    }
                    if (removeMe == null) continue;
                    this.group.removeMember(removeMe);
                }
                this.securityWorkspace.commit();
            }
            this.hasUnsavedChanges = false;
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to apply changes.", e);
        }
    }

    public void discardChanges() {
        this.privilegesEditorPanel.discardChanges();
        this.hasUnsavedChanges = false;
    }

    public void disableIfNecessary() {
        User user = null;
        ArrayList<Grant> grantsForUser = new ArrayList<Grant>();
        for (User aUser : this.securityWorkspace.getChildren(User.class)) {
            if (!aUser.getUsername().equals(this.username)) continue;
            user = aUser;
        }
        if (user == null) {
            throw new IllegalStateException("User cannot possibly be null");
        }
        for (Grant g : user.getChildren(Grant.class)) {
            grantsForUser.add(g);
        }
        for (Grant g : this.securityWorkspace.getChildren(Group.class)) {
            for (GroupMember gm : g.getChildren(GroupMember.class)) {
                if (!gm.getUser().getUUID().equals(user.getUUID())) continue;
                for (Grant gr : g.getChildren(Grant.class)) {
                    grantsForUser.add(gr);
                }
            }
        }
        boolean disableModifyGroup = true;
        for (Grant g : grantsForUser) {
            if ((g.isSystemLevel() || !g.getSubject().equals(this.group.getUUID())) && (!g.isSystemLevel() || !g.getType().equals(Group.class.getName())) || !g.isModifyPrivilege()) continue;
            disableModifyGroup = false;
        }
        if (disableModifyGroup) {
            this.nameTextField.setEnabled(false);
            this.currentUsersList.setEnabled(false);
            this.availableUsersList.setEnabled(false);
            this.removeAction.setEnabled(false);
            this.addAction.setEnabled(false);
        }
    }

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges || this.privilegesEditorPanel.hasUnsavedChanges();
    }
}

