/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public final class SampleTree {
    protected JFrame frame;
    protected JTree tree;
    protected DefaultTreeModel treeModel;

    public SampleTree() {
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenuBar jMenuBar = this.constructMenuBar();
        JPanel jPanel = new JPanel(true);
        this.frame = new JFrame("SampleTree");
        this.frame.getContentPane().add("Center", jPanel);
        this.frame.setJMenuBar(jMenuBar);
        this.frame.setBackground(Color.lightGray);
        DefaultMutableTreeNode defaultMutableTreeNode = this.createNewNode("Root");
        this.treeModel = new SampleTreeModel(defaultMutableTreeNode);
        this.tree = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new SampleTreeCellRenderer());
        this.tree.setRowHeight(-1);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jScrollPane.getViewport().add(this.tree);
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", this.constructOptionsPanel());
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private JPanel constructOptionsPanel() {
        JPanel jPanel = new JPanel(false);
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel.setLayout(new FlowLayout());
        JCheckBox jCheckBox = new JCheckBox("show top level handles");
        jCheckBox.setSelected(this.tree.getShowsRootHandles());
        jCheckBox.addChangeListener(new ShowHandlesChangeListener());
        jPanel.add(jCheckBox);
        jCheckBox = new JCheckBox("show root");
        jCheckBox.setSelected(this.tree.isRootVisible());
        jCheckBox.addChangeListener(new ShowRootChangeListener());
        jPanel.add(jCheckBox);
        jCheckBox = new JCheckBox("editable");
        jCheckBox.setSelected(this.tree.isEditable());
        jCheckBox.addChangeListener(new TreeEditableChangeListener());
        jCheckBox.setToolTipText("Triple click to edit");
        jPanel.add(jCheckBox);
        jPanel2.add((Component)jPanel, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new FlowLayout());
        jPanel3.setBorder(new TitledBorder("Selection Mode"));
        JRadioButton jRadioButton = new JRadioButton("Single");
        jRadioButton.addActionListener(new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SampleTree.this.tree.getSelectionModel().setSelectionMode(1);
            }
        });
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jRadioButton = new JRadioButton("Contiguous");
        jRadioButton.addActionListener(new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SampleTree.this.tree.getSelectionModel().setSelectionMode(2);
            }
        });
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jRadioButton = new JRadioButton("Discontiguous");
        jRadioButton.addActionListener(new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SampleTree.this.tree.getSelectionModel().setSelectionMode(4);
            }
        });
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jPanel2.add((Component)jPanel3, "South");
        return jPanel2;
    }

    private JMenuBar constructMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Exit"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu = new JMenu("Tree");
        jMenuBar.add(jMenu);
        jMenuItem = jMenu.add(new JMenuItem("Add"));
        jMenuItem.addActionListener(new AddAction());
        jMenuItem = jMenu.add(new JMenuItem("Insert"));
        jMenuItem.addActionListener(new InsertAction());
        jMenuItem = jMenu.add(new JMenuItem("Reload"));
        jMenuItem.addActionListener(new ReloadAction());
        jMenuItem = jMenu.add(new JMenuItem("Remove"));
        jMenuItem.addActionListener(new RemoveAction());
        return jMenuBar;
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            return (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    protected TreePath[] getSelectedPaths() {
        return this.tree.getSelectionPaths();
    }

    protected DefaultMutableTreeNode createNewNode(String string) {
        return new DynamicTreeNode(new SampleData(null, Color.black, string));
    }

    public static void main(String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    new SampleTree();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(SampleTree.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(SampleTree.class.getName()).log(Level.SEVERE, null, invocationTargetException);
        }
    }

    class TreeEditableChangeListener
    implements ChangeListener {
        TreeEditableChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SampleTree.this.tree.setEditable(((JCheckBox)changeEvent.getSource()).isSelected());
        }
    }

    class ShowRootChangeListener
    implements ChangeListener {
        ShowRootChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SampleTree.this.tree.setRootVisible(((JCheckBox)changeEvent.getSource()).isSelected());
        }
    }

    class ShowHandlesChangeListener
    implements ChangeListener {
        ShowHandlesChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SampleTree.this.tree.setShowsRootHandles(((JCheckBox)changeEvent.getSource()).isSelected());
        }
    }

    class RemoveAction
    implements ActionListener {
        RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = SampleTree.this.getSelectedPaths();
            if (treePathArray != null && treePathArray.length > 0) {
                TreePath treePath;
                while ((treePath = this.findShallowestPath(treePathArray)) != null) {
                    this.removeSiblings(treePath, treePathArray);
                }
            }
        }

        private void removeSiblings(TreePath treePath, TreePath[] treePathArray) {
            if (treePath.getPathCount() == 1) {
                for (int i = treePathArray.length - 1; i >= 0; --i) {
                    treePathArray[i] = null;
                }
                SampleTree.this.treeModel.setRoot(null);
            } else {
                int n;
                TreePath treePath2 = treePath.getParentPath();
                MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath2.getLastPathComponent();
                ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                for (n = treePathArray.length - 1; n >= 0; --n) {
                    if (treePathArray[n] == null || !treePathArray[n].getParentPath().equals(treePath2)) continue;
                    arrayList.add(treePathArray[n]);
                    treePathArray[n] = null;
                }
                n = arrayList.size();
                for (int i = treePathArray.length - 1; i >= 0; --i) {
                    if (treePathArray[i] == null) continue;
                    for (int j = n - 1; j >= 0; --j) {
                        if (!((TreePath)arrayList.get(j)).isDescendant(treePathArray[i])) continue;
                        treePathArray[i] = null;
                    }
                }
                if (n > 1) {
                    Collections.sort(arrayList, new PositionComparator());
                }
                int[] nArray = new int[n];
                Object[] objectArray = new Object[n];
                for (int i = n - 1; i >= 0; --i) {
                    objectArray[i] = ((TreePath)arrayList.get(i)).getLastPathComponent();
                    nArray[i] = SampleTree.this.treeModel.getIndexOfChild(mutableTreeNode, objectArray[i]);
                    mutableTreeNode.remove(nArray[i]);
                }
                SampleTree.this.treeModel.nodesWereRemoved(mutableTreeNode, nArray, objectArray);
            }
        }

        private TreePath findShallowestPath(TreePath[] treePathArray) {
            int n = -1;
            TreePath treePath = null;
            for (int i = treePathArray.length - 1; i >= 0; --i) {
                if (treePathArray[i] == null) continue;
                if (n != -1) {
                    if (treePathArray[i].getPathCount() >= n) continue;
                    n = treePathArray[i].getPathCount();
                    treePath = treePathArray[i];
                    if (n != 1) continue;
                    return treePath;
                }
                treePath = treePathArray[i];
                n = treePathArray[i].getPathCount();
            }
            return treePath;
        }

        private class PositionComparator
        implements Comparator<TreePath> {
            private PositionComparator() {
            }

            @Override
            public int compare(TreePath treePath, TreePath treePath2) {
                int n = SampleTree.this.treeModel.getIndexOfChild(treePath.getParentPath().getLastPathComponent(), treePath.getLastPathComponent());
                int n2 = SampleTree.this.treeModel.getIndexOfChild(treePath2.getParentPath().getLastPathComponent(), treePath2.getLastPathComponent());
                return n - n2;
            }
        }
    }

    class ReloadAction
    implements ActionListener {
        ReloadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = SampleTree.this.getSelectedNode();
            if (defaultMutableTreeNode != null) {
                SampleTree.this.treeModel.reload(defaultMutableTreeNode);
            }
        }
    }

    class InsertAction
    implements ActionListener {
        public int insertCount;

        InsertAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2 = SampleTree.this.getSelectedNode();
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
                    defaultMutableTreeNode2 = null;
                }
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
            }
            if (defaultMutableTreeNode == null) {
                SampleTree.this.treeModel.setRoot(SampleTree.this.createNewNode("Inserted " + Integer.toString(this.insertCount++)));
            } else {
                int n = defaultMutableTreeNode2 == null ? SampleTree.this.treeModel.getChildCount(defaultMutableTreeNode) : defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
                SampleTree.this.treeModel.insertNodeInto(SampleTree.this.createNewNode("Inserted " + Integer.toString(this.insertCount++)), defaultMutableTreeNode, n);
            }
        }
    }

    class AddAction
    implements ActionListener {
        public int addCount;

        AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2 = SampleTree.this.getSelectedNode();
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
                    defaultMutableTreeNode2 = null;
                }
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
            }
            if (defaultMutableTreeNode == null) {
                SampleTree.this.treeModel.setRoot(SampleTree.this.createNewNode("Added " + Integer.toString(this.addCount++)));
            } else {
                int n = defaultMutableTreeNode2 == null ? SampleTree.this.treeModel.getChildCount(defaultMutableTreeNode) : defaultMutableTreeNode.getIndex(defaultMutableTreeNode2) + 1;
                SampleTree.this.treeModel.insertNodeInto(SampleTree.this.createNewNode("Added " + Integer.toString(this.addCount++)), defaultMutableTreeNode, n);
            }
        }
    }
}

