/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNode;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;

public class JavaArrayItemsProvider
extends HeapViewerNode.Provider {
    @Override
    public String getName() {
        return Bundle.JavaArrayItemsProvider_Name();
    }

    @Override
    public boolean supportsView(Heap heap, String viewID) {
        return viewID.startsWith("java_");
    }

    @Override
    public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
        if (parent instanceof InstanceNode && !InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)((InstanceNode)parent).getMode())) {
            Instance instance = ((InstanceNode)parent).getInstance();
            return instance != null && instance.getJavaClass().isArray();
        }
        return false;
    }

    @Override
    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        final Instance instance = HeapViewerNode.getValue(parent, DataType.INSTANCE, heap);
        if (instance == null) {
            return null;
        }
        if (instance instanceof PrimitiveArrayInstance) {
            final String type = instance.getJavaClass().getName().replace("[]", "");
            final List items = ((PrimitiveArrayInstance)instance).getValues();
            NodesComputer<Integer> computer = new NodesComputer<Integer>(items.size(), UIThresholds.MAX_ARRAY_ITEMS){

                @Override
                protected boolean sorts(DataType dataType) {
                    return DataType.COUNT != dataType && DataType.OWN_SIZE != dataType && DataType.RETAINED_SIZE != dataType;
                }

                @Override
                protected HeapViewerNode createNode(Integer index) {
                    return new PrimitiveNode.ArrayItem(index, type, (String)items.get(index), instance);
                }

                @Override
                protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                    Iterator<Integer> iterator = 1.integerIterator(index, items.size());
                    return new ProgressIterator<Integer>(iterator, index, false, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.JavaArrayItemsProvider_MoreNodes(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.JavaArrayItemsProvider_SamplesContainer(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.JavaArrayItemsProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
        }
        if (instance instanceof ObjectArrayInstance) {
            final List items = ((ObjectArrayInstance)instance).getItems();
            NodesComputer<Integer> computer = new NodesComputer<Integer>(items.size(), UIThresholds.MAX_ARRAY_ITEMS){

                @Override
                protected boolean sorts(DataType dataType) {
                    return !DataType.COUNT.equals(dataType);
                }

                @Override
                protected HeapViewerNode createNode(Integer index) {
                    return new InstanceReferenceNode.ArrayItem((ArrayItemValue)items.get(index), false);
                }

                @Override
                protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                    Iterator<Integer> iterator = 2.integerIterator(index, items.size());
                    return new ProgressIterator<Integer>(iterator, index, false, progress);
                }

                @Override
                protected String getMoreNodesString(String moreNodesCount) {
                    return Bundle.JavaArrayItemsProvider_MoreNodes(moreNodesCount);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return Bundle.JavaArrayItemsProvider_SamplesContainer(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return Bundle.JavaArrayItemsProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
                }
            };
            return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
        }
        return null;
    }
}

