/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.util.response;

import de.rub.nds.tlsattacker.attacks.util.response.ResponseFingerprint;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.transport.exception.InvalidTransportHandlerStateException;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpTransportHandler;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResponseExtractor {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ResponseFingerprint getFingerprint(State state, ReceivingAction action) {
        List<ProtocolMessage> messageList = action.getReceivedMessages();
        List<AbstractRecord> recordList = action.getReceivedRecords();
        SocketState socketState = ResponseExtractor.extractSocketState(state);
        return new ResponseFingerprint(messageList, recordList, socketState);
    }

    public static ResponseFingerprint getFingerprint(State state) {
        ReceivingAction action = state.getWorkflowTrace().getLastReceivingAction();
        return ResponseExtractor.getFingerprint(state, action);
    }

    private static SocketState extractSocketState(State state) {
        try {
            if (state.getTlsContext().getTransportHandler() instanceof ClientTcpTransportHandler) {
                SocketState socketState = ((ClientTcpTransportHandler)state.getTlsContext().getTransportHandler()).getSocketState();
                return socketState;
            }
            return null;
        }
        catch (InvalidTransportHandlerStateException ex) {
            LOGGER.warn((Object)ex);
            return SocketState.DATA_AVAILABLE;
        }
    }

    private static List<Class<AbstractRecord>> extractRecordClasses(ReceivingAction action) {
        LinkedList<Class<AbstractRecord>> classList = new LinkedList<Class<AbstractRecord>>();
        if (action.getReceivedRecords() != null) {
            for (AbstractRecord record : action.getReceivedRecords()) {
                classList.add(record.getClass());
            }
        }
        return classList;
    }

    private static List<Class<ProtocolMessage>> extractMessageClasses(ReceivingAction action) {
        LinkedList<Class<ProtocolMessage>> classList = new LinkedList<Class<ProtocolMessage>>();
        if (action.getReceivedMessages() != null) {
            for (ProtocolMessage message : action.getReceivedMessages()) {
                classList.add(message.getClass());
            }
        }
        return classList;
    }

    private static boolean didReceiveEncryptedAlert(ReceivingAction action) {
        if (action.getReceivedRecords() != null) {
            for (AbstractRecord abstractRecord : action.getReceivedRecords()) {
                Record record;
                if (!(abstractRecord instanceof Record) || (record = (Record)abstractRecord).getContentMessageType() != ProtocolMessageType.ALERT || (Integer)record.getLength().getValue() <= 6) continue;
                return true;
            }
        }
        return false;
    }

    private ResponseExtractor() {
    }
}

