/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class Colibri2Error
extends AbstractPacketExtension {
    public static final String ELEMENT = "error";
    public static final String NAMESPACE = "jitsi:colibri2";
    public static final QName QNAME = new QName("jitsi:colibri2", "error");
    public static final String REASON_ATTR_NAME = "reason";

    public Colibri2Error(Reason reason) {
        super(NAMESPACE, ELEMENT);
        this.setAttribute(REASON_ATTR_NAME, reason.toString().toLowerCase());
    }

    public Colibri2Error() {
        this(Reason.UNSPECIFIED);
    }

    @NotNull
    public Reason getReason() {
        return Reason.parseString(this.getAttributeAsString(REASON_ATTR_NAME));
    }

    public static enum Reason {
        CONFERENCE_NOT_FOUND,
        CONFERENCE_ALREADY_EXISTS,
        FEATURE_NOT_IMPLEMENTED,
        GRACEFUL_SHUTDOWN,
        UNKNOWN_ENDPOINT,
        UNSPECIFIED;


        @NotNull
        public static Reason parseString(String s2) throws IllegalArgumentException {
            if (s2 == null) {
                return UNSPECIFIED;
            }
            return Reason.valueOf(s2.toUpperCase());
        }
    }

    protected static class Provider
    extends DefaultPacketExtensionProvider<Colibri2Error> {
        public Provider() {
            super(Colibri2Error.class);
        }

        @Override
        public Colibri2Error parse(XmlPullParser parser2, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            Colibri2Error colibri2Error = (Colibri2Error)super.parse(parser2, depth, xmlEnvironment);
            try {
                Reason.parseString(colibri2Error.getAttributeAsString(Colibri2Error.REASON_ATTR_NAME));
            }
            catch (IllegalArgumentException e) {
                throw new SmackParsingException("Invalid value for the 'reason' attribute: " + colibri2Error.getAttributeAsString(Colibri2Error.REASON_ATTR_NAME));
            }
            return colibri2Error;
        }
    }
}

