/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.Location;
import com.sun.java.help.search.Query;
import java.io.PrintStream;

class RoleFiller {
    static int Threshold = 300;
    private ConceptData _conceptData;
    private byte _fixedRole;
    private short _filled;
    private int _begin;
    private int _end;
    private int _limit;
    private RoleFiller _next;
    private RoleFiller[] _fillers;
    public static final RoleFiller STOP = new RoleFiller();

    private RoleFiller() {
    }

    public RoleFiller(int n, ConceptData conceptData, int n2, int n3, int n4) {
        this._conceptData = conceptData;
        this._fixedRole = (byte)n2;
        this._filled = (short)(1 << this._fixedRole);
        this._begin = n3;
        this._end = this._begin + conceptData.getConceptLength();
        this._limit = n4;
        this._next = null;
        this._fillers = new RoleFiller[n];
        this._fillers[n2] = this;
    }

    public void print(PrintStream printStream) {
        printStream.println(this._begin + ", " + this._end);
    }

    void makeQueryHit(Query query, int n, int n2, double d) {
        if (query.goodEnough(d)) {
            int[] nArray = query.getConceptArrayOfNewHit(d, new Location(n2, this._begin, this._end));
            for (int i = 0; i < n; ++i) {
                nArray[i] = (this._filled & 1 << i) != 0 ? this._fillers[i].getConcept() : 0;
            }
        }
    }

    boolean isHit() {
        return this._filled > 1 << this._fixedRole;
    }

    double getScore() {
        return this._conceptData.getScore();
    }

    int getConcept() {
        return this._conceptData.getConcept();
    }

    RoleFiller next() {
        return this._next;
    }

    void use(RoleFiller[] roleFillerArray, int n) {
        if (roleFillerArray[n] != null) {
            RoleFiller roleFiller = roleFillerArray[n];
            roleFillerArray[n] = this;
            this._next = roleFiller;
            while (roleFiller._limit >= this._begin) {
                if (this._fixedRole != roleFiller._fixedRole) {
                    if ((roleFiller._filled & 1 << this._fixedRole) == 0) {
                        roleFiller._filled = (short)(roleFiller._filled | 1 << this._fixedRole);
                        roleFiller._fillers[this._fixedRole] = this;
                        roleFiller._end = this._end;
                    } else {
                        roleFiller.considerReplacementWith(this);
                    }
                }
                if (roleFiller._next != null) {
                    roleFiller = roleFiller._next;
                    continue;
                }
                return;
            }
        } else {
            roleFillerArray[n] = this;
        }
    }

    private void considerReplacementWith(RoleFiller roleFiller) {
        byte by = roleFiller._fixedRole;
        if (roleFiller.getScore() > this._fillers[by].getScore()) {
            this._fillers[by] = roleFiller;
        }
    }

    private double penalty(Query query, int n) {
        int n2 = this._end - this._begin + 1;
        double d = query.lookupPenalty(this._filled);
        for (int i = 0; i < n; ++i) {
            if ((this._filled & 1 << i) == 0) continue;
            d += this._fillers[i]._conceptData.getPenalty();
            n2 -= this._fillers[i]._conceptData.getConceptLength() + 1;
            if (this._filled >> i + 1 == 0) continue;
            for (int j = i + 1; j < n; ++j) {
                if ((this._filled & 1 << j) == 0 || this._fillers[j]._begin >= this._begin) continue;
                d += query.getOutOufOrderPenalty();
            }
        }
        return d + (double)n2 * query.getGapPenalty();
    }

    public void scoreList(Query query, int n) {
        int n2 = query.getNColumns();
        RoleFiller roleFiller = this;
        double d = roleFiller.penalty(query, n2);
        RoleFiller roleFiller2 = roleFiller._next;
        while (roleFiller2 != null) {
            if (roleFiller2._end < roleFiller._begin) {
                roleFiller.makeQueryHit(query, n2, n, d);
                roleFiller = roleFiller2;
                d = roleFiller.penalty(query, n2);
            } else {
                double d2 = roleFiller2.penalty(query, n2);
                if (d2 <= d) {
                    d = d2;
                    roleFiller = roleFiller2;
                }
            }
            roleFiller2 = roleFiller2._next;
        }
        roleFiller.makeQueryHit(query, n2, n, d);
    }
}

