'''OpenGL extension ARB.clip_control

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.clip_control to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides additional clip control modes to configure how
	clip space is mapped to window space.  This extension's goal is to 1)
	allow OpenGL to effectively match Direct3D's coordinate system
	conventions, and 2) potentially improve the numerical precision of the Z
	coordinate mapping.
	
	Developers interested in this functionality may be porting content
	from Direct3D to OpenGL and/or interested in improving the numerical
	accuracy of depth testing, particularly with floating-point depth
	buffers.
	
	OpenGL's initial and conventional clip control state is configured by:
	
	    glClipControl(GL_LOWER_LEFT, GL_NEGATIVE_ONE_TO_ONE);
	
	where geometry with (x,y) normalized device coordinates of (-1,-1)
	correspond to the lower-left corner of the viewport and the near and far
	planes correspond to z normalized device coordinates of -1 and +1,
	respectively.
	
	This extension can be used to render content used in a Direct3D
	application in OpenGL in a straightforward way without modifying vertex or
	matrix data.  When rendering into a window, the command
	
	    glClipControl(GL_LOWER_LEFT, GL_ZERO_TO_ONE);
	
	configures the near clip plane to correspond to a z normalized device
	coordinate of 0 as in Direct3D.  Geometry with (x,y) normalized device
	coordinates of (-1,-1) correspond to the lower-left corner of the viewport
	in Direct3D, so no change relative to OpenGL conventions is needed there.
	Other state related to screen-space coordinates may need to be modified
	for the application to map from Direct3D to OpenGL window coordinate
	conventions.  For example, the viewport rectangle in Direct3D needs to be
	inverted within the window to work properly in OpenGL windowed rendering:
	
	   glViewport(d3d_viewport_x,
	              window_height - (d3d_viewport_y + d3d_viewport_height),
	              d3d_viewport_width, d3d_viewport_height);
	
	When rendering Direct3D content into a framebuffer object in OpenGL, there
	is one complication -- how to get a correct image *out* of the related
	textures.  Direct3D applications would expect a texture coordinate of
	(0,0) to correspond to the upper-left corner of a rendered image, while
	OpenGL FBO conventions would map (0,0) to the lower-left corner of the
	rendered image.  For applications wishing to use Direct3D content with
	unmodified texture coordinates, the command
	
	    glClipControl(GL_UPPER_LEFT, GL_ZERO_TO_ONE);
	
	configures the OpenGL to invert geometry vertically inside the viewport.
	Content at the top of the viewport for Direct3D will be rendered to the
	bottom of the viewport from the point of view of OpenGL, but will have a
	<t> texture coordinate of zero in both cases.  When operating in this
	mode, applications need not invert the programmed viewport rectangle as
	recommended for windowed rendering above.
	
	Applications happy with OpenGL's origin conventions but seeking
	potentially improved depth precision can configure clip controls using:
	
	    glClipControl(GL_LOWER_LEFT, GL_ZERO_TO_ONE);
	
	to avoid the loss of precision from the DepthRange transformation
	(which by default is z_window = z_ndc * 0.5 + 0.5).

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/clip_control.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.clip_control import *
from OpenGL.raw.GL.ARB.clip_control import _EXTENSION_NAME

def glInitClipControlARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION