/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.locks;

import java.util.List;
import java.util.ResourceBundle;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.MonitorCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.MonitorInfo;
import org.graalvm.visualvm.lib.jfluid.results.locks.ThreadInfo;

class ThreadLockCCTNode
extends LockCCTNode {
    private static final String WAIT_MONITORS_LBL;
    private static final String WAIT_MONITORS_OWNER_LBL;
    private static final String OWNER_MONITORS_LBL;
    private static final String OWNER_MONITORS__WAIT_LBL;
    private final ThreadInfo ti;
    private final List<ThreadInfo.MonitorDetail> waitMonitors;
    private final List<ThreadInfo.MonitorDetail> ownerMonitors;
    private MonitorsCCTNode waitNode;
    private long allTime;
    private long allCount;

    ThreadLockCCTNode(LockCCTNode parent, ThreadInfo key, List<List<ThreadInfo.MonitorDetail>> value) {
        super(parent);
        assert (value.size() == 2);
        this.ti = key;
        this.waitMonitors = value.get(0);
        this.ownerMonitors = value.get(1);
    }

    @Override
    public String getNodeName() {
        return this.ti.getName();
    }

    @Override
    public long getTime() {
        if (this.allTime == 0L) {
            this.summarize();
        }
        return this.allTime;
    }

    @Override
    public long getWaits() {
        if (this.allCount == 0L) {
            this.summarize();
        }
        return this.allCount;
    }

    @Override
    public boolean isThreadLockNode() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadLockCCTNode) {
            return this.ti.equals(((ThreadLockCCTNode)obj).ti);
        }
        return false;
    }

    public int hashCode() {
        return this.ti.hashCode();
    }

    private void summarize() {
        this.getChildren();
        if (this.waitNode != null) {
            this.allTime = this.waitNode.getTime();
            this.allCount = this.waitNode.getWaits();
        }
    }

    @Override
    void computeChildren() {
        super.computeChildren();
        if (!this.waitMonitors.isEmpty()) {
            this.waitNode = new MonitorsCCTNode(this, WAIT_MONITORS_LBL, WAIT_MONITORS_OWNER_LBL, this.waitMonitors);
            this.addChild(this.waitNode);
        }
        if (!this.ownerMonitors.isEmpty()) {
            this.addChild(new MonitorsCCTNode(this, OWNER_MONITORS_LBL, OWNER_MONITORS__WAIT_LBL, this.ownerMonitors));
        }
    }

    static {
        ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.jfluid.results.locks.Bundle");
        WAIT_MONITORS_LBL = messages.getString("ThreadLockCCTNode_WaitMonitors");
        WAIT_MONITORS_OWNER_LBL = messages.getString("ThreadLockCCTNode_WaitMonitorsOwner");
        OWNER_MONITORS_LBL = messages.getString("ThreadLockCCTNode_OwnerMonitors");
        OWNER_MONITORS__WAIT_LBL = messages.getString("ThreadLockCCTNode_OwnerMonitorsWait");
    }

    static class MonitorDetailsCCTNode
    extends LockCCTNode {
        private final ThreadInfo.MonitorDetail monitorDetail;
        private final String threadNameFormat;

        private MonitorDetailsCCTNode(LockCCTNode p, String tnf, ThreadInfo.MonitorDetail md) {
            super(p);
            this.threadNameFormat = tnf;
            this.monitorDetail = md;
        }

        @Override
        public boolean isMonitorNode() {
            return true;
        }

        @Override
        public String getNodeName() {
            return this.monitorDetail.monitor.getName();
        }

        @Override
        public long getTime() {
            return this.monitorDetail.waitTime;
        }

        @Override
        public long getWaits() {
            return this.monitorDetail.count;
        }

        public int hashCode() {
            return this.monitorDetail.monitor.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MonitorDetailsCCTNode) {
                MonitorDetailsCCTNode mn = (MonitorDetailsCCTNode)obj;
                return this.monitorDetail.monitor.equals(mn.monitorDetail.monitor) && this.getParent().equals(mn.getParent());
            }
            return false;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (MonitorInfo.ThreadDetail td : this.monitorDetail.cloneThreadDetails()) {
                this.addChild(new MonitorCCTNode.ThreadDetailLockCCTNode(this, this.threadNameFormat, td));
            }
        }
    }

    static class MonitorsCCTNode
    extends LockCCTNode {
        private final List<ThreadInfo.MonitorDetail> monitors;
        private final String name;
        private final String threadNameFormat;
        private long allTime;
        private long allCount;

        MonitorsCCTNode(ThreadLockCCTNode p, String n, String tnf, List<ThreadInfo.MonitorDetail> ms) {
            super(p);
            this.name = n;
            this.threadNameFormat = tnf;
            this.monitors = ms;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public long getTime() {
            if (this.allTime == 0L) {
                this.summarize();
            }
            return this.allTime;
        }

        @Override
        public long getWaits() {
            if (this.allCount == 0L) {
                this.summarize();
            }
            return this.allCount;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MonitorsCCTNode) {
                MonitorsCCTNode mn = (MonitorsCCTNode)obj;
                return this.name.equals(mn.name) && this.getParent().equals(mn.getParent());
            }
            return false;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (ThreadInfo.MonitorDetail md : this.monitors) {
                this.addChild(new MonitorDetailsCCTNode(this, this.threadNameFormat, md));
            }
        }

        private void summarize() {
            for (ThreadInfo.MonitorDetail md : this.monitors) {
                this.allTime += md.waitTime;
                this.allCount += md.count;
            }
        }
    }
}

