/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.ApplicationFinder;
import org.graalvm.visualvm.sampler.SamplerSupport;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class SamplerArguments
extends OptionProcessor {
    private static final String START_CPU_LONG_NAME = "start-cpu-sampler";
    private static final Option START_CPU_ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"start-cpu-sampler"), (String)"org.graalvm.visualvm.sampler.Bundle", (String)"Argument_StartCpu_ShortDescr");
    private static final String START_MEMORY_LONG_NAME = "start-memory-sampler";
    private static final Option START_MEMORY_ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"start-memory-sampler"), (String)"org.graalvm.visualvm.sampler.Bundle", (String)"Argument_StartMemory_ShortDescr");
    private static final String SNAPSHOT_LONG_NAME = "snapshot-sampler";
    private static final Option SNAPSHOT_ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"snapshot-sampler"), (String)"org.graalvm.visualvm.sampler.Bundle", (String)"Argument_Snapshot_ShortDescr");
    private static final String STOP_LONG_NAME = "stop-sampler";
    private static final Option STOP_ARGUMENT = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"stop-sampler"), (String)"org.graalvm.visualvm.sampler.Bundle", (String)"Argument_Stop_ShortDescr");

    protected Set<Option> getOptions() {
        HashSet<Option> options = new HashSet<Option>();
        options.add(START_CPU_ARGUMENT);
        options.add(START_MEMORY_ARGUMENT);
        options.add(SNAPSHOT_ARGUMENT);
        options.add(STOP_ARGUMENT);
        return options;
    }

    protected void process(Env env, Map<Option, String[]> maps) throws CommandException {
        String[] startCPU = maps.get(START_CPU_ARGUMENT);
        if (startCPU != null) {
            String[] _startCPU;
            String[] stringArray = _startCPU = startCPU.length == 1 ? startCPU[0].split("@") : null;
            if (_startCPU != null && _startCPU.length == 2) {
                startCPU[0] = _startCPU[0];
            }
            new Finder(startCPU, START_CPU_LONG_NAME){

                public void found(Application application) {
                    String settings = _startCPU != null && _startCPU.length == 2 ? _startCPU[1] : null;
                    SamplerSupport.getInstance().startCPU(application, settings);
                }
            }.find();
            return;
        }
        String[] startMemory = maps.get(START_MEMORY_ARGUMENT);
        if (startMemory != null) {
            String[] _startMemory;
            String[] stringArray = _startMemory = startMemory.length == 1 ? startMemory[0].split("@") : null;
            if (_startMemory != null && _startMemory.length == 2) {
                startMemory[0] = _startMemory[0];
            }
            new Finder(startMemory, START_MEMORY_LONG_NAME){

                public void found(Application application) {
                    String settings = _startMemory != null && _startMemory.length == 2 ? _startMemory[1] : null;
                    SamplerSupport.getInstance().startMemory(application, settings);
                }
            }.find();
            return;
        }
        final String[] snapshot = maps.get(SNAPSHOT_ARGUMENT);
        final String[] stop = maps.get(STOP_ARGUMENT);
        if (snapshot != null) {
            new Finder(snapshot, SNAPSHOT_LONG_NAME){

                public void found(Application application) {
                    SamplerSupport.getInstance().takeSnapshot(application, true);
                    if (stop != null && stop.length == 1 && stop[0].equals(snapshot[0])) {
                        SamplerSupport.getInstance().stop(application);
                    }
                }
            }.find();
            return;
        }
        if (stop != null) {
            new Finder(stop, STOP_LONG_NAME){

                public void found(Application application) {
                    SamplerSupport.getInstance().stop(application);
                }
            }.find();
        }
    }

    private static abstract class Finder
    extends ApplicationFinder {
        Finder(String[] pids, String longName) throws CommandException {
            super(Finder.resolvePid(pids, longName));
        }

        public final void notFound(int pid, String id) {
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SamplerArguments.class, (String)"MSG_NO_APP_PID", (Object[])new Object[]{Integer.toString(pid)}), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
        }

        private static int resolvePid(String[] pids, String longName) throws CommandException {
            if (pids.length == 1) {
                try {
                    return Integer.valueOf(pids[0]);
                }
                catch (NumberFormatException e) {
                    throw new CommandException(0, "Incorrect pid format for --" + longName + ": " + e.getMessage());
                }
            }
            throw new CommandException(0, "--" + longName + " requires exactly one value");
        }
    }

    static enum Request {
        NONE,
        CPU,
        MEMORY;

    }
}

