/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.snapshot;

import java.awt.Image;
import java.io.File;
import javax.swing.JComponent;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotsSupport;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotNPS;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotNPSS;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotsSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class ProfilerSnapshot
extends Snapshot {
    static final Image CPU_ICON = Icons.getImage((String)"ProfilerIcons.Cpu");
    static final Image MEMORY_ICON = Icons.getImage((String)"ProfilerIcons.Memory");
    static final Image JDBC_ICON = Icons.getImage((String)"ProfilerIcons.SqlQuery");
    static final Image SNAPSHOT_ICON = Icons.getImage((String)"ProfilerIcons.SnapshotDO");
    static final Image NODE_BADGE = ImageUtilities.loadImage((String)"org/graalvm/visualvm/core/ui/resources/snapshotBadge.png", (boolean)true);

    public static ProfilerSnapshot createSnapshot(File file, DataSource master) {
        if (file.getName().endsWith("npss")) {
            return new ProfilerSnapshotNPSS(file, master);
        }
        return new ProfilerSnapshotNPS(file, master);
    }

    public ProfilerSnapshot() {
        super(null, ProfilerSnapshotsSupport.getInstance().getCategory());
    }

    public ProfilerSnapshot(File file, DataSource master) {
        super(file, ProfilerSnapshotsSupport.getInstance().getCategory(), master);
    }

    public boolean supportsSaveAs() {
        return this.getFile() != null;
    }

    protected void remove() {
        super.remove();
    }

    public void saveAs() {
        SnapshotsSupport.getInstance().saveAs((Snapshot)this, NbBundle.getMessage(ProfilerSnapshot.class, (String)"MSG_Save_Profiler_Snapshot_As"));
    }

    public abstract LoadedSnapshot getLoadedSnapshot();

    abstract Image resolveIcon();

    abstract JComponent getUIComponent();

    abstract void closeComponent();

    void forceViewClosable(boolean closable) {
        this.getStorage().setCustomProperty("prop_view_closable", Boolean.toString(closable));
    }
}

