/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import java.util.Iterator;
import org.graalvm.visualvm.heapviewer.java.Bundle;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstancesWrapper;
import org.graalvm.visualvm.heapviewer.model.ContainerNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public final class InstancesContainer {
    private InstancesContainer() {
    }

    private static String getMoreNodesString(String moreNodesCount) {
        return Bundle.InstancesContainer_MoreNodes(moreNodesCount);
    }

    private static String getSamplesContainerString(String objectsCount) {
        return Bundle.InstancesContainer_SamplesContainer(objectsCount);
    }

    private static String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
        return Bundle.InstancesContainer_NodesContainer(firstNodeIdx, lastNodeIdx);
    }

    public static class Nodes
    extends ContainerNode.Nodes<InstanceNode> {
        private final JavaClass javaClass;

        public Nodes(String name, JavaClass javaClass) {
            this(name, javaClass, UIThresholds.MAX_CONTAINER_INSTANCES);
        }

        public Nodes(String name, JavaClass javaClass, int maxItems) {
            super(name, maxItems);
            this.javaClass = javaClass;
        }

        @Override
        protected String getMoreNodesString(String moreNodesCount) {
            return InstancesContainer.getMoreNodesString(moreNodesCount);
        }

        @Override
        protected String getSamplesContainerString(String objectsCount) {
            return InstancesContainer.getSamplesContainerString(objectsCount);
        }

        @Override
        protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return InstancesContainer.getNodesContainerString(firstNodeIdx, lastNodeIdx);
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.CLASS) {
                return this.javaClass;
            }
            return super.getValue(type, heap);
        }
    }

    public static class Objects
    extends ContainerNode<Instance> {
        private final JavaClass javaClass;

        public Objects(String name, JavaClass javaClass) {
            this(name, javaClass, UIThresholds.MAX_CONTAINER_INSTANCES);
        }

        public Objects(String name, JavaClass javaClass, int maxItems) {
            super(name, maxItems);
            this.javaClass = javaClass;
        }

        public JavaClass getJavaClass() {
            return this.javaClass;
        }

        public Iterator<Instance> getInstancesIterator() {
            return this.getItems().iterator();
        }

        @Override
        protected int getCount(Instance item, Heap heap) {
            return 1;
        }

        @Override
        protected long getOwnSize(Instance item, Heap heap) {
            return item.getSize();
        }

        @Override
        protected long getRetainedSize(Instance item, Heap heap) {
            return DataType.RETAINED_SIZE.valuesAvailable(heap) ? item.getRetainedSize() : DataType.RETAINED_SIZE.getNotAvailableValue().longValue();
        }

        protected InstanceNode createNode(Instance instance) {
            return new InstanceNode(instance);
        }

        @Override
        protected String getMoreNodesString(String moreNodesCount) {
            return InstancesContainer.getMoreNodesString(moreNodesCount);
        }

        @Override
        protected String getSamplesContainerString(String objectsCount) {
            return InstancesContainer.getSamplesContainerString(objectsCount);
        }

        @Override
        protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return InstancesContainer.getNodesContainerString(firstNodeIdx, lastNodeIdx);
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.CLASS) {
                return this.getJavaClass();
            }
            if (type == DataType.INSTANCES_WRAPPER) {
                return new InstancesWrapper.Simple(this.getJavaClass(), this.getCount()){

                    @Override
                    public Iterator<Instance> getInstancesIterator() {
                        return this.getInstancesIterator();
                    }
                };
            }
            return super.getValue(type, heap);
        }
    }
}

