# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class TasksService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """TasksService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_tasks_id(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a task.

        Deletes a task and associated records.  Use this endpoint to delete a task and all associated records (task runs, logs, and labels). Once the task is deleted, InfluxDB cancels all scheduled runs of the task.  If you want to disable a task instead of delete it, [update the task status to `inactive`](#operation/PatchTasksID).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tasks_id_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tasks_id_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def delete_tasks_id_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a task.

        Deletes a task and associated records.  Use this endpoint to delete a task and all associated records (task runs, logs, and labels). Once the task is deleted, InfluxDB cancels all scheduled runs of the task.  If you want to disable a task instead of delete it, [update the task status to `inactive`](#operation/PatchTasksID).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_tasks_id_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a task.

        Deletes a task and associated records.  Use this endpoint to delete a task and all associated records (task runs, logs, and labels). Once the task is deleted, InfluxDB cancels all scheduled runs of the task.  If you want to disable a task instead of delete it, [update the task status to `inactive`](#operation/PatchTasksID).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_tasks_id_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_tasks_id', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete_tasks_id`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_tasks_id_labels_id(self, task_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a task.

        Deletes a label from a task.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_labels_id(task_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to delete the label from. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tasks_id_labels_id_with_http_info(task_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tasks_id_labels_id_with_http_info(task_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_tasks_id_labels_id_with_http_info(self, task_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a task.

        Deletes a label from a task.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_labels_id_with_http_info(task_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to delete the label from. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_labels_id_prepare(task_id, label_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_tasks_id_labels_id_async(self, task_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a task.

        Deletes a label from a task.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to delete the label from. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_labels_id_prepare(task_id, label_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_tasks_id_labels_id_prepare(self, task_id, label_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'label_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_tasks_id_labels_id', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete_tasks_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_tasks_id_labels_id`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_tasks_id_members_id(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Removes a member from a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_members_id(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tasks_id_members_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tasks_id_members_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
            return data

    def delete_tasks_id_members_id_with_http_info(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Removes a member from a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_members_id_with_http_info(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_members_id_prepare(user_id, task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_tasks_id_members_id_async(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Removes a member from a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the member to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_members_id_prepare(user_id, task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_tasks_id_members_id_prepare(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_tasks_id_members_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_tasks_id_members_id`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete_tasks_id_members_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_tasks_id_owners_id(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_owners_id(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tasks_id_owners_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tasks_id_owners_id_with_http_info(user_id, task_id, **kwargs)  # noqa: E501
            return data

    def delete_tasks_id_owners_id_with_http_info(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_owners_id_with_http_info(user_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_owners_id_prepare(user_id, task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_tasks_id_owners_id_async(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the owner to remove. (required)
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_owners_id_prepare(user_id, task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_tasks_id_owners_id_prepare(self, user_id, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_tasks_id_owners_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_tasks_id_owners_id`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete_tasks_id_owners_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_tasks_id_runs_id(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Cancel a running task.

        Cancels a running [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  Use this endpoint with InfluxDB OSS to cancel a running task.  #### InfluxDB Cloud  - Doesn't support this operation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_runs_id(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to cancel. (required)
        :param str run_id: The ID of the task run to cancel. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tasks_id_runs_id_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tasks_id_runs_id_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
            return data

    def delete_tasks_id_runs_id_with_http_info(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Cancel a running task.

        Cancels a running [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  Use this endpoint with InfluxDB OSS to cancel a running task.  #### InfluxDB Cloud  - Doesn't support this operation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tasks_id_runs_id_with_http_info(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to cancel. (required)
        :param str run_id: The ID of the task run to cancel. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_runs_id_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_tasks_id_runs_id_async(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Cancel a running task.

        Cancels a running [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  Use this endpoint with InfluxDB OSS to cancel a running task.  #### InfluxDB Cloud  - Doesn't support this operation.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to cancel. (required)
        :param str run_id: The ID of the task run to cancel. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_tasks_id_runs_id_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_tasks_id_runs_id_prepare(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'run_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_tasks_id_runs_id', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `delete_tasks_id_runs_id`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if ('run_id' not in local_var_params or
                local_var_params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `delete_tasks_id_runs_id`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501
        if 'run_id' in local_var_params:
            path_params['runID'] = local_var_params['run_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks(self, **kwargs):  # noqa: E501,D401,D403
        """List tasks.

        Retrieves a list of [tasks](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  To limit which tasks are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all tasks up to the default `limit`.  #### Related guide  - [Process data with InfluxDB tasks](https://docs.influxdata.com/influxdb/latest/process-data/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) name. Only returns tasks with the specified name. Different tasks may have the same name.
        :param str after: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) ID. Only returns tasks created after the specified task.
        :param str user: A [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) ID. Only returns tasks owned by the specified user.
        :param str org: An [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) name. Only returns tasks owned by the specified organization.
        :param str org_id: An [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) ID. Only returns tasks owned by the specified organization.
        :param str status: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) status. Only returns tasks that have the specified status (`active` or `inactive`).
        :param int limit: The maximum number of [tasks](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) to return. Default is `100`. The minimum is `1` and the maximum is `500`.  To reduce the payload size, combine _`type=basic`_ and _`limit`_ (see _Request samples_). For more information about the `basic` response, see the _`type`_ parameter.
        :param str type: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) type (`basic` or `system`). Default is `system`. Specifies the level of detail for tasks in the response. The default (`system`) response contains all the metadata properties for tasks. To reduce the response size, pass `basic` to omit some task properties (`flux`, `createdAt`, `updatedAt`).
        :return: Tasks
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tasks_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List tasks.

        Retrieves a list of [tasks](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  To limit which tasks are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all tasks up to the default `limit`.  #### Related guide  - [Process data with InfluxDB tasks](https://docs.influxdata.com/influxdb/latest/process-data/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) name. Only returns tasks with the specified name. Different tasks may have the same name.
        :param str after: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) ID. Only returns tasks created after the specified task.
        :param str user: A [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) ID. Only returns tasks owned by the specified user.
        :param str org: An [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) name. Only returns tasks owned by the specified organization.
        :param str org_id: An [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) ID. Only returns tasks owned by the specified organization.
        :param str status: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) status. Only returns tasks that have the specified status (`active` or `inactive`).
        :param int limit: The maximum number of [tasks](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) to return. Default is `100`. The minimum is `1` and the maximum is `500`.  To reduce the payload size, combine _`type=basic`_ and _`limit`_ (see _Request samples_). For more information about the `basic` response, see the _`type`_ parameter.
        :param str type: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) type (`basic` or `system`). Default is `system`. Specifies the level of detail for tasks in the response. The default (`system`) response contains all the metadata properties for tasks. To reduce the response size, pass `basic` to omit some task properties (`flux`, `createdAt`, `updatedAt`).
        :return: Tasks
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Tasks',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_async(self, **kwargs):  # noqa: E501,D401,D403
        """List tasks.

        Retrieves a list of [tasks](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  To limit which tasks are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all tasks up to the default `limit`.  #### Related guide  - [Process data with InfluxDB tasks](https://docs.influxdata.com/influxdb/latest/process-data/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) name. Only returns tasks with the specified name. Different tasks may have the same name.
        :param str after: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) ID. Only returns tasks created after the specified task.
        :param str user: A [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) ID. Only returns tasks owned by the specified user.
        :param str org: An [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) name. Only returns tasks owned by the specified organization.
        :param str org_id: An [organization](https://docs.influxdata.com/influxdb/latest/reference/glossary/#organization) ID. Only returns tasks owned by the specified organization.
        :param str status: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) status. Only returns tasks that have the specified status (`active` or `inactive`).
        :param int limit: The maximum number of [tasks](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) to return. Default is `100`. The minimum is `1` and the maximum is `500`.  To reduce the payload size, combine _`type=basic`_ and _`limit`_ (see _Request samples_). For more information about the `basic` response, see the _`type`_ parameter.
        :param str type: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) type (`basic` or `system`). Default is `system`. Specifies the level of detail for tasks in the response. The default (`system`) response contains all the metadata properties for tasks. To reduce the response size, pass `basic` to omit some task properties (`flux`, `createdAt`, `updatedAt`).
        :return: Tasks
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Tasks',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'name', 'after', 'user', 'org', 'org_id', 'status', 'limit', 'type']  # noqa: E501
        self._check_operation_params('get_tasks', all_params, local_var_params)

        if 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_tasks`, must be a value less than or equal to `500`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_tasks`, must be a value greater than or equal to `1`")  # noqa: E501
        path_params = {}

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'after' in local_var_params:
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'user' in local_var_params:
            query_params.append(('user', local_var_params['user']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'status' in local_var_params:
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a task.

        Retrieves a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a task.

        Retrieves a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Task',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a task.

        Retrieves a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Task',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_tasks_id', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id_labels(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List labels for a task.

        Retrieves a list of all labels for a task.  Labels may be used for grouping and filtering tasks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_labels(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve labels for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_labels_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_labels_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_labels_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List labels for a task.

        Retrieves a list of all labels for a task.  Labels may be used for grouping and filtering tasks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_labels_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve labels for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_labels_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_labels_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List labels for a task.

        Retrieves a list of all labels for a task.  Labels may be used for grouping and filtering tasks.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to retrieve labels for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_labels_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_labels_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_tasks_id_labels', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_labels`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id_logs(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve all logs for a task.

        Retrieves a list of all logs for a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  When an InfluxDB task runs, a “run” record is created in the task’s history. Logs associated with each run provide relevant log messages, timestamps, and the exit status of the run attempt.  Use this endpoint to retrieve only the log events for a task, without additional task metadata.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_logs(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Logs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_logs_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_logs_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_logs_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve all logs for a task.

        Retrieves a list of all logs for a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  When an InfluxDB task runs, a “run” record is created in the task’s history. Logs associated with each run provide relevant log messages, timestamps, and the exit status of the run attempt.  Use this endpoint to retrieve only the log events for a task, without additional task metadata.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_logs_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Logs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_logs_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Logs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_logs_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve all logs for a task.

        Retrieves a list of all logs for a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  When an InfluxDB task runs, a “run” record is created in the task’s history. Logs associated with each run provide relevant log messages, timestamps, and the exit status of the run attempt.  Use this endpoint to retrieve only the log events for a task, without additional task metadata.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Logs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_logs_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Logs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_logs_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_tasks_id_logs', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_logs`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id_members(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all task members.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Lists all users that have the `member` role for the specified [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_members(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_members_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_members_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_members_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all task members.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Lists all users that have the `member` role for the specified [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_members_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_members_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_members_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all task members.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Lists all users that have the `member` role for the specified [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_members_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_members_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_tasks_id_members', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_members`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id_owners(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Retrieves all users that have owner permission for a task.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_owners(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_owners_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_owners_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_owners_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Retrieves all users that have owner permission for a task.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_owners_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_owners_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_owners_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Retrieves all users that have owner permission for a task.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to retrieve owners for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_owners_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_owners_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_tasks_id_owners', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_owners`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id_runs(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List runs for a task.

        Retrieves a list of runs for a [task](https://docs.influxdata.com/influxdb/latest/process-data/).  To limit which task runs are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all task runs up to the default `limit`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_runs(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to get runs for. Only returns runs for this task. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str after: A task run ID. Only returns runs created after this run.
        :param int limit: Limits the number of task runs returned. Default is `100`.
        :param datetime after_time: A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/latest/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled after this time.
        :param datetime before_time: A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/latest/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled before this time.
        :return: Runs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_runs_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_runs_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_runs_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List runs for a task.

        Retrieves a list of runs for a [task](https://docs.influxdata.com/influxdb/latest/process-data/).  To limit which task runs are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all task runs up to the default `limit`.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_runs_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to get runs for. Only returns runs for this task. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str after: A task run ID. Only returns runs created after this run.
        :param int limit: Limits the number of task runs returned. Default is `100`.
        :param datetime after_time: A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/latest/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled after this time.
        :param datetime before_time: A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/latest/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled before this time.
        :return: Runs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_runs_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Runs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_runs_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """List runs for a task.

        Retrieves a list of runs for a [task](https://docs.influxdata.com/influxdb/latest/process-data/).  To limit which task runs are returned, pass query parameters in your request. If no query parameters are passed, InfluxDB returns all task runs up to the default `limit`.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to get runs for. Only returns runs for this task. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str after: A task run ID. Only returns runs created after this run.
        :param int limit: Limits the number of task runs returned. Default is `100`.
        :param datetime after_time: A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/latest/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled after this time.
        :param datetime before_time: A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/latest/reference/glossary/#rfc3339-timestamp)). Only returns runs scheduled before this time.
        :return: Runs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_runs_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Runs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_runs_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span', 'after', 'limit', 'after_time', 'before_time']  # noqa: E501
        self._check_operation_params('get_tasks_id_runs', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_runs`")  # noqa: E501

        if 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_tasks_id_runs`, must be a value less than or equal to `500`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_tasks_id_runs`, must be a value greater than or equal to `1`")  # noqa: E501
        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []
        if 'after' in local_var_params:
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'after_time' in local_var_params:
            query_params.append(('afterTime', local_var_params['after_time']))  # noqa: E501
        if 'before_time' in local_var_params:
            query_params.append(('beforeTime', local_var_params['before_time']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id_runs_id(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a run for a task..

        Retrieves a specific run for a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  Use this endpoint to retrieve detail and logs for a specific task run.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_runs_id(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve runs for. (required)
        :param str run_id: The ID of the run to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_runs_id_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_runs_id_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_runs_id_with_http_info(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a run for a task..

        Retrieves a specific run for a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  Use this endpoint to retrieve detail and logs for a specific task run.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_runs_id_with_http_info(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to retrieve runs for. (required)
        :param str run_id: The ID of the run to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_runs_id_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Run',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_runs_id_async(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a run for a task..

        Retrieves a specific run for a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task).  Use this endpoint to retrieve detail and logs for a specific task run.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to retrieve runs for. (required)
        :param str run_id: The ID of the run to retrieve. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_runs_id_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Run',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_runs_id_prepare(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'run_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_tasks_id_runs_id', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_runs_id`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if ('run_id' not in local_var_params or
                local_var_params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `get_tasks_id_runs_id`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501
        if 'run_id' in local_var_params:
            path_params['runID'] = local_var_params['run_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_tasks_id_runs_id_logs(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve all logs for a run.

        Retrieves all logs for a task run. A log is a list of run events with `runID`, `time`, and `message` properties.  Use this endpoint to help analyze task performance and troubleshoot failed task runs.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_runs_id_logs(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to get logs for. (required)
        :param str run_id: The ID of the run to get logs for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Logs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tasks_id_runs_id_logs_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tasks_id_runs_id_logs_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
            return data

    def get_tasks_id_runs_id_logs_with_http_info(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve all logs for a run.

        Retrieves all logs for a task run. A log is a list of run events with `runID`, `time`, and `message` properties.  Use this endpoint to help analyze task performance and troubleshoot failed task runs.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_id_runs_id_logs_with_http_info(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to get logs for. (required)
        :param str run_id: The ID of the run to get logs for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Logs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_runs_id_logs_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Logs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_tasks_id_runs_id_logs_async(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve all logs for a run.

        Retrieves all logs for a task run. A log is a list of run events with `runID`, `time`, and `message` properties.  Use this endpoint to help analyze task performance and troubleshoot failed task runs.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to get logs for. (required)
        :param str run_id: The ID of the run to get logs for. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Logs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_tasks_id_runs_id_logs_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Logs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_tasks_id_runs_id_logs_prepare(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'run_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_tasks_id_runs_id_logs', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_tasks_id_runs_id_logs`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if ('run_id' not in local_var_params or
                local_var_params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `get_tasks_id_runs_id_logs`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501
        if 'run_id' in local_var_params:
            path_params['runID'] = local_var_params['run_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_tasks_id(self, task_id, task_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a task.

        Updates a task and then cancels all scheduled runs of the task.  Use this endpoint to set, modify, and clear task properties (for example: `cron`, `name`, `flux`, `status`). Once InfluxDB applies the update, it cancels all previously scheduled runs of the task.  To update a task, pass an object that contains the updated key-value pairs. To activate or inactivate a task, set the `status` property. _`"status": "inactive"`_ cancels scheduled runs and prevents manual runs of the task.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_tasks_id(task_id, task_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to update. (required)
        :param TaskUpdateRequest task_update_request: An object that contains updated task properties to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_tasks_id_with_http_info(task_id, task_update_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_tasks_id_with_http_info(task_id, task_update_request, **kwargs)  # noqa: E501
            return data

    def patch_tasks_id_with_http_info(self, task_id, task_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a task.

        Updates a task and then cancels all scheduled runs of the task.  Use this endpoint to set, modify, and clear task properties (for example: `cron`, `name`, `flux`, `status`). Once InfluxDB applies the update, it cancels all previously scheduled runs of the task.  To update a task, pass an object that contains the updated key-value pairs. To activate or inactivate a task, set the `status` property. _`"status": "inactive"`_ cancels scheduled runs and prevents manual runs of the task.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_tasks_id_with_http_info(task_id, task_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to update. (required)
        :param TaskUpdateRequest task_update_request: An object that contains updated task properties to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_tasks_id_prepare(task_id, task_update_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Task',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_tasks_id_async(self, task_id, task_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a task.

        Updates a task and then cancels all scheduled runs of the task.  Use this endpoint to set, modify, and clear task properties (for example: `cron`, `name`, `flux`, `status`). Once InfluxDB applies the update, it cancels all previously scheduled runs of the task.  To update a task, pass an object that contains the updated key-value pairs. To activate or inactivate a task, set the `status` property. _`"status": "inactive"`_ cancels scheduled runs and prevents manual runs of the task.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to update. (required)
        :param TaskUpdateRequest task_update_request: An object that contains updated task properties to apply. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_tasks_id_prepare(task_id, task_update_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Task',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_tasks_id_prepare(self, task_id, task_update_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'task_update_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_tasks_id', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `patch_tasks_id`")  # noqa: E501
        # verify the required parameter 'task_update_request' is set
        if ('task_update_request' not in local_var_params or
                local_var_params['task_update_request'] is None):
            raise ValueError("Missing the required parameter `task_update_request` when calling `patch_tasks_id`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'task_update_request' in local_var_params:
            body_params = local_var_params['task_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_tasks(self, task_create_request, **kwargs):  # noqa: E501,D401,D403
        """Create a task.

        Creates a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  and returns the task.  #### Related guides  - [Get started with tasks](https://docs.influxdata.com/influxdb/latest/process-data/get-started/) - [Create a task](https://docs.influxdata.com/influxdb/latest/process-data/manage-tasks/create-task/) - [Common tasks](https://docs.influxdata.com/influxdb/latest/process-data/common-tasks/) - [Task configuration options](https://docs.influxdata.com/influxdb/latest/process-data/task-options/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks(task_create_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaskCreateRequest task_create_request: The task to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_with_http_info(task_create_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_with_http_info(task_create_request, **kwargs)  # noqa: E501
            return data

    def post_tasks_with_http_info(self, task_create_request, **kwargs):  # noqa: E501,D401,D403
        """Create a task.

        Creates a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  and returns the task.  #### Related guides  - [Get started with tasks](https://docs.influxdata.com/influxdb/latest/process-data/get-started/) - [Create a task](https://docs.influxdata.com/influxdb/latest/process-data/manage-tasks/create-task/) - [Common tasks](https://docs.influxdata.com/influxdb/latest/process-data/common-tasks/) - [Task configuration options](https://docs.influxdata.com/influxdb/latest/process-data/task-options/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_with_http_info(task_create_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaskCreateRequest task_create_request: The task to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_prepare(task_create_request, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Task',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_tasks_async(self, task_create_request, **kwargs):  # noqa: E501,D401,D403
        """Create a task.

        Creates a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  and returns the task.  #### Related guides  - [Get started with tasks](https://docs.influxdata.com/influxdb/latest/process-data/get-started/) - [Create a task](https://docs.influxdata.com/influxdb/latest/process-data/manage-tasks/create-task/) - [Common tasks](https://docs.influxdata.com/influxdb/latest/process-data/common-tasks/) - [Task configuration options](https://docs.influxdata.com/influxdb/latest/process-data/task-options/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param TaskCreateRequest task_create_request: The task to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_prepare(task_create_request, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Task',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_tasks_prepare(self, task_create_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_create_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_tasks', all_params, local_var_params)
        # verify the required parameter 'task_create_request' is set
        if ('task_create_request' not in local_var_params or
                local_var_params['task_create_request'] is None):
            raise ValueError("Missing the required parameter `task_create_request` when calling `post_tasks`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'task_create_request' in local_var_params:
            body_params = local_var_params['task_create_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_tasks_id_labels(self, task_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a task.

        Adds a label to a task.  Use this endpoint to add a label that you can use to filter tasks in the InfluxDB UI.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_labels(task_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to label. (required)
        :param LabelMapping label_mapping: An object that contains a _`labelID`_ to add to the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_id_labels_with_http_info(task_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_id_labels_with_http_info(task_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_tasks_id_labels_with_http_info(self, task_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a task.

        Adds a label to a task.  Use this endpoint to add a label that you can use to filter tasks in the InfluxDB UI.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_labels_with_http_info(task_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The ID of the task to label. (required)
        :param LabelMapping label_mapping: An object that contains a _`labelID`_ to add to the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_labels_prepare(task_id, label_mapping, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_tasks_id_labels_async(self, task_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a task.

        Adds a label to a task.  Use this endpoint to add a label that you can use to filter tasks in the InfluxDB UI.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The ID of the task to label. (required)
        :param LabelMapping label_mapping: An object that contains a _`labelID`_ to add to the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_labels_prepare(task_id, label_mapping, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_tasks_id_labels_prepare(self, task_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_tasks_id_labels', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `post_tasks_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_tasks_id_labels`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_tasks_id_members(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Adds a user to members of a task and returns the member.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_members(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as a member of the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_id_members_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_id_members_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_tasks_id_members_with_http_info(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Adds a user to members of a task and returns the member.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_members_with_http_info(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as a member of the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_members_prepare(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_tasks_id_members_async(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Adds a user to members of a task and returns the member.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as a member of the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_members_prepare(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_tasks_id_members_prepare(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_tasks_id_members', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `post_tasks_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_tasks_id_members`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_tasks_id_owners(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner for a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Assigns a task `owner` role to a user.  Use this endpoint to create a _resource owner_ for the task. A _resource owner_ is a user with `role: owner` for a specific resource.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_owners(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as an owner of the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_id_owners_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_id_owners_with_http_info(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_tasks_id_owners_with_http_info(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner for a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Assigns a task `owner` role to a user.  Use this endpoint to create a _resource owner_ for the task. A _resource owner_ is a user with `role: owner` for a specific resource.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_owners_with_http_info(task_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as an owner of the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_owners_prepare(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_tasks_id_owners_async(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner for a task.

        **Deprecated**: Tasks don't use `owner` and `member` roles. Use [`/api/v2/authorizations`](#tag/Authorizations-(API-tokens)) to assign user permissions.  Assigns a task `owner` role to a user.  Use this endpoint to create a _resource owner_ for the task. A _resource owner_ is a user with `role: owner` for a specific resource.
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: The task ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: A user to add as an owner of the task. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_owners_prepare(task_id, add_resource_member_request_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_tasks_id_owners_prepare(self, task_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_tasks_id_owners', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `post_tasks_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_tasks_id_owners`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_tasks_id_runs(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Start a task run, overriding the schedule.

        Schedules a task run to start immediately, ignoring scheduled runs.  Use this endpoint to manually start a task run. Scheduled runs will continue to run as scheduled. This may result in concurrently running tasks.  To _retry_ a previous run (and avoid creating a new run), use the [`POST /api/v2/tasks/{taskID}/runs/{runID}/retry` endpoint](#operation/PostTasksIDRunsIDRetry).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_runs(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :param RunManually run_manually:
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_id_runs_with_http_info(task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_id_runs_with_http_info(task_id, **kwargs)  # noqa: E501
            return data

    def post_tasks_id_runs_with_http_info(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Start a task run, overriding the schedule.

        Schedules a task run to start immediately, ignoring scheduled runs.  Use this endpoint to manually start a task run. Scheduled runs will continue to run as scheduled. This may result in concurrently running tasks.  To _retry_ a previous run (and avoid creating a new run), use the [`POST /api/v2/tasks/{taskID}/runs/{runID}/retry` endpoint](#operation/PostTasksIDRunsIDRetry).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_runs_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :param RunManually run_manually:
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_runs_prepare(task_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Run',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_tasks_id_runs_async(self, task_id, **kwargs):  # noqa: E501,D401,D403
        """Start a task run, overriding the schedule.

        Schedules a task run to start immediately, ignoring scheduled runs.  Use this endpoint to manually start a task run. Scheduled runs will continue to run as scheduled. This may result in concurrently running tasks.  To _retry_ a previous run (and avoid creating a new run), use the [`POST /api/v2/tasks/{taskID}/runs/{runID}/retry` endpoint](#operation/PostTasksIDRunsIDRetry).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :param RunManually run_manually:
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_runs_prepare(task_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Run',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_tasks_id_runs_prepare(self, task_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'zap_trace_span', 'run_manually']  # noqa: E501
        self._check_operation_params('post_tasks_id_runs', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `post_tasks_id_runs`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'run_manually' in local_var_params:
            body_params = local_var_params['run_manually']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_tasks_id_runs_id_retry(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retry a task run.

        Queues a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  run to retry and returns the scheduled run.  To manually start a _new_ task run, use the [`POST /api/v2/tasks/{taskID}/runs` endpoint](#operation/PostTasksIDRuns).  #### Limitations  - The task must be _active_ (`status: "active"`).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_runs_id_retry(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  ID. Specifies the task to retry. (required)
        :param str run_id: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) run ID. Specifies the task run to retry.  To find a task run ID, use the [`GET /api/v2/tasks/{taskID}/runs` endpoint](#operation/GetTasksIDRuns) to list task runs. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str body:
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_tasks_id_runs_id_retry_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_tasks_id_runs_id_retry_with_http_info(task_id, run_id, **kwargs)  # noqa: E501
            return data

    def post_tasks_id_runs_id_retry_with_http_info(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retry a task run.

        Queues a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  run to retry and returns the scheduled run.  To manually start a _new_ task run, use the [`POST /api/v2/tasks/{taskID}/runs` endpoint](#operation/PostTasksIDRuns).  #### Limitations  - The task must be _active_ (`status: "active"`).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_tasks_id_runs_id_retry_with_http_info(task_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_id: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  ID. Specifies the task to retry. (required)
        :param str run_id: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) run ID. Specifies the task run to retry.  To find a task run ID, use the [`GET /api/v2/tasks/{taskID}/runs` endpoint](#operation/GetTasksIDRuns) to list task runs. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str body:
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_runs_id_retry_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}/retry', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Run',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_tasks_id_runs_id_retry_async(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        """Retry a task run.

        Queues a [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  run to retry and returns the scheduled run.  To manually start a _new_ task run, use the [`POST /api/v2/tasks/{taskID}/runs` endpoint](#operation/PostTasksIDRuns).  #### Limitations  - The task must be _active_ (`status: "active"`).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str task_id: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task)  ID. Specifies the task to retry. (required)
        :param str run_id: A [task](https://docs.influxdata.com/influxdb/latest/reference/glossary/#task) run ID. Specifies the task run to retry.  To find a task run ID, use the [`GET /api/v2/tasks/{taskID}/runs` endpoint](#operation/GetTasksIDRuns) to list task runs. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str body:
        :return: Run
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_tasks_id_runs_id_retry_prepare(task_id, run_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/tasks/{taskID}/runs/{runID}/retry', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Run',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_tasks_id_runs_id_retry_prepare(self, task_id, run_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['task_id', 'run_id', 'zap_trace_span', 'body']  # noqa: E501
        self._check_operation_params('post_tasks_id_runs_id_retry', all_params, local_var_params)
        # verify the required parameter 'task_id' is set
        if ('task_id' not in local_var_params or
                local_var_params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `post_tasks_id_runs_id_retry`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if ('run_id' not in local_var_params or
                local_var_params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `post_tasks_id_runs_id_retry`")  # noqa: E501

        path_params = {}
        if 'task_id' in local_var_params:
            path_params['taskID'] = local_var_params['task_id']  # noqa: E501
        if 'run_id' in local_var_params:
            path_params['runID'] = local_var_params['run_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=utf-8'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
