/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (false ? uvec3(36u, 32u, 88u) : uvec3(36u, 32u, 88u)) => uvec3(36u, 32u, 88u)
 * (false ? uvec3(36u, 32u, 88u) : uvec3(59u, 77u, 68u)) => uvec3(59u, 77u, 68u)
 * (false ? uvec3(59u, 77u, 68u) : uvec3(36u, 32u, 88u)) => uvec3(36u, 32u, 88u)
 * (false ? uvec3(59u, 77u, 68u) : uvec3(59u, 77u, 68u)) => uvec3(59u, 77u, 68u)
 * (true ? uvec3(36u, 32u, 88u) : uvec3(36u, 32u, 88u)) => uvec3(36u, 32u, 88u)
 * (true ? uvec3(36u, 32u, 88u) : uvec3(59u, 77u, 68u)) => uvec3(36u, 32u, 88u)
 * (true ? uvec3(59u, 77u, 68u) : uvec3(36u, 32u, 88u)) => uvec3(59u, 77u, 68u)
 * (true ? uvec3(59u, 77u, 68u) : uvec3(59u, 77u, 68u)) => uvec3(59u, 77u, 68u)
 */
#version 150

void main()
{
  float[all(equal((false ? uvec3(36u, 32u, 88u) : uvec3(36u, 32u, 88u)), uvec3(36u, 32u, 88u))) ? 1 : -1] array0;
  float[all(equal((false ? uvec3(36u, 32u, 88u) : uvec3(59u, 77u, 68u)), uvec3(59u, 77u, 68u))) ? 1 : -1] array1;
  float[all(equal((false ? uvec3(59u, 77u, 68u) : uvec3(36u, 32u, 88u)), uvec3(36u, 32u, 88u))) ? 1 : -1] array2;
  float[all(equal((false ? uvec3(59u, 77u, 68u) : uvec3(59u, 77u, 68u)), uvec3(59u, 77u, 68u))) ? 1 : -1] array3;
  float[all(equal((true ? uvec3(36u, 32u, 88u) : uvec3(36u, 32u, 88u)), uvec3(36u, 32u, 88u))) ? 1 : -1] array4;
  float[all(equal((true ? uvec3(36u, 32u, 88u) : uvec3(59u, 77u, 68u)), uvec3(36u, 32u, 88u))) ? 1 : -1] array5;
  float[all(equal((true ? uvec3(59u, 77u, 68u) : uvec3(36u, 32u, 88u)), uvec3(59u, 77u, 68u))) ? 1 : -1] array6;
  float[all(equal((true ? uvec3(59u, 77u, 68u) : uvec3(59u, 77u, 68u)), uvec3(59u, 77u, 68u))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
