/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 ^ (- abs(ivec3(-36, 32, -88)))) => ivec3(-48, -20, -92)
 * (12 ^ (- abs(ivec3(36, 32, 88)))) => ivec3(-48, -20, -92)
 * (12 ^ (- abs(ivec3(59, 77, 68)))) => ivec3(-55, -65, -80)
 * (-6 ^ (- abs(ivec3(-36, 32, -88)))) => ivec3(38, 26, 82)
 * (-6 ^ (- abs(ivec3(36, 32, 88)))) => ivec3(38, 26, 82)
 * (-6 ^ (- abs(ivec3(59, 77, 68)))) => ivec3(63, 73, 70)
 * (76 ^ (- abs(ivec3(-36, 32, -88)))) => ivec3(-112, -84, -28)
 * (76 ^ (- abs(ivec3(36, 32, 88)))) => ivec3(-112, -84, -28)
 * (76 ^ (- abs(ivec3(59, 77, 68)))) => ivec3(-119, -1, -16)
 * (-32 ^ (- abs(ivec3(-36, 32, -88)))) => ivec3(60, 0, 72)
 * (-32 ^ (- abs(ivec3(36, 32, 88)))) => ivec3(60, 0, 72)
 * (-32 ^ (- abs(ivec3(59, 77, 68)))) => ivec3(37, 83, 92)
 * (0 ^ (- abs(ivec3(-36, 32, -88)))) => ivec3(-36, -32, -88)
 * (0 ^ (- abs(ivec3(36, 32, 88)))) => ivec3(-36, -32, -88)
 * (0 ^ (- abs(ivec3(59, 77, 68)))) => ivec3(-59, -77, -68)
 */
#version 130

void main()
{
  float[all(equal((12 ^ (- abs(ivec3(-36, 32, -88)))), ivec3(-48, -20, -92))) ? 1 : -1] array0;
  float[all(equal((12 ^ (- abs(ivec3(36, 32, 88)))), ivec3(-48, -20, -92))) ? 1 : -1] array1;
  float[all(equal((12 ^ (- abs(ivec3(59, 77, 68)))), ivec3(-55, -65, -80))) ? 1 : -1] array2;
  float[all(equal((-6 ^ (- abs(ivec3(-36, 32, -88)))), ivec3(38, 26, 82))) ? 1 : -1] array3;
  float[all(equal((-6 ^ (- abs(ivec3(36, 32, 88)))), ivec3(38, 26, 82))) ? 1 : -1] array4;
  float[all(equal((-6 ^ (- abs(ivec3(59, 77, 68)))), ivec3(63, 73, 70))) ? 1 : -1] array5;
  float[all(equal((76 ^ (- abs(ivec3(-36, 32, -88)))), ivec3(-112, -84, -28))) ? 1 : -1] array6;
  float[all(equal((76 ^ (- abs(ivec3(36, 32, 88)))), ivec3(-112, -84, -28))) ? 1 : -1] array7;
  float[all(equal((76 ^ (- abs(ivec3(59, 77, 68)))), ivec3(-119, -1, -16))) ? 1 : -1] array8;
  float[all(equal((-32 ^ (- abs(ivec3(-36, 32, -88)))), ivec3(60, 0, 72))) ? 1 : -1] array9;
  float[all(equal((-32 ^ (- abs(ivec3(36, 32, 88)))), ivec3(60, 0, 72))) ? 1 : -1] array10;
  float[all(equal((-32 ^ (- abs(ivec3(59, 77, 68)))), ivec3(37, 83, 92))) ? 1 : -1] array11;
  float[all(equal((0 ^ (- abs(ivec3(-36, 32, -88)))), ivec3(-36, -32, -88))) ? 1 : -1] array12;
  float[all(equal((0 ^ (- abs(ivec3(36, 32, 88)))), ivec3(-36, -32, -88))) ? 1 : -1] array13;
  float[all(equal((0 ^ (- abs(ivec3(59, 77, 68)))), ivec3(-59, -77, -68))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
