/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.io.PrintStream;
import liquibase.command.DiffCommand;
import liquibase.diff.DiffResult;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.util.StringUtils;

public class DiffToChangeLogCommand
extends DiffCommand {
    private String changeLogFile;
    private PrintStream outputStream;
    private DiffOutputControl diffOutputControl;

    @Override
    public String getName() {
        return "diffChangeLog";
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public DiffToChangeLogCommand setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
        return this;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public DiffToChangeLogCommand setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public DiffOutputControl getDiffOutputControl() {
        return this.diffOutputControl;
    }

    public DiffToChangeLogCommand setDiffOutputControl(DiffOutputControl diffOutputControl) {
        this.diffOutputControl = diffOutputControl;
        return this;
    }

    @Override
    protected Object run() throws Exception {
        DiffResult diffResult = this.createDiffResult();
        PrintStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            outputStream = System.out;
        }
        if (StringUtils.trimToNull(this.changeLogFile) == null) {
            new DiffToChangeLog(diffResult, this.diffOutputControl).print(outputStream);
        } else {
            new DiffToChangeLog(diffResult, this.diffOutputControl).print(this.changeLogFile);
        }
        return null;
    }
}

