/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public abstract class BasicActionExpiryScanner<T extends BasicAction>
implements ExpiryScanner {
    private static final Duration EXPIRY_TIME;
    private static final DateTimeFormatter TIME_FORMAT;
    private final RecoveryStore recoveryStore;
    private final Class<T> typeClass;
    private final String typeName;
    private final String movedTypeName;

    public BasicActionExpiryScanner(T typeInstance, String movedSubFolder) {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debugf("%s - created, with expiry time of %s", (Object)this.getClass().getSimpleName(), (Object)EXPIRY_TIME);
        }
        this.recoveryStore = StoreManager.getRecoveryStore();
        this.typeClass = typeInstance.getClass();
        this.typeName = ((BasicAction)typeInstance).type();
        this.movedTypeName = movedSubFolder != null && !movedSubFolder.isEmpty() ? this.typeName + movedSubFolder : null;
    }

    private boolean isNotNullUid(Uid uid) {
        return !uid.equals(Uid.nullUid());
    }

    @Override
    public void scan() {
        block10: {
            Instant oldestSurviving = Instant.now().minus(EXPIRY_TIME);
            if (tsLogger.logger.isDebugEnabled()) {
                ZonedDateTime zdt = oldestSurviving.atZone(ZoneId.systemDefault());
                tsLogger.logger.debugf("%s - scanning to remove items from before %s", (Object)this.getClass().getSimpleName(), (Object)TIME_FORMAT.format(zdt));
            }
            try {
                InputObjectState uids = new InputObjectState();
                if (!this.recoveryStore.allObjUids(this.typeName, uids)) break block10;
                Uid uid = UidHelper.unpackFrom(uids);
                while (this.isNotNullUid(uid)) {
                    Instant creationTime;
                    BasicAction action = (BasicAction)this.typeClass.getConstructor(Uid.class).newInstance(uid);
                    if (action.activate() && (creationTime = Instant.ofEpochMilli(action.getCreationTimeMillis())).isBefore(oldestSurviving)) {
                        try {
                            if (this.movedTypeName != null) {
                                this.moveEntry(uid);
                            } else {
                                this.removeEntry(uid);
                            }
                        }
                        catch (Exception ex) {
                            tsLogger.logger.warnf((Throwable)ex, "%s - exception during attempted move of %s", (Object)this.getClass().getSimpleName(), (Object)uid);
                        }
                    }
                    uid = UidHelper.unpackFrom(uids);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                tsLogger.logger.errorf((Throwable)ex, "Action class %s could not be initiated", this.typeClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void moveEntry(Uid uid) throws ObjectStoreException {
        InputObjectState state = this.recoveryStore.read_committed(uid, this.typeName);
        if (state != null) {
            tsLogger.logger.warnf("%s - %s is assumed complete and will be moved", (Object)this.getClass().getSimpleName(), (Object)uid);
            boolean moved = this.recoveryStore.write_committed(uid, this.movedTypeName, new OutputObjectState(state));
            if (moved) {
                this.removeEntry(uid);
            }
        }
    }

    private void removeEntry(Uid uid) throws ObjectStoreException {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debugf("%s - removing old transaction item %s", (Object)this.getClass().getSimpleName(), (Object)uid);
        }
        this.recoveryStore.remove_committed(uid, this.typeName);
    }

    @Override
    public boolean toBeUsed() {
        return !EXPIRY_TIME.isZero();
    }

    static {
        TIME_FORMAT = DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss");
        EXPIRY_TIME = Duration.ofHours(recoveryPropertyManager.getRecoveryEnvironmentBean().getExpiryScanInterval());
    }
}

