/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class JWKSServerUtils {
    public static JSONWebKeySet getRealmJwks(KeycloakSession session, RealmModel realm) {
        JWK[] jwks = (JWK[])session.keys().getKeysStream(realm).filter(k -> k.getStatus().isEnabled() && k.getPublicKey() != null).map(k -> {
            JWKBuilder b = JWKBuilder.create().kid(k.getKid()).algorithm(k.getAlgorithmOrDefault());
            List certificates = Optional.ofNullable(k.getCertificateChain()).filter(certs -> !certs.isEmpty()).orElseGet(() -> Optional.ofNullable(k.getCertificate()).map(Collections::singletonList).orElseGet(Collections::emptyList));
            if (k.getType().equals("RSA")) {
                return b.rsa(k.getPublicKey(), certificates, k.getUse());
            }
            if (k.getType().equals("EC")) {
                return b.ec(k.getPublicKey(), certificates, k.getUse());
            }
            if (k.getType().equals("OKP")) {
                return b.okp(k.getPublicKey(), k.getUse());
            }
            return null;
        }).filter(Objects::nonNull).toArray(JWK[]::new);
        JSONWebKeySet keySet = new JSONWebKeySet();
        keySet.setKeys(jwks);
        return keySet;
    }
}

