/*
 * --------------- DO NOT EDIT THIS FILE! ---------------
 * This file was automatically generated by the
 * $ERL_TOP/erts/lib_src/utils/make_atomics_api script.
 * If you need to make changes, edit the script and
 * regenerate this file.
 * --------------- DO NOT EDIT THIS FILE! ---------------
 */

/*
 * %CopyrightBegin%
 *
 * Copyright Ericsson AB 2011-2021. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * %CopyrightEnd%
 */

/*
 * Description: The ethread atomics API
 * Author: Rickard Green
 */

/*
 * This file maps native atomic implementations to ethread
 * API atomics. If no native atomic implementation
 * is available, a less efficient fallback is used instead.
 * The API consists of 32-bit size, word size (pointer size),
 * and double word size atomics.
 *
 * The following atomic operations are implemented for
 * 32-bit size, and word size atomics:
 * - cmpxchg
 * - xchg
 * - set
 * - init
 * - add_read
 * - read
 * - inc_read
 * - dec_read
 * - add
 * - inc
 * - dec
 * - read_band
 * - read_bor
 *
 * The following atomic operations are implemented for
 * double word size atomics:
 * - cmpxchg
 * - set
 * - read
 * - init
 *
 * Apart from a function implementing the atomic operation
 * with unspecified memory barrier semantics, there are
 * functions implementing each operation with the following
 * implied memory barrier semantics:
 * - mb   - Full memory barrier. Orders both loads, and
 *          stores before, and after the atomic operation.
 *          No load or store is allowed to be reordered
 *          over the atomic operation.
 * - relb - Release barrier. Orders both loads, and
 *          stores appearing *before* the atomic
 *          operation. These are not allowed to be
 *          reordered over the atomic operation.
 * - acqb - Acquire barrier. Orders both loads, and stores
 *          appearing *after* the atomic operation. These
 *          are not allowed to be reordered over the
 *          atomic operation.
 * - wb   - Write barrier. Orders *only* stores. These are
 *          not allowed to be reordered over the barrier.
 *          Store in atomic operation is ordered *after*
 *          the barrier.
 * - rb   - Read barrier. Orders *only* loads. These are
 *          not allowed to be reordered over the barrier.
 *          Load in atomic operation is ordered *before*
 *          the barrier. 
 * - ddrb - Data dependency read barrier. Orders *only*
 *          loads according to data dependency across the
 *          barrier. Load in atomic operation is ordered
 *          before the barrier.
 *
 * We implement all of these operation/barrier
 * combinations, regardless of whether they are useful
 * or not (some of them are useless).
 *
 * Double word size atomic functions are on the followning
 * form:
 *   ethr_dw_atomic_<OP>[_<BARRIER>]
 *
 * Word size atomic functions are on the followning
 * form:
 *   ethr_atomic_<OP>[_<BARRIER>]
 *
 * 32-bit size atomic functions are on the followning
 * form:
 *   ethr_atomic32_<OP>[_<BARRIER>]
 *
 * Apart from the operation/barrier functions
 * described above also 'addr' functions are implemented
 * which return the actual memory address used of the
 * atomic variable. The 'addr' functions have no barrier
 * versions.
 *
 * The native atomic implementation does not need to
 * implement all operation/barrier combinations.
 * Functions that have no native implementation will be
 * constructed from existing native functionality. These
 * functions will perform the wanted operation and will
 * produce sufficient memory barriers, but may
 * in some cases be less efficient than pure native
 * versions.
 *
 * When we create ethread API operation/barrier functions by
 * adding barriers before and after native operations it is
 * assumed that:
 * - A native read operation begins, and ends with a load.
 * - A native set operation begins, and ends with a store.
 * - An init operation begins with either a load, or a store,
 *   and ends with either a load, or a store.
 * - All other operations begins with a load, and ends with
 *   either a load, or a store.
 *
 * This is the minimum functionality that a native
 * implementation needs to provide:
 *
 * - Functions that need to be implemented:
 *
 *   - ethr_native_[dw_|su_dw_]atomic[BITS]_addr
 *   - ethr_native_[dw_|su_dw_]atomic[BITS]_cmpxchg[_<BARRIER>]
 *     (at least one cmpxchg of optional barrier)
 *
 * - Macros that needs to be defined:
 *
 *   A macro informing about the presence of the native
 *   implementation:
 *
 *   - ETHR_HAVE_NATIVE_[DW_|SU_DW_]ATOMIC[BITS]
 *
 *   A macro naming (a string constant) the implementation:
 *
 *   - ETHR_NATIVE_[DW_]ATOMIC[BITS]_IMPL
 *
 *   Each implemented native atomic function has to
 *   be accompanied by a defined macro on the following
 *   form informing about its presence:
 *
 *   - ETHR_HAVE_ETHR_NATIVE_[DW_|SU_DW_]ATOMIC[BITS]_<OP>[_<BARRIER>]
 *
 *   A (sparc-v9 style) membar macro:
 *
 *   - ETHR_MEMBAR(B)
 *
 *     Which takes a combination of the following macros
 *     or:ed (using |) together:
 *
 *     - ETHR_LoadLoad
 *     - ETHR_LoadStore
 *     - ETHR_StoreLoad
 *     - ETHR_StoreStore
 *
 */

#ifndef ETHR_ATOMICS_H__
#define ETHR_ATOMICS_H__

#undef ETHR_AMC_FALLBACK__
#undef ETHR_AMC_NO_ATMCS__
#undef ETHR_AMC_ATMC_T__
#undef ETHR_AMC_ATMC_FUNC__

/* -- 32-bit atomics -- */

#undef ETHR_NAINT32_T__
#undef ETHR_NATMC32_FUNC__
#undef ETHR_NATMC32_ADDR_FUNC__
#undef ETHR_NATMC32_BITS__
#if defined(ETHR_HAVE_NATIVE_ATOMIC32)
#    define ETHR_NEED_NATMC32_ADDR
#  define ETHR_NATMC32_ADDR_FUNC__ ethr_native_atomic32_addr
typedef ethr_native_atomic32_t ethr_atomic32_t;
#  define ETHR_NAINT32_T__ ethr_sint32_t
#  define ETHR_NATMC32_FUNC__(X) ethr_native_atomic32_ ## X
#  define ETHR_NATMC32_BITS__ 32
#elif defined(ETHR_HAVE_NATIVE_ATOMIC64)
#  define ETHR_NEED_NATMC64_ADDR
#ifdef ETHR_BIGENDIAN
#  define ETHR_NATMC32_ADDR_FUNC__(VAR) \
  (((ethr_sint32_t *) ethr_native_atomic64_addr((VAR))) + 1)
#else
#  define ETHR_NATMC32_ADDR_FUNC__(VAR) \
  ((ethr_sint32_t *) ethr_native_atomic64_addr((VAR)))
#endif
typedef ethr_native_atomic64_t ethr_atomic32_t;
#  define ETHR_NAINT32_T__ ethr_sint64_t
#  define ETHR_NATMC32_FUNC__(X) ethr_native_atomic64_ ## X
#  define ETHR_NATMC32_BITS__ 64
#else
/*
 * No native atomics usable for 32-bits atomics :(
 * Use fallback...
 */
typedef ethr_sint32_t ethr_atomic32_t;
#endif

#undef ETHR_ATMC32_INLINE__
#ifdef ETHR_NATMC32_BITS__
#  ifdef ETHR_TRY_INLINE_FUNCS
#    define ETHR_ATMC32_INLINE__
#  endif
#  define ETHR_HAVE_32BIT_NATIVE_ATOMIC_OPS
#endif

#if !defined(ETHR_ATMC32_INLINE__) || defined(ETHR_ATOMIC_IMPL__)
#  define ETHR_NEED_ATMC32_PROTOTYPES__
#endif

#ifndef ETHR_INLINE_ATMC32_FUNC_NAME_
#  define ETHR_INLINE_ATMC32_FUNC_NAME_(X) X
#endif

#undef ETHR_ATMC32_FUNC__
#define ETHR_ATMC32_FUNC__(X) ETHR_INLINE_ATMC32_FUNC_NAME_(ethr_atomic32_ ## X)


/* -- Word size atomics -- */

#undef ETHR_NEED_NATMC32_ADDR
#undef ETHR_NEED_NATMC64_ADDR

#undef ETHR_NAINT_T__
#undef ETHR_NATMC_FUNC__
#undef ETHR_NATMC_ADDR_FUNC__
#undef ETHR_NATMC_BITS__
#if ETHR_SIZEOF_PTR == 8 && defined(ETHR_HAVE_NATIVE_ATOMIC64)
#  ifndef ETHR_NEED_NATMC64_ADDR
#    define ETHR_NEED_NATMC64_ADDR
#  endif
#  define ETHR_NATMC_ADDR_FUNC__ ethr_native_atomic64_addr
typedef ethr_native_atomic64_t ethr_atomic_t;
#  define ETHR_NAINT_T__ ethr_sint64_t
#  define ETHR_NATMC_FUNC__(X) ethr_native_atomic64_ ## X
#  define ETHR_NATMC_BITS__ 64
#elif ETHR_SIZEOF_PTR == 4 && defined(ETHR_HAVE_NATIVE_ATOMIC32)
#  ifndef ETHR_NEED_NATMC64_ADDR
#    define ETHR_NEED_NATMC32_ADDR
#  endif
#  define ETHR_NATMC_ADDR_FUNC__ ethr_native_atomic32_addr
typedef ethr_native_atomic32_t ethr_atomic_t;
#  define ETHR_NAINT_T__ ethr_sint32_t
#  define ETHR_NATMC_FUNC__(X) ethr_native_atomic32_ ## X
#  define ETHR_NATMC_BITS__ 32
#elif ETHR_SIZEOF_PTR == 4 && defined(ETHR_HAVE_NATIVE_ATOMIC64)
#  ifndef ETHR_NEED_NATMC64_ADDR
#    define ETHR_NEED_NATMC64_ADDR
#  endif
#ifdef ETHR_BIGENDIAN
#  define ETHR_NATMC_ADDR_FUNC__(VAR) \
  (((ethr_sint32_t *) ethr_native_atomic64_addr((VAR))) + 1)
#else
#  define ETHR_NATMC_ADDR_FUNC__(VAR) \
  ((ethr_sint32_t *) ethr_native_atomic64_addr((VAR)))
#endif
typedef ethr_native_atomic64_t ethr_atomic_t;
#  define ETHR_NATMC_T__ ethr_native_atomic64_t
#  define ETHR_NAINT_T__ ethr_sint64_t
#  define ETHR_NATMC_FUNC__(X) ethr_native_atomic64_ ## X
#  define ETHR_NATMC_BITS__ 64
#else
/*
 * No native atomics usable for pointer size atomics :(
 * Use fallback...
 */

#  if defined(ETHR_HAVE_32BIT_NATIVE_ATOMIC_OPS)
#    define ETHR_AMC_FALLBACK__
#    define ETHR_AMC_NO_ATMCS__ 2
#    define ETHR_AMC_SINT_T__ ethr_sint32_t
#    define ETHR_AMC_ATMC_T__ ethr_atomic32_t
#    define ETHR_AMC_ATMC_FUNC__(X) ETHR_INLINE_ATMC32_FUNC_NAME_(ethr_atomic32_ ## X)
typedef struct {
    ETHR_AMC_ATMC_T__ atomic[ETHR_AMC_NO_ATMCS__];
} ethr_amc_t;
typedef struct {
    ethr_amc_t amc;
    ethr_sint_t sint;
} ethr_atomic_t;
#  else /* locked fallback */
typedef ethr_sint_t ethr_atomic_t;
#  endif
#endif

#undef ETHR_ATMC_INLINE__
#ifdef ETHR_NATMC_BITS__
#  ifdef ETHR_TRY_INLINE_FUNCS
#    define ETHR_ATMC_INLINE__
#  endif
#  define ETHR_HAVE_WORD_SZ_NATIVE_ATOMIC_OPS
#endif

#if !defined(ETHR_ATMC_INLINE__) || defined(ETHR_ATOMIC_IMPL__)
#  define ETHR_NEED_ATMC_PROTOTYPES__
#endif

#ifndef ETHR_INLINE_ATMC_FUNC_NAME_
#  define ETHR_INLINE_ATMC_FUNC_NAME_(X) X
#endif

#undef ETHR_ATMC_FUNC__
#define ETHR_ATMC_FUNC__(X) ETHR_INLINE_ATMC_FUNC_NAME_(ethr_atomic_ ## X)

/* -- Double word atomics -- */

#undef ETHR_SU_DW_NAINT_T__
#undef ETHR_SU_DW_NATMC_FUNC__
#undef ETHR_SU_DW_NATMC_ADDR_FUNC__
#undef ETHR_DW_NATMC_FUNC__
#undef ETHR_DW_NATMC_ADDR_FUNC__
#undef ETHR_DW_NATMC_BITS__
#if defined(ETHR_HAVE_NATIVE_DW_ATOMIC) || defined(ETHR_HAVE_NATIVE_SU_DW_ATOMIC)
#  define ETHR_NEED_DW_NATMC_ADDR
#  define ETHR_DW_NATMC_ADDR_FUNC__ ethr_native_dw_atomic_addr
#  define ETHR_NATIVE_DW_ATOMIC_T__ ethr_native_dw_atomic_t
#  define ETHR_DW_NATMC_FUNC__(X) ethr_native_dw_atomic_ ## X
#  define ETHR_SU_DW_NATMC_FUNC__(X) ethr_native_su_dw_atomic_ ## X
#  if ETHR_SIZEOF_PTR == 8
#    define ETHR_DW_NATMC_BITS__ 128
#  elif ETHR_SIZEOF_PTR == 4
#    define ETHR_DW_NATMC_BITS__ 64
#  else
#    error "Word size not supported"
#  endif
#  ifdef ETHR_NATIVE_SU_DW_SINT_T
#    define ETHR_SU_DW_NAINT_T__ ETHR_NATIVE_SU_DW_SINT_T
#  endif
#elif ETHR_SIZEOF_PTR == 4 && defined(ETHR_HAVE_NATIVE_ATOMIC64)
#  define ETHR_HAVE_NATIVE_SU_DW_ATOMIC
#  ifndef ETHR_NEED_NATMC64_ADDR
#    define ETHR_NEED_NATMC64_ADDR
#  endif
#  define ETHR_DW_NATMC_ADDR_FUNC__(VAR) \
  ((ethr_dw_sint_t *) ethr_native_atomic64_addr((VAR)))
#  define ETHR_NATIVE_DW_ATOMIC_T__ ethr_native_atomic64_t
#  define ETHR_SU_DW_NAINT_T__ ethr_sint64_t
#  define ETHR_SU_DW_NATMC_FUNC__(X) ethr_native_atomic64_ ## X
#  define ETHR_DW_NATMC_BITS__ 64
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
#define ETHR_DW_ATOMIC_FUNC__(X) ethr_dw_atomic_ ## X ## _fallback__
#else
#define ETHR_DW_ATOMIC_FUNC__(X) ethr_dw_atomic_ ## X
#endif

#if !defined(ETHR_DW_NATMC_BITS__) || defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
#  define ETHR_NEED_DW_FALLBACK__
#endif

#if defined(ETHR_NEED_DW_FALLBACK__)
/*
 * No native atomics usable for double word atomics :(
 * Use fallback...
 */

#  ifndef ETHR_AMC_FALLBACK__
#    if ETHR_SIZEOF_PTR == 8 && defined(ETHR_HAVE_WORD_SZ_NATIVE_ATOMIC_OPS)
#      define ETHR_AMC_FALLBACK__
#      define ETHR_AMC_NO_ATMCS__ 1
#      define ETHR_AMC_SINT_T__ ethr_sint_t
#      define ETHR_AMC_ATMC_T__ ethr_atomic_t
#      define ETHR_AMC_ATMC_FUNC__(X) ETHR_INLINE_ATMC_FUNC_NAME_(ethr_atomic_ ## X)
#    elif defined(ETHR_HAVE_32BIT_NATIVE_ATOMIC_OPS)
#      define ETHR_AMC_FALLBACK__
#      define ETHR_AMC_NO_ATMCS__ 2
#      define ETHR_AMC_SINT_T__ ethr_sint32_t
#      define ETHR_AMC_ATMC_T__ ethr_atomic32_t
#      define ETHR_AMC_ATMC_FUNC__(X) ETHR_INLINE_ATMC32_FUNC_NAME_(ethr_atomic32_ ## X)
#    endif
#    ifdef ETHR_AMC_FALLBACK__
typedef struct {
    ETHR_AMC_ATMC_T__ atomic[ETHR_AMC_NO_ATMCS__];
} ethr_amc_t;
#    endif
#  endif

typedef struct {
#ifdef ETHR_AMC_FALLBACK__
    ethr_amc_t amc;
#endif
    ethr_sint_t sint[2];
} ethr_dw_atomic_fallback_t;

#endif

typedef union {
#ifdef ETHR_NATIVE_DW_ATOMIC_T__
    ETHR_NATIVE_DW_ATOMIC_T__ native;
#endif
#ifdef ETHR_NEED_DW_FALLBACK__
    ethr_dw_atomic_fallback_t fallback;
#endif
    ethr_sint_t sint[2];
} ethr_dw_atomic_t;

typedef union {
#ifdef ETHR_SU_DW_NAINT_T__
    ETHR_SU_DW_NAINT_T__ dw_sint;
#endif
    ethr_sint_t sint[2];
} ethr_dw_sint_t;

#ifdef ETHR_BIGENDIAN
#  define ETHR_DW_SINT_LOW_WORD 1
#  define ETHR_DW_SINT_HIGH_WORD 0
#else
#  define ETHR_DW_SINT_LOW_WORD 0
#  define ETHR_DW_SINT_HIGH_WORD 1
#endif

#undef ETHR_DW_ATMC_INLINE__
#ifdef ETHR_DW_NATMC_BITS__
#  ifdef ETHR_TRY_INLINE_FUNCS
#    define ETHR_ATMC32_INLINE__
#  endif
#  define ETHR_HAVE_DOUBLE_WORD_SZ_NATIVE_ATOMIC_OPS
#endif

#if !defined(ETHR_DW_ATMC_INLINE__) || defined(ETHR_ATOMIC_IMPL__)
#  define ETHR_NEED_DW_ATMC_PROTOTYPES__
#endif

#ifndef ETHR_INLINE_DW_ATMC_FUNC_NAME_
#  define ETHR_INLINE_DW_ATMC_FUNC_NAME_(X) X
#endif

#undef ETHR_DW_ATMC_FUNC__
#define ETHR_DW_ATMC_FUNC__(X) ETHR_INLINE_DW_ATMC_FUNC_NAME_(ethr_dw_atomic_ ## X)

#if defined(ETHR_NEED_DW_ATMC_PROTOTYPES__)
int ethr_have_native_dw_atomic(void);
#endif
#if defined(ETHR_DW_ATMC_INLINE__) || defined(ETHR_ATOMIC_IMPL__)
static ETHR_INLINE int
ETHR_INLINE_DW_ATMC_FUNC_NAME_(ethr_have_native_dw_atomic)(void)
{
#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    return ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__;
#elif defined(ETHR_DW_NATMC_BITS__)
    return 1;
#else
    return 0;
#endif
}
#endif

/* -- Misc -- */

#if defined(ETHR_TRY_INLINE_FUNCS) || defined(ETHR_ATOMIC_IMPL__)
/*
 * Unusual values are used by read() fallbacks implemented via cmpxchg().
 * We want to use an unusual value in hope that it is more efficient
 * not to match the value in memory.
 *
 * - Negative integer values are probably more unusual.
 * - Very large absolute integer values are probably more unusual.
 * - Odd pointers are probably more unusual (only char pointers can be odd).
 */
#  define ETHR_UNUSUAL_SINT32_VAL__ ((ethr_sint32_t) 0x81818181)
#  if ETHR_SIZEOF_PTR == 4
#    define ETHR_UNUSUAL_SINT_VAL__ ((ethr_sint_t) ETHR_UNUSUAL_SINT32_VAL__)
#  elif ETHR_SIZEOF_PTR == 8
#    define ETHR_UNUSUAL_SINT_VAL__ ((ethr_sint_t) 0x8181818181818181L)
#  else
#    error "Word size not supported"
#  endif
#  if defined(ETHR_NEED_DW_NATMC_ADDR) && !defined(ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_ADDR)
#    error "No ethr_native_dw_atomic_addr() available"
#  endif
#  if defined(ETHR_NEED_NATMC32_ADDR) && !defined(ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADDR)
#    error "No ethr_native_atomic32_addr() available"
#  endif
#  if defined(ETHR_NEED_NATMC64_ADDR) && !defined(ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADDR)
#    error "No ethr_native_atomic64_addr() available"
#  endif
#endif

#if defined(__GNUC__)
#  ifndef ETHR_COMPILER_BARRIER
#    define ETHR_COMPILER_BARRIER __asm__ __volatile__("" : : : "memory")
#  endif
#elif defined(ETHR_WIN32_THREADS)
#  ifndef ETHR_COMPILER_BARRIER
#    include <intrin.h>
#    pragma intrinsic(_ReadWriteBarrier)
#    define ETHR_COMPILER_BARRIER _ReadWriteBarrier()
#  endif
#endif

void ethr_compiler_barrier_fallback(void);
#ifndef ETHR_COMPILER_BARRIER
#  define ETHR_COMPILER_BARRIER ethr_compiler_barrier_fallback()
#endif

int ethr_init_atomics(void);

/* info */
char **ethr_native_atomic32_ops(void);
char **ethr_native_atomic64_ops(void);
char **ethr_native_dw_atomic_ops(void);
char **ethr_native_su_dw_atomic_ops(void);

#if !defined(ETHR_DW_NATMC_BITS__) && !defined(ETHR_NATMC_BITS__) && !defined(ETHR_NATMC32_BITS__)
/*
 * ETHR_*MEMORY_BARRIER orders between locked and atomic accesses only,
 * i.e. when no native atomic implementation exist and only our lock
 * based atomic fallback is used, a noop is sufficient.
 */
#  undef ETHR_MEMORY_BARRIER
#  undef ETHR_WRITE_MEMORY_BARRIER
#  undef ETHR_READ_MEMORY_BARRIER
#  undef ETHR_READ_DEPEND_MEMORY_BARRIER
#  undef ETHR_MEMBAR
#  define ETHR_MEMBAR(B) do { } while (0)
#endif

#ifndef ETHR_MEMBAR
#  error "No ETHR_MEMBAR defined"
#endif

#define ETHR_MEMORY_BARRIER ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore)
#define ETHR_WRITE_MEMORY_BARRIER ETHR_MEMBAR(ETHR_StoreStore)
#define ETHR_READ_MEMORY_BARRIER ETHR_MEMBAR(ETHR_LoadLoad)
#ifdef ETHR_READ_DEPEND_MEMORY_BARRIER
#  undef ETHR_ORDERED_READ_DEPEND
#else
#  define ETHR_READ_DEPEND_MEMORY_BARRIER ETHR_COMPILER_BARRIER
#  define ETHR_ORDERED_READ_DEPEND
#endif


/* ---------- Double word size atomic implementation ---------- */


#ifdef ETHR_NEED_DW_ATMC_PROTOTYPES__
ethr_sint_t *ethr_dw_atomic_addr(ethr_dw_atomic_t *var);
int ethr_dw_atomic_cmpxchg(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ethr_dw_atomic_cmpxchg_ddrb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ethr_dw_atomic_cmpxchg_rb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ethr_dw_atomic_cmpxchg_wb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ethr_dw_atomic_cmpxchg_acqb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ethr_dw_atomic_cmpxchg_relb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ethr_dw_atomic_cmpxchg_mb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
void ethr_dw_atomic_set(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_set_ddrb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_set_rb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_set_wb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_set_acqb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_set_relb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_set_mb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_read(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_read_ddrb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_read_rb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_read_wb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_read_acqb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_read_relb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_read_mb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_init(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_init_ddrb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_init_rb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_init_wb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_init_acqb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_init_relb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ethr_dw_atomic_init_mb(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
ethr_sint_t *ETHR_DW_ATOMIC_FUNC__(addr)(ethr_dw_atomic_t *var);
int ETHR_DW_ATOMIC_FUNC__(cmpxchg)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ETHR_DW_ATOMIC_FUNC__(cmpxchg_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ETHR_DW_ATOMIC_FUNC__(cmpxchg_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ETHR_DW_ATOMIC_FUNC__(cmpxchg_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ETHR_DW_ATOMIC_FUNC__(cmpxchg_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ETHR_DW_ATOMIC_FUNC__(cmpxchg_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
int ETHR_DW_ATOMIC_FUNC__(cmpxchg_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val);
void ETHR_DW_ATOMIC_FUNC__(set)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(set_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(set_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(set_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(set_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(set_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(set_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(read)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(read_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(read_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(read_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(read_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(read_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(read_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(init)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(init_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(init_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(init_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(init_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(init_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
void ETHR_DW_ATOMIC_FUNC__(init_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val);
#endif
#endif /* ETHR_NEED_DW_ATMC_PROTOTYPES__ */

#if (defined(ETHR_HAVE_DOUBLE_WORD_SZ_NATIVE_ATOMIC_OPS) \
     && (defined(ETHR_DW_ATMC_INLINE__) || defined(ETHR_ATOMIC_IMPL__)))

#if !defined(ETHR_DW_NATMC_BITS__)
#  error "Missing native atomic implementation"
#elif defined(ETHR_HAVE_NATIVE_DW_ATOMIC)  || defined(ETHR_HAVE_NATIVE_SU_DW_ATOMIC)
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_CMPXCHG
#    define ETHR_HAVE_DW_NATMC_CMPXCHG 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_CMPXCHG
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_CMPXCHG_RB
#    define ETHR_HAVE_DW_NATMC_CMPXCHG_RB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_CMPXCHG_RB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_CMPXCHG_WB
#    define ETHR_HAVE_DW_NATMC_CMPXCHG_WB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_CMPXCHG_WB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_CMPXCHG_ACQB
#    define ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_CMPXCHG_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_CMPXCHG_RELB
#    define ETHR_HAVE_DW_NATMC_CMPXCHG_RELB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_CMPXCHG_RELB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_CMPXCHG_MB
#    define ETHR_HAVE_DW_NATMC_CMPXCHG_MB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_CMPXCHG_MB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_SET
#  undef ETHR_HAVE_DW_NATMC_SET
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_SET
#    define ETHR_HAVE_DW_NATMC_SET 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_SET
#    define ETHR_HAVE_SU_DW_NATMC_SET 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_SET_RB
#  undef ETHR_HAVE_DW_NATMC_SET_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_SET_RB
#    define ETHR_HAVE_DW_NATMC_SET_RB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_SET_RB
#    define ETHR_HAVE_SU_DW_NATMC_SET_RB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_SET_WB
#  undef ETHR_HAVE_DW_NATMC_SET_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_SET_WB
#    define ETHR_HAVE_DW_NATMC_SET_WB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_SET_WB
#    define ETHR_HAVE_SU_DW_NATMC_SET_WB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_SET_ACQB
#  undef ETHR_HAVE_DW_NATMC_SET_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_SET_ACQB
#    define ETHR_HAVE_DW_NATMC_SET_ACQB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_SET_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_SET_ACQB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_SET_RELB
#  undef ETHR_HAVE_DW_NATMC_SET_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_SET_RELB
#    define ETHR_HAVE_DW_NATMC_SET_RELB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_SET_RELB
#    define ETHR_HAVE_SU_DW_NATMC_SET_RELB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_SET_MB
#  undef ETHR_HAVE_DW_NATMC_SET_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_SET_MB
#    define ETHR_HAVE_DW_NATMC_SET_MB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_SET_MB
#    define ETHR_HAVE_SU_DW_NATMC_SET_MB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_READ
#  undef ETHR_HAVE_DW_NATMC_READ
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_READ
#    define ETHR_HAVE_DW_NATMC_READ 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_READ
#    define ETHR_HAVE_SU_DW_NATMC_READ 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_READ_RB
#  undef ETHR_HAVE_DW_NATMC_READ_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_READ_RB
#    define ETHR_HAVE_DW_NATMC_READ_RB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_READ_RB
#    define ETHR_HAVE_SU_DW_NATMC_READ_RB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_READ_WB
#  undef ETHR_HAVE_DW_NATMC_READ_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_READ_WB
#    define ETHR_HAVE_DW_NATMC_READ_WB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_READ_WB
#    define ETHR_HAVE_SU_DW_NATMC_READ_WB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_READ_ACQB
#  undef ETHR_HAVE_DW_NATMC_READ_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_READ_ACQB
#    define ETHR_HAVE_DW_NATMC_READ_ACQB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_READ_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_READ_ACQB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_READ_RELB
#  undef ETHR_HAVE_DW_NATMC_READ_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_READ_RELB
#    define ETHR_HAVE_DW_NATMC_READ_RELB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_READ_RELB
#    define ETHR_HAVE_SU_DW_NATMC_READ_RELB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_READ_MB
#  undef ETHR_HAVE_DW_NATMC_READ_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_READ_MB
#    define ETHR_HAVE_DW_NATMC_READ_MB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_READ_MB
#    define ETHR_HAVE_SU_DW_NATMC_READ_MB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_INIT
#  undef ETHR_HAVE_DW_NATMC_INIT
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_INIT
#    define ETHR_HAVE_DW_NATMC_INIT 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_INIT
#    define ETHR_HAVE_SU_DW_NATMC_INIT 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_RB
#  undef ETHR_HAVE_DW_NATMC_INIT_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_INIT_RB
#    define ETHR_HAVE_DW_NATMC_INIT_RB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_INIT_RB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_RB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_WB
#  undef ETHR_HAVE_DW_NATMC_INIT_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_INIT_WB
#    define ETHR_HAVE_DW_NATMC_INIT_WB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_INIT_WB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_WB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_ACQB
#  undef ETHR_HAVE_DW_NATMC_INIT_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_INIT_ACQB
#    define ETHR_HAVE_DW_NATMC_INIT_ACQB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_INIT_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_ACQB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_RELB
#  undef ETHR_HAVE_DW_NATMC_INIT_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_INIT_RELB
#    define ETHR_HAVE_DW_NATMC_INIT_RELB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_INIT_RELB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_RELB 1
#  endif
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_MB
#  undef ETHR_HAVE_DW_NATMC_INIT_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_DW_ATOMIC_INIT_MB
#    define ETHR_HAVE_DW_NATMC_INIT_MB 1
#  endif
#  ifdef ETHR_HAVE_ETHR_NATIVE_SU_DW_ATOMIC_INIT_MB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_MB 1
#  endif
#elif ETHR_DW_NATMC_BITS__ == 64
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_RB
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_RB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_WB
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_WB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_RELB
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_RELB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_CMPXCHG_MB
#  undef ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_MB
#    define ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_SET
#  undef ETHR_HAVE_SU_DW_NATMC_SET
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET
#    define ETHR_HAVE_SU_DW_NATMC_SET 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_SET_RB
#  undef ETHR_HAVE_SU_DW_NATMC_SET_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_RB
#    define ETHR_HAVE_SU_DW_NATMC_SET_RB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_SET_WB
#  undef ETHR_HAVE_SU_DW_NATMC_SET_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_WB
#    define ETHR_HAVE_SU_DW_NATMC_SET_WB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_SET_ACQB
#  undef ETHR_HAVE_SU_DW_NATMC_SET_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_SET_ACQB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_SET_RELB
#  undef ETHR_HAVE_SU_DW_NATMC_SET_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_RELB
#    define ETHR_HAVE_SU_DW_NATMC_SET_RELB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_SET_MB
#  undef ETHR_HAVE_SU_DW_NATMC_SET_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_MB
#    define ETHR_HAVE_SU_DW_NATMC_SET_MB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_READ
#  undef ETHR_HAVE_SU_DW_NATMC_READ
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ
#    define ETHR_HAVE_SU_DW_NATMC_READ 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_READ_RB
#  undef ETHR_HAVE_SU_DW_NATMC_READ_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_RB
#    define ETHR_HAVE_SU_DW_NATMC_READ_RB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_READ_WB
#  undef ETHR_HAVE_SU_DW_NATMC_READ_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_WB
#    define ETHR_HAVE_SU_DW_NATMC_READ_WB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_READ_ACQB
#  undef ETHR_HAVE_SU_DW_NATMC_READ_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_READ_ACQB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_READ_RELB
#  undef ETHR_HAVE_SU_DW_NATMC_READ_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_RELB
#    define ETHR_HAVE_SU_DW_NATMC_READ_RELB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_READ_MB
#  undef ETHR_HAVE_SU_DW_NATMC_READ_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_MB
#    define ETHR_HAVE_SU_DW_NATMC_READ_MB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_INIT
#  undef ETHR_HAVE_SU_DW_NATMC_INIT
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT
#    define ETHR_HAVE_SU_DW_NATMC_INIT 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_INIT_RB
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_RB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_RB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_INIT_WB
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_WB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_WB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_INIT_ACQB
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_ACQB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_ACQB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_INIT_RELB
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_RELB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_RELB 1
#  endif
#  undef ETHR_HAVE_DW_NATMC_INIT_MB
#  undef ETHR_HAVE_SU_DW_NATMC_INIT_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_MB
#    define ETHR_HAVE_SU_DW_NATMC_INIT_MB 1
#  endif
#else
#  error "Invalid native atomic size"
#endif


#if defined(ETHR_HAVE_NATIVE_DW_ATOMIC)

#if (!defined(ETHR_HAVE_DW_NATMC_CMPXCHG) \
     && !defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB) \
     && !defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB) \
     && !defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB) \
     && !defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB) \
     && !defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB))
#  error "No native cmpxchg() op available"
#endif


/*
 * Read op used together with cmpxchg() fallback when no native op present.
 */
#if defined(ETHR_HAVE_DW_NATMC_READ)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  ETHR_DW_NATMC_FUNC__(read)(VAR, VAL)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  VAL.dw_sint = ETHR_SU_DW_NATMC_FUNC__(read)(VAR)
#elif defined(ETHR_HAVE_DW_NATMC_READ_RB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  ETHR_DW_NATMC_FUNC__(read_rb)(VAR, VAL)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  VAL.dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_rb)(VAR)
#elif defined(ETHR_HAVE_DW_NATMC_READ_WB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  ETHR_DW_NATMC_FUNC__(read_wb)(VAR, VAL)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  VAL.dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_wb)(VAR)
#elif defined(ETHR_HAVE_DW_NATMC_READ_ACQB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  ETHR_DW_NATMC_FUNC__(read_acqb)(VAR, VAL)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  VAL.dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_acqb)(VAR)
#elif defined(ETHR_HAVE_DW_NATMC_READ_RELB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  ETHR_DW_NATMC_FUNC__(read_relb)(VAR, VAL)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  VAL.dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_relb)(VAR)
#elif defined(ETHR_HAVE_DW_NATMC_READ_MB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  ETHR_DW_NATMC_FUNC__(read_mb)(VAR, VAL)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
  VAL.dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_mb)(VAR)
#else
/*
 * We have no native read() op; guess zero and then use the
 * the atomics actual value returned from cmpxchg().
 */
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, VAL) \
do { \
  VAL.sint[0] = (ethr_sint_t) 0; \
  VAL.sint[1] = (ethr_sint_t) 0; \
} while (0)
#endif

/*
 * Native cmpxchg() fallback used when no native op present.
 */
#define ETHR_DW_NATMC_CMPXCHG_FALLBACK__(CMPXCHG, VAR, AVAL, OPS) \
do { \
    int res__; \
    ethr_dw_sint_t AVAL, exp_act__; \
    ETHR_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR, exp_act__); \
    do { \
	AVAL.sint[0] = exp_act__.sint[0]; \
	AVAL.sint[1] = exp_act__.sint[1]; \
	{ OPS; } \
	res__ = CMPXCHG(VAR, AVAL.sint, exp_act__.sint); \
    } while (__builtin_expect(res__ == 0, 0)); \
} while (0)


#elif defined(ETHR_HAVE_NATIVE_SU_DW_ATOMIC)

#if (!defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG) \
     && !defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB) \
     && !defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB) \
     && !defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB) \
     && !defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB) \
     && !defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB))
#  error "No native cmpxchg() op available"
#endif


/*
 * Read op used together with cmpxchg() fallback when no native op present.
 */
#if defined(ETHR_HAVE_SU_DW_NATMC_READ)
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_SU_DW_NATMC_FUNC__(read)(VAR)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_SU_DW_NATMC_FUNC__(read_rb)(VAR)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_SU_DW_NATMC_FUNC__(read_wb)(VAR)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_SU_DW_NATMC_FUNC__(read_acqb)(VAR)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_SU_DW_NATMC_FUNC__(read_relb)(VAR)
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_SU_DW_NATMC_FUNC__(read_mb)(VAR)
#else
/*
 * We have no native read() op; guess zero and then use the
 * the atomics actual value returned from cmpxchg().
 */
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ((ETHR_SU_DW_NAINT_T__) 0)
#endif

/*
 * Native cmpxchg() fallback used when no native op present.
 */
#define ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(CMPXCHG, VAR, AVAL, OPS) \
do { \
    ETHR_SU_DW_NAINT_T__ AVAL; \
    ETHR_SU_DW_NAINT_T__ new__, act__, exp__; \
    act__ = ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK_READ__(VAR); \
    do { \
	exp__ = act__; \
	AVAL = (ETHR_SU_DW_NAINT_T__) act__; \
	{ OPS; } \
	new__ = (ETHR_SU_DW_NAINT_T__) AVAL; \
	act__ = CMPXCHG(VAR, new__, exp__); \
    } while (__builtin_expect(act__ != exp__, 0)); \
} while (0)


#else
#  error "?!?"
#endif



/* --- addr() --- */

static ETHR_INLINE ethr_sint_t *ETHR_DW_ATMC_FUNC__(addr)(ethr_dw_atomic_t *var)
{
#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

    return (ethr_sint_t *) ETHR_DW_NATMC_ADDR_FUNC__((&var->native));

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { return ETHR_DW_ATOMIC_FUNC__(addr)(var); }
#endif

}


/* --- cmpxchg() --- */


static ETHR_INLINE int ETHR_DW_ATMC_FUNC__(cmpxchg)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val)
{
    int res;

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->sint, old_val->sint);
#else
#error "Missing implementation of ethr_dw_atomic_cmpxchg()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { res = ETHR_DW_ATOMIC_FUNC__(cmpxchg)(var, val, old_val); }
#endif

    return res;
}

static ETHR_INLINE int ETHR_DW_ATMC_FUNC__(cmpxchg_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val)
{
    int res;

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_dw_atomic_cmpxchg_rb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { res = ETHR_DW_ATOMIC_FUNC__(cmpxchg_rb)(var, val, old_val); }
#endif

    return res;
}

static ETHR_INLINE int ETHR_DW_ATMC_FUNC__(cmpxchg_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val)
{
    int res;

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_StoreStore);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_StoreStore);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_StoreStore);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_StoreStore);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->sint, old_val->sint);
#else
#error "Missing implementation of ethr_dw_atomic_cmpxchg_wb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { res = ETHR_DW_ATOMIC_FUNC__(cmpxchg_wb)(var, val, old_val); }
#endif

    return res;
}

static ETHR_INLINE int ETHR_DW_ATMC_FUNC__(cmpxchg_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val)
{
    int res;

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_dw_atomic_cmpxchg_acqb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { res = ETHR_DW_ATOMIC_FUNC__(cmpxchg_acqb)(var, val, old_val); }
#endif

    return res;
}

static ETHR_INLINE int ETHR_DW_ATMC_FUNC__(cmpxchg_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val)
{
    int res;

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->sint, old_val->sint);
#else
#error "Missing implementation of ethr_dw_atomic_cmpxchg_relb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { res = ETHR_DW_ATOMIC_FUNC__(cmpxchg_relb)(var, val, old_val); }
#endif

    return res;
}

static ETHR_INLINE int ETHR_DW_ATMC_FUNC__(cmpxchg_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val)
{
    int res;

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NAINT_T__ act;
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->dw_sint, old_val->dw_sint);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NAINT_T__ act;
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    act = ETHR_SU_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->dw_sint, old_val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    res = (act == old_val->dw_sint);
    old_val->dw_sint = act;
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_mb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_relb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_acqb)(&var->native, val->sint, old_val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_wb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg_rb)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = ETHR_DW_NATMC_FUNC__(cmpxchg)(&var->native, val->sint, old_val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_dw_atomic_cmpxchg_mb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { res = ETHR_DW_ATOMIC_FUNC__(cmpxchg_mb)(var, val, old_val); }
#endif

    return res;
}

static ETHR_INLINE int ETHR_DW_ATMC_FUNC__(cmpxchg_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val, ethr_dw_sint_t *old_val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_DW_ATMC_FUNC__(cmpxchg)(var, val, old_val);
#else
    return ETHR_DW_ATMC_FUNC__(cmpxchg_rb)(var, val, old_val);
#endif
}


/* --- set() --- */


static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(set)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_SET)
    ETHR_SU_DW_NATMC_FUNC__(set)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RB)
    ETHR_SU_DW_NATMC_FUNC__(set_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_WB)
    ETHR_SU_DW_NATMC_FUNC__(set_wb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_ACQB)
    ETHR_SU_DW_NATMC_FUNC__(set_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RELB)
    ETHR_SU_DW_NATMC_FUNC__(set_relb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_MB)
    ETHR_SU_DW_NATMC_FUNC__(set_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET)
    ETHR_DW_NATMC_FUNC__(set)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RB)
    ETHR_DW_NATMC_FUNC__(set_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_WB)
    ETHR_DW_NATMC_FUNC__(set_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_ACQB)
    ETHR_DW_NATMC_FUNC__(set_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RELB)
    ETHR_DW_NATMC_FUNC__(set_relb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_MB)
    ETHR_DW_NATMC_FUNC__(set_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#else
#error "Missing implementation of ethr_dw_atomic_set()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(set)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(set_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_SET_RB)
    ETHR_SU_DW_NATMC_FUNC__(set_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET)
    ETHR_SU_DW_NATMC_FUNC__(set)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_MB)
    ETHR_SU_DW_NATMC_FUNC__(set_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_WB)
    ETHR_SU_DW_NATMC_FUNC__(set_wb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_ACQB)
    ETHR_SU_DW_NATMC_FUNC__(set_acqb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RELB)
    ETHR_SU_DW_NATMC_FUNC__(set_relb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RB)
    ETHR_DW_NATMC_FUNC__(set_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET)
    ETHR_DW_NATMC_FUNC__(set)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_SET_MB)
    ETHR_DW_NATMC_FUNC__(set_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_WB)
    ETHR_DW_NATMC_FUNC__(set_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_SET_ACQB)
    ETHR_DW_NATMC_FUNC__(set_acqb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RELB)
    ETHR_DW_NATMC_FUNC__(set_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_dw_atomic_set_rb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(set_rb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(set_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_SET_WB)
    ETHR_SU_DW_NATMC_FUNC__(set_wb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_MB)
    ETHR_SU_DW_NATMC_FUNC__(set_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set_relb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_WB)
    ETHR_DW_NATMC_FUNC__(set_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_MB)
    ETHR_DW_NATMC_FUNC__(set_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set_relb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#else
#error "Missing implementation of ethr_dw_atomic_set_wb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(set_wb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(set_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_SET_ACQB)
    ETHR_SU_DW_NATMC_FUNC__(set_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RB)
    ETHR_SU_DW_NATMC_FUNC__(set_rb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET)
    ETHR_SU_DW_NATMC_FUNC__(set)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_MB)
    ETHR_SU_DW_NATMC_FUNC__(set_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_WB)
    ETHR_SU_DW_NATMC_FUNC__(set_wb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RELB)
    ETHR_SU_DW_NATMC_FUNC__(set_relb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET_ACQB)
    ETHR_DW_NATMC_FUNC__(set_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RB)
    ETHR_DW_NATMC_FUNC__(set_rb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET)
    ETHR_DW_NATMC_FUNC__(set)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET_MB)
    ETHR_DW_NATMC_FUNC__(set_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_WB)
    ETHR_DW_NATMC_FUNC__(set_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RELB)
    ETHR_DW_NATMC_FUNC__(set_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_dw_atomic_set_acqb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(set_acqb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(set_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_SET_RELB)
    ETHR_SU_DW_NATMC_FUNC__(set_relb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_SU_DW_NATMC_FUNC__(set_wb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_MB)
    ETHR_SU_DW_NATMC_FUNC__(set_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RELB)
    ETHR_DW_NATMC_FUNC__(set_relb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_DW_NATMC_FUNC__(set_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_MB)
    ETHR_DW_NATMC_FUNC__(set_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#else
#error "Missing implementation of ethr_dw_atomic_set_relb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(set_relb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(set_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_SET_MB)
    ETHR_SU_DW_NATMC_FUNC__(set_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RELB)
    ETHR_SU_DW_NATMC_FUNC__(set_relb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_SU_DW_NATMC_FUNC__(set_wb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set_rb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(set)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET_MB)
    ETHR_DW_NATMC_FUNC__(set_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RELB)
    ETHR_DW_NATMC_FUNC__(set_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_DW_NATMC_FUNC__(set_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set_rb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(set)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_MB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RELB)
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval = val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_SU_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval = val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_MB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_mb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RELB)
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_relb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_acqb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_wb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg_rb), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_CMPXCHG_FALLBACK__(ETHR_DW_NATMC_FUNC__(cmpxchg), &var->native, aval, aval.sint[0] = val->sint[0]; aval.sint[1] = val->sint[1]);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_dw_atomic_set_mb()!"
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(set_mb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(set_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_DW_ATMC_FUNC__(set)(var, val);
#else
    ETHR_DW_ATMC_FUNC__(set_rb)(var, val);
#endif
}


/* --- read() --- */


static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(read)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_READ)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_rb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_wb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_acqb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_relb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_mb)(&var->native);
#elif defined(ETHR_HAVE_DW_NATMC_READ)
    ETHR_DW_NATMC_FUNC__(read)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RB)
    ETHR_DW_NATMC_FUNC__(read_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_WB)
    ETHR_DW_NATMC_FUNC__(read_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_ACQB)
    ETHR_DW_NATMC_FUNC__(read_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RELB)
    ETHR_DW_NATMC_FUNC__(read_relb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_MB)
    ETHR_DW_NATMC_FUNC__(read_mb)(&var->native, val->sint);
#else
    ethr_dw_sint_t tmp;
    tmp.sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    tmp.sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    (void) ETHR_DW_ATMC_FUNC__(cmpxchg)(var, &tmp, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(read)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(read_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_rb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_mb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_wb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_acqb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_relb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RB)
    ETHR_DW_NATMC_FUNC__(read_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ)
    ETHR_DW_NATMC_FUNC__(read)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_READ_MB)
    ETHR_DW_NATMC_FUNC__(read_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_WB)
    ETHR_DW_NATMC_FUNC__(read_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_READ_ACQB)
    ETHR_DW_NATMC_FUNC__(read_acqb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RELB)
    ETHR_DW_NATMC_FUNC__(read_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    ethr_dw_sint_t tmp;
    tmp.sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    tmp.sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    (void) ETHR_DW_ATMC_FUNC__(cmpxchg_rb)(var, &tmp, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(read_rb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(read_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_wb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ)
    ETHR_MEMBAR(ETHR_StoreStore);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_mb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_rb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_acqb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_relb)(&var->native);
#elif defined(ETHR_HAVE_DW_NATMC_READ_WB)
    ETHR_DW_NATMC_FUNC__(read_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(read)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_MB)
    ETHR_DW_NATMC_FUNC__(read_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(read_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(read_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(read_relb)(&var->native, val->sint);
#else
    ethr_dw_sint_t tmp;
    tmp.sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    tmp.sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    (void) ETHR_DW_ATMC_FUNC__(cmpxchg_wb)(var, &tmp, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(read_wb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(read_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_acqb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_rb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_mb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_wb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_relb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ_ACQB)
    ETHR_DW_NATMC_FUNC__(read_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RB)
    ETHR_DW_NATMC_FUNC__(read_rb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ)
    ETHR_DW_NATMC_FUNC__(read)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ_MB)
    ETHR_DW_NATMC_FUNC__(read_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_WB)
    ETHR_DW_NATMC_FUNC__(read_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RELB)
    ETHR_DW_NATMC_FUNC__(read_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#else
    ethr_dw_sint_t tmp;
    tmp.sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    tmp.sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    (void) ETHR_DW_ATMC_FUNC__(cmpxchg_acqb)(var, &tmp, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(read_acqb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(read_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_relb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_wb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_mb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_rb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_acqb)(&var->native);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RELB)
    ETHR_DW_NATMC_FUNC__(read_relb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_MB)
    ETHR_DW_NATMC_FUNC__(read_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read_acqb)(&var->native, val->sint);
#else
    ethr_dw_sint_t tmp;
    tmp.sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    tmp.sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    (void) ETHR_DW_ATMC_FUNC__(cmpxchg_relb)(var, &tmp, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(read_relb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(read_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_READ_MB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_mb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RELB)
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_relb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_acqb)(&var->native);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_wb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read_rb)(&var->native);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    val->dw_sint = ETHR_SU_DW_NATMC_FUNC__(read)(&var->native);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ_MB)
    ETHR_DW_NATMC_FUNC__(read_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RELB)
    ETHR_DW_NATMC_FUNC__(read_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read_rb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_DW_NATMC_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(read)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#else
    ethr_dw_sint_t tmp;
    tmp.sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    tmp.sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[0] = ETHR_UNUSUAL_SINT_VAL__;
    val->sint[1] = ETHR_UNUSUAL_SINT_VAL__;
    (void) ETHR_DW_ATMC_FUNC__(cmpxchg_mb)(var, &tmp, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(read_mb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(read_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_DW_ATMC_FUNC__(read)(var, val);
#else
    ETHR_DW_ATMC_FUNC__(read_rb)(var, val);
#endif
}


/* --- init() --- */


static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(init)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_INIT)
    ETHR_SU_DW_NATMC_FUNC__(init)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RB)
    ETHR_SU_DW_NATMC_FUNC__(init_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_WB)
    ETHR_SU_DW_NATMC_FUNC__(init_wb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_ACQB)
    ETHR_SU_DW_NATMC_FUNC__(init_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RELB)
    ETHR_SU_DW_NATMC_FUNC__(init_relb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_MB)
    ETHR_SU_DW_NATMC_FUNC__(init_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT)
    ETHR_DW_NATMC_FUNC__(init)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RB)
    ETHR_DW_NATMC_FUNC__(init_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_WB)
    ETHR_DW_NATMC_FUNC__(init_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_ACQB)
    ETHR_DW_NATMC_FUNC__(init_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RELB)
    ETHR_DW_NATMC_FUNC__(init_relb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_MB)
    ETHR_DW_NATMC_FUNC__(init_mb)(&var->native, val->sint);
#else
    ETHR_DW_ATMC_FUNC__(set)(var, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(init)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(init_rb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_INIT_RB)
    ETHR_SU_DW_NATMC_FUNC__(init_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT)
    ETHR_SU_DW_NATMC_FUNC__(init)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_MB)
    ETHR_SU_DW_NATMC_FUNC__(init_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_WB)
    ETHR_SU_DW_NATMC_FUNC__(init_wb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_ACQB)
    ETHR_SU_DW_NATMC_FUNC__(init_acqb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RELB)
    ETHR_SU_DW_NATMC_FUNC__(init_relb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RB)
    ETHR_DW_NATMC_FUNC__(init_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT)
    ETHR_DW_NATMC_FUNC__(init)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_MB)
    ETHR_DW_NATMC_FUNC__(init_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_WB)
    ETHR_DW_NATMC_FUNC__(init_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_ACQB)
    ETHR_DW_NATMC_FUNC__(init_acqb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RELB)
    ETHR_DW_NATMC_FUNC__(init_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    ETHR_DW_ATMC_FUNC__(set_rb)(var, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(init_rb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(init_wb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_INIT_WB)
    ETHR_SU_DW_NATMC_FUNC__(init_wb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_MB)
    ETHR_SU_DW_NATMC_FUNC__(init_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init_relb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_WB)
    ETHR_DW_NATMC_FUNC__(init_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_MB)
    ETHR_DW_NATMC_FUNC__(init_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init_relb)(&var->native, val->sint);
#else
    ETHR_DW_ATMC_FUNC__(set_wb)(var, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(init_wb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(init_acqb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_INIT_ACQB)
    ETHR_SU_DW_NATMC_FUNC__(init_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RB)
    ETHR_SU_DW_NATMC_FUNC__(init_rb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT)
    ETHR_SU_DW_NATMC_FUNC__(init)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_MB)
    ETHR_SU_DW_NATMC_FUNC__(init_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_WB)
    ETHR_SU_DW_NATMC_FUNC__(init_wb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RELB)
    ETHR_SU_DW_NATMC_FUNC__(init_relb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_ACQB)
    ETHR_DW_NATMC_FUNC__(init_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RB)
    ETHR_DW_NATMC_FUNC__(init_rb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT)
    ETHR_DW_NATMC_FUNC__(init)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_MB)
    ETHR_DW_NATMC_FUNC__(init_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_WB)
    ETHR_DW_NATMC_FUNC__(init_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RELB)
    ETHR_DW_NATMC_FUNC__(init_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    ETHR_DW_ATMC_FUNC__(set_acqb)(var, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(init_acqb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(init_relb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_INIT_RELB)
    ETHR_SU_DW_NATMC_FUNC__(init_relb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_FUNC__(init_wb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_MB)
    ETHR_SU_DW_NATMC_FUNC__(init_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init_rb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RELB)
    ETHR_DW_NATMC_FUNC__(init_relb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(init_wb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_MB)
    ETHR_DW_NATMC_FUNC__(init_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init_rb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init_acqb)(&var->native, val->sint);
#else
    ETHR_DW_ATMC_FUNC__(set_relb)(var, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(init_relb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(init_mb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    if (ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__) {
#endif

#if defined(ETHR_HAVE_SU_DW_NATMC_INIT_MB)
    ETHR_SU_DW_NATMC_FUNC__(init_mb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RELB)
    ETHR_SU_DW_NATMC_FUNC__(init_relb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init_acqb)(&var->native, val->dw_sint);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_SU_DW_NATMC_FUNC__(init_wb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init_rb)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_SU_DW_NATMC_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_SU_DW_NATMC_FUNC__(init)(&var->native, val->dw_sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_MB)
    ETHR_DW_NATMC_FUNC__(init_mb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RELB)
    ETHR_DW_NATMC_FUNC__(init_relb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init_acqb)(&var->native, val->sint);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_DW_NATMC_FUNC__(init_wb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init_rb)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_DW_NATMC_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_DW_NATMC_FUNC__(init)(&var->native, val->sint);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    ETHR_DW_ATMC_FUNC__(set_mb)(var, val);
#endif

#if defined(ETHR_RTCHK_USE_NATIVE_DW_ATOMIC_IMPL__)
    } else { ETHR_DW_ATOMIC_FUNC__(init_mb)(var, val); }
#endif

}

static ETHR_INLINE void ETHR_DW_ATMC_FUNC__(init_ddrb)(ethr_dw_atomic_t *var, ethr_dw_sint_t *val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_DW_ATMC_FUNC__(init)(var, val);
#else
    ETHR_DW_ATMC_FUNC__(init_rb)(var, val);
#endif
}

#endif /* ETHR_DW_ATMC_INLINE__ */


/* ---------- Word size atomic implementation ---------- */


#ifdef ETHR_NEED_ATMC_PROTOTYPES__
ethr_sint_t *ethr_atomic_addr(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_cmpxchg(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val);
ethr_sint_t ethr_atomic_cmpxchg_ddrb(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val);
ethr_sint_t ethr_atomic_cmpxchg_rb(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val);
ethr_sint_t ethr_atomic_cmpxchg_wb(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val);
ethr_sint_t ethr_atomic_cmpxchg_acqb(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val);
ethr_sint_t ethr_atomic_cmpxchg_relb(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val);
ethr_sint_t ethr_atomic_cmpxchg_mb(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val);
ethr_sint_t ethr_atomic_xchg(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_xchg_ddrb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_xchg_rb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_xchg_wb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_xchg_acqb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_xchg_relb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_xchg_mb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_set(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_set_ddrb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_set_rb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_set_wb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_set_acqb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_set_relb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_set_mb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_init(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_init_ddrb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_init_rb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_init_wb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_init_acqb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_init_relb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_init_mb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_add_read(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_add_read_ddrb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_add_read_rb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_add_read_wb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_add_read_acqb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_add_read_relb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_add_read_mb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_read_ddrb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_read_rb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_read_wb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_read_acqb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_read_relb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_read_mb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_inc_read(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_inc_read_ddrb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_inc_read_rb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_inc_read_wb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_inc_read_acqb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_inc_read_relb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_inc_read_mb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_dec_read(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_dec_read_ddrb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_dec_read_rb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_dec_read_wb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_dec_read_acqb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_dec_read_relb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_dec_read_mb(ethr_atomic_t *var);
void ethr_atomic_add(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_add_ddrb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_add_rb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_add_wb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_add_acqb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_add_relb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_add_mb(ethr_atomic_t *var, ethr_sint_t val);
void ethr_atomic_inc(ethr_atomic_t *var);
void ethr_atomic_inc_ddrb(ethr_atomic_t *var);
void ethr_atomic_inc_rb(ethr_atomic_t *var);
void ethr_atomic_inc_wb(ethr_atomic_t *var);
void ethr_atomic_inc_acqb(ethr_atomic_t *var);
void ethr_atomic_inc_relb(ethr_atomic_t *var);
void ethr_atomic_inc_mb(ethr_atomic_t *var);
void ethr_atomic_dec(ethr_atomic_t *var);
void ethr_atomic_dec_ddrb(ethr_atomic_t *var);
void ethr_atomic_dec_rb(ethr_atomic_t *var);
void ethr_atomic_dec_wb(ethr_atomic_t *var);
void ethr_atomic_dec_acqb(ethr_atomic_t *var);
void ethr_atomic_dec_relb(ethr_atomic_t *var);
void ethr_atomic_dec_mb(ethr_atomic_t *var);
ethr_sint_t ethr_atomic_read_band(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_band_ddrb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_band_rb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_band_wb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_band_acqb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_band_relb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_band_mb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_bor(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_bor_ddrb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_bor_rb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_bor_wb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_bor_acqb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_bor_relb(ethr_atomic_t *var, ethr_sint_t val);
ethr_sint_t ethr_atomic_read_bor_mb(ethr_atomic_t *var, ethr_sint_t val);
#endif /* ETHR_NEED_ATMC_PROTOTYPES__ */

#if (defined(ETHR_HAVE_WORD_SZ_NATIVE_ATOMIC_OPS) \
     && (defined(ETHR_ATMC_INLINE__) || defined(ETHR_ATOMIC_IMPL__)))

#if !defined(ETHR_NATMC_BITS__)
#  error "Missing native atomic implementation"
#elif ETHR_NATMC_BITS__ == 64
#  undef ETHR_HAVE_NATMC_CMPXCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG
#    define ETHR_HAVE_NATMC_CMPXCHG 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_RB
#    define ETHR_HAVE_NATMC_CMPXCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_WB
#    define ETHR_HAVE_NATMC_CMPXCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_ACQB
#    define ETHR_HAVE_NATMC_CMPXCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_RELB
#    define ETHR_HAVE_NATMC_CMPXCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_MB
#    define ETHR_HAVE_NATMC_CMPXCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG
#    define ETHR_HAVE_NATMC_XCHG 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_RB
#    define ETHR_HAVE_NATMC_XCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_WB
#    define ETHR_HAVE_NATMC_XCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_ACQB
#    define ETHR_HAVE_NATMC_XCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_RELB
#    define ETHR_HAVE_NATMC_XCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_MB
#    define ETHR_HAVE_NATMC_XCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET
#    define ETHR_HAVE_NATMC_SET 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_RB
#    define ETHR_HAVE_NATMC_SET_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_WB
#    define ETHR_HAVE_NATMC_SET_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_ACQB
#    define ETHR_HAVE_NATMC_SET_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_RELB
#    define ETHR_HAVE_NATMC_SET_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_MB
#    define ETHR_HAVE_NATMC_SET_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT
#    define ETHR_HAVE_NATMC_INIT 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_RB
#    define ETHR_HAVE_NATMC_INIT_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_WB
#    define ETHR_HAVE_NATMC_INIT_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_ACQB
#    define ETHR_HAVE_NATMC_INIT_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_RELB
#    define ETHR_HAVE_NATMC_INIT_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_MB
#    define ETHR_HAVE_NATMC_INIT_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN
#    define ETHR_HAVE_NATMC_ADD_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_RB
#    define ETHR_HAVE_NATMC_ADD_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_WB
#    define ETHR_HAVE_NATMC_ADD_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_ACQB
#    define ETHR_HAVE_NATMC_ADD_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_RELB
#    define ETHR_HAVE_NATMC_ADD_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_MB
#    define ETHR_HAVE_NATMC_ADD_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ
#    define ETHR_HAVE_NATMC_READ 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_RB
#    define ETHR_HAVE_NATMC_READ_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_WB
#    define ETHR_HAVE_NATMC_READ_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_ACQB
#    define ETHR_HAVE_NATMC_READ_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_RELB
#    define ETHR_HAVE_NATMC_READ_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_MB
#    define ETHR_HAVE_NATMC_READ_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN
#    define ETHR_HAVE_NATMC_INC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_RB
#    define ETHR_HAVE_NATMC_INC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_WB
#    define ETHR_HAVE_NATMC_INC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_ACQB
#    define ETHR_HAVE_NATMC_INC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_RELB
#    define ETHR_HAVE_NATMC_INC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_MB
#    define ETHR_HAVE_NATMC_INC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN
#    define ETHR_HAVE_NATMC_DEC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_RB
#    define ETHR_HAVE_NATMC_DEC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_WB
#    define ETHR_HAVE_NATMC_DEC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_ACQB
#    define ETHR_HAVE_NATMC_DEC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_RELB
#    define ETHR_HAVE_NATMC_DEC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_MB
#    define ETHR_HAVE_NATMC_DEC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD
#    define ETHR_HAVE_NATMC_ADD 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RB
#    define ETHR_HAVE_NATMC_ADD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_WB
#    define ETHR_HAVE_NATMC_ADD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_ACQB
#    define ETHR_HAVE_NATMC_ADD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RELB
#    define ETHR_HAVE_NATMC_ADD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_MB
#    define ETHR_HAVE_NATMC_ADD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC
#    define ETHR_HAVE_NATMC_INC 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RB
#    define ETHR_HAVE_NATMC_INC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_WB
#    define ETHR_HAVE_NATMC_INC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_ACQB
#    define ETHR_HAVE_NATMC_INC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RELB
#    define ETHR_HAVE_NATMC_INC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_MB
#    define ETHR_HAVE_NATMC_INC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC
#    define ETHR_HAVE_NATMC_DEC 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RB
#    define ETHR_HAVE_NATMC_DEC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_WB
#    define ETHR_HAVE_NATMC_DEC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_ACQB
#    define ETHR_HAVE_NATMC_DEC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RELB
#    define ETHR_HAVE_NATMC_DEC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_MB
#    define ETHR_HAVE_NATMC_DEC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD
#    define ETHR_HAVE_NATMC_AND_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_RB
#    define ETHR_HAVE_NATMC_AND_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_WB
#    define ETHR_HAVE_NATMC_AND_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_ACQB
#    define ETHR_HAVE_NATMC_AND_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_RELB
#    define ETHR_HAVE_NATMC_AND_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_MB
#    define ETHR_HAVE_NATMC_AND_RETOLD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD
#    define ETHR_HAVE_NATMC_OR_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_RB
#    define ETHR_HAVE_NATMC_OR_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_WB
#    define ETHR_HAVE_NATMC_OR_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_ACQB
#    define ETHR_HAVE_NATMC_OR_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_RELB
#    define ETHR_HAVE_NATMC_OR_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_MB
#    define ETHR_HAVE_NATMC_OR_RETOLD_MB 1
#  endif
#elif ETHR_NATMC_BITS__ == 32
#  undef ETHR_HAVE_NATMC_CMPXCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG
#    define ETHR_HAVE_NATMC_CMPXCHG 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_RB
#    define ETHR_HAVE_NATMC_CMPXCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_WB
#    define ETHR_HAVE_NATMC_CMPXCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_ACQB
#    define ETHR_HAVE_NATMC_CMPXCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_RELB
#    define ETHR_HAVE_NATMC_CMPXCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_CMPXCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_MB
#    define ETHR_HAVE_NATMC_CMPXCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG
#    define ETHR_HAVE_NATMC_XCHG 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_RB
#    define ETHR_HAVE_NATMC_XCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_WB
#    define ETHR_HAVE_NATMC_XCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_ACQB
#    define ETHR_HAVE_NATMC_XCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_RELB
#    define ETHR_HAVE_NATMC_XCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_XCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_MB
#    define ETHR_HAVE_NATMC_XCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET
#    define ETHR_HAVE_NATMC_SET 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_RB
#    define ETHR_HAVE_NATMC_SET_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_WB
#    define ETHR_HAVE_NATMC_SET_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_ACQB
#    define ETHR_HAVE_NATMC_SET_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_RELB
#    define ETHR_HAVE_NATMC_SET_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_SET_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_MB
#    define ETHR_HAVE_NATMC_SET_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT
#    define ETHR_HAVE_NATMC_INIT 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_RB
#    define ETHR_HAVE_NATMC_INIT_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_WB
#    define ETHR_HAVE_NATMC_INIT_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_ACQB
#    define ETHR_HAVE_NATMC_INIT_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_RELB
#    define ETHR_HAVE_NATMC_INIT_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_INIT_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_MB
#    define ETHR_HAVE_NATMC_INIT_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN
#    define ETHR_HAVE_NATMC_ADD_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_RB
#    define ETHR_HAVE_NATMC_ADD_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_WB
#    define ETHR_HAVE_NATMC_ADD_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_ACQB
#    define ETHR_HAVE_NATMC_ADD_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_RELB
#    define ETHR_HAVE_NATMC_ADD_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_MB
#    define ETHR_HAVE_NATMC_ADD_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ
#    define ETHR_HAVE_NATMC_READ 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_RB
#    define ETHR_HAVE_NATMC_READ_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_WB
#    define ETHR_HAVE_NATMC_READ_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_ACQB
#    define ETHR_HAVE_NATMC_READ_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_RELB
#    define ETHR_HAVE_NATMC_READ_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_READ_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_MB
#    define ETHR_HAVE_NATMC_READ_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN
#    define ETHR_HAVE_NATMC_INC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_RB
#    define ETHR_HAVE_NATMC_INC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_WB
#    define ETHR_HAVE_NATMC_INC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_ACQB
#    define ETHR_HAVE_NATMC_INC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_RELB
#    define ETHR_HAVE_NATMC_INC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_MB
#    define ETHR_HAVE_NATMC_INC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN
#    define ETHR_HAVE_NATMC_DEC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_RB
#    define ETHR_HAVE_NATMC_DEC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_WB
#    define ETHR_HAVE_NATMC_DEC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_ACQB
#    define ETHR_HAVE_NATMC_DEC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_RELB
#    define ETHR_HAVE_NATMC_DEC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_MB
#    define ETHR_HAVE_NATMC_DEC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD
#    define ETHR_HAVE_NATMC_ADD 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RB
#    define ETHR_HAVE_NATMC_ADD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_WB
#    define ETHR_HAVE_NATMC_ADD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_ACQB
#    define ETHR_HAVE_NATMC_ADD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RELB
#    define ETHR_HAVE_NATMC_ADD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_ADD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_MB
#    define ETHR_HAVE_NATMC_ADD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC
#    define ETHR_HAVE_NATMC_INC 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RB
#    define ETHR_HAVE_NATMC_INC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_WB
#    define ETHR_HAVE_NATMC_INC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_ACQB
#    define ETHR_HAVE_NATMC_INC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RELB
#    define ETHR_HAVE_NATMC_INC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_INC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_MB
#    define ETHR_HAVE_NATMC_INC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC
#    define ETHR_HAVE_NATMC_DEC 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RB
#    define ETHR_HAVE_NATMC_DEC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_WB
#    define ETHR_HAVE_NATMC_DEC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_ACQB
#    define ETHR_HAVE_NATMC_DEC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RELB
#    define ETHR_HAVE_NATMC_DEC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_DEC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_MB
#    define ETHR_HAVE_NATMC_DEC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD
#    define ETHR_HAVE_NATMC_AND_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_RB
#    define ETHR_HAVE_NATMC_AND_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_WB
#    define ETHR_HAVE_NATMC_AND_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_ACQB
#    define ETHR_HAVE_NATMC_AND_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_RELB
#    define ETHR_HAVE_NATMC_AND_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_AND_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_MB
#    define ETHR_HAVE_NATMC_AND_RETOLD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD
#    define ETHR_HAVE_NATMC_OR_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_RB
#    define ETHR_HAVE_NATMC_OR_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_WB
#    define ETHR_HAVE_NATMC_OR_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_ACQB
#    define ETHR_HAVE_NATMC_OR_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_RELB
#    define ETHR_HAVE_NATMC_OR_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC_OR_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_MB
#    define ETHR_HAVE_NATMC_OR_RETOLD_MB 1
#  endif
#else
#  error "Invalid native atomic size"
#endif

#if (!defined(ETHR_HAVE_NATMC_CMPXCHG) \
     && !defined(ETHR_HAVE_NATMC_CMPXCHG_RB) \
     && !defined(ETHR_HAVE_NATMC_CMPXCHG_WB) \
     && !defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB) \
     && !defined(ETHR_HAVE_NATMC_CMPXCHG_RELB) \
     && !defined(ETHR_HAVE_NATMC_CMPXCHG_MB))
#  error "No native cmpxchg() op available"
#endif


/*
 * Read op used together with cmpxchg() fallback when no native op present.
 */
#if defined(ETHR_HAVE_NATMC_READ)
#define ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC_FUNC__(read)(VAR)
#elif defined(ETHR_HAVE_NATMC_READ_RB)
#define ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC_FUNC__(read_rb)(VAR)
#elif defined(ETHR_HAVE_NATMC_READ_WB)
#define ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC_FUNC__(read_wb)(VAR)
#elif defined(ETHR_HAVE_NATMC_READ_ACQB)
#define ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC_FUNC__(read_acqb)(VAR)
#elif defined(ETHR_HAVE_NATMC_READ_RELB)
#define ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC_FUNC__(read_relb)(VAR)
#elif defined(ETHR_HAVE_NATMC_READ_MB)
#define ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC_FUNC__(read_mb)(VAR)
#else
/*
 * We have no native read() op; guess zero and then use the
 * the atomics actual value returned from cmpxchg().
 */
#define ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR) \
  ((ETHR_NAINT_T__) 0)
#endif

/*
 * Native cmpxchg() fallback used when no native op present.
 */
#define ETHR_NATMC_CMPXCHG_FALLBACK__(CMPXCHG, VAR, AVAL, OPS) \
do { \
    ethr_sint_t AVAL; \
    ETHR_NAINT_T__ new__, act__, exp__; \
    act__ = ETHR_NATMC_CMPXCHG_FALLBACK_READ__(VAR); \
    do { \
	exp__ = act__; \
	AVAL = (ethr_sint_t) act__; \
	{ OPS; } \
	new__ = (ETHR_NAINT_T__) AVAL; \
	act__ = CMPXCHG(VAR, new__, exp__); \
    } while (__builtin_expect(act__ != exp__, 0)); \
} while (0)



/* --- addr() --- */

static ETHR_INLINE ethr_sint_t *ETHR_ATMC_FUNC__(addr)(ethr_atomic_t *var)
{
    return (ethr_sint_t *) ETHR_NATMC_ADDR_FUNC__(var);

}


/* --- cmpxchg() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(cmpxchg)(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_CMPXCHG)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#else
#error "Missing implementation of ethr_atomic_cmpxchg()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(cmpxchg_rb)(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic_cmpxchg_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(cmpxchg_wb)(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#else
#error "Missing implementation of ethr_atomic_cmpxchg_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(cmpxchg_acqb)(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_cmpxchg_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(cmpxchg_relb)(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#else
#error "Missing implementation of ethr_atomic_cmpxchg_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(cmpxchg_mb)(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(cmpxchg)(var, (ETHR_NAINT_T__) val, (ETHR_NAINT_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_cmpxchg_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(cmpxchg_ddrb)(ethr_atomic_t *var, ethr_sint_t val, ethr_sint_t old_val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(cmpxchg)(var, val, old_val);
#else
    return ETHR_ATMC_FUNC__(cmpxchg_rb)(var, val, old_val);
#endif
}


/* --- xchg() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(xchg)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_XCHG)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#else
#error "Missing implementation of ethr_atomic_xchg()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(xchg_rb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_XCHG_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_XCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_XCHG_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_acqb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_XCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic_xchg_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(xchg_wb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_XCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
#else
#error "Missing implementation of ethr_atomic_xchg_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(xchg_acqb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_XCHG_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_XCHG)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_XCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_XCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_xchg_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(xchg_relb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_XCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#else
#error "Missing implementation of ethr_atomic_xchg_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(xchg_mb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_XCHG_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_XCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_XCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_XCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_XCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(xchg)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_xchg_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(xchg_ddrb)(ethr_atomic_t *var, ethr_sint_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(xchg)(var, val);
#else
    return ETHR_ATMC_FUNC__(xchg_rb)(var, val);
#endif
}


/* --- set() --- */


static ETHR_INLINE void ETHR_ATMC_FUNC__(set)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_SET)
    ETHR_NATMC_FUNC__(set)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_RB)
    ETHR_NATMC_FUNC__(set_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_WB)
    ETHR_NATMC_FUNC__(set_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_ACQB)
    ETHR_NATMC_FUNC__(set_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_RELB)
    ETHR_NATMC_FUNC__(set_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_MB)
    ETHR_NATMC_FUNC__(set_mb)(var, (ETHR_NAINT_T__) val);
#else
    (void) ETHR_ATMC_FUNC__(xchg)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(set_rb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_SET_RB)
    ETHR_NATMC_FUNC__(set_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET)
    ETHR_NATMC_FUNC__(set)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_SET_MB)
    ETHR_NATMC_FUNC__(set_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_WB)
    ETHR_NATMC_FUNC__(set_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_SET_ACQB)
    ETHR_NATMC_FUNC__(set_acqb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_SET_RELB)
    ETHR_NATMC_FUNC__(set_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC_FUNC__(xchg_rb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(set_wb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_SET_WB)
    ETHR_NATMC_FUNC__(set_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_MB)
    ETHR_NATMC_FUNC__(set_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set_relb)(var, (ETHR_NAINT_T__) val);
#else
    (void) ETHR_ATMC_FUNC__(xchg_wb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(set_acqb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_SET_ACQB)
    ETHR_NATMC_FUNC__(set_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_RB)
    ETHR_NATMC_FUNC__(set_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_SET)
    ETHR_NATMC_FUNC__(set)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_SET_MB)
    ETHR_NATMC_FUNC__(set_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_WB)
    ETHR_NATMC_FUNC__(set_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_SET_RELB)
    ETHR_NATMC_FUNC__(set_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(xchg_acqb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(set_relb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_SET_RELB)
    ETHR_NATMC_FUNC__(set_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_NATMC_FUNC__(set_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_MB)
    ETHR_NATMC_FUNC__(set_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set_acqb)(var, (ETHR_NAINT_T__) val);
#else
    (void) ETHR_ATMC_FUNC__(xchg_relb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(set_mb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_SET_MB)
    ETHR_NATMC_FUNC__(set_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_RELB)
    ETHR_NATMC_FUNC__(set_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_NATMC_FUNC__(set_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(set)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(xchg_mb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(set_ddrb)(ethr_atomic_t *var, ethr_sint_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC_FUNC__(set)(var, val);
#else
    ETHR_ATMC_FUNC__(set_rb)(var, val);
#endif
}


/* --- init() --- */


static ETHR_INLINE void ETHR_ATMC_FUNC__(init)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_INIT)
    ETHR_NATMC_FUNC__(init)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_RB)
    ETHR_NATMC_FUNC__(init_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_WB)
    ETHR_NATMC_FUNC__(init_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_ACQB)
    ETHR_NATMC_FUNC__(init_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_RELB)
    ETHR_NATMC_FUNC__(init_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_MB)
    ETHR_NATMC_FUNC__(init_mb)(var, (ETHR_NAINT_T__) val);
#else
    ETHR_ATMC_FUNC__(set)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(init_rb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_INIT_RB)
    ETHR_NATMC_FUNC__(init_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT)
    ETHR_NATMC_FUNC__(init)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INIT_MB)
    ETHR_NATMC_FUNC__(init_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_WB)
    ETHR_NATMC_FUNC__(init_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INIT_ACQB)
    ETHR_NATMC_FUNC__(init_acqb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INIT_RELB)
    ETHR_NATMC_FUNC__(init_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    ETHR_ATMC_FUNC__(set_rb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(init_wb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_INIT_WB)
    ETHR_NATMC_FUNC__(init_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_MB)
    ETHR_NATMC_FUNC__(init_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init_relb)(var, (ETHR_NAINT_T__) val);
#else
    ETHR_ATMC_FUNC__(set_wb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(init_acqb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_INIT_ACQB)
    ETHR_NATMC_FUNC__(init_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_RB)
    ETHR_NATMC_FUNC__(init_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INIT)
    ETHR_NATMC_FUNC__(init)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INIT_MB)
    ETHR_NATMC_FUNC__(init_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_WB)
    ETHR_NATMC_FUNC__(init_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INIT_RELB)
    ETHR_NATMC_FUNC__(init_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    ETHR_ATMC_FUNC__(set_acqb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(init_relb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_INIT_RELB)
    ETHR_NATMC_FUNC__(init_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(init_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_MB)
    ETHR_NATMC_FUNC__(init_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init_acqb)(var, (ETHR_NAINT_T__) val);
#else
    ETHR_ATMC_FUNC__(set_relb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(init_mb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_INIT_MB)
    ETHR_NATMC_FUNC__(init_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_RELB)
    ETHR_NATMC_FUNC__(init_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(init_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC_FUNC__(init)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    ETHR_ATMC_FUNC__(set_mb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(init_ddrb)(ethr_atomic_t *var, ethr_sint_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC_FUNC__(init)(var, val);
#else
    ETHR_ATMC_FUNC__(init_rb)(var, val);
#endif
}


/* --- add_read() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(add_read)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_ADD_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#else
#error "Missing implementation of ethr_atomic_add_read()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(add_read_rb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_ADD_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_acqb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic_add_read_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(add_read_wb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_ADD_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
#else
#error "Missing implementation of ethr_atomic_add_read_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(add_read_acqb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_ADD_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_add_read_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(add_read_relb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_ADD_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#else
#error "Missing implementation of ethr_atomic_add_read_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(add_read_mb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_ADD_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(add_return)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_add_read_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(add_read_ddrb)(ethr_atomic_t *var, ethr_sint_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(add_read)(var, val);
#else
    return ETHR_ATMC_FUNC__(add_read_rb)(var, val);
#endif
}


/* --- read() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_READ)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read)(var);
#elif defined(ETHR_HAVE_NATMC_READ_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_wb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_relb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_mb)(var);
#else
    res = ETHR_ATMC_FUNC__(cmpxchg)(var, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_rb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_READ_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC_READ)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_READ_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_READ_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_READ_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    res = ETHR_ATMC_FUNC__(cmpxchg_rb)(var, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_wb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_READ_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_wb)(var);
#elif defined(ETHR_HAVE_NATMC_READ)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read)(var);
#elif defined(ETHR_HAVE_NATMC_READ_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_relb)(var);
#else
    res = ETHR_ATMC_FUNC__(cmpxchg_wb)(var, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_acqb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_READ_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC_READ)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC_READ_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC_READ_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#else
    res = ETHR_ATMC_FUNC__(cmpxchg_acqb)(var, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_relb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_READ_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_relb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_wb)(var);
#elif defined(ETHR_HAVE_NATMC_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read)(var);
#elif defined(ETHR_HAVE_NATMC_READ_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_acqb)(var);
#else
    res = ETHR_ATMC_FUNC__(cmpxchg_relb)(var, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_mb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_READ_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(read)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#else
    res = ETHR_ATMC_FUNC__(cmpxchg_mb)(var, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__, (ethr_sint_t) ETHR_UNUSUAL_SINT_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_ddrb)(ethr_atomic_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(read)(var);
#else
    return ETHR_ATMC_FUNC__(read_rb)(var);
#endif
}


/* --- inc_read() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(inc_read)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_INC_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_mb)(var);
#else
    res = ETHR_ATMC_FUNC__(add_read)(var, (ethr_sint_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(inc_read_rb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_INC_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    res = ETHR_ATMC_FUNC__(add_read_rb)(var, (ethr_sint_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(inc_read_wb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_INC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_relb)(var);
#else
    res = ETHR_ATMC_FUNC__(add_read_wb)(var, (ethr_sint_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(inc_read_acqb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_INC_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC_FUNC__(add_read_acqb)(var, (ethr_sint_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(inc_read_relb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_INC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_acqb)(var);
#else
    res = ETHR_ATMC_FUNC__(add_read_relb)(var, (ethr_sint_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(inc_read_mb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_INC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(inc_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC_FUNC__(add_read_mb)(var, (ethr_sint_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(inc_read_ddrb)(ethr_atomic_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(inc_read)(var);
#else
    return ETHR_ATMC_FUNC__(inc_read_rb)(var);
#endif
}


/* --- dec_read() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(dec_read)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_DEC_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_mb)(var);
#else
    res = ETHR_ATMC_FUNC__(add_read)(var, (ethr_sint_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(dec_read_rb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_DEC_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    res = ETHR_ATMC_FUNC__(add_read_rb)(var, (ethr_sint_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(dec_read_wb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_DEC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_relb)(var);
#else
    res = ETHR_ATMC_FUNC__(add_read_wb)(var, (ethr_sint_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(dec_read_acqb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_DEC_RETURN_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC_FUNC__(add_read_acqb)(var, (ethr_sint_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(dec_read_relb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_DEC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_acqb)(var);
#else
    res = ETHR_ATMC_FUNC__(add_read_relb)(var, (ethr_sint_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(dec_read_mb)(ethr_atomic_t *var)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_DEC_RETURN_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(dec_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC_FUNC__(add_read_mb)(var, (ethr_sint_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(dec_read_ddrb)(ethr_atomic_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(dec_read)(var);
#else
    return ETHR_ATMC_FUNC__(dec_read_rb)(var);
#endif
}


/* --- add() --- */


static ETHR_INLINE void ETHR_ATMC_FUNC__(add)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_ADD)
    ETHR_NATMC_FUNC__(add)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RB)
    ETHR_NATMC_FUNC__(add_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_WB)
    ETHR_NATMC_FUNC__(add_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_ACQB)
    ETHR_NATMC_FUNC__(add_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RELB)
    ETHR_NATMC_FUNC__(add_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_MB)
    ETHR_NATMC_FUNC__(add_mb)(var, (ETHR_NAINT_T__) val);
#else
    (void) ETHR_ATMC_FUNC__(add_read)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(add_rb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_ADD_RB)
    ETHR_NATMC_FUNC__(add_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD)
    ETHR_NATMC_FUNC__(add)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_ADD_MB)
    ETHR_NATMC_FUNC__(add_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_WB)
    ETHR_NATMC_FUNC__(add_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_ADD_ACQB)
    ETHR_NATMC_FUNC__(add_acqb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_ADD_RELB)
    ETHR_NATMC_FUNC__(add_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC_FUNC__(add_read_rb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(add_wb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_ADD_WB)
    ETHR_NATMC_FUNC__(add_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(add)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_MB)
    ETHR_NATMC_FUNC__(add_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(add_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(add_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(add_relb)(var, (ETHR_NAINT_T__) val);
#else
    (void) ETHR_ATMC_FUNC__(add_read_wb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(add_acqb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_ADD_ACQB)
    ETHR_NATMC_FUNC__(add_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RB)
    ETHR_NATMC_FUNC__(add_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD)
    ETHR_NATMC_FUNC__(add)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_MB)
    ETHR_NATMC_FUNC__(add_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_WB)
    ETHR_NATMC_FUNC__(add_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RELB)
    ETHR_NATMC_FUNC__(add_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(add_read_acqb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(add_relb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_ADD_RELB)
    ETHR_NATMC_FUNC__(add_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_MB)
    ETHR_NATMC_FUNC__(add_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add_acqb)(var, (ETHR_NAINT_T__) val);
#else
    (void) ETHR_ATMC_FUNC__(add_read_relb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(add_mb)(ethr_atomic_t *var, ethr_sint_t val)
{
#if defined(ETHR_HAVE_NATMC_ADD_MB)
    ETHR_NATMC_FUNC__(add_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_RELB)
    ETHR_NATMC_FUNC__(add_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_ADD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_ADD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(add)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(add_read_mb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(add_ddrb)(ethr_atomic_t *var, ethr_sint_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC_FUNC__(add)(var, val);
#else
    ETHR_ATMC_FUNC__(add_rb)(var, val);
#endif
}


/* --- inc() --- */


static ETHR_INLINE void ETHR_ATMC_FUNC__(inc)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_INC)
    ETHR_NATMC_FUNC__(inc)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RB)
    ETHR_NATMC_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_WB)
    ETHR_NATMC_FUNC__(inc_wb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_ACQB)
    ETHR_NATMC_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RELB)
    ETHR_NATMC_FUNC__(inc_relb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_MB)
    ETHR_NATMC_FUNC__(inc_mb)(var);
#else
    (void) ETHR_ATMC_FUNC__(inc_read)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(inc_rb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_INC_RB)
    ETHR_NATMC_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC)
    ETHR_NATMC_FUNC__(inc)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INC_MB)
    ETHR_NATMC_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_WB)
    ETHR_NATMC_FUNC__(inc_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INC_ACQB)
    ETHR_NATMC_FUNC__(inc_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_INC_RELB)
    ETHR_NATMC_FUNC__(inc_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC_FUNC__(inc_read_rb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(inc_wb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_INC_WB)
    ETHR_NATMC_FUNC__(inc_wb)(var);
#elif defined(ETHR_HAVE_NATMC_INC)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(inc)(var);
#elif defined(ETHR_HAVE_NATMC_INC_MB)
    ETHR_NATMC_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(inc_relb)(var);
#else
    (void) ETHR_ATMC_FUNC__(inc_read_wb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(inc_acqb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_INC_ACQB)
    ETHR_NATMC_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RB)
    ETHR_NATMC_FUNC__(inc_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC)
    ETHR_NATMC_FUNC__(inc)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_MB)
    ETHR_NATMC_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_WB)
    ETHR_NATMC_FUNC__(inc_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RELB)
    ETHR_NATMC_FUNC__(inc_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(inc_read_acqb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(inc_relb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_INC_RELB)
    ETHR_NATMC_FUNC__(inc_relb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc_wb)(var);
#elif defined(ETHR_HAVE_NATMC_INC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc)(var);
#elif defined(ETHR_HAVE_NATMC_INC_MB)
    ETHR_NATMC_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc_acqb)(var);
#else
    (void) ETHR_ATMC_FUNC__(inc_read_relb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(inc_mb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_INC_MB)
    ETHR_NATMC_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_RELB)
    ETHR_NATMC_FUNC__(inc_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_INC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_INC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(inc)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(inc_read_mb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(inc_ddrb)(ethr_atomic_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC_FUNC__(inc)(var);
#else
    ETHR_ATMC_FUNC__(inc_rb)(var);
#endif
}


/* --- dec() --- */


static ETHR_INLINE void ETHR_ATMC_FUNC__(dec)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_DEC)
    ETHR_NATMC_FUNC__(dec)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RB)
    ETHR_NATMC_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_WB)
    ETHR_NATMC_FUNC__(dec_wb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_ACQB)
    ETHR_NATMC_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RELB)
    ETHR_NATMC_FUNC__(dec_relb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_MB)
    ETHR_NATMC_FUNC__(dec_mb)(var);
#else
    (void) ETHR_ATMC_FUNC__(dec_read)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(dec_rb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_DEC_RB)
    ETHR_NATMC_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC)
    ETHR_NATMC_FUNC__(dec)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_DEC_MB)
    ETHR_NATMC_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_WB)
    ETHR_NATMC_FUNC__(dec_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_DEC_ACQB)
    ETHR_NATMC_FUNC__(dec_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_DEC_RELB)
    ETHR_NATMC_FUNC__(dec_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC_FUNC__(dec_read_rb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(dec_wb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_DEC_WB)
    ETHR_NATMC_FUNC__(dec_wb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(dec)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_MB)
    ETHR_NATMC_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_FUNC__(dec_relb)(var);
#else
    (void) ETHR_ATMC_FUNC__(dec_read_wb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(dec_acqb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_DEC_ACQB)
    ETHR_NATMC_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RB)
    ETHR_NATMC_FUNC__(dec_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC)
    ETHR_NATMC_FUNC__(dec)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_MB)
    ETHR_NATMC_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_WB)
    ETHR_NATMC_FUNC__(dec_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RELB)
    ETHR_NATMC_FUNC__(dec_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(dec_read_acqb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(dec_relb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_DEC_RELB)
    ETHR_NATMC_FUNC__(dec_relb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec_wb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_MB)
    ETHR_NATMC_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec_acqb)(var);
#else
    (void) ETHR_ATMC_FUNC__(dec_read_relb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(dec_mb)(ethr_atomic_t *var)
{
#if defined(ETHR_HAVE_NATMC_DEC_MB)
    ETHR_NATMC_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_RELB)
    ETHR_NATMC_FUNC__(dec_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC_DEC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_DEC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_FUNC__(dec)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC_FUNC__(dec_read_mb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC_FUNC__(dec_ddrb)(ethr_atomic_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC_FUNC__(dec)(var);
#else
    ETHR_ATMC_FUNC__(dec_rb)(var);
#endif
}


/* --- read_band() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_band)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_AND_RETOLD)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#else
#error "Missing implementation of ethr_atomic_read_band()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_band_rb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_AND_RETOLD_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_acqb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic_read_band_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_band_wb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_AND_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
#else
#error "Missing implementation of ethr_atomic_read_band_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_band_acqb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_AND_RETOLD_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_read_band_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_band_relb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_AND_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#else
#error "Missing implementation of ethr_atomic_read_band_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_band_mb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_AND_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_AND_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(and_retold)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_read_band_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_band_ddrb)(ethr_atomic_t *var, ethr_sint_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(read_band)(var, val);
#else
    return ETHR_ATMC_FUNC__(read_band_rb)(var, val);
#endif
}


/* --- read_bor() --- */


static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_bor)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_OR_RETOLD)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#else
#error "Missing implementation of ethr_atomic_read_bor()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_bor_rb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_OR_RETOLD_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_acqb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic_read_bor_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_bor_wb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_OR_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
#else
#error "Missing implementation of ethr_atomic_read_bor_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_bor_acqb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_OR_RETOLD_ACQB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_WB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_read_bor_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_bor_relb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_OR_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_relb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_wb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_rb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#else
#error "Missing implementation of ethr_atomic_read_bor_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_bor_mb)(ethr_atomic_t *var, ethr_sint_t val)
{
    ethr_sint_t res;
#if defined(ETHR_HAVE_NATMC_OR_RETOLD_MB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_mb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RELB)
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_relb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_acqb)(var, (ETHR_NAINT_T__) val);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_wb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold_rb)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_OR_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint_t) ETHR_NATMC_FUNC__(or_retold)(var, (ETHR_NAINT_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_MB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RELB)
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC_CMPXCHG_FALLBACK__(ETHR_NATMC_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic_read_bor_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint_t ETHR_ATMC_FUNC__(read_bor_ddrb)(ethr_atomic_t *var, ethr_sint_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC_FUNC__(read_bor)(var, val);
#else
    return ETHR_ATMC_FUNC__(read_bor_rb)(var, val);
#endif
}

#endif /* ETHR_ATMC_INLINE__ */


/* ---------- 32-bit atomic implementation ---------- */


#ifdef ETHR_NEED_ATMC32_PROTOTYPES__
ethr_sint32_t *ethr_atomic32_addr(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_cmpxchg(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val);
ethr_sint32_t ethr_atomic32_cmpxchg_ddrb(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val);
ethr_sint32_t ethr_atomic32_cmpxchg_rb(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val);
ethr_sint32_t ethr_atomic32_cmpxchg_wb(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val);
ethr_sint32_t ethr_atomic32_cmpxchg_acqb(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val);
ethr_sint32_t ethr_atomic32_cmpxchg_relb(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val);
ethr_sint32_t ethr_atomic32_cmpxchg_mb(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val);
ethr_sint32_t ethr_atomic32_xchg(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_xchg_ddrb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_xchg_rb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_xchg_wb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_xchg_acqb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_xchg_relb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_xchg_mb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_set(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_set_ddrb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_set_rb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_set_wb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_set_acqb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_set_relb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_set_mb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_init(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_init_ddrb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_init_rb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_init_wb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_init_acqb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_init_relb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_init_mb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_add_read(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_add_read_ddrb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_add_read_rb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_add_read_wb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_add_read_acqb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_add_read_relb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_add_read_mb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_read_ddrb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_read_rb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_read_wb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_read_acqb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_read_relb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_read_mb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_inc_read(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_inc_read_ddrb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_inc_read_rb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_inc_read_wb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_inc_read_acqb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_inc_read_relb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_inc_read_mb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_dec_read(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_dec_read_ddrb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_dec_read_rb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_dec_read_wb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_dec_read_acqb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_dec_read_relb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_dec_read_mb(ethr_atomic32_t *var);
void ethr_atomic32_add(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_add_ddrb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_add_rb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_add_wb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_add_acqb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_add_relb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_add_mb(ethr_atomic32_t *var, ethr_sint32_t val);
void ethr_atomic32_inc(ethr_atomic32_t *var);
void ethr_atomic32_inc_ddrb(ethr_atomic32_t *var);
void ethr_atomic32_inc_rb(ethr_atomic32_t *var);
void ethr_atomic32_inc_wb(ethr_atomic32_t *var);
void ethr_atomic32_inc_acqb(ethr_atomic32_t *var);
void ethr_atomic32_inc_relb(ethr_atomic32_t *var);
void ethr_atomic32_inc_mb(ethr_atomic32_t *var);
void ethr_atomic32_dec(ethr_atomic32_t *var);
void ethr_atomic32_dec_ddrb(ethr_atomic32_t *var);
void ethr_atomic32_dec_rb(ethr_atomic32_t *var);
void ethr_atomic32_dec_wb(ethr_atomic32_t *var);
void ethr_atomic32_dec_acqb(ethr_atomic32_t *var);
void ethr_atomic32_dec_relb(ethr_atomic32_t *var);
void ethr_atomic32_dec_mb(ethr_atomic32_t *var);
ethr_sint32_t ethr_atomic32_read_band(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_band_ddrb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_band_rb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_band_wb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_band_acqb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_band_relb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_band_mb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_bor(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_bor_ddrb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_bor_rb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_bor_wb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_bor_acqb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_bor_relb(ethr_atomic32_t *var, ethr_sint32_t val);
ethr_sint32_t ethr_atomic32_read_bor_mb(ethr_atomic32_t *var, ethr_sint32_t val);
#endif /* ETHR_NEED_ATMC32_PROTOTYPES__ */

#if (defined(ETHR_HAVE_32BIT_NATIVE_ATOMIC_OPS) \
     && (defined(ETHR_ATMC32_INLINE__) || defined(ETHR_ATOMIC_IMPL__)))

#if !defined(ETHR_NATMC32_BITS__)
#  error "Missing native atomic implementation"
#elif ETHR_NATMC32_BITS__ == 64
#  undef ETHR_HAVE_NATMC32_CMPXCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG
#    define ETHR_HAVE_NATMC32_CMPXCHG 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_RB
#    define ETHR_HAVE_NATMC32_CMPXCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_WB
#    define ETHR_HAVE_NATMC32_CMPXCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_ACQB
#    define ETHR_HAVE_NATMC32_CMPXCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_RELB
#    define ETHR_HAVE_NATMC32_CMPXCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_CMPXCHG_MB
#    define ETHR_HAVE_NATMC32_CMPXCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG
#    define ETHR_HAVE_NATMC32_XCHG 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_RB
#    define ETHR_HAVE_NATMC32_XCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_WB
#    define ETHR_HAVE_NATMC32_XCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_ACQB
#    define ETHR_HAVE_NATMC32_XCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_RELB
#    define ETHR_HAVE_NATMC32_XCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_XCHG_MB
#    define ETHR_HAVE_NATMC32_XCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET
#    define ETHR_HAVE_NATMC32_SET 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_RB
#    define ETHR_HAVE_NATMC32_SET_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_WB
#    define ETHR_HAVE_NATMC32_SET_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_ACQB
#    define ETHR_HAVE_NATMC32_SET_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_RELB
#    define ETHR_HAVE_NATMC32_SET_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_SET_MB
#    define ETHR_HAVE_NATMC32_SET_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT
#    define ETHR_HAVE_NATMC32_INIT 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_RB
#    define ETHR_HAVE_NATMC32_INIT_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_WB
#    define ETHR_HAVE_NATMC32_INIT_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_ACQB
#    define ETHR_HAVE_NATMC32_INIT_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_RELB
#    define ETHR_HAVE_NATMC32_INIT_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INIT_MB
#    define ETHR_HAVE_NATMC32_INIT_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN
#    define ETHR_HAVE_NATMC32_ADD_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_RB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_WB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_ACQB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_RELB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RETURN_MB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ
#    define ETHR_HAVE_NATMC32_READ 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_RB
#    define ETHR_HAVE_NATMC32_READ_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_WB
#    define ETHR_HAVE_NATMC32_READ_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_ACQB
#    define ETHR_HAVE_NATMC32_READ_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_RELB
#    define ETHR_HAVE_NATMC32_READ_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_READ_MB
#    define ETHR_HAVE_NATMC32_READ_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN
#    define ETHR_HAVE_NATMC32_INC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_RB
#    define ETHR_HAVE_NATMC32_INC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_WB
#    define ETHR_HAVE_NATMC32_INC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_ACQB
#    define ETHR_HAVE_NATMC32_INC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_RELB
#    define ETHR_HAVE_NATMC32_INC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RETURN_MB
#    define ETHR_HAVE_NATMC32_INC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN
#    define ETHR_HAVE_NATMC32_DEC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_RB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_WB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_ACQB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_RELB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RETURN_MB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD
#    define ETHR_HAVE_NATMC32_ADD 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RB
#    define ETHR_HAVE_NATMC32_ADD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_WB
#    define ETHR_HAVE_NATMC32_ADD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_ACQB
#    define ETHR_HAVE_NATMC32_ADD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_RELB
#    define ETHR_HAVE_NATMC32_ADD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_ADD_MB
#    define ETHR_HAVE_NATMC32_ADD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC
#    define ETHR_HAVE_NATMC32_INC 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RB
#    define ETHR_HAVE_NATMC32_INC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_WB
#    define ETHR_HAVE_NATMC32_INC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_ACQB
#    define ETHR_HAVE_NATMC32_INC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_RELB
#    define ETHR_HAVE_NATMC32_INC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_INC_MB
#    define ETHR_HAVE_NATMC32_INC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC
#    define ETHR_HAVE_NATMC32_DEC 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RB
#    define ETHR_HAVE_NATMC32_DEC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_WB
#    define ETHR_HAVE_NATMC32_DEC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_ACQB
#    define ETHR_HAVE_NATMC32_DEC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_RELB
#    define ETHR_HAVE_NATMC32_DEC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_DEC_MB
#    define ETHR_HAVE_NATMC32_DEC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD
#    define ETHR_HAVE_NATMC32_AND_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_RB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_WB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_ACQB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_RELB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_AND_RETOLD_MB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD
#    define ETHR_HAVE_NATMC32_OR_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_RB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_WB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_ACQB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_RELB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC64_OR_RETOLD_MB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_MB 1
#  endif
#elif ETHR_NATMC32_BITS__ == 32
#  undef ETHR_HAVE_NATMC32_CMPXCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG
#    define ETHR_HAVE_NATMC32_CMPXCHG 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_RB
#    define ETHR_HAVE_NATMC32_CMPXCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_WB
#    define ETHR_HAVE_NATMC32_CMPXCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_ACQB
#    define ETHR_HAVE_NATMC32_CMPXCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_RELB
#    define ETHR_HAVE_NATMC32_CMPXCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_CMPXCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_CMPXCHG_MB
#    define ETHR_HAVE_NATMC32_CMPXCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG
#    define ETHR_HAVE_NATMC32_XCHG 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_RB
#    define ETHR_HAVE_NATMC32_XCHG_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_WB
#    define ETHR_HAVE_NATMC32_XCHG_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_ACQB
#    define ETHR_HAVE_NATMC32_XCHG_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_RELB
#    define ETHR_HAVE_NATMC32_XCHG_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_XCHG_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_XCHG_MB
#    define ETHR_HAVE_NATMC32_XCHG_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET
#    define ETHR_HAVE_NATMC32_SET 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_RB
#    define ETHR_HAVE_NATMC32_SET_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_WB
#    define ETHR_HAVE_NATMC32_SET_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_ACQB
#    define ETHR_HAVE_NATMC32_SET_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_RELB
#    define ETHR_HAVE_NATMC32_SET_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_SET_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_SET_MB
#    define ETHR_HAVE_NATMC32_SET_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT
#    define ETHR_HAVE_NATMC32_INIT 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_RB
#    define ETHR_HAVE_NATMC32_INIT_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_WB
#    define ETHR_HAVE_NATMC32_INIT_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_ACQB
#    define ETHR_HAVE_NATMC32_INIT_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_RELB
#    define ETHR_HAVE_NATMC32_INIT_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INIT_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INIT_MB
#    define ETHR_HAVE_NATMC32_INIT_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN
#    define ETHR_HAVE_NATMC32_ADD_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_RB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_WB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_ACQB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_RELB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RETURN_MB
#    define ETHR_HAVE_NATMC32_ADD_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ
#    define ETHR_HAVE_NATMC32_READ 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_RB
#    define ETHR_HAVE_NATMC32_READ_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_WB
#    define ETHR_HAVE_NATMC32_READ_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_ACQB
#    define ETHR_HAVE_NATMC32_READ_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_RELB
#    define ETHR_HAVE_NATMC32_READ_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_READ_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_READ_MB
#    define ETHR_HAVE_NATMC32_READ_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN
#    define ETHR_HAVE_NATMC32_INC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_RB
#    define ETHR_HAVE_NATMC32_INC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_WB
#    define ETHR_HAVE_NATMC32_INC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_ACQB
#    define ETHR_HAVE_NATMC32_INC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_RELB
#    define ETHR_HAVE_NATMC32_INC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RETURN_MB
#    define ETHR_HAVE_NATMC32_INC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN
#    define ETHR_HAVE_NATMC32_DEC_RETURN 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_RB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_WB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_ACQB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_RELB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RETURN_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RETURN_MB
#    define ETHR_HAVE_NATMC32_DEC_RETURN_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD
#    define ETHR_HAVE_NATMC32_ADD 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RB
#    define ETHR_HAVE_NATMC32_ADD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_WB
#    define ETHR_HAVE_NATMC32_ADD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_ACQB
#    define ETHR_HAVE_NATMC32_ADD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_RELB
#    define ETHR_HAVE_NATMC32_ADD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_ADD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_ADD_MB
#    define ETHR_HAVE_NATMC32_ADD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC
#    define ETHR_HAVE_NATMC32_INC 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RB
#    define ETHR_HAVE_NATMC32_INC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_WB
#    define ETHR_HAVE_NATMC32_INC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_ACQB
#    define ETHR_HAVE_NATMC32_INC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_RELB
#    define ETHR_HAVE_NATMC32_INC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_INC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_INC_MB
#    define ETHR_HAVE_NATMC32_INC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC
#    define ETHR_HAVE_NATMC32_DEC 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RB
#    define ETHR_HAVE_NATMC32_DEC_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_WB
#    define ETHR_HAVE_NATMC32_DEC_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_ACQB
#    define ETHR_HAVE_NATMC32_DEC_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_RELB
#    define ETHR_HAVE_NATMC32_DEC_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_DEC_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_DEC_MB
#    define ETHR_HAVE_NATMC32_DEC_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD
#    define ETHR_HAVE_NATMC32_AND_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_RB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_WB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_ACQB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_RELB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_AND_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_AND_RETOLD_MB
#    define ETHR_HAVE_NATMC32_AND_RETOLD_MB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD
#    define ETHR_HAVE_NATMC32_OR_RETOLD 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_RB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_RB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_RB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_WB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_WB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_WB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_ACQB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_ACQB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_ACQB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_RELB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_RELB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_RELB 1
#  endif
#  undef ETHR_HAVE_NATMC32_OR_RETOLD_MB
#  ifdef ETHR_HAVE_ETHR_NATIVE_ATOMIC32_OR_RETOLD_MB
#    define ETHR_HAVE_NATMC32_OR_RETOLD_MB 1
#  endif
#else
#  error "Invalid native atomic size"
#endif

#if (!defined(ETHR_HAVE_NATMC32_CMPXCHG) \
     && !defined(ETHR_HAVE_NATMC32_CMPXCHG_RB) \
     && !defined(ETHR_HAVE_NATMC32_CMPXCHG_WB) \
     && !defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB) \
     && !defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB) \
     && !defined(ETHR_HAVE_NATMC32_CMPXCHG_MB))
#  error "No native cmpxchg() op available"
#endif


/*
 * Read op used together with cmpxchg() fallback when no native op present.
 */
#if defined(ETHR_HAVE_NATMC32_READ)
#define ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC32_FUNC__(read)(VAR)
#elif defined(ETHR_HAVE_NATMC32_READ_RB)
#define ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC32_FUNC__(read_rb)(VAR)
#elif defined(ETHR_HAVE_NATMC32_READ_WB)
#define ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC32_FUNC__(read_wb)(VAR)
#elif defined(ETHR_HAVE_NATMC32_READ_ACQB)
#define ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC32_FUNC__(read_acqb)(VAR)
#elif defined(ETHR_HAVE_NATMC32_READ_RELB)
#define ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC32_FUNC__(read_relb)(VAR)
#elif defined(ETHR_HAVE_NATMC32_READ_MB)
#define ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR) \
  ETHR_NATMC32_FUNC__(read_mb)(VAR)
#else
/*
 * We have no native read() op; guess zero and then use the
 * the atomics actual value returned from cmpxchg().
 */
#define ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR) \
  ((ETHR_NAINT32_T__) 0)
#endif

/*
 * Native cmpxchg() fallback used when no native op present.
 */
#define ETHR_NATMC32_CMPXCHG_FALLBACK__(CMPXCHG, VAR, AVAL, OPS) \
do { \
    ethr_sint32_t AVAL; \
    ETHR_NAINT32_T__ new__, act__, exp__; \
    act__ = ETHR_NATMC32_CMPXCHG_FALLBACK_READ__(VAR); \
    do { \
	exp__ = act__; \
	AVAL = (ethr_sint32_t) act__; \
	{ OPS; } \
	new__ = (ETHR_NAINT32_T__) AVAL; \
	act__ = CMPXCHG(VAR, new__, exp__); \
    } while (__builtin_expect(act__ != exp__, 0)); \
} while (0)



/* --- addr() --- */

static ETHR_INLINE ethr_sint32_t *ETHR_ATMC32_FUNC__(addr)(ethr_atomic32_t *var)
{
    return (ethr_sint32_t *) ETHR_NATMC32_ADDR_FUNC__(var);

}


/* --- cmpxchg() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(cmpxchg)(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_CMPXCHG)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#else
#error "Missing implementation of ethr_atomic32_cmpxchg()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(cmpxchg_rb)(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic32_cmpxchg_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(cmpxchg_wb)(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#else
#error "Missing implementation of ethr_atomic32_cmpxchg_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(cmpxchg_acqb)(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_cmpxchg_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(cmpxchg_relb)(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#else
#error "Missing implementation of ethr_atomic32_cmpxchg_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(cmpxchg_mb)(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_mb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_relb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_acqb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_wb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg_rb)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(cmpxchg)(var, (ETHR_NAINT32_T__) val, (ETHR_NAINT32_T__) old_val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_cmpxchg_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(cmpxchg_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val, ethr_sint32_t old_val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(cmpxchg)(var, val, old_val);
#else
    return ETHR_ATMC32_FUNC__(cmpxchg_rb)(var, val, old_val);
#endif
}


/* --- xchg() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(xchg)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_XCHG)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#else
#error "Missing implementation of ethr_atomic32_xchg()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(xchg_rb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_XCHG_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_XCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_XCHG_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_acqb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic32_xchg_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(xchg_wb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_XCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
#else
#error "Missing implementation of ethr_atomic32_xchg_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(xchg_acqb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_XCHG_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_XCHG)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_XCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_xchg_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(xchg_relb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_XCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#else
#error "Missing implementation of ethr_atomic32_xchg_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(xchg_mb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_XCHG_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_XCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_XCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_XCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_XCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(xchg)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval = val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval = val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_xchg_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(xchg_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(xchg)(var, val);
#else
    return ETHR_ATMC32_FUNC__(xchg_rb)(var, val);
#endif
}


/* --- set() --- */


static ETHR_INLINE void ETHR_ATMC32_FUNC__(set)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_SET)
    ETHR_NATMC32_FUNC__(set)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_RB)
    ETHR_NATMC32_FUNC__(set_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_WB)
    ETHR_NATMC32_FUNC__(set_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_ACQB)
    ETHR_NATMC32_FUNC__(set_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_RELB)
    ETHR_NATMC32_FUNC__(set_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_MB)
    ETHR_NATMC32_FUNC__(set_mb)(var, (ETHR_NAINT32_T__) val);
#else
    (void) ETHR_ATMC32_FUNC__(xchg)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(set_rb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_SET_RB)
    ETHR_NATMC32_FUNC__(set_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET)
    ETHR_NATMC32_FUNC__(set)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_SET_MB)
    ETHR_NATMC32_FUNC__(set_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_WB)
    ETHR_NATMC32_FUNC__(set_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_SET_ACQB)
    ETHR_NATMC32_FUNC__(set_acqb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_SET_RELB)
    ETHR_NATMC32_FUNC__(set_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC32_FUNC__(xchg_rb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(set_wb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_SET_WB)
    ETHR_NATMC32_FUNC__(set_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_MB)
    ETHR_NATMC32_FUNC__(set_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set_relb)(var, (ETHR_NAINT32_T__) val);
#else
    (void) ETHR_ATMC32_FUNC__(xchg_wb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(set_acqb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_SET_ACQB)
    ETHR_NATMC32_FUNC__(set_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_RB)
    ETHR_NATMC32_FUNC__(set_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_SET)
    ETHR_NATMC32_FUNC__(set)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_SET_MB)
    ETHR_NATMC32_FUNC__(set_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_WB)
    ETHR_NATMC32_FUNC__(set_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_SET_RELB)
    ETHR_NATMC32_FUNC__(set_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(xchg_acqb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(set_relb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_SET_RELB)
    ETHR_NATMC32_FUNC__(set_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_NATMC32_FUNC__(set_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_MB)
    ETHR_NATMC32_FUNC__(set_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set_acqb)(var, (ETHR_NAINT32_T__) val);
#else
    (void) ETHR_ATMC32_FUNC__(xchg_relb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(set_mb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_SET_MB)
    ETHR_NATMC32_FUNC__(set_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_RELB)
    ETHR_NATMC32_FUNC__(set_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_SET_ACQB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_SET_WB)
    ETHR_MEMBAR(ETHR_LoadStore);
    ETHR_NATMC32_FUNC__(set_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_SET_RB)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_SET)
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(set)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(xchg_mb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(set_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC32_FUNC__(set)(var, val);
#else
    ETHR_ATMC32_FUNC__(set_rb)(var, val);
#endif
}


/* --- init() --- */


static ETHR_INLINE void ETHR_ATMC32_FUNC__(init)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_INIT)
    ETHR_NATMC32_FUNC__(init)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_RB)
    ETHR_NATMC32_FUNC__(init_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_WB)
    ETHR_NATMC32_FUNC__(init_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_ACQB)
    ETHR_NATMC32_FUNC__(init_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_RELB)
    ETHR_NATMC32_FUNC__(init_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_MB)
    ETHR_NATMC32_FUNC__(init_mb)(var, (ETHR_NAINT32_T__) val);
#else
    ETHR_ATMC32_FUNC__(set)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(init_rb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_INIT_RB)
    ETHR_NATMC32_FUNC__(init_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT)
    ETHR_NATMC32_FUNC__(init)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INIT_MB)
    ETHR_NATMC32_FUNC__(init_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_WB)
    ETHR_NATMC32_FUNC__(init_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INIT_ACQB)
    ETHR_NATMC32_FUNC__(init_acqb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INIT_RELB)
    ETHR_NATMC32_FUNC__(init_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    ETHR_ATMC32_FUNC__(set_rb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(init_wb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_INIT_WB)
    ETHR_NATMC32_FUNC__(init_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_MB)
    ETHR_NATMC32_FUNC__(init_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init_relb)(var, (ETHR_NAINT32_T__) val);
#else
    ETHR_ATMC32_FUNC__(set_wb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(init_acqb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_INIT_ACQB)
    ETHR_NATMC32_FUNC__(init_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_RB)
    ETHR_NATMC32_FUNC__(init_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INIT)
    ETHR_NATMC32_FUNC__(init)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INIT_MB)
    ETHR_NATMC32_FUNC__(init_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_WB)
    ETHR_NATMC32_FUNC__(init_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INIT_RELB)
    ETHR_NATMC32_FUNC__(init_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    ETHR_ATMC32_FUNC__(set_acqb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(init_relb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_INIT_RELB)
    ETHR_NATMC32_FUNC__(init_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(init_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_MB)
    ETHR_NATMC32_FUNC__(init_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init_acqb)(var, (ETHR_NAINT32_T__) val);
#else
    ETHR_ATMC32_FUNC__(set_relb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(init_mb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_INIT_MB)
    ETHR_NATMC32_FUNC__(init_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_RELB)
    ETHR_NATMC32_FUNC__(init_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INIT_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_INIT_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(init_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INIT_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INIT)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(init)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    ETHR_ATMC32_FUNC__(set_mb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(init_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC32_FUNC__(init)(var, val);
#else
    ETHR_ATMC32_FUNC__(init_rb)(var, val);
#endif
}


/* --- add_read() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(add_read)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_ADD_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#else
#error "Missing implementation of ethr_atomic32_add_read()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(add_read_rb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_ADD_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_acqb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic32_add_read_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(add_read_wb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_ADD_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
#else
#error "Missing implementation of ethr_atomic32_add_read_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(add_read_acqb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_ADD_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_add_read_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(add_read_relb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_ADD_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#else
#error "Missing implementation of ethr_atomic32_add_read_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(add_read_mb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_ADD_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(add_return)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, aval += val; res = aval);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, aval += val; res = aval);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_add_read_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(add_read_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(add_read)(var, val);
#else
    return ETHR_ATMC32_FUNC__(add_read_rb)(var, val);
#endif
}


/* --- read() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_READ)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_mb)(var);
#else
    res = ETHR_ATMC32_FUNC__(cmpxchg)(var, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_rb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_READ_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_READ_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_READ_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_READ_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    res = ETHR_ATMC32_FUNC__(cmpxchg_rb)(var, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_wb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_READ_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_relb)(var);
#else
    res = ETHR_ATMC32_FUNC__(cmpxchg_wb)(var, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_acqb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_READ_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC32_READ)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC32_READ_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC32_READ_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#else
    res = ETHR_ATMC32_FUNC__(cmpxchg_acqb)(var, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_relb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_READ_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_acqb)(var);
#else
    res = ETHR_ATMC32_FUNC__(cmpxchg_relb)(var, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_mb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_READ_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC32_READ_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_READ_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC32_READ_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore);
#elif defined(ETHR_HAVE_NATMC32_READ)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(read)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore);
#else
    res = ETHR_ATMC32_FUNC__(cmpxchg_mb)(var, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__, (ethr_sint32_t) ETHR_UNUSUAL_SINT32_VAL__);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_ddrb)(ethr_atomic32_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(read)(var);
#else
    return ETHR_ATMC32_FUNC__(read_rb)(var);
#endif
}


/* --- inc_read() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(inc_read)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_INC_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_mb)(var);
#else
    res = ETHR_ATMC32_FUNC__(add_read)(var, (ethr_sint32_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(inc_read_rb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_INC_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    res = ETHR_ATMC32_FUNC__(add_read_rb)(var, (ethr_sint32_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(inc_read_wb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_INC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_relb)(var);
#else
    res = ETHR_ATMC32_FUNC__(add_read_wb)(var, (ethr_sint32_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(inc_read_acqb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_INC_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC32_FUNC__(add_read_acqb)(var, (ethr_sint32_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(inc_read_relb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_INC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_acqb)(var);
#else
    res = ETHR_ATMC32_FUNC__(add_read_relb)(var, (ethr_sint32_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(inc_read_mb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_INC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(inc_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC32_FUNC__(add_read_mb)(var, (ethr_sint32_t) 1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(inc_read_ddrb)(ethr_atomic32_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(inc_read)(var);
#else
    return ETHR_ATMC32_FUNC__(inc_read_rb)(var);
#endif
}


/* --- dec_read() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(dec_read)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_DEC_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_mb)(var);
#else
    res = ETHR_ATMC32_FUNC__(add_read)(var, (ethr_sint32_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(dec_read_rb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_DEC_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    res = ETHR_ATMC32_FUNC__(add_read_rb)(var, (ethr_sint32_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(dec_read_wb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_DEC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_relb)(var);
#else
    res = ETHR_ATMC32_FUNC__(add_read_wb)(var, (ethr_sint32_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(dec_read_acqb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_DEC_RETURN_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC32_FUNC__(add_read_acqb)(var, (ethr_sint32_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(dec_read_relb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_DEC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_acqb)(var);
#else
    res = ETHR_ATMC32_FUNC__(add_read_relb)(var, (ethr_sint32_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(dec_read_mb)(ethr_atomic32_t *var)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_DEC_RETURN_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RETURN)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(dec_return)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    res = ETHR_ATMC32_FUNC__(add_read_mb)(var, (ethr_sint32_t) -1);
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(dec_read_ddrb)(ethr_atomic32_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(dec_read)(var);
#else
    return ETHR_ATMC32_FUNC__(dec_read_rb)(var);
#endif
}


/* --- add() --- */


static ETHR_INLINE void ETHR_ATMC32_FUNC__(add)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_ADD)
    ETHR_NATMC32_FUNC__(add)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RB)
    ETHR_NATMC32_FUNC__(add_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_WB)
    ETHR_NATMC32_FUNC__(add_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_ACQB)
    ETHR_NATMC32_FUNC__(add_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RELB)
    ETHR_NATMC32_FUNC__(add_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_MB)
    ETHR_NATMC32_FUNC__(add_mb)(var, (ETHR_NAINT32_T__) val);
#else
    (void) ETHR_ATMC32_FUNC__(add_read)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(add_rb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_ADD_RB)
    ETHR_NATMC32_FUNC__(add_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD)
    ETHR_NATMC32_FUNC__(add)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_ADD_MB)
    ETHR_NATMC32_FUNC__(add_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_WB)
    ETHR_NATMC32_FUNC__(add_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_ADD_ACQB)
    ETHR_NATMC32_FUNC__(add_acqb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_ADD_RELB)
    ETHR_NATMC32_FUNC__(add_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC32_FUNC__(add_read_rb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(add_wb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_ADD_WB)
    ETHR_NATMC32_FUNC__(add_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(add)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_MB)
    ETHR_NATMC32_FUNC__(add_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(add_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(add_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(add_relb)(var, (ETHR_NAINT32_T__) val);
#else
    (void) ETHR_ATMC32_FUNC__(add_read_wb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(add_acqb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_ADD_ACQB)
    ETHR_NATMC32_FUNC__(add_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RB)
    ETHR_NATMC32_FUNC__(add_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD)
    ETHR_NATMC32_FUNC__(add)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_MB)
    ETHR_NATMC32_FUNC__(add_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_WB)
    ETHR_NATMC32_FUNC__(add_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RELB)
    ETHR_NATMC32_FUNC__(add_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(add_read_acqb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(add_relb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_ADD_RELB)
    ETHR_NATMC32_FUNC__(add_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_MB)
    ETHR_NATMC32_FUNC__(add_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add_acqb)(var, (ETHR_NAINT32_T__) val);
#else
    (void) ETHR_ATMC32_FUNC__(add_read_relb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(add_mb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#if defined(ETHR_HAVE_NATMC32_ADD_MB)
    ETHR_NATMC32_FUNC__(add_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_RELB)
    ETHR_NATMC32_FUNC__(add_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_ADD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_ADD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(add)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(add_read_mb)(var, val);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(add_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC32_FUNC__(add)(var, val);
#else
    ETHR_ATMC32_FUNC__(add_rb)(var, val);
#endif
}


/* --- inc() --- */


static ETHR_INLINE void ETHR_ATMC32_FUNC__(inc)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_INC)
    ETHR_NATMC32_FUNC__(inc)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RB)
    ETHR_NATMC32_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_WB)
    ETHR_NATMC32_FUNC__(inc_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_ACQB)
    ETHR_NATMC32_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RELB)
    ETHR_NATMC32_FUNC__(inc_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_MB)
    ETHR_NATMC32_FUNC__(inc_mb)(var);
#else
    (void) ETHR_ATMC32_FUNC__(inc_read)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(inc_rb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_INC_RB)
    ETHR_NATMC32_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC)
    ETHR_NATMC32_FUNC__(inc)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INC_MB)
    ETHR_NATMC32_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_WB)
    ETHR_NATMC32_FUNC__(inc_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INC_ACQB)
    ETHR_NATMC32_FUNC__(inc_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_INC_RELB)
    ETHR_NATMC32_FUNC__(inc_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC32_FUNC__(inc_read_rb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(inc_wb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_INC_WB)
    ETHR_NATMC32_FUNC__(inc_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(inc)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_MB)
    ETHR_NATMC32_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(inc_relb)(var);
#else
    (void) ETHR_ATMC32_FUNC__(inc_read_wb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(inc_acqb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_INC_ACQB)
    ETHR_NATMC32_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RB)
    ETHR_NATMC32_FUNC__(inc_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC)
    ETHR_NATMC32_FUNC__(inc)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_MB)
    ETHR_NATMC32_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_WB)
    ETHR_NATMC32_FUNC__(inc_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RELB)
    ETHR_NATMC32_FUNC__(inc_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(inc_read_acqb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(inc_relb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_INC_RELB)
    ETHR_NATMC32_FUNC__(inc_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_MB)
    ETHR_NATMC32_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc_acqb)(var);
#else
    (void) ETHR_ATMC32_FUNC__(inc_read_relb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(inc_mb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_INC_MB)
    ETHR_NATMC32_FUNC__(inc_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_RELB)
    ETHR_NATMC32_FUNC__(inc_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_INC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_INC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(inc)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(inc_read_mb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(inc_ddrb)(ethr_atomic32_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC32_FUNC__(inc)(var);
#else
    ETHR_ATMC32_FUNC__(inc_rb)(var);
#endif
}


/* --- dec() --- */


static ETHR_INLINE void ETHR_ATMC32_FUNC__(dec)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_DEC)
    ETHR_NATMC32_FUNC__(dec)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RB)
    ETHR_NATMC32_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_WB)
    ETHR_NATMC32_FUNC__(dec_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_ACQB)
    ETHR_NATMC32_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RELB)
    ETHR_NATMC32_FUNC__(dec_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_MB)
    ETHR_NATMC32_FUNC__(dec_mb)(var);
#else
    (void) ETHR_ATMC32_FUNC__(dec_read)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(dec_rb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_DEC_RB)
    ETHR_NATMC32_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC)
    ETHR_NATMC32_FUNC__(dec)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_DEC_MB)
    ETHR_NATMC32_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_WB)
    ETHR_NATMC32_FUNC__(dec_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_DEC_ACQB)
    ETHR_NATMC32_FUNC__(dec_acqb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_DEC_RELB)
    ETHR_NATMC32_FUNC__(dec_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
    (void) ETHR_ATMC32_FUNC__(dec_read_rb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(dec_wb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_DEC_WB)
    ETHR_NATMC32_FUNC__(dec_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(dec)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_MB)
    ETHR_NATMC32_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_FUNC__(dec_relb)(var);
#else
    (void) ETHR_ATMC32_FUNC__(dec_read_wb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(dec_acqb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_DEC_ACQB)
    ETHR_NATMC32_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RB)
    ETHR_NATMC32_FUNC__(dec_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC)
    ETHR_NATMC32_FUNC__(dec)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_MB)
    ETHR_NATMC32_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_WB)
    ETHR_NATMC32_FUNC__(dec_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RELB)
    ETHR_NATMC32_FUNC__(dec_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(dec_read_acqb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(dec_relb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_DEC_RELB)
    ETHR_NATMC32_FUNC__(dec_relb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec_wb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_MB)
    ETHR_NATMC32_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec_rb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec_acqb)(var);
#else
    (void) ETHR_ATMC32_FUNC__(dec_read_relb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(dec_mb)(ethr_atomic32_t *var)
{
#if defined(ETHR_HAVE_NATMC32_DEC_MB)
    ETHR_NATMC32_FUNC__(dec_mb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_RELB)
    ETHR_NATMC32_FUNC__(dec_relb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec_acqb)(var);
#elif defined(ETHR_HAVE_NATMC32_DEC_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec_wb)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec_rb)(var);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_DEC)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_FUNC__(dec)(var);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
    (void) ETHR_ATMC32_FUNC__(dec_read_mb)(var);
#endif
}

static ETHR_INLINE void ETHR_ATMC32_FUNC__(dec_ddrb)(ethr_atomic32_t *var)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    ETHR_ATMC32_FUNC__(dec)(var);
#else
    ETHR_ATMC32_FUNC__(dec_rb)(var);
#endif
}


/* --- read_band() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_band)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_AND_RETOLD)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#else
#error "Missing implementation of ethr_atomic32_read_band()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_band_rb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_AND_RETOLD_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_acqb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic32_read_band_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_band_wb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_AND_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
#else
#error "Missing implementation of ethr_atomic32_read_band_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_band_acqb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_AND_RETOLD_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_read_band_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_band_relb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_AND_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#else
#error "Missing implementation of ethr_atomic32_read_band_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_band_mb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_AND_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_AND_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(and_retold)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval &= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval &= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_read_band_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_band_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(read_band)(var, val);
#else
    return ETHR_ATMC32_FUNC__(read_band_rb)(var, val);
#endif
}


/* --- read_bor() --- */


static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_bor)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_OR_RETOLD)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#else
#error "Missing implementation of ethr_atomic32_read_bor()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_bor_rb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_OR_RETOLD_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_acqb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad);
#else
#error "Missing implementation of ethr_atomic32_read_bor_rb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_bor_wb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_OR_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_MEMBAR(ETHR_StoreStore);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
#else
#error "Missing implementation of ethr_atomic32_read_bor_wb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_bor_acqb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_OR_RETOLD_ACQB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_WB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_read_bor_acqb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_bor_relb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_OR_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_relb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_wb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_rb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#else
#error "Missing implementation of ethr_atomic32_read_bor_relb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_bor_mb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
    ethr_sint32_t res;
#if defined(ETHR_HAVE_NATMC32_OR_RETOLD_MB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_mb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RELB)
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_relb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_acqb)(var, (ETHR_NAINT32_T__) val);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_wb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold_rb)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_OR_RETOLD)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    res = (ethr_sint32_t) ETHR_NATMC32_FUNC__(or_retold)(var, (ETHR_NAINT32_T__) val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_MB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_mb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RELB)
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_relb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_ACQB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_acqb), var, aval, res = aval; aval |= val);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_WB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_wb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG_RB)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg_rb), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#elif defined(ETHR_HAVE_NATMC32_CMPXCHG)
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_StoreLoad);
    ETHR_NATMC32_CMPXCHG_FALLBACK__(ETHR_NATMC32_FUNC__(cmpxchg), var, aval, res = aval; aval |= val);
    ETHR_MEMBAR(ETHR_LoadLoad|ETHR_LoadStore|ETHR_StoreLoad|ETHR_StoreStore);
#else
#error "Missing implementation of ethr_atomic32_read_bor_mb()!"
#endif
    return res;
}

static ETHR_INLINE ethr_sint32_t ETHR_ATMC32_FUNC__(read_bor_ddrb)(ethr_atomic32_t *var, ethr_sint32_t val)
{
#ifdef ETHR_ORDERED_READ_DEPEND
    return ETHR_ATMC32_FUNC__(read_bor)(var, val);
#else
    return ETHR_ATMC32_FUNC__(read_bor_rb)(var, val);
#endif
}

#endif /* ETHR_ATMC32_INLINE__ */

#endif /* ETHR_ATOMICS_H__ */
